/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.trxRetry;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.filter.BaseFilter;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogFactory;
import dm.jdbc.filter.trxRetry.TrxRetryInfo;
import dm.jdbc.internal.conf.DmProperties;
import dm.jdbc.internal.convert.OffRowData;
import dm.jdbc.internal.desc.Parameter;
import dm.jdbc.util.MiscUtil;
import dm.jdbc.util.StringUtil;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TrxRetryFilter
extends BaseFilter {
    private static final ILogger LOG = LogFactory.getLog(TrxRetryFilter.class);
    private int trxRetryFlag = 0;
    private int retryTimes = 3;
    private int retryInterval = 200;
    private static boolean retryFlag = true;

    public TrxRetryFilter(int trxRetryFlag, int retryTimes, int retryInterval) {
        this.trxRetryFlag = trxRetryFlag;
        this.retryTimes = retryTimes;
        this.retryInterval = retryInterval;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Connection Driver_connect(DmDriver driver, DmProperties props) throws SQLException {
        try {
            return super.Driver_connect(driver, props);
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                throw e;
            }
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry Driver connect " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                return driver.do_connect(props);
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "Driver connect", innerException)) break;
                ++i;
            }
            continue;
        }
lbl17:
        // 2 sources

        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        try {
            ret = super.Statement_executeUpdate(statement, sql, autoGeneratedKeys);
            this.sqlListProcess(false, sql, statement.connection);
            return ret;
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                statement.connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry update(statement, sql, autoGeneratedKeys): " + sql);
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry update " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(statement);
                result = statement.do_executeUpdate(sql, autoGeneratedKeys);
                this.sqlListProcess(false, sql, statement.connection);
                return result;
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "update", innerException)) break;
                ++i;
            }
            continue;
        }
lbl24:
        // 2 sources

        statement.connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        try {
            ret = super.Statement_executeUpdate(statement, sql, columnIndexes);
            this.sqlListProcess(false, sql, statement.connection);
            return ret;
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                statement.connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry update(statement, sql, columnIndexes): " + sql);
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry update " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(statement);
                result = statement.do_executeUpdate(sql, columnIndexes);
                this.sqlListProcess(false, sql, statement.connection);
                return result;
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "update", innerException)) break;
                ++i;
            }
            continue;
        }
lbl24:
        // 2 sources

        statement.connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        try {
            ret = super.Statement_executeUpdate(statement, sql, columnNames);
            this.sqlListProcess(false, sql, statement.connection);
            return ret;
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                statement.connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry update(statement, sql, columnNames): " + sql);
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry update " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(statement);
                result = statement.do_executeUpdate(sql, columnNames);
                this.sqlListProcess(false, sql, statement.connection);
                return result;
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "update", innerException)) break;
                ++i;
            }
            continue;
        }
lbl24:
        // 2 sources

        statement.connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        try {
            ret = super.Statement_execute(statement, sql, autoGeneratedKeys);
            this.sqlListProcess(false, sql, statement.connection);
            return ret;
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                statement.connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry execute(statement, sql, autoGenerateKeys): " + sql);
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry execute " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(statement);
                result = statement.do_execute(sql, autoGeneratedKeys);
                this.sqlListProcess(false, sql, statement.connection);
                return result;
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "execute", innerException)) break;
                ++i;
            }
            continue;
        }
lbl24:
        // 2 sources

        statement.connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return false;
    }

    private boolean retryEnable(int errorCode) {
        if (!retryFlag) {
            LOG.error("TrxRetry Flag: false, contains offRowData");
            retryFlag = true;
            return true;
        }
        return DBError.ECJDBC_CONNECTION_SWITCHED.errCode != errorCode && DBError.ECJDBC_CONNECTION_SWITCH_FAILED.errCode != errorCode && DBError.EC_CONNECT_LOST.errCode != errorCode && DBError.EC_SESS_CLOSED.errCode != errorCode && DBError.EC_RECV_OOB.errCode != errorCode && DBError.EC_XLNK_SEND_FAIL.errCode != errorCode && DBError.EC_XLNK_RECV_FAIL.errCode != errorCode && DBError.ECJDBC_COMMUNITION_ERROR.errCode != errorCode && -3840 != errorCode && -9658 != errorCode;
    }

    private void sqlListProcess(boolean skipQuery, String sql, DmdbConnection connection) {
        boolean trxFinished = connection.getTransFinish();
        List<TrxRetryInfo> sqlList = connection.sqlList;
        if (trxFinished) {
            sqlList.clear();
        } else if (!skipQuery) {
            sqlList.add(new TrxRetryInfo(sql));
        }
    }

    private void sqlListProcess(boolean skipQuery, DmdbPreparedStatement ps, boolean trxFinished) {
        if (trxFinished) {
            ps.connection.sqlList.clear();
        } else if (!skipQuery) {
            Parameter[] bindParams = new Parameter[ps.bindParameters.length];
            int i2 = 0;
            while (i2 < ps.bindParameters.length) {
                Parameter parameter = new Parameter();
                parameter.reset(ps.bindParameters[i2]);
                bindParams[i2] = parameter;
                ++i2;
            }
            ArrayList<Object[]> curRows = new ArrayList<Object[]>(1);
            curRows.add((Object[])ps.curRowDatas.clone());
            ps.connection.sqlList.add(new TrxRetryInfo(ps.nativeSql, TrxRetryInfo.STMT_TYPE.PSTMT, curRows, bindParams));
        }
    }

    private void sqlListProcess(boolean batchFlag, List<String> batchSQLs, List<Object[]> multiRows, DmdbPreparedStatement ps) {
        if (ps.connection.getTransFinish()) {
            ps.connection.sqlList.clear();
        } else {
            Parameter[] bindParams = new Parameter[ps.bindParameters.length];
            int i2 = 0;
            while (i2 < ps.bindParameters.length) {
                Parameter parameter = new Parameter();
                parameter.reset(ps.bindParameters[i2]);
                bindParams[i2] = parameter;
                ++i2;
            }
            if (batchFlag) {
                ps.connection.sqlList.add(new TrxRetryInfo(ps.nativeSql, TrxRetryInfo.STMT_TYPE.PSTMT, bindParams, batchSQLs));
            } else {
                ps.connection.sqlList.add(new TrxRetryInfo(ps.nativeSql, TrxRetryInfo.STMT_TYPE.PSTMT, multiRows, bindParams));
            }
        }
    }

    private void processTrx(DmdbStatement statement) throws SQLException {
        DmdbConnection connection = statement.connection;
        if (connection.do_isClosed()) {
            boolean autoCommit = connection.do_getAutoCommit();
            connection.do_reconnect();
            connection.do_setAutoCommit(autoCommit);
            LOG.debug("processTrx: try reconnect, autoCommit: " + autoCommit);
        }
        if (connection.getTransFinish()) {
            LOG.debug("processTrx trxStatus: true");
            statement.connection.sqlList.clear();
            return;
        }
        LOG.debug("before repeat sqlList size: " + connection.sqlList.size());
        this.repeatExecSql(null, connection);
    }

    private void processTrx(String savePoint, DmdbConnection connection) throws SQLException {
        if (connection.do_isClosed()) {
            boolean autoCommit = connection.do_getAutoCommit();
            connection.do_reconnect();
            connection.do_setAutoCommit(autoCommit);
            LOG.debug("processTrx: try reconnect, autoCommit: " + autoCommit);
        }
        if (connection.getTransFinish()) {
            LOG.debug("processTrx trxStatus: true");
            connection.sqlList.clear();
            return;
        }
        this.repeatExecSql(savePoint, connection);
    }

    private void processTrx(DmdbConnection connection) throws SQLException {
        if (connection.do_isClosed()) {
            boolean autoCommit = connection.do_getAutoCommit();
            connection.do_reconnect();
            connection.do_setAutoCommit(autoCommit);
            LOG.debug("processTrx: try reconnect, autoCommit: " + autoCommit);
        }
        if (connection.getTransFinish()) {
            LOG.debug("processTrx trxStatus: true");
            connection.sqlList.clear();
            return;
        }
        this.repeatExecSql(null, connection);
    }

    private void repeatExecSql(String savePoint, DmdbConnection connection) throws SQLException {
        LOG.debug("repeatExecSql: do rollback");
        connection.do_rollback();
        List<TrxRetryInfo> sqlList = connection.sqlList;
        if (sqlList.isEmpty()) {
            sqlList.clear();
            return;
        }
        DmdbStatement stmt = connection.do_createStatement();
        for (TrxRetryInfo trxRetryInfo : sqlList) {
            LOG.debug("repeatExecSq execute: " + trxRetryInfo.sql);
            if (trxRetryInfo.stmtType == TrxRetryInfo.STMT_TYPE.STMT) {
                stmt.do_execute(trxRetryInfo.sql);
            } else if (trxRetryInfo.stmtType == TrxRetryInfo.STMT_TYPE.PSTMT) {
                DmdbPreparedStatement ps = connection.do_prepareStatement(trxRetryInfo.sql);
                if (trxRetryInfo.multiRows != null) {
                    ps.multiRowDatas = trxRetryInfo.multiRows;
                    ps.irow = trxRetryInfo.multiRows.size();
                    ps.bindParameters = trxRetryInfo.bindParameters;
                } else {
                    ps.batchSqls = trxRetryInfo.batchSQLs;
                }
                ps.do_executeBatch();
                ps.multiRowDatas = Collections.emptyList();
                ps.bindParameters = new Parameter[0];
                ps.batchSqls = Collections.emptyList();
                ps.do_close();
            }
            if (!StringUtil.isNotEmpty(savePoint) || !savePoint.equalsIgnoreCase(trxRetryInfo.savePointName)) continue;
            trxRetryInfo.savePointName = null;
            return;
        }
        stmt.do_close();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        try {
            ret = super.Statement_execute(statement, sql, columnIndexes);
            this.sqlListProcess(false, sql, statement.connection);
            return ret;
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                statement.connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry execute(statement, sql, columnIndexes): " + sql);
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry execute " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(statement);
                result = statement.do_execute(sql, columnIndexes);
                this.sqlListProcess(false, sql, statement.connection);
                return result;
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "execute", innerException)) break;
                ++i;
            }
            continue;
        }
lbl24:
        // 2 sources

        statement.connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        try {
            ret = super.Statement_execute(statement, sql, columnNames);
            this.sqlListProcess(false, sql, statement.connection);
            return ret;
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                statement.connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry execute(statement, sql, columnNames): " + sql);
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry execute " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(statement);
                result = statement.do_execute(sql, columnNames);
                this.sqlListProcess(false, sql, statement.connection);
                return result;
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "execute", innerException)) break;
                ++i;
            }
            continue;
        }
lbl24:
        // 2 sources

        statement.connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql) throws SQLException {
        try {
            ret = super.Statement_executeLargeUpdate(statement, sql);
            this.sqlListProcess(false, sql, statement.connection);
            return ret;
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                statement.connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry largeUpdate(statement, sql): " + sql);
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry largeUpdate " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(statement);
                result = statement.do_executeLargeUpdate(sql);
                this.sqlListProcess(false, sql, statement.connection);
                return result;
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "largeUpdate", innerException)) break;
                ++i;
            }
            continue;
        }
lbl24:
        // 2 sources

        statement.connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return -1L;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        try {
            ret = super.Statement_executeLargeUpdate(statement, sql, autoGeneratedKeys);
            this.sqlListProcess(false, sql, statement.connection);
            return ret;
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                statement.connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry largeUpdate(statement, sql, autoGenerateKeys): " + sql);
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry largeUpdate " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(statement);
                result = statement.do_executeLargeUpdate(sql, autoGeneratedKeys);
                this.sqlListProcess(false, sql, statement.connection);
                return result;
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "largeUpdate", innerException)) break;
                ++i;
            }
            continue;
        }
lbl24:
        // 2 sources

        statement.connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return -1L;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        try {
            ret = super.Statement_executeLargeUpdate(statement, sql, columnIndexes);
            this.sqlListProcess(false, sql, statement.connection);
            return ret;
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                statement.connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry largeUpdate(statement, sql, columnIndexes): " + sql);
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry largeUpdate " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(statement);
                result = statement.do_executeLargeUpdate(sql, columnIndexes);
                this.sqlListProcess(false, sql, statement.connection);
                return result;
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "largeUpdate", innerException)) break;
                ++i;
            }
            continue;
        }
lbl24:
        // 2 sources

        statement.connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return -1L;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        try {
            ret = super.Statement_executeLargeUpdate(statement, sql, columnNames);
            this.sqlListProcess(false, sql, statement.connection);
            return ret;
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                statement.connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry largeUpdate(statement, sql, columnNames): " + sql);
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry largeUpdate " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(statement);
                result = statement.do_executeLargeUpdate(sql, columnNames);
                this.sqlListProcess(false, sql, statement.connection);
                return result;
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "largeUpdate", innerException)) break;
                ++i;
            }
            continue;
        }
lbl24:
        // 2 sources

        statement.connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return -1L;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql) throws SQLException {
        try {
            ret = super.Statement_execute(statement, sql);
            this.sqlListProcess(false, sql, statement.connection);
            return ret;
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                statement.connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry execute(statement, sql): " + sql);
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry execute " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(statement);
                result = statement.do_execute(sql);
                this.sqlListProcess(false, sql, statement.connection);
                return result;
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "execute", innerException)) break;
                ++i;
            }
            continue;
        }
lbl24:
        // 2 sources

        statement.connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ResultSet Statement_executeQuery(DmdbStatement statement, String sql) throws SQLException {
        try {
            ret = super.Statement_executeQuery(statement, sql);
            this.sqlListProcess(this.trxRetryFlag == 2, sql, statement.connection);
            return ret;
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                statement.connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry query(statement, sql): " + sql);
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry query " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(statement);
                result = statement.do_executeQuery(sql);
                this.sqlListProcess(this.trxRetryFlag == 2, sql, statement.connection);
                return result;
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "query", innerException)) break;
                ++i;
            }
            continue;
        }
lbl24:
        // 2 sources

        statement.connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return DmdbResultSet.newEmptyResultSet(statement);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql) throws SQLException {
        try {
            ret = super.Statement_executeUpdate(statement, sql);
            this.sqlListProcess(false, sql, statement.connection);
            return ret;
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                statement.connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry update(statement, sql): " + sql);
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry update " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(statement);
                result = statement.do_executeUpdate(sql);
                this.sqlListProcess(false, sql, statement.connection);
                return result;
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "update", innerException)) break;
                ++i;
            }
            continue;
        }
lbl24:
        // 2 sources

        statement.connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ResultSet PreparedStatement_executeQuery(DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            this.checkOffRowData(preparedStatement);
            ret = super.PreparedStatement_executeQuery(preparedStatement);
            this.sqlListProcess(this.trxRetryFlag == 2, preparedStatement, preparedStatement.connection.getTransFinish());
            return ret;
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                preparedStatement.connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry query(preparedStatement): " + preparedStatement.nativeSql);
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry query " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(preparedStatement);
                preparedStatement.do_preCompile(preparedStatement.nativeSql);
                result = preparedStatement.do_executeQuery();
                this.sqlListProcess(this.trxRetryFlag == 2, preparedStatement, preparedStatement.connection.getTransFinish());
                return result;
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "query", innerException)) break;
                ++i;
            }
            continue;
        }
lbl26:
        // 2 sources

        preparedStatement.connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return DmdbResultSet.newEmptyResultSet(preparedStatement);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int PreparedStatement_executeUpdate(DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            this.checkOffRowData(preparedStatement);
            ret = super.PreparedStatement_executeUpdate(preparedStatement);
            this.sqlListProcess(false, preparedStatement, preparedStatement.connection.getTransFinish());
            return ret;
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                preparedStatement.connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry update(preparedStatement): " + preparedStatement.nativeSql);
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry update " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(preparedStatement);
                preparedStatement.do_preCompile(preparedStatement.nativeSql);
                result = preparedStatement.do_executeUpdate();
                this.sqlListProcess(this.trxRetryFlag == 2, preparedStatement, preparedStatement.connection.getTransFinish());
                return result;
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "update", innerException)) break;
                ++i;
            }
            continue;
        }
lbl26:
        // 2 sources

        preparedStatement.connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return -1;
    }

    private void restorePrepareStatement(DmdbPreparedStatement preparedStatement) {
        preparedStatement.multiRowDatas = new ArrayList<Object[]>();
        preparedStatement.batchSqls = new ArrayList();
        preparedStatement.do_clearBatch();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int[] PreparedStatement_executeBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        batchSqls = null;
        multiRows = null;
        batchSQLFlag = false;
        if (preparedStatement.batchSqls != null && preparedStatement.batchSqls.size() > 0) {
            batchSQLFlag = true;
            batchSqls = (List)((ArrayList)preparedStatement.batchSqls).clone();
        } else {
            multiRows = preparedStatement.multiRowDatas;
        }
        try {
            ret = super.PreparedStatement_executeBatch(preparedStatement);
            this.sqlListProcess(batchSQLFlag, batchSqls, multiRows, preparedStatement);
            return ret;
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                preparedStatement.connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry PreparedStatement_executeBatch(preparedStatement): " + preparedStatement.nativeSql);
            oldClearBatch = preparedStatement.clearBatch;
            preparedStatement.clearBatch = false;
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry PreparedStatement_executeBatch " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(preparedStatement);
                if (batchSQLFlag) {
                    preparedStatement.batchSqls = batchSqls;
                } else {
                    preparedStatement.do_preCompile(preparedStatement.nativeSql);
                    preparedStatement.multiRowDatas = multiRows;
                    preparedStatement.irow = multiRows.size();
                }
                result = preparedStatement.do_executeBatch();
                this.sqlListProcess(this.trxRetryFlag == 2, preparedStatement, preparedStatement.connection.getTransFinish());
                preparedStatement.clearBatch = oldClearBatch;
                if (preparedStatement.clearBatch) {
                    this.restorePrepareStatement(preparedStatement);
                }
                return result;
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "update", innerException)) break;
                ++i;
            }
            continue;
        }
lbl43:
        // 2 sources

        preparedStatement.connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return new int[0];
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long[] PreparedStatement_executeLargeBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        batchSqls = null;
        multiRows = null;
        batchSQLFlag = false;
        if (preparedStatement.batchSqls != null && preparedStatement.batchSqls.size() > 0) {
            batchSQLFlag = true;
            batchSqls = (List)((ArrayList)preparedStatement.batchSqls).clone();
        } else {
            multiRows = (List)((ArrayList)preparedStatement.multiRowDatas).clone();
        }
        try {
            ret = super.PreparedStatement_executeLargeBatch(preparedStatement);
            this.sqlListProcess(false, preparedStatement, preparedStatement.connection.getTransFinish());
            return ret;
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                preparedStatement.connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry PreparedStatement_executeBatch(preparedStatement): " + preparedStatement.nativeSql);
            oldClearBatch = preparedStatement.clearBatch;
            preparedStatement.clearBatch = false;
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry PreparedStatement_executeBatch " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(preparedStatement);
                if (batchSQLFlag) {
                    preparedStatement.batchSqls = batchSqls;
                } else {
                    preparedStatement.do_preCompile(preparedStatement.nativeSql);
                    preparedStatement.multiRowDatas = multiRows;
                    preparedStatement.irow = multiRows.size();
                }
                result = preparedStatement.do_executeLargeBatch();
                this.sqlListProcess(this.trxRetryFlag == 2, preparedStatement, preparedStatement.connection.getTransFinish());
                preparedStatement.clearBatch = oldClearBatch;
                if (preparedStatement.clearBatch) {
                    this.restorePrepareStatement(preparedStatement);
                }
                return result;
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "update", innerException)) break;
                ++i;
            }
            continue;
        }
lbl43:
        // 2 sources

        preparedStatement.connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return new long[0];
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long PreparedStatement_executeLargeUpdate(DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            ret = super.PreparedStatement_executeLargeUpdate(preparedStatement);
            this.sqlListProcess(false, preparedStatement, preparedStatement.connection.getTransFinish());
            return ret;
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                preparedStatement.connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry update(preparedStatement): " + preparedStatement.nativeSql);
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry update " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(preparedStatement);
                preparedStatement.do_preCompile(preparedStatement.nativeSql);
                result = preparedStatement.do_executeLargeUpdate();
                this.sqlListProcess(this.trxRetryFlag == 2, preparedStatement, preparedStatement.connection.getTransFinish());
                return result;
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "update", innerException)) break;
                ++i;
            }
            continue;
        }
lbl25:
        // 2 sources

        preparedStatement.connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return -1L;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean PreparedStatement_execute(DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            this.checkOffRowData(preparedStatement);
            ret = super.PreparedStatement_execute(preparedStatement);
            this.sqlListProcess(false, preparedStatement, preparedStatement.connection.getTransFinish());
            return ret;
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                preparedStatement.connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry update(preparedStatement): " + preparedStatement.nativeSql);
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry update " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(preparedStatement);
                preparedStatement.do_preCompile(preparedStatement.nativeSql);
                result = preparedStatement.do_execute();
                this.sqlListProcess(this.trxRetryFlag == 2, preparedStatement, preparedStatement.connection.getTransFinish());
                return result;
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "update", innerException)) break;
                ++i;
            }
            continue;
        }
lbl26:
        // 2 sources

        preparedStatement.connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return false;
    }

    private void checkOffRowData(DmdbPreparedStatement preparedStatement) {
        if (!retryFlag) {
            return;
        }
        Object[] curRow = preparedStatement.curRowDatas;
        if (curRow != null && curRow.length > 0) {
            Object[] objectArray = curRow;
            int n2 = curRow.length;
            int n3 = 0;
            while (n3 < n2) {
                Object row = objectArray[n3];
                if (row instanceof OffRowData) {
                    retryFlag = false;
                    break;
                }
                ++n3;
            }
        }
    }

    @Override
    public void PreparedStatement_addBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        this.checkOffRowData(preparedStatement);
        super.PreparedStatement_addBatch(preparedStatement);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void Connection_commit(DmdbConnection connection) throws SQLException {
        block8: {
            try {
                super.Connection_commit(connection);
                if (connection.getTransFinish()) {
                    connection.sqlList.clear();
                }
                break block8;
            }
            catch (SQLException e) {
                if (this.retryEnable(e.getErrorCode())) {
                    connection.sqlList.clear();
                    throw new SQLException(e);
                }
                TrxRetryFilter.LOG.debug("TrxRetry commit");
                i = 0;
                ** while (i < this.retryTimes)
            }
lbl-1000:
            // 1 sources

            {
                TrxRetryFilter.LOG.debug("TrxRetry commit " + (i + 1) + " times");
                try {
                    if (this.retryInterval > 0) {
                        MiscUtil.sleep(this.retryInterval);
                    }
                    this.processTrx(connection);
                    connection.do_commit();
                    connection.sqlList.clear();
                    return;
                }
                catch (SQLException innerException) {
                    if (this.processInnerError(i + 1, "commit", innerException)) break;
                    ++i;
                }
                continue;
            }
lbl25:
            // 2 sources

            connection.sqlList.clear();
            DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void Connection_rollback(DmdbConnection connection) throws SQLException {
        block8: {
            try {
                super.Connection_rollback(connection);
                connection.sqlList.clear();
                break block8;
            }
            catch (SQLException e) {
                if (this.retryEnable(e.getErrorCode())) {
                    connection.sqlList.clear();
                    throw new SQLException(e);
                }
                TrxRetryFilter.LOG.debug("TrxRetry rollback");
                connection.sqlList.clear();
                i = 0;
                ** while (i < this.retryTimes)
            }
lbl-1000:
            // 1 sources

            {
                TrxRetryFilter.LOG.debug("TrxRetry rollback " + (i + 1) + " times");
                try {
                    if (this.retryInterval > 0) {
                        MiscUtil.sleep(this.retryInterval);
                    }
                    if (connection.do_isClosed()) {
                        TrxRetryFilter.LOG.debug("processTrx: try reconnect");
                        connection.do_reconnect();
                        return;
                    }
                    connection.do_rollback();
                    return;
                }
                catch (SQLException innerException) {
                    if (this.processInnerError(i + 1, "rollback", innerException)) break;
                    ++i;
                }
                continue;
            }
lbl27:
            // 2 sources

            DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void Connection_rollback(DmdbConnection connection, Savepoint savepoint) throws SQLException {
        block7: {
            try {
                super.Connection_rollback(connection, savepoint);
                this.removeSavePoint(false, savepoint, connection);
                break block7;
            }
            catch (SQLException e) {
                if (this.retryEnable(e.getErrorCode())) {
                    connection.sqlList.clear();
                    throw e;
                }
                TrxRetryFilter.LOG.debug("TrxRetry rollback(savePoint)");
                i = 0;
                ** while (i < this.retryTimes)
            }
lbl-1000:
            // 1 sources

            {
                TrxRetryFilter.LOG.debug("TrxRetry setSavepoint " + (i + 1) + " times");
                try {
                    if (this.retryInterval > 0) {
                        MiscUtil.sleep(this.retryInterval);
                    }
                    this.processTrx(savepoint.getSavepointName(), connection);
                    this.removeSavePoint(false, savepoint, connection);
                }
                catch (SQLException innerException) {
                    if (this.processInnerError(i + 1, "setSavepoint", innerException)) break;
                }
                ++i;
                continue;
            }
lbl23:
            // 2 sources

            DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Savepoint Connection_setSavepoint(DmdbConnection connection) throws SQLException {
        try {
            return this.do_setSavePoint(connection, null);
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                connection.sqlList.clear();
                throw e;
            }
            TrxRetryFilter.LOG.debug("TrxRetry setSavepoint");
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry setSavepoint " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(connection);
                return connection.do_setSavepoint();
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "setSavepoint", innerException)) break;
                ++i;
            }
            continue;
        }
lbl20:
        // 2 sources

        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void Connection_releaseSavepoint(DmdbConnection connection, Savepoint savepoint) throws SQLException {
        block7: {
            try {
                super.Connection_releaseSavepoint(connection, savepoint);
                this.removeSavePoint(true, savepoint, connection);
                break block7;
            }
            catch (SQLException e) {
                if (this.retryEnable(e.getErrorCode())) {
                    connection.sqlList.clear();
                    throw e;
                }
                TrxRetryFilter.LOG.debug("TrxRetry setSavepoint");
                i = 0;
                ** while (i < this.retryTimes)
            }
lbl-1000:
            // 1 sources

            {
                TrxRetryFilter.LOG.debug("TrxRetry releaseSavePoint " + (i + 1) + " times");
                try {
                    if (this.retryInterval > 0) {
                        MiscUtil.sleep(this.retryInterval);
                    }
                    this.processTrx(connection);
                }
                catch (SQLException innerException) {
                    if (this.processInnerError(i + 1, "releaseSavePoint", innerException)) break;
                }
                ++i;
                continue;
            }
lbl22:
            // 2 sources

            DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        }
    }

    private void removeSavePoint(boolean logicRemove, Savepoint savepoint, DmdbConnection connection) throws SQLException {
        String name = savepoint.getSavepointName();
        if (logicRemove) {
            for (TrxRetryInfo info : connection.sqlList) {
                if (!name.equalsIgnoreCase(info.savePointName)) continue;
                info.savePointName = null;
                break;
            }
        } else {
            ArrayList<TrxRetryInfo> list = new ArrayList<TrxRetryInfo>();
            for (TrxRetryInfo info : connection.sqlList) {
                list.add(info);
                if (!name.equalsIgnoreCase(info.savePointName)) continue;
                info.savePointName = null;
                break;
            }
            connection.sqlList = list;
        }
    }

    private Savepoint do_setSavePoint(DmdbConnection connection, String name) throws SQLException {
        Savepoint savepoint = StringUtil.isEmpty(name) ? super.Connection_setSavepoint(connection) : super.Connection_setSavepoint(connection, name);
        List<TrxRetryInfo> sqlList = connection.sqlList;
        if (!sqlList.isEmpty()) {
            sqlList.get((int)(sqlList.size() - 1)).savePointName = savepoint.getSavepointName();
        }
        return savepoint;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Savepoint Connection_setSavepoint(DmdbConnection connection, String name) throws SQLException {
        try {
            return this.do_setSavePoint(connection, name);
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                connection.sqlList.clear();
                throw e;
            }
            TrxRetryFilter.LOG.debug("TrxRetry setSavepoint");
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry setSavepoint(name) " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(connection);
                return connection.do_setSavepoint();
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "setSavepoint(name)", innerException)) break;
                ++i;
            }
            continue;
        }
lbl20:
        // 2 sources

        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Statement Connection_createStatement(DmdbConnection connection, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return super.Connection_createStatement(connection, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry Connection_createStatement(connection, resultSetType, resultSetConcurrency)");
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry create statement " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(connection);
                return connection.do_createStatement(resultSetType, resultSetConcurrency);
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "create statement", innerException)) break;
                ++i;
            }
            continue;
        }
lbl20:
        // 2 sources

        connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Statement Connection_createStatement(DmdbConnection connection) throws SQLException {
        try {
            return super.Connection_createStatement(connection);
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry Connection_createStatement(DmdbConnection connection)");
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry create statement " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(connection);
                return connection.do_createStatement();
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "create statement", innerException)) break;
                ++i;
            }
            continue;
        }
lbl20:
        // 2 sources

        connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Statement Connection_createStatement(DmdbConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return super.Connection_createStatement(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry Connection_createStatement(DmdbConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability)");
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry create statement " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(connection);
                return connection.do_createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "create statement", innerException)) break;
                ++i;
            }
            continue;
        }
lbl20:
        // 2 sources

        connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql) throws SQLException {
        try {
            return super.Connection_prepareStatement(connection, sql);
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry Connection_prepareStatement(DmdbConnection connection, String sql)");
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry prepareStatement " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(connection);
                return connection.do_prepareStatement(sql);
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "prepareStatement", innerException)) break;
                ++i;
            }
            continue;
        }
lbl20:
        // 2 sources

        connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return super.Connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry Connection_prepareStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency)");
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry prepareStatement " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(connection);
                return connection.do_prepareStatement(sql, resultSetType, resultSetConcurrency);
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "prepareStatement", innerException)) break;
                ++i;
            }
            continue;
        }
lbl20:
        // 2 sources

        connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return super.Connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry Connection_prepareStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability)");
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry prepareStatement " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(connection);
                return connection.do_prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "prepareStatement", innerException)) break;
                ++i;
            }
            continue;
        }
lbl20:
        // 2 sources

        connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return super.Connection_prepareStatement(connection, sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry Connection_prepareStatement(DmdbConnection connection, String sql, int autoGeneratedKeys)");
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry prepareStatement " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(connection);
                return connection.do_prepareStatement(sql, autoGeneratedKeys);
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "prepareStatement", innerException)) break;
                ++i;
            }
            continue;
        }
lbl20:
        // 2 sources

        connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int[] columnIndexes) throws SQLException {
        try {
            return super.Connection_prepareStatement(connection, sql, columnIndexes);
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry Connection_prepareStatement(DmdbConnection connection, String sql, int[] columnIndexes)");
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry prepareStatement " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(connection);
                return connection.do_prepareStatement(sql, columnIndexes);
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "prepareStatement", innerException)) break;
                ++i;
            }
            continue;
        }
lbl20:
        // 2 sources

        connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, String[] columnNames) throws SQLException {
        try {
            return super.Connection_prepareStatement(connection, sql, columnNames);
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry Connection_prepareStatement(DmdbConnection connection, String sql, String[] columnNames)");
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry prepareStatement " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(connection);
                return connection.do_prepareStatement(sql, columnNames);
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "prepareStatement", innerException)) break;
                ++i;
            }
            continue;
        }
lbl20:
        // 2 sources

        connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CallableStatement Connection_prepareCall(DmdbConnection connection, String sql) throws SQLException {
        try {
            return super.Connection_prepareCall(connection, sql);
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry Connection_prepareCall(DmdbConnection connection, String sql)");
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry prepareCall " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(connection);
                return connection.do_prepareCall(sql);
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "prepareCall", innerException)) break;
                ++i;
            }
            continue;
        }
lbl20:
        // 2 sources

        connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CallableStatement Connection_prepareCall(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return super.Connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry Connection_prepareCall(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency)");
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry prepareCall " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(connection);
                return connection.do_prepareCall(sql, resultSetType, resultSetConcurrency);
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "prepareCall", innerException)) break;
                ++i;
            }
            continue;
        }
lbl20:
        // 2 sources

        connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CallableStatement Connection_prepareCall(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return super.Connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            if (this.retryEnable(e.getErrorCode())) {
                connection.sqlList.clear();
                throw new SQLException(e);
            }
            TrxRetryFilter.LOG.debug("TrxRetry Connection_prepareCall(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability)");
            i = 0;
            ** while (i < this.retryTimes)
        }
lbl-1000:
        // 1 sources

        {
            TrxRetryFilter.LOG.debug("TrxRetry prepareCall " + (i + 1) + " times");
            try {
                if (this.retryInterval > 0) {
                    MiscUtil.sleep(this.retryInterval);
                }
                this.processTrx(connection);
                return connection.do_prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            catch (SQLException innerException) {
                if (this.processInnerError(i + 1, "prepareCall", innerException)) break;
                ++i;
            }
            continue;
        }
lbl20:
        // 2 sources

        connection.sqlList.clear();
        DBError.ECJDBC_TRX_RETRY_APPROACH_MAX_TIMES.throwz(new Object[]{e.getMessage()});
        return null;
    }

    private boolean processInnerError(int times, String head, SQLException sqlException) {
        boolean ret = this.retryEnable(sqlException.getErrorCode());
        StringBuilder stringBuilder = new StringBuilder("TrxRetry ").append(head).append(" inner error [").append(times).append("]");
        if (ret) {
            stringBuilder.append(" cannot be retry: ");
        } else {
            stringBuilder.append(": ");
        }
        stringBuilder.append("errorCode: ").append(String.valueOf(sqlException.getErrorCode()) + ", msg: " + sqlException.getMessage());
        LOG.error(stringBuilder.toString());
        return ret;
    }
}

