/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.rw;

import dm.jdbc.driver.Configuration;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogFactory;
import dm.jdbc.filter.rw.RWCallBack;
import dm.jdbc.filter.rw.RWCounter;
import dm.jdbc.internal.conf.DmProperties;
import dm.jdbc.internal.enums.RWSite;
import dm.jdbc.util.MiscUtil;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;

public class RWUtil {
    protected ILogger log = LogFactory.getLog(RWUtil.class);

    public DmdbConnection connect(DmDriver driver, DmProperties props) throws SQLException {
        props.setProperty(Configuration.loginMode.getName(), "1");
        DmdbConnection connection = driver.do_connect(props);
        connection.rwInfo.rwCounter = RWCounter.getInstance(connection, connection.standbyCount);
        this.connectStandby(connection);
        return connection;
    }

    public void reconnect(DmdbConnection connection) throws SQLException {
        if (connection.rwInfo == null) {
            return;
        }
        this.removeStandby(connection);
        connection.do_reconnect();
        connection.rwInfo.cleanup();
        connection.rwInfo.rwCounter = RWCounter.getInstance(connection, connection.standbyCount);
        this.connectStandby(connection);
    }

    public void recoverStandby(DmdbConnection connection) throws SQLException {
        if (connection.do_isClosed() || this.isStandbyAlive(connection)) {
            return;
        }
        long ts = System.currentTimeMillis();
        int freq = connection.rwStandbyRecoverTime;
        if (freq <= 0 || ts - connection.rwInfo.tryRecoverTs < (long)freq) {
            return;
        }
        this.connectStandby(connection);
        if (!this.checkStatusValid(connection)) {
            this.removeStandby(connection);
            this.log.debug((Object)connection, "recoverStandby", "standby status invalid");
        }
        connection.rwInfo.tryRecoverTs = ts;
    }

    protected void connectStandby(DmdbConnection connection) throws SQLException {
        if (StringUtil.isEmpty(connection.standbyHost) || connection.standbyPort <= 0) {
            this.log.warn(connection, "connStandby", "no standby");
            return;
        }
        try {
            DmProperties standbyProps = (DmProperties)connection.props.clone();
            standbyProps.setProperty(Configuration.host.getName(), connection.standbyHost);
            standbyProps.setProperty(Configuration.port.getName(), String.valueOf(connection.standbyPort));
            standbyProps.setProperty(Configuration.rwStandby.getName(), String.valueOf(true));
            standbyProps.setProperty(Configuration.epGroup.getName(), null);
            standbyProps.setProperty(Configuration.loginMode.getName(), String.valueOf(2));
            standbyProps.setProperty(Configuration.switchTimes.getName(), "1");
            connection.rwInfo.connStandby = DmDriver.driver.do_connect(standbyProps);
        }
        catch (Throwable ignore) {
            this.log.warn(connection, "connStandby", ignore.getMessage());
        }
    }

    private boolean checkStatusValid(DmdbConnection primary) {
        block8: {
            DmdbResultSet srs;
            DmdbStatement sstmt;
            DmdbResultSet prs;
            DmdbStatement pstmt;
            block7: {
                DmdbConnection standby = primary.rwInfo.connStandby;
                if (standby == null || standby.do_isClosed()) {
                    return false;
                }
                if (standby.svrMode != 2 || standby.svrStat != 4) {
                    return false;
                }
                pstmt = null;
                prs = null;
                sstmt = null;
                srs = null;
                int oguidPrimary = 0;
                try {
                    pstmt = primary.do_createStatement();
                    prs = pstmt.do_executeQuery("select oguid from v$instance");
                    prs.do_next();
                    oguidPrimary = prs.do_getInt(1);
                    sstmt = standby.do_createStatement();
                    srs = sstmt.do_executeQuery("select oguid from v$instance");
                    srs.do_next();
                    if (oguidPrimary != srs.do_getInt(1)) break block7;
                    MiscUtil.close(prs);
                }
                catch (Exception exception) {
                    break block8;
                }
                finally {
                    MiscUtil.close(prs);
                    MiscUtil.close(srs);
                    MiscUtil.close(pstmt);
                    MiscUtil.close(sstmt);
                }
                MiscUtil.close(srs);
                MiscUtil.close(pstmt);
                MiscUtil.close(sstmt);
                return true;
            }
            MiscUtil.close(prs);
            MiscUtil.close(srs);
            MiscUtil.close(pstmt);
            MiscUtil.close(sstmt);
        }
        return false;
    }

    public void afterExceptionOnStandby(DmdbConnection connection, SQLException e2) {
        if (e2.getErrorCode() == DBError.ECJDBC_COMMUNITION_ERROR.errCode) {
            this.removeStandby(connection);
        }
    }

    protected void removeStandby(DmdbConnection connection) {
        try {
            if (connection.rwInfo.connStandby != null) {
                connection.rwInfo.connStandby.do_close();
                connection.rwInfo.connStandby = null;
            }
        }
        catch (Throwable throwable) {}
    }

    public boolean isCreateStandbyStmt(DmdbStatement stmt) {
        return stmt != null && stmt.rwInfo.readOnly && this.isStandbyAlive(stmt.connection);
    }

    public <T> T execute(DmdbStatement stmt, String sql, RWCallBack<T> callback) throws SQLException {
        DmdbStatement orgStmt = stmt.rwInfo.stmtCurrent;
        this.recoverStandby(stmt.connection);
        this.distribute(stmt, sql);
        if (orgStmt != stmt.rwInfo.stmtCurrent) {
            stmt.rwInfo.stmtCurrent.resetParams(orgStmt);
        }
        T ret = null;
        boolean turnToPrimary = false;
        try {
            ret = callback.execute();
            DmdbStatement curStmt = stmt.rwInfo.stmtCurrent;
            switch (curStmt.getRetType()) {
                case 147: 
                case 148: 
                case 151: 
                case 153: 
                case 165: 
                case 166: {
                    try {
                        DmdbStatement otherStmt;
                        DmdbStatement dmdbStatement = otherStmt = curStmt != stmt ? stmt : stmt.rwInfo.stmtStandby;
                        if (otherStmt == null) break;
                        otherStmt.resetParams(curStmt);
                        callback.execute(otherStmt);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 162: {
                    String tmpsql = StringUtil.isNotEmpty(sql) ? sql.trim() : (StringUtil.isNotEmpty(stmt.nativeSql) ? stmt.nativeSql.trim() : "");
                    String sqlhead = tmpsql.split("[ (]", 2)[0];
                    if (sqlhead.equalsIgnoreCase("SP_SET_PARA_VALUE") || sqlhead.equalsIgnoreCase("SP_SET_SESSION_READONLY")) {
                        try {
                            DmdbStatement otherStmt;
                            DmdbStatement dmdbStatement = otherStmt = curStmt != stmt ? stmt : stmt.rwInfo.stmtStandby;
                            if (otherStmt == null) break;
                            otherStmt.resetParams(curStmt);
                            callback.execute(otherStmt);
                        }
                        catch (Exception exception) {}
                    }
                    break;
                }
                case 160: {
                    if (stmt.connection.rwHA && curStmt == stmt.rwInfo.stmtStandby && (curStmt.execInfo.rsDatas == null || curStmt.execInfo.rsDatas.length == 0)) {
                        turnToPrimary = true;
                    }
                    break;
                }
            }
        }
        catch (SQLException e2) {
            if (stmt.rwInfo.stmtCurrent == stmt.rwInfo.stmtStandby) {
                this.afterExceptionOnStandby(stmt.connection, e2);
                turnToPrimary = true;
            }
            throw e2;
        }
        if (turnToPrimary) {
            stmt.connection.rwInfo.toPrimary();
            stmt.rwInfo.stmtCurrent = stmt;
            stmt.resetParams(stmt.rwInfo.stmtStandby);
            return callback.execute(stmt);
        }
        return ret;
    }

    public boolean checkReadonly(DmdbStatement stmt, String sql) {
        boolean readonly = true;
        if (StringUtil.isNotEmpty(sql) && !stmt.connection.rwIgnoreSql) {
            String tmpsql = sql.trim();
            String sqlhead = tmpsql.split(" ", 2)[0];
            readonly = sqlhead.equalsIgnoreCase("SELECT") ? stmt.resultSetConcurrency == 1007 : !sqlhead.equalsIgnoreCase("INSERT") && !sqlhead.equalsIgnoreCase("UPDATE") && !sqlhead.equalsIgnoreCase("DELETE") && !sqlhead.equalsIgnoreCase("CREATE") && !sqlhead.equalsIgnoreCase("TRUNCATE") && !sqlhead.equalsIgnoreCase("DROP") && !sqlhead.equalsIgnoreCase("ALTER");
        }
        return readonly;
    }

    public RWSite distribute(DmdbStatement stmt, String sql) {
        RWSite dest = null;
        if (!this.isStandbyAlive(stmt.connection)) {
            this.log.debug((Object)stmt.connection, "distribute", "to Primary because standby not alive");
            dest = stmt.connection.rwInfo.toPrimary();
        } else if (stmt.connection.isoLevel == 8) {
            this.log.debug((Object)stmt.connection, "distribute", "to Primary because TRANSACTION_SERIALIZABLE");
            dest = stmt.connection.rwInfo.toPrimary();
        } else if (stmt instanceof DmdbPreparedStatement ? !stmt.rwInfo.readOnly : !this.checkReadonly(stmt, sql)) {
            this.log.debug((Object)stmt.connection, "distribute", "to Primary because sql not readonly");
            dest = stmt.connection.rwInfo.toPrimary();
        } else if (stmt.connection.rwInfo.distribute == RWSite.PRIMARY && !stmt.connection.getTransFinish() || stmt.connection.rwInfo.distribute == RWSite.STANDBY && !stmt.connection.rwInfo.connStandby.getTransFinish()) {
            dest = stmt.connection.rwInfo.distribute;
            this.log.debug((Object)stmt.connection, "distribute", "to " + (Object)((Object)dest) + " because transaction unfinished");
        } else if (!stmt.connection.rwAutoDistribute) {
            this.log.debug((Object)stmt.connection, "distribute", "to Primary because rwAutoDistribute=0 and readOnly=" + stmt.connection.readOnly);
            dest = stmt.connection.readOnly ? stmt.connection.rwInfo.toStandby() : stmt.connection.rwInfo.toPrimary();
        } else {
            dest = stmt.connection.rwInfo.toAny();
            this.log.debug((Object)stmt.connection, "distribute", "to " + (Object)((Object)dest) + " because new distribute");
        }
        if (dest == RWSite.STANDBY && !this.isStandbyStatementValid(stmt)) {
            try {
                stmt.rwInfo.stmtStandby = stmt instanceof DmdbCallableStatement ? stmt.connection.rwInfo.connStandby.do_prepareCall(stmt.nativeSql, stmt.resultSetType, stmt.resultSetConcurrency, stmt.resultSetHoldability) : (stmt instanceof DmdbPreparedStatement ? stmt.connection.rwInfo.connStandby.do_prepareStatement(stmt.nativeSql, stmt.resultSetType, stmt.resultSetConcurrency, stmt.resultSetHoldability) : stmt.connection.rwInfo.connStandby.do_createStatement(stmt.resultSetType, stmt.resultSetConcurrency, stmt.resultSetHoldability));
            }
            catch (Exception exception) {
                dest = stmt.connection.rwInfo.toPrimary();
            }
        }
        stmt.rwInfo.stmtCurrent = dest == RWSite.PRIMARY ? stmt : stmt.rwInfo.stmtStandby;
        return dest;
    }

    public boolean isStandbyAlive(DmdbConnection connection) {
        return connection.rwInfo.connStandby != null && !connection.rwInfo.connStandby.do_isClosed();
    }

    public boolean isStandbyStatementValid(DmdbStatement statement) {
        return statement.rwInfo.stmtStandby != null && !statement.rwInfo.stmtStandby.do_isClosed();
    }
}

