/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.log;

import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.driver.DmdbXAResource;
import dm.jdbc.filter.BaseFilter;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogFactory;
import dm.jdbc.filter.log.LogRecord;
import dm.jdbc.internal.conf.DmProperties;
import dm.jdbc.plugin.fldr.FldrConfig;
import dm.jdbc.plugin.fldr.FldrStatement;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.RowIdLifetime;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class LogFilter
extends BaseFilter {
    private static final ILogger LOG = LogFactory.getLog(LogFilter.class);

    private LogFilter() {
    }

    public static LogFilter getInstance() {
        return new LogFilter();
    }

    private void doLog(LogRecord logRecord) {
        if (logRecord == null) {
            return;
        }
        logRecord.endTime = System.nanoTime();
        try {
            if (logRecord.getThrowable() != null) {
                LOG.error(logRecord.toString(), logRecord.getThrowable());
            } else if (logRecord.getSql() != null && LOG.isSqlEnabled()) {
                LOG.sql(logRecord.toString());
            } else {
                LOG.info(logRecord.toString());
            }
        }
        catch (Exception e2) {
            LOG.error("Log failed!", e2);
        }
    }

    @Override
    public Array CallableStatement_getArray(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getArray", parameterName);
        try {
            Array ret = super.CallableStatement_getArray(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            Array array = ret;
            return array;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Array CallableStatement_getArray(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getArray", parameterIndex);
        try {
            Array ret = super.CallableStatement_getArray(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            Array array = ret;
            return array;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getBigDecimal", parameterName);
        try {
            BigDecimal ret = super.CallableStatement_getBigDecimal(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            BigDecimal bigDecimal = ret;
            return bigDecimal;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getBigDecimal", parameterIndex);
        try {
            BigDecimal ret = super.CallableStatement_getBigDecimal(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            BigDecimal bigDecimal = ret;
            return bigDecimal;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(DmdbCallableStatement callableStatement, int parameterIndex, int scale) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getBigDecimal", parameterIndex, scale);
        try {
            BigDecimal ret = super.CallableStatement_getBigDecimal(callableStatement, parameterIndex, scale);
            logRecord.setReturnValue(ret);
            BigDecimal bigDecimal = ret;
            return bigDecimal;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Blob CallableStatement_getBlob(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getBlob", parameterName);
        try {
            Blob ret = super.CallableStatement_getBlob(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            Blob blob = ret;
            return blob;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Blob CallableStatement_getBlob(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getBlob", parameterIndex);
        try {
            Blob ret = super.CallableStatement_getBlob(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            Blob blob = ret;
            return blob;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean CallableStatement_getBoolean(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getBoolean", parameterName);
        try {
            boolean ret = super.CallableStatement_getBoolean(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean CallableStatement_getBoolean(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getBoolean", parameterIndex);
        try {
            boolean ret = super.CallableStatement_getBoolean(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public byte CallableStatement_getByte(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getByte", parameterName);
        try {
            byte ret = super.CallableStatement_getByte(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            byte by = ret;
            return by;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public byte CallableStatement_getByte(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getByte", parameterIndex);
        try {
            byte ret = super.CallableStatement_getByte(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            byte by = ret;
            return by;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public byte[] CallableStatement_getBytes(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getBytes", parameterName);
        try {
            byte[] ret = super.CallableStatement_getBytes(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            byte[] byArray = ret;
            return byArray;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public byte[] CallableStatement_getBytes(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getBytes", parameterIndex);
        try {
            byte[] ret = super.CallableStatement_getBytes(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            byte[] byArray = ret;
            return byArray;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Reader CallableStatement_getCharacterStream(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getCharacterStream", parameterName);
        try {
            Reader ret = super.CallableStatement_getCharacterStream(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            Reader reader = ret;
            return reader;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Reader CallableStatement_getCharacterStream(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getCharacterStream", parameterIndex);
        try {
            Reader ret = super.CallableStatement_getCharacterStream(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            Reader reader = ret;
            return reader;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Clob CallableStatement_getClob(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getClob", parameterName);
        try {
            Clob ret = super.CallableStatement_getClob(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            Clob clob = ret;
            return clob;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Clob CallableStatement_getClob(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getClob", parameterIndex);
        try {
            Clob ret = super.CallableStatement_getClob(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            Clob clob = ret;
            return clob;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Date CallableStatement_getDate(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getDate", parameterName);
        try {
            Date ret = super.CallableStatement_getDate(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            Date date = ret;
            return date;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Date CallableStatement_getDate(DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getDate", parameterName, cal);
        try {
            Date ret = super.CallableStatement_getDate(callableStatement, parameterName, cal);
            logRecord.setReturnValue(ret);
            Date date = ret;
            return date;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Date CallableStatement_getDate(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getDate", parameterIndex);
        try {
            Date ret = super.CallableStatement_getDate(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            Date date = ret;
            return date;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Date CallableStatement_getDate(DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getDate", parameterIndex, cal);
        try {
            Date ret = super.CallableStatement_getDate(callableStatement, parameterIndex, cal);
            logRecord.setReturnValue(ret);
            Date date = ret;
            return date;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public double CallableStatement_getDouble(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getDouble", parameterName);
        try {
            double ret = super.CallableStatement_getDouble(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            double d2 = ret;
            return d2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public double CallableStatement_getDouble(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getDouble", parameterIndex);
        try {
            double ret = super.CallableStatement_getDouble(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            double d2 = ret;
            return d2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public float CallableStatement_getFloat(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getFloat", parameterName);
        try {
            float ret = super.CallableStatement_getFloat(callableStatement, parameterName);
            logRecord.setReturnValue(Float.valueOf(ret));
            float f2 = ret;
            return f2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public float CallableStatement_getFloat(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getFloat", parameterIndex);
        try {
            float ret = super.CallableStatement_getFloat(callableStatement, parameterIndex);
            logRecord.setReturnValue(Float.valueOf(ret));
            float f2 = ret;
            return f2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int CallableStatement_getInt(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getInt", parameterName);
        try {
            int ret = super.CallableStatement_getInt(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int CallableStatement_getInt(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getInt", parameterIndex);
        try {
            int ret = super.CallableStatement_getInt(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long CallableStatement_getLong(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getLong", parameterName);
        try {
            long ret = super.CallableStatement_getLong(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long CallableStatement_getLong(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getLong", parameterIndex);
        try {
            long ret = super.CallableStatement_getLong(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getNCharacterStream", parameterName);
        try {
            Reader ret = super.CallableStatement_getNCharacterStream(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            Reader reader = ret;
            return reader;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getNCharacterStream", parameterIndex);
        try {
            Reader ret = super.CallableStatement_getNCharacterStream(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            Reader reader = ret;
            return reader;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public NClob CallableStatement_getNClob(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getNClob", parameterName);
        try {
            NClob ret = super.CallableStatement_getNClob(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            NClob nClob = ret;
            return nClob;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public NClob CallableStatement_getNClob(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getNClob", parameterIndex);
        try {
            NClob ret = super.CallableStatement_getNClob(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            NClob nClob = ret;
            return nClob;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String CallableStatement_getNString(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getNString", parameterName);
        try {
            String ret = super.CallableStatement_getNString(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String CallableStatement_getNString(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getNString", parameterIndex);
        try {
            String ret = super.CallableStatement_getNString(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getObject", parameterName);
        try {
            Object ret = super.CallableStatement_getObject(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            Object object = ret;
            return object;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public <T> T CallableStatement_getObject(DmdbCallableStatement callableStatement, String parameterName, Class<T> type) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getObject", parameterName, type);
        try {
            T ret = super.CallableStatement_getObject(callableStatement, parameterName, type);
            logRecord.setReturnValue(ret);
            T t2 = ret;
            return t2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, String parameterName, Map<String, Class<?>> map) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getObject", parameterName, map);
        try {
            Object ret = super.CallableStatement_getObject(callableStatement, parameterName, map);
            logRecord.setReturnValue(ret);
            Object object = ret;
            return object;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getObject", parameterIndex);
        try {
            Object ret = super.CallableStatement_getObject(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            Object object = ret;
            return object;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public <T> T CallableStatement_getObject(DmdbCallableStatement callableStatement, int parameterIndex, Class<T> type) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getObject", parameterIndex, type);
        try {
            T ret = super.CallableStatement_getObject(callableStatement, parameterIndex, type);
            logRecord.setReturnValue(ret);
            T t2 = ret;
            return t2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getObject", parameterIndex, map);
        try {
            Object ret = super.CallableStatement_getObject(callableStatement, parameterIndex, map);
            logRecord.setReturnValue(ret);
            Object object = ret;
            return object;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Ref CallableStatement_getRef(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getRef", parameterName);
        try {
            Ref ret = super.CallableStatement_getRef(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            Ref ref = ret;
            return ref;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Ref CallableStatement_getRef(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getRef", parameterIndex);
        try {
            Ref ret = super.CallableStatement_getRef(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            Ref ref = ret;
            return ref;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public RowId CallableStatement_getRowId(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getRowId", parameterName);
        try {
            RowId ret = super.CallableStatement_getRowId(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            RowId rowId = ret;
            return rowId;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public RowId CallableStatement_getRowId(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getRowId", parameterIndex);
        try {
            RowId ret = super.CallableStatement_getRowId(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            RowId rowId = ret;
            return rowId;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getSQLXML", parameterName);
        try {
            SQLXML ret = super.CallableStatement_getSQLXML(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            SQLXML sQLXML = ret;
            return sQLXML;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getSQLXML", parameterIndex);
        try {
            SQLXML ret = super.CallableStatement_getSQLXML(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            SQLXML sQLXML = ret;
            return sQLXML;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public short CallableStatement_getShort(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getShort", parameterName);
        try {
            short ret = super.CallableStatement_getShort(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            short s2 = ret;
            return s2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public short CallableStatement_getShort(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getShort", parameterIndex);
        try {
            short ret = super.CallableStatement_getShort(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            short s2 = ret;
            return s2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String CallableStatement_getString(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getString", parameterName);
        try {
            String ret = super.CallableStatement_getString(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String CallableStatement_getString(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getString", parameterIndex);
        try {
            String ret = super.CallableStatement_getString(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getTime", parameterName);
        try {
            Time ret = super.CallableStatement_getTime(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            Time time = ret;
            return time;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getTime", parameterName, cal);
        try {
            Time ret = super.CallableStatement_getTime(callableStatement, parameterName, cal);
            logRecord.setReturnValue(ret);
            Time time = ret;
            return time;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getTime", parameterIndex);
        try {
            Time ret = super.CallableStatement_getTime(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            Time time = ret;
            return time;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getTime", parameterIndex, cal);
        try {
            Time ret = super.CallableStatement_getTime(callableStatement, parameterIndex, cal);
            logRecord.setReturnValue(ret);
            Time time = ret;
            return time;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getTimestamp", parameterName);
        try {
            Timestamp ret = super.CallableStatement_getTimestamp(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getTimestamp", parameterName, cal);
        try {
            Timestamp ret = super.CallableStatement_getTimestamp(callableStatement, parameterName, cal);
            logRecord.setReturnValue(ret);
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getTimestamp", parameterIndex);
        try {
            Timestamp ret = super.CallableStatement_getTimestamp(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getTimestamp", parameterIndex, cal);
        try {
            Timestamp ret = super.CallableStatement_getTimestamp(callableStatement, parameterIndex, cal);
            logRecord.setReturnValue(ret);
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public URL CallableStatement_getURL(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getURL", parameterName);
        try {
            URL ret = super.CallableStatement_getURL(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            URL uRL = ret;
            return uRL;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public URL CallableStatement_getURL(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getURL", parameterIndex);
        try {
            URL ret = super.CallableStatement_getURL(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            URL uRL = ret;
            return uRL;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "registerOutParameter", parameterName, sqlType);
        try {
            try {
                super.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "registerOutParameter", parameterName, sqlType, typeName);
        try {
            try {
                super.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, typeName);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, int sqlType, int scale) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "registerOutParameter", parameterName, sqlType, scale);
        try {
            try {
                super.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, scale);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, int sqlType) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "registerOutParameter", parameterIndex, sqlType);
        try {
            try {
                super.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "registerOutParameter", parameterIndex, sqlType, typeName);
        try {
            try {
                super.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, typeName);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, int scale) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "registerOutParameter", parameterIndex, sqlType, scale);
        try {
            try {
                super.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, scale);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setAsciiStream", parameterName, x2);
        try {
            try {
                super.CallableStatement_setAsciiStream(callableStatement, parameterName, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setAsciiStream", parameterName, x2, length);
        try {
            try {
                super.CallableStatement_setAsciiStream(callableStatement, parameterName, x2, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setAsciiStream", parameterName, x2, length);
        try {
            try {
                super.CallableStatement_setAsciiStream(callableStatement, parameterName, x2, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setBigDecimal(DmdbCallableStatement callableStatement, String parameterName, BigDecimal x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setBigDecimal", parameterName, x2);
        try {
            try {
                super.CallableStatement_setBigDecimal(callableStatement, parameterName, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setBinaryStream", parameterName, x2);
        try {
            try {
                super.CallableStatement_setBinaryStream(callableStatement, parameterName, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setBinaryStream", parameterName, x2, length);
        try {
            try {
                super.CallableStatement_setBinaryStream(callableStatement, parameterName, x2, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setBinaryStream", parameterName, x2, length);
        try {
            try {
                super.CallableStatement_setBinaryStream(callableStatement, parameterName, x2, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, Blob x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setBlob", parameterName, x2);
        try {
            try {
                super.CallableStatement_setBlob(callableStatement, parameterName, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setBlob", parameterName, inputStream);
        try {
            try {
                super.CallableStatement_setBlob(callableStatement, parameterName, inputStream);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setBlob", parameterName, inputStream, length);
        try {
            try {
                super.CallableStatement_setBlob(callableStatement, parameterName, inputStream, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setBoolean(DmdbCallableStatement callableStatement, String parameterName, boolean x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setBoolean", parameterName, x2);
        try {
            try {
                super.CallableStatement_setBoolean(callableStatement, parameterName, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setByte(DmdbCallableStatement callableStatement, String parameterName, byte x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setByte", parameterName, x2);
        try {
            try {
                super.CallableStatement_setByte(callableStatement, parameterName, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setBytes(DmdbCallableStatement callableStatement, String parameterName, byte[] x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setBytes", parameterName, x2);
        try {
            try {
                super.CallableStatement_setBytes(callableStatement, parameterName, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setCharacterStream", parameterName, reader);
        try {
            try {
                super.CallableStatement_setCharacterStream(callableStatement, parameterName, reader);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader reader, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setCharacterStream", parameterName, reader, length);
        try {
            try {
                super.CallableStatement_setCharacterStream(callableStatement, parameterName, reader, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setCharacterStream", parameterName, reader, length);
        try {
            try {
                super.CallableStatement_setCharacterStream(callableStatement, parameterName, reader, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Clob x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setClob", parameterName, x2);
        try {
            try {
                super.CallableStatement_setClob(callableStatement, parameterName, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setClob", parameterName, reader);
        try {
            try {
                super.CallableStatement_setClob(callableStatement, parameterName, reader);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setClob", parameterName, reader, length);
        try {
            try {
                super.CallableStatement_setClob(callableStatement, parameterName, reader, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setDate(DmdbCallableStatement callableStatement, String parameterName, Date x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setDate", parameterName, x2);
        try {
            try {
                super.CallableStatement_setDate(callableStatement, parameterName, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setDate(DmdbCallableStatement callableStatement, String parameterName, Date x2, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setDate", parameterName, x2, cal);
        try {
            try {
                super.CallableStatement_setDate(callableStatement, parameterName, x2, cal);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setDouble(DmdbCallableStatement callableStatement, String parameterName, double x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setDouble", parameterName, x2);
        try {
            try {
                super.CallableStatement_setDouble(callableStatement, parameterName, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setFloat(DmdbCallableStatement callableStatement, String parameterName, float x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setFloat", parameterName, Float.valueOf(x2));
        try {
            try {
                super.CallableStatement_setFloat(callableStatement, parameterName, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setInt(DmdbCallableStatement callableStatement, String parameterName, int x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setInt", parameterName, x2);
        try {
            try {
                super.CallableStatement_setInt(callableStatement, parameterName, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setLong(DmdbCallableStatement callableStatement, String parameterName, long x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setLong", parameterName, x2);
        try {
            try {
                super.CallableStatement_setLong(callableStatement, parameterName, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setNCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader value) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setNCharacterStream", parameterName, value);
        try {
            try {
                super.CallableStatement_setNCharacterStream(callableStatement, parameterName, value);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setNCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader value, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setNCharacterStream", parameterName, value, length);
        try {
            try {
                super.CallableStatement_setNCharacterStream(callableStatement, parameterName, value, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, NClob value) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setNClob", parameterName, value);
        try {
            try {
                super.CallableStatement_setNClob(callableStatement, parameterName, value);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setNClob", parameterName, reader);
        try {
            try {
                super.CallableStatement_setNClob(callableStatement, parameterName, reader);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setNClob", parameterName, reader, length);
        try {
            try {
                super.CallableStatement_setNClob(callableStatement, parameterName, reader, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setNString(DmdbCallableStatement callableStatement, String parameterName, String value) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setNString", parameterName, value);
        try {
            try {
                super.CallableStatement_setNString(callableStatement, parameterName, value);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setNull(DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setNull", parameterName, sqlType);
        try {
            try {
                super.CallableStatement_setNull(callableStatement, parameterName, sqlType);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setNull(DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setNull", parameterName, sqlType, typeName);
        try {
            try {
                super.CallableStatement_setNull(callableStatement, parameterName, sqlType, typeName);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setObject", parameterName, x2);
        try {
            try {
                super.CallableStatement_setObject(callableStatement, parameterName, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setObject", parameterName, x2, targetSqlType);
        try {
            try {
                super.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType, int scale) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setObject", parameterName, x2, targetSqlType, scale);
        try {
            try {
                super.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType, scale);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setRowId(DmdbCallableStatement callableStatement, String parameterName, RowId x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setRowId", parameterName, x2);
        try {
            try {
                super.CallableStatement_setRowId(callableStatement, parameterName, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setSQLXML(DmdbCallableStatement callableStatement, String parameterName, SQLXML xmlObject) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setSQLXML", parameterName, xmlObject);
        try {
            try {
                super.CallableStatement_setSQLXML(callableStatement, parameterName, xmlObject);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setShort(DmdbCallableStatement callableStatement, String parameterName, short x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setShort", parameterName, x2);
        try {
            try {
                super.CallableStatement_setShort(callableStatement, parameterName, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setString(DmdbCallableStatement callableStatement, String parameterName, String x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setString", parameterName, x2);
        try {
            try {
                super.CallableStatement_setString(callableStatement, parameterName, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setTime(DmdbCallableStatement callableStatement, String parameterName, Time x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setTime", parameterName, x2);
        try {
            try {
                super.CallableStatement_setTime(callableStatement, parameterName, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setTime(DmdbCallableStatement callableStatement, String parameterName, Time x2, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setTime", parameterName, x2, cal);
        try {
            try {
                super.CallableStatement_setTime(callableStatement, parameterName, x2, cal);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setTimestamp(DmdbCallableStatement callableStatement, String parameterName, Timestamp x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setTimestamp", parameterName, x2);
        try {
            try {
                super.CallableStatement_setTimestamp(callableStatement, parameterName, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setTimestamp(DmdbCallableStatement callableStatement, String parameterName, Timestamp x2, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setTimestamp", parameterName, x2, cal);
        try {
            try {
                super.CallableStatement_setTimestamp(callableStatement, parameterName, x2, cal);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setURL(DmdbCallableStatement callableStatement, String parameterName, URL val) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setURL", parameterName, val);
        try {
            try {
                super.CallableStatement_setURL(callableStatement, parameterName, val);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean CallableStatement_wasNull(DmdbCallableStatement callableStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "wasNull", new Object[0]);
        try {
            boolean ret = super.CallableStatement_wasNull(callableStatement);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setObject", parameterName, x2, targetSqlType, scaleOrLength);
        try {
            try {
                super.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType, scaleOrLength);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, SQLType targetSqlType) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setObject", parameterName, x2, targetSqlType);
        try {
            try {
                super.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "registerOutParameter", parameterIndex, sqlType);
        try {
            try {
                super.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "registerOutParameter", parameterIndex, sqlType, scale);
        try {
            try {
                super.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, scale);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "registerOutParameter", parameterIndex, sqlType, typeName);
        try {
            try {
                super.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, typeName);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "registerOutParameter", parameterName, sqlType);
        try {
            try {
                super.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType, int scale) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "registerOutParameter", parameterName, sqlType, scale);
        try {
            try {
                super.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, scale);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType, String typeName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "registerOutParameter", parameterName, sqlType, typeName);
        try {
            try {
                super.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, typeName);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public DmdbIntervalYM CallableStatement_getINTERVALYM(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getINTERVALYM", parameterIndex);
        try {
            DmdbIntervalYM ret = super.CallableStatement_getINTERVALYM(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            DmdbIntervalYM dmdbIntervalYM = ret;
            return dmdbIntervalYM;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public DmdbIntervalDT CallableStatement_getINTERVALDT(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getINTERVALDT", parameterIndex);
        try {
            DmdbIntervalDT ret = super.CallableStatement_getINTERVALDT(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            DmdbIntervalDT dmdbIntervalDT = ret;
            return dmdbIntervalDT;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public DmdbTimestamp CallableStatement_getTIMESTAMP(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getTIMESTAMP", parameterIndex);
        try {
            DmdbTimestamp ret = super.CallableStatement_getTIMESTAMP(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            DmdbTimestamp dmdbTimestamp = ret;
            return dmdbTimestamp;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet CallableStatement_getCursor(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getCursor", parameterIndex);
        try {
            ResultSet ret = super.CallableStatement_getCursor(callableStatement, parameterIndex);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_reconnect(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "reconnect", new Object[0]);
        try {
            try {
                super.Connection_reconnect(connection);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_abort(DmdbConnection connection, Executor executor) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "abort", executor);
        try {
            try {
                super.Connection_abort(connection, executor);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_clearWarnings(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "clearWarnings", new Object[0]);
        try {
            try {
                super.Connection_clearWarnings(connection);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_close(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "close", new Object[0]);
        try {
            try {
                super.Connection_close(connection);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_commit(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "commit", new Object[0]);
        try {
            try {
                super.Connection_commit(connection);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Array Connection_createArrayOf(DmdbConnection connection, String typeName, Object[] elements) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "createArrayOf", typeName, elements);
        try {
            Array ret = super.Connection_createArrayOf(connection, typeName, elements);
            logRecord.setReturnValue(ret);
            Array array = ret;
            return array;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Blob Connection_createBlob(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "createBlob", new Object[0]);
        try {
            Blob ret = super.Connection_createBlob(connection);
            logRecord.setReturnValue(ret);
            Blob blob = ret;
            return blob;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Clob Connection_createClob(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "createClob", new Object[0]);
        try {
            Clob ret = super.Connection_createClob(connection);
            logRecord.setReturnValue(ret);
            Clob clob = ret;
            return clob;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public NClob Connection_createNClob(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "createNClob", new Object[0]);
        try {
            NClob ret = super.Connection_createNClob(connection);
            logRecord.setReturnValue(ret);
            NClob nClob = ret;
            return nClob;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public SQLXML Connection_createSQLXML(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "createSQLXML", new Object[0]);
        try {
            SQLXML ret = super.Connection_createSQLXML(connection);
            logRecord.setReturnValue(ret);
            SQLXML sQLXML = ret;
            return sQLXML;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Statement Connection_createStatement(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "createStatement", new Object[0]);
        try {
            Statement ret = this.next != null ? this.next.Connection_createStatement(connection) : connection.do_createStatement();
            logRecord.setReturnValue(ret);
            Statement statement = ret;
            return statement;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Statement Connection_createStatement(DmdbConnection connection, int resultSetType, int resultSetConcurrency) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "createStatement", resultSetType, resultSetConcurrency);
        try {
            Statement ret = this.next != null ? this.next.Connection_createStatement(connection, resultSetType, resultSetConcurrency) : connection.do_createStatement(resultSetType, resultSetConcurrency);
            logRecord.setReturnValue(ret);
            Statement statement = ret;
            return statement;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Statement Connection_createStatement(DmdbConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "createStatement", resultSetType, resultSetConcurrency, resultSetHoldability);
        try {
            Statement ret = super.Connection_createStatement(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
            logRecord.setReturnValue(ret);
            Statement statement = ret;
            return statement;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Struct Connection_createStruct(DmdbConnection connection, String typeName, Object[] attributes) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "createStruct", typeName, attributes);
        try {
            Struct ret = super.Connection_createStruct(connection, typeName, attributes);
            logRecord.setReturnValue(ret);
            Struct struct = ret;
            return struct;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Connection_getAutoCommit(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getAutoCommit", new Object[0]);
        try {
            boolean ret = super.Connection_getAutoCommit(connection);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String Connection_getCatalog(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getCatalog", new Object[0]);
        try {
            String ret = super.Connection_getCatalog(connection);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Properties Connection_getClientInfo(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getClientInfo", new Object[0]);
        try {
            Properties ret = super.Connection_getClientInfo(connection);
            logRecord.setReturnValue(ret);
            Properties properties = ret;
            return properties;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String Connection_getClientInfo(DmdbConnection connection, String name) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getClientInfo", name);
        try {
            String ret = super.Connection_getClientInfo(connection, name);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Connection_getHoldability(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getHoldability", new Object[0]);
        try {
            int ret = super.Connection_getHoldability(connection);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public DatabaseMetaData Connection_getMetaData(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getMetaData", new Object[0]);
        try {
            DatabaseMetaData ret = super.Connection_getMetaData(connection);
            logRecord.setReturnValue(ret);
            DatabaseMetaData databaseMetaData = ret;
            return databaseMetaData;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Connection_getNetworkTimeout(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getNetworkTimeout", new Object[0]);
        try {
            int ret = super.Connection_getNetworkTimeout(connection);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String Connection_getSchema(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getSchema", new Object[0]);
        try {
            String ret = super.Connection_getSchema(connection);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Connection_getTransactionIsolation(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getTransactionIsolation", new Object[0]);
        try {
            int ret = super.Connection_getTransactionIsolation(connection);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Map<String, Class<?>> Connection_getTypeMap(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getTypeMap", new Object[0]);
        try {
            Map<String, Class<?>> ret = super.Connection_getTypeMap(connection);
            logRecord.setReturnValue(ret);
            Map<String, Class<?>> map = ret;
            return map;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public SQLWarning Connection_getWarnings(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "getWarnings", new Object[0]);
        try {
            SQLWarning ret = super.Connection_getWarnings(connection);
            logRecord.setReturnValue(ret);
            SQLWarning sQLWarning = ret;
            return sQLWarning;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Connection_isClosed(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "isClosed", new Object[0]);
        try {
            boolean ret = super.Connection_isClosed(connection);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Connection_isReadOnly(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "isReadOnly", new Object[0]);
        try {
            boolean ret = super.Connection_isReadOnly(connection);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Connection_isValid(DmdbConnection connection, int timeout) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "isValid", timeout);
        try {
            boolean ret = super.Connection_isValid(connection, timeout);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String Connection_nativeSQL(DmdbConnection connection, String sql) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "nativeSQL", sql);
        logRecord.setSql(sql);
        try {
            String ret = super.Connection_nativeSQL(connection, sql);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public CallableStatement Connection_prepareCall(DmdbConnection connection, String sql) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "prepareCall", sql);
        logRecord.setSql(sql);
        try {
            CallableStatement ret = super.Connection_prepareCall(connection, sql);
            logRecord.setReturnValue(ret);
            CallableStatement callableStatement = ret;
            return callableStatement;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public CallableStatement Connection_prepareCall(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "prepareCall", sql, resultSetType, resultSetConcurrency);
        logRecord.setSql(sql);
        try {
            CallableStatement ret = super.Connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency);
            logRecord.setReturnValue(ret);
            CallableStatement callableStatement = ret;
            return callableStatement;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public CallableStatement Connection_prepareCall(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "prepareCall", sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        logRecord.setSql(sql);
        try {
            CallableStatement ret = super.Connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            logRecord.setReturnValue(ret);
            CallableStatement callableStatement = ret;
            return callableStatement;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public FldrStatement Connection_fldrStatement(DmdbConnection connection, FldrConfig config) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "fldrPrepareStatement", config);
        logRecord.setSql(config.toString());
        try {
            FldrStatement ret = super.Connection_fldrStatement(connection, config);
            logRecord.setReturnValue(ret);
            FldrStatement fldrStatement = ret;
            return fldrStatement;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "prepareStatement", sql);
        logRecord.setSql(sql);
        try {
            PreparedStatement ret = this.next != null ? this.next.Connection_prepareStatement(connection, sql) : connection.do_prepareStatement(sql);
            logRecord.setReturnValue(ret);
            PreparedStatement preparedStatement = ret;
            return preparedStatement;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, String[] columnNames) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "prepareStatement", sql, columnNames);
        logRecord.setSql(sql);
        try {
            PreparedStatement ret = this.next != null ? this.next.Connection_prepareStatement(connection, sql, columnNames) : connection.do_prepareStatement(sql, columnNames);
            logRecord.setReturnValue(ret);
            PreparedStatement preparedStatement = ret;
            return preparedStatement;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "prepareStatement", sql, autoGeneratedKeys);
        logRecord.setSql(sql);
        try {
            PreparedStatement ret = this.next != null ? this.next.Connection_prepareStatement(connection, sql, autoGeneratedKeys) : connection.do_prepareStatement(sql, autoGeneratedKeys);
            logRecord.setReturnValue(ret);
            PreparedStatement preparedStatement = ret;
            return preparedStatement;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int[] columnIndexes) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "prepareStatement", sql, columnIndexes);
        logRecord.setSql(sql);
        try {
            PreparedStatement ret = this.next != null ? this.next.Connection_prepareStatement(connection, sql, columnIndexes) : connection.do_prepareStatement(sql, columnIndexes);
            logRecord.setReturnValue(ret);
            PreparedStatement preparedStatement = ret;
            return preparedStatement;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "prepareStatement", sql, resultSetType, resultSetConcurrency);
        logRecord.setSql(sql);
        try {
            PreparedStatement ret = this.next != null ? this.next.Connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency) : connection.do_prepareStatement(sql, resultSetType, resultSetConcurrency);
            logRecord.setReturnValue(ret);
            PreparedStatement preparedStatement = ret;
            return preparedStatement;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "prepareStatement", sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        logRecord.setSql(sql);
        try {
            PreparedStatement ret = super.Connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            logRecord.setReturnValue(ret);
            PreparedStatement preparedStatement = ret;
            return preparedStatement;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_releaseSavepoint(DmdbConnection connection, Savepoint savepoint) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "releaseSavepoint", savepoint);
        try {
            try {
                super.Connection_releaseSavepoint(connection, savepoint);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_rollback(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "rollback", new Object[0]);
        try {
            try {
                super.Connection_rollback(connection);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_rollback(DmdbConnection connection, Savepoint savepoint) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "rollback", savepoint);
        try {
            try {
                super.Connection_rollback(connection, savepoint);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_setAutoCommit(DmdbConnection connection, boolean autoCommit) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "setAutoCommit", autoCommit);
        try {
            try {
                super.Connection_setAutoCommit(connection, autoCommit);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_setCatalog(DmdbConnection connection, String catalog) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "setCatalog", catalog);
        try {
            try {
                super.Connection_setCatalog(connection, catalog);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_setClientInfo(DmdbConnection connection, Properties properties) throws SQLClientInfoException {
        LogRecord logRecord = new LogRecord(connection, "setClientInfo", properties);
        try {
            try {
                super.Connection_setClientInfo(connection, properties);
            }
            catch (SQLClientInfoException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_setClientInfo(DmdbConnection connection, String name, String value) throws SQLClientInfoException {
        LogRecord logRecord = new LogRecord(connection, "setClientInfo", name, value);
        try {
            try {
                super.Connection_setClientInfo(connection, name, value);
            }
            catch (SQLClientInfoException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_setHoldability(DmdbConnection connection, int holdability) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "setHoldability", holdability);
        try {
            try {
                super.Connection_setHoldability(connection, holdability);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_setNetworkTimeout(DmdbConnection connection, Executor executor, int milliseconds) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "setNetworkTimeout", executor, milliseconds);
        try {
            try {
                super.Connection_setNetworkTimeout(connection, executor, milliseconds);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_setReadOnly(DmdbConnection connection, boolean readOnly) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "setReadOnly", readOnly);
        try {
            try {
                super.Connection_setReadOnly(connection, readOnly);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Savepoint Connection_setSavepoint(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "setSavepoint", new Object[0]);
        try {
            Savepoint ret = super.Connection_setSavepoint(connection);
            logRecord.setReturnValue(ret);
            Savepoint savepoint = ret;
            return savepoint;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Savepoint Connection_setSavepoint(DmdbConnection connection, String name) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "setSavepoint", name);
        try {
            Savepoint ret = super.Connection_setSavepoint(connection, name);
            logRecord.setReturnValue(ret);
            Savepoint savepoint = ret;
            return savepoint;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_setSchema(DmdbConnection connection, String schema) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "setSchema", schema);
        try {
            try {
                super.Connection_setSchema(connection, schema);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_setTransactionIsolation(DmdbConnection connection, int level) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "setTransactionIsolation", level);
        try {
            try {
                super.Connection_setTransactionIsolation(connection, level);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Connection_setTypeMap(DmdbConnection connection, Map<String, Class<?>> map) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "setTypeMap", map);
        try {
            try {
                super.Connection_setTypeMap(connection, map);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_allProceduresAreCallable(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "allProceduresAreCallable", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_allProceduresAreCallable(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_allTablesAreSelectable(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "allTablesAreSelectable", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_allTablesAreSelectable(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_autoCommitFailureClosesAllResultSets(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "autoCommitFailureClosesAllResultSets", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_autoCommitFailureClosesAllResultSets(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_dataDefinitionCausesTransactionCommit(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "dataDefinitionCausesTransactionCommit", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_dataDefinitionCausesTransactionCommit(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_dataDefinitionIgnoredInTransactions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "dataDefinitionIgnoredInTransactions", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_dataDefinitionIgnoredInTransactions(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_deletesAreDetected(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "deletesAreDetected", type);
        try {
            boolean ret = super.DatabaseMetaData_deletesAreDetected(databaseMetaData, type);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_doesMaxRowSizeIncludeBlobs(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "doesMaxRowSizeIncludeBlobs", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_doesMaxRowSizeIncludeBlobs(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_generatedKeyAlwaysReturned(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "generatedKeyAlwaysReturned", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_generatedKeyAlwaysReturned(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getAttributes(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getAttributes", catalog, schemaPattern, typeNamePattern, attributeNamePattern);
        try {
            ResultSet ret = super.DatabaseMetaData_getAttributes(databaseMetaData, catalog, schemaPattern, typeNamePattern, attributeNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getBestRowIdentifier(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getBestRowIdentifier", catalog, schema, table, scope, nullable);
        try {
            ResultSet ret = super.DatabaseMetaData_getBestRowIdentifier(databaseMetaData, catalog, schema, table, scope, nullable);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getCatalogSeparator(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getCatalogSeparator", new Object[0]);
        try {
            String ret = super.DatabaseMetaData_getCatalogSeparator(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getCatalogTerm(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getCatalogTerm", new Object[0]);
        try {
            String ret = super.DatabaseMetaData_getCatalogTerm(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getCatalogs(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getCatalogs", new Object[0]);
        try {
            ResultSet ret = super.DatabaseMetaData_getCatalogs(databaseMetaData);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getClientInfoProperties(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getClientInfoProperties", new Object[0]);
        try {
            ResultSet ret = super.DatabaseMetaData_getClientInfoProperties(databaseMetaData);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getColumnPrivileges(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getColumnPrivileges", catalog, schema, table, columnNamePattern);
        try {
            ResultSet ret = super.DatabaseMetaData_getColumnPrivileges(databaseMetaData, catalog, schema, table, columnNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getColumns", catalog, schemaPattern, tableNamePattern, columnNamePattern);
        try {
            ResultSet ret = super.DatabaseMetaData_getColumns(databaseMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Connection DatabaseMetaData_getConnection(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getConnection", new Object[0]);
        try {
            Connection ret = super.DatabaseMetaData_getConnection(databaseMetaData);
            logRecord.setReturnValue(ret);
            Connection connection = ret;
            return connection;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getCrossReference(DmdbDatabaseMetaData databaseMetaData, String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getCrossReference", parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
        try {
            ResultSet ret = super.DatabaseMetaData_getCrossReference(databaseMetaData, parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getDatabaseMajorVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getDatabaseMajorVersion", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getDatabaseMajorVersion(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getDatabaseMinorVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getDatabaseMinorVersion", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getDatabaseMinorVersion(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getDatabaseProductName(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getDatabaseProductName", new Object[0]);
        try {
            String ret = super.DatabaseMetaData_getDatabaseProductName(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getDatabaseProductVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getDatabaseProductVersion", new Object[0]);
        try {
            String ret = super.DatabaseMetaData_getDatabaseProductVersion(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getDefaultTransactionIsolation(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getDefaultTransactionIsolation", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getDefaultTransactionIsolation(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getDriverMajorVersion(DmdbDatabaseMetaData databaseMetaData) {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getDriverMajorVersion", new Object[0]);
        int ret = super.DatabaseMetaData_getDriverMajorVersion(databaseMetaData);
        logRecord.setReturnValue(ret);
        return ret;
    }

    @Override
    public int DatabaseMetaData_getDriverMinorVersion(DmdbDatabaseMetaData databaseMetaData) {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getDriverMinorVersion", new Object[0]);
        int ret = super.DatabaseMetaData_getDriverMinorVersion(databaseMetaData);
        logRecord.setReturnValue(ret);
        return ret;
    }

    @Override
    public String DatabaseMetaData_getDriverName(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getDriverName", new Object[0]);
        try {
            String ret = super.DatabaseMetaData_getDriverName(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getDriverVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getDriverVersion", new Object[0]);
        try {
            String ret = super.DatabaseMetaData_getDriverVersion(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getExportedKeys(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getExportedKeys", catalog, schema, table);
        try {
            ResultSet ret = super.DatabaseMetaData_getExportedKeys(databaseMetaData, catalog, schema, table);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getExtraNameCharacters(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getExtraNameCharacters", new Object[0]);
        try {
            String ret = super.DatabaseMetaData_getExtraNameCharacters(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getFunctionColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getFunctionColumns", catalog, schemaPattern, functionNamePattern, columnNamePattern);
        try {
            ResultSet ret = super.DatabaseMetaData_getFunctionColumns(databaseMetaData, catalog, schemaPattern, functionNamePattern, columnNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getFunctions(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getFunctions", catalog, schemaPattern, functionNamePattern);
        try {
            ResultSet ret = super.DatabaseMetaData_getFunctions(databaseMetaData, catalog, schemaPattern, functionNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getIdentifierQuoteString(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getIdentifierQuoteString", new Object[0]);
        try {
            String ret = super.DatabaseMetaData_getIdentifierQuoteString(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getImportedKeys(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getImportedKeys", catalog, schema, table);
        try {
            ResultSet ret = super.DatabaseMetaData_getImportedKeys(databaseMetaData, catalog, schema, table);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getIndexInfo(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getIndexInfo", catalog, schema, table, unique, approximate);
        try {
            ResultSet ret = super.DatabaseMetaData_getIndexInfo(databaseMetaData, catalog, schema, table, unique, approximate);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getJDBCMajorVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getJDBCMajorVersion", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getJDBCMajorVersion(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getJDBCMinorVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getJDBCMinorVersion", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getJDBCMinorVersion(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxBinaryLiteralLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxBinaryLiteralLength", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getMaxBinaryLiteralLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxCatalogNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxCatalogNameLength", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getMaxCatalogNameLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxCharLiteralLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxCharLiteralLength", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getMaxCharLiteralLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxColumnNameLength", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getMaxColumnNameLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInGroupBy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxColumnsInGroupBy", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getMaxColumnsInGroupBy(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInIndex(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxColumnsInIndex", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getMaxColumnsInIndex(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInOrderBy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxColumnsInOrderBy", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getMaxColumnsInOrderBy(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInSelect(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxColumnsInSelect", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getMaxColumnsInSelect(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInTable(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxColumnsInTable", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getMaxColumnsInTable(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxConnections(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxConnections", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getMaxConnections(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxCursorNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxCursorNameLength", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getMaxCursorNameLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxIndexLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxIndexLength", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getMaxIndexLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxProcedureNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxProcedureNameLength", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getMaxProcedureNameLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxRowSize(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxRowSize", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getMaxRowSize(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxSchemaNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxSchemaNameLength", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getMaxSchemaNameLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxStatementLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxStatementLength", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getMaxStatementLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxStatements(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxStatements", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getMaxStatements(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxTableNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxTableNameLength", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getMaxTableNameLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxTablesInSelect(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxTablesInSelect", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getMaxTablesInSelect(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getMaxUserNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxUserNameLength", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getMaxUserNameLength(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getNumericFunctions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getNumericFunctions", new Object[0]);
        try {
            String ret = super.DatabaseMetaData_getNumericFunctions(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getPrimaryKeys(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getPrimaryKeys", catalog, schema, table);
        try {
            ResultSet ret = super.DatabaseMetaData_getPrimaryKeys(databaseMetaData, catalog, schema, table);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getProcedureColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getProcedureColumns", catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        try {
            ResultSet ret = super.DatabaseMetaData_getProcedureColumns(databaseMetaData, catalog, schemaPattern, procedureNamePattern, columnNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getProcedureTerm(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getProcedureTerm", new Object[0]);
        try {
            String ret = super.DatabaseMetaData_getProcedureTerm(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getProcedures(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getProcedures", catalog, schemaPattern, procedureNamePattern);
        try {
            ResultSet ret = super.DatabaseMetaData_getProcedures(databaseMetaData, catalog, schemaPattern, procedureNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getPseudoColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getPseudoColumns", catalog, schemaPattern, tableNamePattern, columnNamePattern);
        try {
            ResultSet ret = super.DatabaseMetaData_getPseudoColumns(databaseMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getResultSetHoldability(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getResultSetHoldability", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getResultSetHoldability(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public RowIdLifetime DatabaseMetaData_getRowIdLifetime(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getRowIdLifetime", new Object[0]);
        try {
            RowIdLifetime ret = super.DatabaseMetaData_getRowIdLifetime(databaseMetaData);
            logRecord.setReturnValue((Object)ret);
            RowIdLifetime rowIdLifetime = ret;
            return rowIdLifetime;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getSQLKeywords(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getSQLKeywords", new Object[0]);
        try {
            String ret = super.DatabaseMetaData_getSQLKeywords(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int DatabaseMetaData_getSQLStateType(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getSQLStateType", new Object[0]);
        try {
            int ret = super.DatabaseMetaData_getSQLStateType(databaseMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getSchemaTerm(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getSchemaTerm", new Object[0]);
        try {
            String ret = super.DatabaseMetaData_getSchemaTerm(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getSchemas(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getSchemas", new Object[0]);
        try {
            ResultSet ret = super.DatabaseMetaData_getSchemas(databaseMetaData);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getSchemas(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getSchemas", catalog, schemaPattern);
        try {
            ResultSet ret = super.DatabaseMetaData_getSchemas(databaseMetaData, catalog, schemaPattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getSearchStringEscape(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getSearchStringEscape", new Object[0]);
        try {
            String ret = super.DatabaseMetaData_getSearchStringEscape(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getStringFunctions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getStringFunctions", new Object[0]);
        try {
            String ret = super.DatabaseMetaData_getStringFunctions(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getSuperTables(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getSuperTables", catalog, schemaPattern, tableNamePattern);
        try {
            ResultSet ret = super.DatabaseMetaData_getSuperTables(databaseMetaData, catalog, schemaPattern, tableNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getSuperTypes(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getSuperTypes", catalog, schemaPattern, typeNamePattern);
        try {
            ResultSet ret = super.DatabaseMetaData_getSuperTypes(databaseMetaData, catalog, schemaPattern, typeNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getSystemFunctions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getSystemFunctions", new Object[0]);
        try {
            String ret = super.DatabaseMetaData_getSystemFunctions(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getTablePrivileges(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getTablePrivileges", catalog, schemaPattern, tableNamePattern);
        try {
            ResultSet ret = super.DatabaseMetaData_getTablePrivileges(databaseMetaData, catalog, schemaPattern, tableNamePattern);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getTableTypes(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getTableTypes", new Object[0]);
        try {
            ResultSet ret = super.DatabaseMetaData_getTableTypes(databaseMetaData);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getTables(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getTables", catalog, schemaPattern, tableNamePattern, types);
        try {
            ResultSet ret = super.DatabaseMetaData_getTables(databaseMetaData, catalog, schemaPattern, tableNamePattern, types);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getTimeDateFunctions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getTimeDateFunctions", new Object[0]);
        try {
            String ret = super.DatabaseMetaData_getTimeDateFunctions(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getTypeInfo(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getTypeInfo", new Object[0]);
        try {
            ResultSet ret = super.DatabaseMetaData_getTypeInfo(databaseMetaData);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getUDTs(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getUDTs", catalog, schemaPattern, typeNamePattern, types);
        try {
            ResultSet ret = super.DatabaseMetaData_getUDTs(databaseMetaData, catalog, schemaPattern, typeNamePattern, types);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getURL(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getURL", new Object[0]);
        try {
            String ret = super.DatabaseMetaData_getURL(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String DatabaseMetaData_getUserName(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getUserName", new Object[0]);
        try {
            String ret = super.DatabaseMetaData_getUserName(databaseMetaData);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getVersionColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getVersionColumns", catalog, schema, table);
        try {
            ResultSet ret = super.DatabaseMetaData_getVersionColumns(databaseMetaData, catalog, schema, table);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_insertsAreDetected(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "insertsAreDetected", type);
        try {
            boolean ret = super.DatabaseMetaData_insertsAreDetected(databaseMetaData, type);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_isCatalogAtStart(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "isCatalogAtStart", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_isCatalogAtStart(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_isReadOnly(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "isReadOnly", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_isReadOnly(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_locatorsUpdateCopy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "locatorsUpdateCopy", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_locatorsUpdateCopy(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_nullPlusNonNullIsNull(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "nullPlusNonNullIsNull", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_nullPlusNonNullIsNull(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedAtEnd(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "nullsAreSortedAtEnd", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_nullsAreSortedAtEnd(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedAtStart(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "nullsAreSortedAtStart", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_nullsAreSortedAtStart(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedHigh(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "nullsAreSortedHigh", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_nullsAreSortedHigh(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedLow(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "nullsAreSortedLow", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_nullsAreSortedLow(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_othersDeletesAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "othersDeletesAreVisible", type);
        try {
            boolean ret = super.DatabaseMetaData_othersDeletesAreVisible(databaseMetaData, type);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_othersInsertsAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "othersInsertsAreVisible", type);
        try {
            boolean ret = super.DatabaseMetaData_othersInsertsAreVisible(databaseMetaData, type);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_othersUpdatesAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "othersUpdatesAreVisible", type);
        try {
            boolean ret = super.DatabaseMetaData_othersUpdatesAreVisible(databaseMetaData, type);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_ownDeletesAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "ownDeletesAreVisible", type);
        try {
            boolean ret = super.DatabaseMetaData_ownDeletesAreVisible(databaseMetaData, type);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_ownInsertsAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "ownInsertsAreVisible", type);
        try {
            boolean ret = super.DatabaseMetaData_ownInsertsAreVisible(databaseMetaData, type);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_ownUpdatesAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "ownUpdatesAreVisible", type);
        try {
            boolean ret = super.DatabaseMetaData_ownUpdatesAreVisible(databaseMetaData, type);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_storesLowerCaseIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "storesLowerCaseIdentifiers", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_storesLowerCaseIdentifiers(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_storesLowerCaseQuotedIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "storesLowerCaseQuotedIdentifiers", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_storesLowerCaseQuotedIdentifiers(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_storesMixedCaseIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "storesMixedCaseIdentifiers", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_storesMixedCaseIdentifiers(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_storesMixedCaseQuotedIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "storesMixedCaseQuotedIdentifiers", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_storesMixedCaseQuotedIdentifiers(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_storesUpperCaseIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "storesUpperCaseIdentifiers", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_storesUpperCaseIdentifiers(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_storesUpperCaseQuotedIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "storesUpperCaseQuotedIdentifiers", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_storesUpperCaseQuotedIdentifiers(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92EntryLevelSQL(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsANSI92EntryLevelSQL", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsANSI92EntryLevelSQL(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92FullSQL(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsANSI92FullSQL", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsANSI92FullSQL(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92IntermediateSQL(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsANSI92IntermediateSQL", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsANSI92IntermediateSQL(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsAlterTableWithAddColumn(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsAlterTableWithAddColumn", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsAlterTableWithAddColumn(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsAlterTableWithDropColumn(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsAlterTableWithDropColumn", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsAlterTableWithDropColumn(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsBatchUpdates(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsBatchUpdates", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsBatchUpdates(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInDataManipulation(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsCatalogsInDataManipulation", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsCatalogsInDataManipulation(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInIndexDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsCatalogsInIndexDefinitions", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsCatalogsInIndexDefinitions(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsCatalogsInPrivilegeDefinitions", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInProcedureCalls(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsCatalogsInProcedureCalls", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsCatalogsInProcedureCalls(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInTableDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsCatalogsInTableDefinitions", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsCatalogsInTableDefinitions(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsColumnAliasing(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsColumnAliasing", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsColumnAliasing(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsConvert(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsConvert", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsConvert(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsConvert(DmdbDatabaseMetaData databaseMetaData, int fromType, int toType) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsConvert", fromType, toType);
        try {
            boolean ret = super.DatabaseMetaData_supportsConvert(databaseMetaData, fromType, toType);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCoreSQLGrammar(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsCoreSQLGrammar", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsCoreSQLGrammar(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCorrelatedSubqueries(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsCorrelatedSubqueries", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsCorrelatedSubqueries(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsDataDefinitionAndDataManipulationTransactions", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsDataManipulationTransactionsOnly(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsDataManipulationTransactionsOnly", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsDataManipulationTransactionsOnly(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsDifferentTableCorrelationNames(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsDifferentTableCorrelationNames", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsDifferentTableCorrelationNames(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsExpressionsInOrderBy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsExpressionsInOrderBy", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsExpressionsInOrderBy(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsExtendedSQLGrammar(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsExtendedSQLGrammar", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsExtendedSQLGrammar(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsFullOuterJoins(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsFullOuterJoins", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsFullOuterJoins(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsGetGeneratedKeys(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsGetGeneratedKeys", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsGetGeneratedKeys(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupBy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsGroupBy", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsGroupBy(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupByBeyondSelect(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsGroupByBeyondSelect", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsGroupByBeyondSelect(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupByUnrelated(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsGroupByUnrelated", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsGroupByUnrelated(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsIntegrityEnhancementFacility(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsIntegrityEnhancementFacility", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsIntegrityEnhancementFacility(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsLikeEscapeClause(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsLikeEscapeClause", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsLikeEscapeClause(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsLimitedOuterJoins(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsLimitedOuterJoins", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsLimitedOuterJoins(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMinimumSQLGrammar(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsMinimumSQLGrammar", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsMinimumSQLGrammar(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMixedCaseIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsMixedCaseIdentifiers", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsMixedCaseIdentifiers(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsMixedCaseQuotedIdentifiers", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleOpenResults(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsMultipleOpenResults", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsMultipleOpenResults(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleResultSets(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsMultipleResultSets", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsMultipleResultSets(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleTransactions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsMultipleTransactions", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsMultipleTransactions(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsNamedParameters(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsNamedParameters", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsNamedParameters(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsNonNullableColumns(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsNonNullableColumns", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsNonNullableColumns(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenCursorsAcrossCommit(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsOpenCursorsAcrossCommit", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsOpenCursorsAcrossCommit(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenCursorsAcrossRollback(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsOpenCursorsAcrossRollback", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsOpenCursorsAcrossRollback(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenStatementsAcrossCommit(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsOpenStatementsAcrossCommit", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsOpenStatementsAcrossCommit(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenStatementsAcrossRollback(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsOpenStatementsAcrossRollback", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsOpenStatementsAcrossRollback(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOrderByUnrelated(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsOrderByUnrelated", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsOrderByUnrelated(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOuterJoins(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsOuterJoins", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsOuterJoins(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsPositionedDelete(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsPositionedDelete", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsPositionedDelete(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsPositionedUpdate(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsPositionedUpdate", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsPositionedUpdate(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetConcurrency(DmdbDatabaseMetaData databaseMetaData, int type, int concurrency) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsResultSetConcurrency", type, concurrency);
        try {
            boolean ret = super.DatabaseMetaData_supportsResultSetConcurrency(databaseMetaData, type, concurrency);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetHoldability(DmdbDatabaseMetaData databaseMetaData, int holdability) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsResultSetHoldability", holdability);
        try {
            boolean ret = super.DatabaseMetaData_supportsResultSetHoldability(databaseMetaData, holdability);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetType(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsResultSetType", type);
        try {
            boolean ret = super.DatabaseMetaData_supportsResultSetType(databaseMetaData, type);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSavepoints(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSavepoints", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsSavepoints(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInDataManipulation(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSchemasInDataManipulation", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsSchemasInDataManipulation(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInIndexDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSchemasInIndexDefinitions", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsSchemasInIndexDefinitions(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSchemasInPrivilegeDefinitions", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInProcedureCalls(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSchemasInProcedureCalls", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsSchemasInProcedureCalls(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInTableDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSchemasInTableDefinitions", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsSchemasInTableDefinitions(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSelectForUpdate(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSelectForUpdate", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsSelectForUpdate(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsStatementPooling(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsStatementPooling", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsStatementPooling(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsStoredFunctionsUsingCallSyntax", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsStoredProcedures(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsStoredProcedures", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsStoredProcedures(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInComparisons(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSubqueriesInComparisons", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsSubqueriesInComparisons(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInExists(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSubqueriesInExists", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsSubqueriesInExists(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInIns(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSubqueriesInIns", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsSubqueriesInIns(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInQuantifieds(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsSubqueriesInQuantifieds", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsSubqueriesInQuantifieds(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsTableCorrelationNames(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsTableCorrelationNames", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsTableCorrelationNames(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsTransactionIsolationLevel(DmdbDatabaseMetaData databaseMetaData, int level) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsTransactionIsolationLevel", level);
        try {
            boolean ret = super.DatabaseMetaData_supportsTransactionIsolationLevel(databaseMetaData, level);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsTransactions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsTransactions", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsTransactions(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsUnion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsUnion", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsUnion(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsUnionAll(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsUnionAll", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsUnionAll(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_updatesAreDetected(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "updatesAreDetected", type);
        try {
            boolean ret = super.DatabaseMetaData_updatesAreDetected(databaseMetaData, type);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_usesLocalFilePerTable(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "usesLocalFilePerTable", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_usesLocalFilePerTable(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_usesLocalFiles(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "usesLocalFiles", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_usesLocalFiles(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long DatabaseMetaData_getMaxLogicalLobSize(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "getMaxLogicalLobSize", new Object[0]);
        try {
            long ret = super.DatabaseMetaData_getMaxLogicalLobSize(databaseMetaData);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsRefCursors(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(databaseMetaData, "supportsRefCursors", new Object[0]);
        try {
            boolean ret = super.DatabaseMetaData_supportsRefCursors(databaseMetaData);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ParameterMetaData_getParameterClassName(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        LogRecord logRecord = new LogRecord(parameterMetaData, "getParameterClassName", param);
        try {
            String ret = super.ParameterMetaData_getParameterClassName(parameterMetaData, param);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ParameterMetaData_getParameterCount(DmdbParameterMetaData parameterMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(parameterMetaData, "getParameterCount", new Object[0]);
        try {
            int ret = super.ParameterMetaData_getParameterCount(parameterMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ParameterMetaData_getParameterMode(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        LogRecord logRecord = new LogRecord(parameterMetaData, "getParameterMode", param);
        try {
            int ret = super.ParameterMetaData_getParameterMode(parameterMetaData, param);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ParameterMetaData_getParameterType(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        LogRecord logRecord = new LogRecord(parameterMetaData, "getParameterType", param);
        try {
            int ret = super.ParameterMetaData_getParameterType(parameterMetaData, param);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ParameterMetaData_getParameterTypeName(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        LogRecord logRecord = new LogRecord(parameterMetaData, "getParameterTypeName", param);
        try {
            String ret = super.ParameterMetaData_getParameterTypeName(parameterMetaData, param);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ParameterMetaData_getPrecision(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        LogRecord logRecord = new LogRecord(parameterMetaData, "getPrecision", param);
        try {
            int ret = super.ParameterMetaData_getPrecision(parameterMetaData, param);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ParameterMetaData_getScale(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        LogRecord logRecord = new LogRecord(parameterMetaData, "getScale", param);
        try {
            int ret = super.ParameterMetaData_getScale(parameterMetaData, param);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ParameterMetaData_isNullable(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        LogRecord logRecord = new LogRecord(parameterMetaData, "isNullable", param);
        try {
            int ret = super.ParameterMetaData_isNullable(parameterMetaData, param);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ParameterMetaData_isSigned(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        LogRecord logRecord = new LogRecord(parameterMetaData, "isSigned", param);
        try {
            boolean ret = super.ParameterMetaData_isSigned(parameterMetaData, param);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_addBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "addBatch", new Object[0]);
        try {
            try {
                super.PreparedStatement_addBatch(preparedStatement);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_clearParameters(DmdbPreparedStatement preparedStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "clearParameters", new Object[0]);
        try {
            try {
                super.PreparedStatement_clearParameters(preparedStatement);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int[] PreparedStatement_executeBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "executeBatch", new Object[0]);
        try {
            int[] ret = super.PreparedStatement_executeBatch(preparedStatement);
            logRecord.setReturnValue(ret);
            int[] nArray = ret;
            return nArray;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, preparedStatement);
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean PreparedStatement_execute(DmdbPreparedStatement preparedStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "execute", new Object[0]);
        try {
            boolean ret = super.PreparedStatement_execute(preparedStatement);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, preparedStatement);
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet PreparedStatement_executeQuery(DmdbPreparedStatement preparedStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "executeQuery", new Object[0]);
        try {
            ResultSet ret = super.PreparedStatement_executeQuery(preparedStatement);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, preparedStatement);
            this.doLog(logRecord);
        }
    }

    @Override
    public int PreparedStatement_executeUpdate(DmdbPreparedStatement preparedStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "executeUpdate", new Object[0]);
        try {
            int ret = super.PreparedStatement_executeUpdate(preparedStatement);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, preparedStatement);
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSetMetaData PreparedStatement_getMetaData(DmdbPreparedStatement preparedStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "getMetaData", new Object[0]);
        try {
            ResultSetMetaData ret = super.PreparedStatement_getMetaData(preparedStatement);
            logRecord.setReturnValue(ret);
            ResultSetMetaData resultSetMetaData = ret;
            return resultSetMetaData;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ParameterMetaData PreparedStatement_getParameterMetaData(DmdbPreparedStatement preparedStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "getParameterMetaData", new Object[0]);
        try {
            ParameterMetaData ret = super.PreparedStatement_getParameterMetaData(preparedStatement);
            logRecord.setReturnValue(ret);
            ParameterMetaData parameterMetaData = ret;
            return parameterMetaData;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setArray(DmdbPreparedStatement preparedStatement, int parameterIndex, Array x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setArray", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setArray(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setAsciiStream", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setAsciiStream", parameterIndex, x2, length);
        try {
            try {
                super.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setAsciiStream", parameterIndex, x2, length);
        try {
            try {
                super.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setBigDecimal(DmdbPreparedStatement preparedStatement, int parameterIndex, BigDecimal x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setBigDecimal", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setBigDecimal(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setBinaryStream", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setBinaryStream", parameterIndex, x2, length);
        try {
            try {
                super.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setBinaryStream", parameterIndex, x2, length);
        try {
            try {
                super.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, Blob x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setBlob", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setBlob(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setBlob", parameterIndex, inputStream);
        try {
            try {
                super.PreparedStatement_setBlob(preparedStatement, parameterIndex, inputStream);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setBlob", parameterIndex, inputStream, length);
        try {
            try {
                super.PreparedStatement_setBlob(preparedStatement, parameterIndex, inputStream, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setBoolean(DmdbPreparedStatement preparedStatement, int parameterIndex, boolean x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setBoolean", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setBoolean(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setByte(DmdbPreparedStatement preparedStatement, int parameterIndex, byte x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setByte", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setByte(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setBytes(DmdbPreparedStatement preparedStatement, int parameterIndex, byte[] x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setBytes", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setBytes(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setCharacterStream", parameterIndex, reader);
        try {
            try {
                super.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setCharacterStream", parameterIndex, reader, length);
        try {
            try {
                super.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setCharacterStream", parameterIndex, reader, length);
        try {
            try {
                super.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Clob x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setClob", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setClob(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setClob", parameterIndex, reader);
        try {
            try {
                super.PreparedStatement_setClob(preparedStatement, parameterIndex, reader);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setClob", parameterIndex, reader, length);
        try {
            try {
                super.PreparedStatement_setClob(preparedStatement, parameterIndex, reader, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setDate(DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setDate", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setDate(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setDate(DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setDate", parameterIndex, x2, cal);
        try {
            try {
                super.PreparedStatement_setDate(preparedStatement, parameterIndex, x2, cal);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setDouble(DmdbPreparedStatement preparedStatement, int parameterIndex, double x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setDouble", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setDouble(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setFloat(DmdbPreparedStatement preparedStatement, int parameterIndex, float x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setFloat", parameterIndex, Float.valueOf(x2));
        try {
            try {
                super.PreparedStatement_setFloat(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setInt(DmdbPreparedStatement preparedStatement, int parameterIndex, int x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setInt", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setInt(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setLong(DmdbPreparedStatement preparedStatement, int parameterIndex, long x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setLong", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setLong(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setNCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setNCharacterStream", parameterIndex, value);
        try {
            try {
                super.PreparedStatement_setNCharacterStream(preparedStatement, parameterIndex, value);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setNCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setNCharacterStream", parameterIndex, value, length);
        try {
            try {
                super.PreparedStatement_setNCharacterStream(preparedStatement, parameterIndex, value, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, NClob value) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setNClob", parameterIndex, value);
        try {
            try {
                super.PreparedStatement_setNClob(preparedStatement, parameterIndex, value);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setNClob", parameterIndex, reader);
        try {
            try {
                super.PreparedStatement_setNClob(preparedStatement, parameterIndex, reader);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setNClob", parameterIndex, reader, length);
        try {
            try {
                super.PreparedStatement_setNClob(preparedStatement, parameterIndex, reader, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setNString(DmdbPreparedStatement preparedStatement, int parameterIndex, String value) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setNString", parameterIndex, value);
        try {
            try {
                super.PreparedStatement_setNString(preparedStatement, parameterIndex, value);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setNull(DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setNull", parameterIndex, sqlType);
        try {
            try {
                super.PreparedStatement_setNull(preparedStatement, parameterIndex, sqlType);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setNull(DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setNull", parameterIndex, sqlType, typeName);
        try {
            try {
                super.PreparedStatement_setNull(preparedStatement, parameterIndex, sqlType, typeName);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setObject", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setObject(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setObject", parameterIndex, x2, targetSqlType);
        try {
            try {
                super.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType, int scaleOrLength) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setObject", parameterIndex, x2, targetSqlType, scaleOrLength);
        try {
            try {
                super.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType, scaleOrLength);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setRef(DmdbPreparedStatement preparedStatement, int parameterIndex, Ref x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setRef", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setRef(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setRowId(DmdbPreparedStatement preparedStatement, int parameterIndex, RowId x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setRowId", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setRowId(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setSQLXML(DmdbPreparedStatement preparedStatement, int parameterIndex, SQLXML xmlObject) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setSQLXML", parameterIndex, xmlObject);
        try {
            try {
                super.PreparedStatement_setSQLXML(preparedStatement, parameterIndex, xmlObject);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setShort(DmdbPreparedStatement preparedStatement, int parameterIndex, short x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setShort", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setShort(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setString(DmdbPreparedStatement preparedStatement, int parameterIndex, String x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setString", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setString(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setFixedCHAR(DmdbPreparedStatement preparedStatement, int parameterIndex, String x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setFixedCHAR", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setFixedCHAR(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setTime(DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setTime", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setTime(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setTime(DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setTime", parameterIndex, x2, cal);
        try {
            try {
                super.PreparedStatement_setTime(preparedStatement, parameterIndex, x2, cal);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setTimestamp(DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setTimestamp", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setTimestamp(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setTimestamp(DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setTimestamp", parameterIndex, x2, cal);
        try {
            try {
                super.PreparedStatement_setTimestamp(preparedStatement, parameterIndex, x2, cal);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setURL(DmdbPreparedStatement preparedStatement, int parameterIndex, URL x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setURL", parameterIndex, x2);
        try {
            try {
                super.PreparedStatement_setURL(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setUnicodeStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setUnicodeStream", parameterIndex, x2, length);
        try {
            try {
                super.PreparedStatement_setUnicodeStream(preparedStatement, parameterIndex, x2, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long[] PreparedStatement_executeLargeBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "executeLargeBatch", new Object[0]);
        try {
            long[] ret = super.PreparedStatement_executeLargeBatch(preparedStatement);
            logRecord.setReturnValue(ret);
            long[] lArray = ret;
            return lArray;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, preparedStatement);
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setObject", parameterIndex, x2, targetSqlType, scaleOrLength);
        try {
            try {
                super.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType, scaleOrLength);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, SQLType targetSqlType) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setObject", parameterIndex, x2, targetSqlType);
        try {
            try {
                super.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long PreparedStatement_executeLargeUpdate(DmdbPreparedStatement preparedStatement) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "executeLargeUpdate", new Object[0]);
        try {
            long ret = super.PreparedStatement_executeLargeUpdate(preparedStatement);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, preparedStatement);
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_preCompile(DmdbPreparedStatement preparedStatement, String sql) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "preCompile", new Object[0]);
        logRecord.setSql(sql);
        try {
            try {
                super.PreparedStatement_preCompile(preparedStatement, sql);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setTIMESTAMP(DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbTimestamp x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setTIMESTAMP", new Object[0]);
        try {
            try {
                super.PreparedStatement_setTIMESTAMP(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setINTERVALYM(DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbIntervalYM x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setINTERVALYM", new Object[0]);
        try {
            try {
                super.PreparedStatement_setINTERVALYM(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void PreparedStatement_setINTERVALDT(DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbIntervalDT x2) throws SQLException {
        LogRecord logRecord = new LogRecord(preparedStatement, "setINTERVALDT", new Object[0]);
        try {
            try {
                super.PreparedStatement_setINTERVALDT(preparedStatement, parameterIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_absolute(DmdbResultSet resultSet, int row) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "absolute", row);
        try {
            boolean ret = super.ResultSet_absolute(resultSet, row);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_afterLast(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "afterLast", new Object[0]);
        try {
            try {
                super.ResultSet_afterLast(resultSet);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_beforeFirst(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "beforeFirst", new Object[0]);
        try {
            try {
                super.ResultSet_beforeFirst(resultSet);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_cancelRowUpdates(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "cancelRowUpdates", new Object[0]);
        try {
            try {
                super.ResultSet_cancelRowUpdates(resultSet);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_clearWarnings(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "clearWarnings", new Object[0]);
        try {
            try {
                super.ResultSet_clearWarnings(resultSet);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_close(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "close", new Object[0]);
        try {
            try {
                super.ResultSet_close(resultSet);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_deleteRow(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "deleteRow", new Object[0]);
        try {
            try {
                super.ResultSet_deleteRow(resultSet);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSet_findColumn(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "findColumn", columnLabel);
        try {
            int ret = super.ResultSet_findColumn(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_first(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "first", new Object[0]);
        try {
            boolean ret = super.ResultSet_first(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Array ResultSet_getArray(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getArray", columnLabel);
        try {
            Array ret = super.ResultSet_getArray(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            Array array = ret;
            return array;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Array ResultSet_getArray(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getArray", columnIndex);
        try {
            Array ret = super.ResultSet_getArray(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            Array array = ret;
            return array;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public InputStream ResultSet_getAsciiStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getAsciiStream", columnLabel);
        try {
            InputStream ret = super.ResultSet_getAsciiStream(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            InputStream inputStream = ret;
            return inputStream;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public InputStream ResultSet_getAsciiStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getAsciiStream", columnIndex);
        try {
            InputStream ret = super.ResultSet_getAsciiStream(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            InputStream inputStream = ret;
            return inputStream;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBigDecimal", columnLabel);
        try {
            BigDecimal ret = super.ResultSet_getBigDecimal(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            BigDecimal bigDecimal = ret;
            return bigDecimal;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(DmdbResultSet resultSet, String columnLabel, int scale) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBigDecimal", columnLabel, scale);
        try {
            BigDecimal ret = super.ResultSet_getBigDecimal(resultSet, columnLabel, scale);
            logRecord.setReturnValue(ret);
            BigDecimal bigDecimal = ret;
            return bigDecimal;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBigDecimal", columnIndex);
        try {
            BigDecimal ret = super.ResultSet_getBigDecimal(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            BigDecimal bigDecimal = ret;
            return bigDecimal;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(DmdbResultSet resultSet, int columnIndex, int scale) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBigDecimal", columnIndex, scale);
        try {
            BigDecimal ret = super.ResultSet_getBigDecimal(resultSet, columnIndex, scale);
            logRecord.setReturnValue(ret);
            BigDecimal bigDecimal = ret;
            return bigDecimal;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public InputStream ResultSet_getBinaryStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBinaryStream", columnLabel);
        try {
            InputStream ret = super.ResultSet_getBinaryStream(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            InputStream inputStream = ret;
            return inputStream;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public InputStream ResultSet_getBinaryStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBinaryStream", columnIndex);
        try {
            InputStream ret = super.ResultSet_getBinaryStream(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            InputStream inputStream = ret;
            return inputStream;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Blob ResultSet_getBlob(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBlob", columnLabel);
        try {
            Blob ret = super.ResultSet_getBlob(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            Blob blob = ret;
            return blob;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Blob ResultSet_getBlob(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBlob", columnIndex);
        try {
            Blob ret = super.ResultSet_getBlob(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            Blob blob = ret;
            return blob;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_getBoolean(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBoolean", columnLabel);
        try {
            boolean ret = super.ResultSet_getBoolean(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_getBoolean(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBoolean", columnIndex);
        try {
            boolean ret = super.ResultSet_getBoolean(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public byte ResultSet_getByte(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getByte", columnLabel);
        try {
            byte ret = super.ResultSet_getByte(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            byte by = ret;
            return by;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public byte ResultSet_getByte(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getByte", columnIndex);
        try {
            byte ret = super.ResultSet_getByte(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            byte by = ret;
            return by;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public byte[] ResultSet_getBytes(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBytes", columnLabel);
        try {
            byte[] ret = super.ResultSet_getBytes(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            byte[] byArray = ret;
            return byArray;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public byte[] ResultSet_getBytes(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getBytes", columnIndex);
        try {
            byte[] ret = super.ResultSet_getBytes(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            byte[] byArray = ret;
            return byArray;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Reader ResultSet_getCharacterStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getCharacterStream", columnLabel);
        try {
            Reader ret = super.ResultSet_getCharacterStream(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            Reader reader = ret;
            return reader;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Reader ResultSet_getCharacterStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getCharacterStream", columnIndex);
        try {
            Reader ret = super.ResultSet_getCharacterStream(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            Reader reader = ret;
            return reader;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Clob ResultSet_getClob(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getClob", columnLabel);
        try {
            Clob ret = super.ResultSet_getClob(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            Clob clob = ret;
            return clob;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Clob ResultSet_getClob(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getClob", columnIndex);
        try {
            Clob ret = super.ResultSet_getClob(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            Clob clob = ret;
            return clob;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSet_getConcurrency(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getConcurrency", new Object[0]);
        try {
            int ret = super.ResultSet_getConcurrency(resultSet);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSet_getCursorName(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getCursorName", new Object[0]);
        try {
            String ret = super.ResultSet_getCursorName(resultSet);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Date ResultSet_getDate(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getDate", columnLabel);
        try {
            Date ret = super.ResultSet_getDate(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            Date date = ret;
            return date;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Date ResultSet_getDate(DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getDate", columnLabel, cal);
        try {
            Date ret = super.ResultSet_getDate(resultSet, columnLabel, cal);
            logRecord.setReturnValue(ret);
            Date date = ret;
            return date;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Date ResultSet_getDate(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getDate", columnIndex);
        try {
            Date ret = super.ResultSet_getDate(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            Date date = ret;
            return date;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Date ResultSet_getDate(DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getDate", columnIndex, cal);
        try {
            Date ret = super.ResultSet_getDate(resultSet, columnIndex, cal);
            logRecord.setReturnValue(ret);
            Date date = ret;
            return date;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public double ResultSet_getDouble(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getDouble", columnLabel);
        try {
            double ret = super.ResultSet_getDouble(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            double d2 = ret;
            return d2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public double ResultSet_getDouble(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getDouble", columnIndex);
        try {
            double ret = super.ResultSet_getDouble(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            double d2 = ret;
            return d2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSet_getFetchDirection(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getFetchDirection", new Object[0]);
        try {
            int ret = super.ResultSet_getFetchDirection(resultSet);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSet_getFetchSize(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getFetchSize", new Object[0]);
        try {
            int ret = super.ResultSet_getFetchSize(resultSet);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public float ResultSet_getFloat(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getFloat", columnLabel);
        try {
            float ret = super.ResultSet_getFloat(resultSet, columnLabel);
            logRecord.setReturnValue(Float.valueOf(ret));
            float f2 = ret;
            return f2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public float ResultSet_getFloat(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getFloat", columnIndex);
        try {
            float ret = super.ResultSet_getFloat(resultSet, columnIndex);
            logRecord.setReturnValue(Float.valueOf(ret));
            float f2 = ret;
            return f2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSet_getHoldability(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getHoldability", new Object[0]);
        try {
            int ret = super.ResultSet_getHoldability(resultSet);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSet_getInt(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getInt", columnLabel);
        try {
            int ret = super.ResultSet_getInt(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSet_getInt(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getInt", columnIndex);
        try {
            int ret = super.ResultSet_getInt(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long ResultSet_getLong(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getLong", columnLabel);
        try {
            long ret = super.ResultSet_getLong(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long ResultSet_getLong(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getLong", columnIndex);
        try {
            long ret = super.ResultSet_getLong(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSetMetaData ResultSet_getMetaData(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getMetaData", new Object[0]);
        try {
            ResultSetMetaData ret = super.ResultSet_getMetaData(resultSet);
            logRecord.setReturnValue(ret);
            ResultSetMetaData resultSetMetaData = ret;
            return resultSetMetaData;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Reader ResultSet_getNCharacterStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getNCharacterStream", columnLabel);
        try {
            Reader ret = super.ResultSet_getNCharacterStream(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            Reader reader = ret;
            return reader;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Reader ResultSet_getNCharacterStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getNCharacterStream", columnIndex);
        try {
            Reader ret = super.ResultSet_getNCharacterStream(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            Reader reader = ret;
            return reader;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public NClob ResultSet_getNClob(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getNClob", columnLabel);
        try {
            NClob ret = super.ResultSet_getNClob(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            NClob nClob = ret;
            return nClob;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public NClob ResultSet_getNClob(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getNClob", columnIndex);
        try {
            NClob ret = super.ResultSet_getNClob(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            NClob nClob = ret;
            return nClob;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSet_getNString(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getNString", columnLabel);
        try {
            String ret = super.ResultSet_getNString(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSet_getNString(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getNString", columnIndex);
        try {
            String ret = super.ResultSet_getNString(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Object ResultSet_getObject(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getObject", columnLabel);
        try {
            Object ret = super.ResultSet_getObject(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            Object object = ret;
            return object;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public <T> T ResultSet_getObject(DmdbResultSet resultSet, String columnLabel, Class<T> type) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getObject", columnLabel, type);
        try {
            T ret = super.ResultSet_getObject(resultSet, columnLabel, type);
            logRecord.setReturnValue(ret);
            T t2 = ret;
            return t2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Object ResultSet_getObject(DmdbResultSet resultSet, String columnLabel, Map<String, Class<?>> map) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getObject", columnLabel, map);
        try {
            Object ret = super.ResultSet_getObject(resultSet, columnLabel, map);
            logRecord.setReturnValue(ret);
            Object object = ret;
            return object;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Object ResultSet_getObject(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getObject", columnIndex);
        try {
            Object ret = super.ResultSet_getObject(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            Object object = ret;
            return object;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public <T> T ResultSet_getObject(DmdbResultSet resultSet, int columnIndex, Class<T> type) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getObject", columnIndex, type);
        try {
            T ret = super.ResultSet_getObject(resultSet, columnIndex, type);
            logRecord.setReturnValue(ret);
            T t2 = ret;
            return t2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Object ResultSet_getObject(DmdbResultSet resultSet, int columnIndex, Map<String, Class<?>> map) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getObject", columnIndex, map);
        try {
            Object ret = super.ResultSet_getObject(resultSet, columnIndex, map);
            logRecord.setReturnValue(ret);
            Object object = ret;
            return object;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Ref ResultSet_getRef(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getRef", columnLabel);
        try {
            Ref ret = super.ResultSet_getRef(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            Ref ref = ret;
            return ref;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Ref ResultSet_getRef(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getRef", columnIndex);
        try {
            Ref ret = super.ResultSet_getRef(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            Ref ref = ret;
            return ref;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSet_getRow(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getRow", new Object[0]);
        try {
            int ret = super.ResultSet_getRow(resultSet);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public RowId ResultSet_getRowId(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getRowId", columnLabel);
        try {
            RowId ret = super.ResultSet_getRowId(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            RowId rowId = ret;
            return rowId;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public RowId ResultSet_getRowId(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getRowId", columnIndex);
        try {
            RowId ret = super.ResultSet_getRowId(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            RowId rowId = ret;
            return rowId;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public SQLXML ResultSet_getSQLXML(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getSQLXML", columnLabel);
        try {
            SQLXML ret = super.ResultSet_getSQLXML(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            SQLXML sQLXML = ret;
            return sQLXML;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public SQLXML ResultSet_getSQLXML(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getSQLXML", columnIndex);
        try {
            SQLXML ret = super.ResultSet_getSQLXML(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            SQLXML sQLXML = ret;
            return sQLXML;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public short ResultSet_getShort(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getShort", columnLabel);
        try {
            short ret = super.ResultSet_getShort(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            short s2 = ret;
            return s2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public short ResultSet_getShort(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getShort", columnIndex);
        try {
            short ret = super.ResultSet_getShort(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            short s2 = ret;
            return s2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Statement ResultSet_getStatement(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getStatement", new Object[0]);
        try {
            Statement ret = super.ResultSet_getStatement(resultSet);
            logRecord.setReturnValue(ret);
            Statement statement = ret;
            return statement;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSet_getString(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getString", columnLabel);
        try {
            String ret = super.ResultSet_getString(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSet_getString(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getString", columnIndex);
        try {
            String ret = super.ResultSet_getString(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Time ResultSet_getTime(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getTime", columnLabel);
        try {
            Time ret = super.ResultSet_getTime(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            Time time = ret;
            return time;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Time ResultSet_getTime(DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getTime", columnLabel, cal);
        try {
            Time ret = super.ResultSet_getTime(resultSet, columnLabel, cal);
            logRecord.setReturnValue(ret);
            Time time = ret;
            return time;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Time ResultSet_getTime(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getTime", columnIndex);
        try {
            Time ret = super.ResultSet_getTime(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            Time time = ret;
            return time;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Time ResultSet_getTime(DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getTime", columnIndex, cal);
        try {
            Time ret = super.ResultSet_getTime(resultSet, columnIndex, cal);
            logRecord.setReturnValue(ret);
            Time time = ret;
            return time;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Timestamp ResultSet_getTimestamp(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getTimestamp", columnLabel);
        try {
            Timestamp ret = super.ResultSet_getTimestamp(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Timestamp ResultSet_getTimestamp(DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getTimestamp", columnLabel, cal);
        try {
            Timestamp ret = super.ResultSet_getTimestamp(resultSet, columnLabel, cal);
            logRecord.setReturnValue(ret);
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Timestamp ResultSet_getTimestamp(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getTimestamp", columnIndex);
        try {
            Timestamp ret = super.ResultSet_getTimestamp(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Timestamp ResultSet_getTimestamp(DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getTimestamp", columnIndex, cal);
        try {
            Timestamp ret = super.ResultSet_getTimestamp(resultSet, columnIndex, cal);
            logRecord.setReturnValue(ret);
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSet_getType(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getType", new Object[0]);
        try {
            int ret = super.ResultSet_getType(resultSet);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public URL ResultSet_getURL(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getURL", columnLabel);
        try {
            URL ret = super.ResultSet_getURL(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            URL uRL = ret;
            return uRL;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public URL ResultSet_getURL(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getURL", columnIndex);
        try {
            URL ret = super.ResultSet_getURL(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            URL uRL = ret;
            return uRL;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public InputStream ResultSet_getUnicodeStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getUnicodeStream", columnLabel);
        try {
            InputStream ret = super.ResultSet_getUnicodeStream(resultSet, columnLabel);
            logRecord.setReturnValue(ret);
            InputStream inputStream = ret;
            return inputStream;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public InputStream ResultSet_getUnicodeStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getUnicodeStream", columnIndex);
        try {
            InputStream ret = super.ResultSet_getUnicodeStream(resultSet, columnIndex);
            logRecord.setReturnValue(ret);
            InputStream inputStream = ret;
            return inputStream;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public SQLWarning ResultSet_getWarnings(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "getWarnings", new Object[0]);
        try {
            SQLWarning ret = super.ResultSet_getWarnings(resultSet);
            logRecord.setReturnValue(ret);
            SQLWarning sQLWarning = ret;
            return sQLWarning;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_insertRow(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "insertRow", new Object[0]);
        try {
            try {
                super.ResultSet_insertRow(resultSet);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_isAfterLast(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "isAfterLast", new Object[0]);
        try {
            boolean ret = super.ResultSet_isAfterLast(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_isBeforeFirst(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "isBeforeFirst", new Object[0]);
        try {
            boolean ret = super.ResultSet_isBeforeFirst(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_isClosed(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "isClosed", new Object[0]);
        try {
            boolean ret = super.ResultSet_isClosed(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_isFirst(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "isFirst", new Object[0]);
        try {
            boolean ret = super.ResultSet_isFirst(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_isLast(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "isLast", new Object[0]);
        try {
            boolean ret = super.ResultSet_isLast(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_last(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "last", new Object[0]);
        try {
            boolean ret = super.ResultSet_last(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_moveToCurrentRow(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "moveToCurrentRow", new Object[0]);
        try {
            try {
                super.ResultSet_moveToCurrentRow(resultSet);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_moveToInsertRow(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "moveToInsertRow", new Object[0]);
        try {
            try {
                super.ResultSet_moveToInsertRow(resultSet);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_next(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "next", new Object[0]);
        try {
            boolean ret = super.ResultSet_next(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_previous(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "previous", new Object[0]);
        try {
            boolean ret = super.ResultSet_previous(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_refreshRow(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "refreshRow", new Object[0]);
        try {
            try {
                super.ResultSet_refreshRow(resultSet);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_relative(DmdbResultSet resultSet, int rows) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "relative", rows);
        try {
            boolean ret = super.ResultSet_relative(resultSet, rows);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_rowDeleted(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "rowDeleted", new Object[0]);
        try {
            boolean ret = super.ResultSet_rowDeleted(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_rowInserted(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "rowInserted", new Object[0]);
        try {
            boolean ret = super.ResultSet_rowInserted(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_rowUpdated(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "rowUpdated", new Object[0]);
        try {
            boolean ret = super.ResultSet_rowUpdated(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_setFetchDirection(DmdbResultSet resultSet, int direction) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "setFetchDirection", direction);
        try {
            try {
                super.ResultSet_setFetchDirection(resultSet, direction);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_setFetchSize(DmdbResultSet resultSet, int rows) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "setFetchSize", rows);
        try {
            try {
                super.ResultSet_setFetchSize(resultSet, rows);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateArray(DmdbResultSet resultSet, String columnLabel, Array x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateArray", columnLabel, x2);
        try {
            try {
                super.ResultSet_updateArray(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateArray(DmdbResultSet resultSet, int columnIndex, Array x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateArray", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateArray(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, String columnLabel, InputStream x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateAsciiStream", columnLabel, x2);
        try {
            try {
                super.ResultSet_updateAsciiStream(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, String columnLabel, InputStream x2, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateAsciiStream", columnLabel, x2, length);
        try {
            try {
                super.ResultSet_updateAsciiStream(resultSet, columnLabel, x2, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, String columnLabel, InputStream x2, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateAsciiStream", columnLabel, x2, length);
        try {
            try {
                super.ResultSet_updateAsciiStream(resultSet, columnLabel, x2, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, int columnIndex, InputStream x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateAsciiStream", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateAsciiStream(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, int columnIndex, InputStream x2, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateAsciiStream", columnIndex, x2, length);
        try {
            try {
                super.ResultSet_updateAsciiStream(resultSet, columnIndex, x2, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, int columnIndex, InputStream x2, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateAsciiStream", columnIndex, x2, length);
        try {
            try {
                super.ResultSet_updateAsciiStream(resultSet, columnIndex, x2, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBigDecimal(DmdbResultSet resultSet, String columnLabel, BigDecimal x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBigDecimal", columnLabel, x2);
        try {
            try {
                super.ResultSet_updateBigDecimal(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBigDecimal(DmdbResultSet resultSet, int columnIndex, BigDecimal x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBigDecimal", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateBigDecimal(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, String columnLabel, InputStream x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBinaryStream", columnLabel, x2);
        try {
            try {
                super.ResultSet_updateBinaryStream(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, String columnLabel, InputStream x2, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBinaryStream", columnLabel, x2, length);
        try {
            try {
                super.ResultSet_updateBinaryStream(resultSet, columnLabel, x2, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, String columnLabel, InputStream x2, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBinaryStream", columnLabel, x2, length);
        try {
            try {
                super.ResultSet_updateBinaryStream(resultSet, columnLabel, x2, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, int columnIndex, InputStream x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBinaryStream", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateBinaryStream(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, int columnIndex, InputStream x2, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBinaryStream", columnIndex, x2, length);
        try {
            try {
                super.ResultSet_updateBinaryStream(resultSet, columnIndex, x2, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, int columnIndex, InputStream x2, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBinaryStream", columnIndex, x2, length);
        try {
            try {
                super.ResultSet_updateBinaryStream(resultSet, columnIndex, x2, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, String columnLabel, InputStream inputStream) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBlob", columnLabel, inputStream);
        try {
            try {
                super.ResultSet_updateBlob(resultSet, columnLabel, inputStream);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, String columnLabel, InputStream inputStream, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBlob", columnLabel, inputStream, length);
        try {
            try {
                super.ResultSet_updateBlob(resultSet, columnLabel, inputStream, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, String columnLabel, Blob x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBlob", columnLabel, x2);
        try {
            try {
                super.ResultSet_updateBlob(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, int columnIndex, InputStream inputStream) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBlob", columnIndex, inputStream);
        try {
            try {
                super.ResultSet_updateBlob(resultSet, columnIndex, inputStream);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, int columnIndex, InputStream inputStream, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBlob", columnIndex, inputStream, length);
        try {
            try {
                super.ResultSet_updateBlob(resultSet, columnIndex, inputStream, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, int columnIndex, Blob x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBlob", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateBlob(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBoolean(DmdbResultSet resultSet, String columnLabel, boolean x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBoolean", columnLabel, x2);
        try {
            try {
                super.ResultSet_updateBoolean(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBoolean(DmdbResultSet resultSet, int columnIndex, boolean x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBoolean", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateBoolean(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateByte(DmdbResultSet resultSet, String columnLabel, byte x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateByte", columnLabel, x2);
        try {
            try {
                super.ResultSet_updateByte(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateByte(DmdbResultSet resultSet, int columnIndex, byte x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateByte", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateByte(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBytes(DmdbResultSet resultSet, String columnLabel, byte[] x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBytes", columnLabel, x2);
        try {
            try {
                super.ResultSet_updateBytes(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateBytes(DmdbResultSet resultSet, int columnIndex, byte[] x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateBytes", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateBytes(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateCharacterStream", columnLabel, reader);
        try {
            try {
                super.ResultSet_updateCharacterStream(resultSet, columnLabel, reader);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateCharacterStream", columnLabel, reader, length);
        try {
            try {
                super.ResultSet_updateCharacterStream(resultSet, columnLabel, reader, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateCharacterStream", columnLabel, reader, length);
        try {
            try {
                super.ResultSet_updateCharacterStream(resultSet, columnLabel, reader, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateCharacterStream", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateCharacterStream(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x2, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateCharacterStream", columnIndex, x2, length);
        try {
            try {
                super.ResultSet_updateCharacterStream(resultSet, columnIndex, x2, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x2, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateCharacterStream", columnIndex, x2, length);
        try {
            try {
                super.ResultSet_updateCharacterStream(resultSet, columnIndex, x2, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateClob", columnLabel, reader);
        try {
            try {
                super.ResultSet_updateClob(resultSet, columnLabel, reader);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateClob", columnLabel, reader, length);
        try {
            try {
                super.ResultSet_updateClob(resultSet, columnLabel, reader, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, String columnLabel, Clob x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateClob", columnLabel, x2);
        try {
            try {
                super.ResultSet_updateClob(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, int columnIndex, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateClob", columnIndex, reader);
        try {
            try {
                super.ResultSet_updateClob(resultSet, columnIndex, reader);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateClob", columnIndex, reader, length);
        try {
            try {
                super.ResultSet_updateClob(resultSet, columnIndex, reader, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, int columnIndex, Clob x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateClob", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateClob(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateDate(DmdbResultSet resultSet, String columnLabel, Date x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateDate", columnLabel, x2);
        try {
            try {
                super.ResultSet_updateDate(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateDate(DmdbResultSet resultSet, int columnIndex, Date x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateDate", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateDate(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateDouble(DmdbResultSet resultSet, String columnLabel, double x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateDouble", columnLabel, x2);
        try {
            try {
                super.ResultSet_updateDouble(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateDouble(DmdbResultSet resultSet, int columnIndex, double x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateDouble", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateDouble(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateFloat(DmdbResultSet resultSet, String columnLabel, float x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateFloat", columnLabel, Float.valueOf(x2));
        try {
            try {
                super.ResultSet_updateFloat(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateFloat(DmdbResultSet resultSet, int columnIndex, float x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateFloat", columnIndex, Float.valueOf(x2));
        try {
            try {
                super.ResultSet_updateFloat(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateInt(DmdbResultSet resultSet, String columnLabel, int x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateInt", columnLabel, x2);
        try {
            try {
                super.ResultSet_updateInt(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateInt(DmdbResultSet resultSet, int columnIndex, int x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateInt", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateInt(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateLong(DmdbResultSet resultSet, String columnLabel, long x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateLong", columnLabel, x2);
        try {
            try {
                super.ResultSet_updateLong(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateLong(DmdbResultSet resultSet, int columnIndex, long x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateLong", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateLong(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNCharacterStream", columnLabel, reader);
        try {
            try {
                super.ResultSet_updateNCharacterStream(resultSet, columnLabel, reader);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNCharacterStream", columnLabel, reader, length);
        try {
            try {
                super.ResultSet_updateNCharacterStream(resultSet, columnLabel, reader, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNCharacterStream", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateNCharacterStream(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x2, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNCharacterStream", columnIndex, x2, length);
        try {
            try {
                super.ResultSet_updateNCharacterStream(resultSet, columnIndex, x2, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, String columnLabel, NClob nClob) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNClob", columnLabel, nClob);
        try {
            try {
                super.ResultSet_updateNClob(resultSet, columnLabel, nClob);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNClob", columnLabel, reader);
        try {
            try {
                super.ResultSet_updateNClob(resultSet, columnLabel, reader);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNClob", columnLabel, reader, length);
        try {
            try {
                super.ResultSet_updateNClob(resultSet, columnLabel, reader, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, int columnIndex, NClob nClob) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNClob", columnIndex, nClob);
        try {
            try {
                super.ResultSet_updateNClob(resultSet, columnIndex, nClob);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, int columnIndex, Reader reader) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNClob", columnIndex, reader);
        try {
            try {
                super.ResultSet_updateNClob(resultSet, columnIndex, reader);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNClob", columnIndex, reader, length);
        try {
            try {
                super.ResultSet_updateNClob(resultSet, columnIndex, reader, length);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNString(DmdbResultSet resultSet, String columnLabel, String nString) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNString", columnLabel, nString);
        try {
            try {
                super.ResultSet_updateNString(resultSet, columnLabel, nString);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNString(DmdbResultSet resultSet, int columnIndex, String nString) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNString", columnIndex, nString);
        try {
            try {
                super.ResultSet_updateNString(resultSet, columnIndex, nString);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNull(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNull", columnLabel);
        try {
            try {
                super.ResultSet_updateNull(resultSet, columnLabel);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateNull(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateNull", columnIndex);
        try {
            try {
                super.ResultSet_updateNull(resultSet, columnIndex);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, String columnLabel, Object x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateObject", columnLabel, x2);
        try {
            try {
                super.ResultSet_updateObject(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, String columnLabel, Object x2, int scaleOrLength) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateObject", columnLabel, x2, scaleOrLength);
        try {
            try {
                super.ResultSet_updateObject(resultSet, columnLabel, x2, scaleOrLength);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, int columnIndex, Object x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateObject", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateObject(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, int columnIndex, Object x2, int scaleOrLength) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateObject", columnIndex, x2, scaleOrLength);
        try {
            try {
                super.ResultSet_updateObject(resultSet, columnIndex, x2, scaleOrLength);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateRef(DmdbResultSet resultSet, String columnLabel, Ref x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateRef", columnLabel, x2);
        try {
            try {
                super.ResultSet_updateRef(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateRef(DmdbResultSet resultSet, int columnIndex, Ref x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateRef", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateRef(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateRow(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateRow", new Object[0]);
        try {
            try {
                super.ResultSet_updateRow(resultSet);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateRowId(DmdbResultSet resultSet, String columnLabel, RowId x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateRowId", columnLabel, x2);
        try {
            try {
                super.ResultSet_updateRowId(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateRowId(DmdbResultSet resultSet, int columnIndex, RowId x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateRowId", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateRowId(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateSQLXML(DmdbResultSet resultSet, String columnLabel, SQLXML xmlObject) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateSQLXML", columnLabel, xmlObject);
        try {
            try {
                super.ResultSet_updateSQLXML(resultSet, columnLabel, xmlObject);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateSQLXML(DmdbResultSet resultSet, int columnIndex, SQLXML xmlObject) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateSQLXML", columnIndex, xmlObject);
        try {
            try {
                super.ResultSet_updateSQLXML(resultSet, columnIndex, xmlObject);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateShort(DmdbResultSet resultSet, String columnLabel, short x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateShort", columnLabel, x2);
        try {
            try {
                super.ResultSet_updateShort(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateShort(DmdbResultSet resultSet, int columnIndex, short x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateShort", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateShort(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateString(DmdbResultSet resultSet, String columnLabel, String x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateString", columnLabel, x2);
        try {
            try {
                super.ResultSet_updateString(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateString(DmdbResultSet resultSet, int columnIndex, String x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateString", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateString(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateTime(DmdbResultSet resultSet, String columnLabel, Time x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateTime", columnLabel, x2);
        try {
            try {
                super.ResultSet_updateTime(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateTime(DmdbResultSet resultSet, int columnIndex, Time x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateTime", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateTime(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateTimestamp(DmdbResultSet resultSet, String columnLabel, Timestamp x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateTimestamp", columnLabel, x2);
        try {
            try {
                super.ResultSet_updateTimestamp(resultSet, columnLabel, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateTimestamp(DmdbResultSet resultSet, int columnIndex, Timestamp x2) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateTimestamp", columnIndex, x2);
        try {
            try {
                super.ResultSet_updateTimestamp(resultSet, columnIndex, x2);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSet_wasNull(DmdbResultSet resultSet) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "wasNull", new Object[0]);
        try {
            boolean ret = super.ResultSet_wasNull(resultSet);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, int columnIndex, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateObject", columnIndex, x2, targetSqlType, scaleOrLength);
        try {
            try {
                super.ResultSet_updateObject(resultSet, columnIndex, x2, targetSqlType, scaleOrLength);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, String columnLabel, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateObject", columnLabel, x2, targetSqlType, scaleOrLength);
        try {
            try {
                super.ResultSet_updateObject(resultSet, columnLabel, x2, targetSqlType, scaleOrLength);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, int columnIndex, Object x2, SQLType targetSqlType) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateObject", columnIndex, x2, targetSqlType);
        try {
            try {
                super.ResultSet_updateObject(resultSet, columnIndex, x2, targetSqlType);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, String columnLabel, Object x2, SQLType targetSqlType) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSet, "updateObject", columnLabel, x2, targetSqlType);
        try {
            try {
                super.ResultSet_updateObject(resultSet, columnLabel, x2, targetSqlType);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSetMetaData_getCatalogName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getCatalogName", column);
        try {
            String ret = super.ResultSetMetaData_getCatalogName(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSetMetaData_getColumnClassName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getColumnClassName", column);
        try {
            String ret = super.ResultSetMetaData_getColumnClassName(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSetMetaData_getColumnCount(DmdbResultSetMetaData resultSetMetaData) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getColumnCount", new Object[0]);
        try {
            int ret = super.ResultSetMetaData_getColumnCount(resultSetMetaData);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSetMetaData_getColumnDisplaySize(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getColumnDisplaySize", column);
        try {
            int ret = super.ResultSetMetaData_getColumnDisplaySize(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSetMetaData_getColumnLabel(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getColumnLabel", column);
        try {
            String ret = super.ResultSetMetaData_getColumnLabel(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSetMetaData_getColumnName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getColumnName", column);
        try {
            String ret = super.ResultSetMetaData_getColumnName(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSetMetaData_getColumnType(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getColumnType", column);
        try {
            int ret = super.ResultSetMetaData_getColumnType(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSetMetaData_getColumnTypeName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getColumnTypeName", column);
        try {
            String ret = super.ResultSetMetaData_getColumnTypeName(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSetMetaData_getPrecision(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getPrecision", column);
        try {
            int ret = super.ResultSetMetaData_getPrecision(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSetMetaData_getScale(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getScale", column);
        try {
            int ret = super.ResultSetMetaData_getScale(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSetMetaData_getSchemaName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getSchemaName", column);
        try {
            String ret = super.ResultSetMetaData_getSchemaName(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String ResultSetMetaData_getTableName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "getTableName", column);
        try {
            String ret = super.ResultSetMetaData_getTableName(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSetMetaData_isAutoIncrement(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "isAutoIncrement", column);
        try {
            boolean ret = super.ResultSetMetaData_isAutoIncrement(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSetMetaData_isCaseSensitive(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "isCaseSensitive", column);
        try {
            boolean ret = super.ResultSetMetaData_isCaseSensitive(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSetMetaData_isCurrency(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "isCurrency", column);
        try {
            boolean ret = super.ResultSetMetaData_isCurrency(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSetMetaData_isDefinitelyWritable(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "isDefinitelyWritable", column);
        try {
            boolean ret = super.ResultSetMetaData_isDefinitelyWritable(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int ResultSetMetaData_isNullable(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "isNullable", column);
        try {
            int ret = super.ResultSetMetaData_isNullable(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSetMetaData_isReadOnly(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "isReadOnly", column);
        try {
            boolean ret = super.ResultSetMetaData_isReadOnly(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSetMetaData_isSearchable(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "isSearchable", column);
        try {
            boolean ret = super.ResultSetMetaData_isSearchable(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSetMetaData_isSigned(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "isSigned", column);
        try {
            boolean ret = super.ResultSetMetaData_isSigned(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean ResultSetMetaData_isWritable(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        LogRecord logRecord = new LogRecord(resultSetMetaData, "isWritable", column);
        try {
            boolean ret = super.ResultSetMetaData_isWritable(resultSetMetaData, column);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_addBatch(DmdbStatement statement, String sql) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "addBatch", sql);
        logRecord.setSql(sql);
        try {
            try {
                super.Statement_addBatch(statement, sql);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_cancel(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "cancel", new Object[0]);
        try {
            try {
                super.Statement_cancel(statement);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_clearBatch(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "clearBatch", new Object[0]);
        try {
            try {
                super.Statement_clearBatch(statement);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_clearWarnings(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "clearWarnings", new Object[0]);
        try {
            try {
                super.Statement_clearWarnings(statement);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_close(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "close", new Object[0]);
        try {
            try {
                super.Statement_close(statement);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_closeOnCompletion(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "closeOnCompletion", new Object[0]);
        try {
            try {
                super.Statement_closeOnCompletion(statement);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    private <T extends DmdbStatement> void setExecuteId(LogRecord logRecord, T stmt) throws SQLException {
        logRecord.setExecuteId(stmt.do_getExecuteId());
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "execute", sql);
        logRecord.setSql(sql);
        try {
            boolean ret = super.Statement_execute(statement, sql);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, statement);
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "execute", sql, columnNames);
        logRecord.setSql(sql);
        try {
            boolean ret = super.Statement_execute(statement, sql, columnNames);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, statement);
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "execute", sql, autoGeneratedKeys);
        logRecord.setSql(sql);
        try {
            boolean ret = super.Statement_execute(statement, sql, autoGeneratedKeys);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, statement);
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "execute", sql, columnIndexes);
        logRecord.setSql(sql);
        try {
            boolean ret = super.Statement_execute(statement, sql, columnIndexes);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, statement);
            this.doLog(logRecord);
        }
    }

    @Override
    public int[] Statement_executeBatch(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeBatch", new Object[0]);
        try {
            int[] ret = super.Statement_executeBatch(statement);
            logRecord.setReturnValue(ret);
            int[] nArray = ret;
            return nArray;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, statement);
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet Statement_executeQuery(DmdbStatement statement, String sql) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeQuery", sql);
        logRecord.setSql(sql);
        try {
            ResultSet ret = super.Statement_executeQuery(statement, sql);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, statement);
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeUpdate", sql);
        logRecord.setSql(sql);
        try {
            int ret = super.Statement_executeUpdate(statement, sql);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, statement);
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeUpdate", sql, columnNames);
        logRecord.setSql(sql);
        try {
            int ret = super.Statement_executeUpdate(statement, sql, columnNames);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, statement);
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeUpdate", sql, autoGeneratedKeys);
        logRecord.setSql(sql);
        try {
            int ret = super.Statement_executeUpdate(statement, sql, autoGeneratedKeys);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, statement);
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeUpdate", sql, columnIndexes);
        logRecord.setSql(sql);
        try {
            int ret = super.Statement_executeUpdate(statement, sql, columnIndexes);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, statement);
            this.doLog(logRecord);
        }
    }

    @Override
    public Connection Statement_getConnection(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getConnection", new Object[0]);
        try {
            Connection ret = super.Statement_getConnection(statement);
            logRecord.setReturnValue(ret);
            Connection connection = ret;
            return connection;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_getFetchDirection(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getFetchDirection", new Object[0]);
        try {
            int ret = super.Statement_getFetchDirection(statement);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_getFetchSize(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getFetchSize", new Object[0]);
        try {
            int ret = super.Statement_getFetchSize(statement);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet Statement_getGeneratedKeys(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getGeneratedKeys", new Object[0]);
        try {
            ResultSet ret = super.Statement_getGeneratedKeys(statement);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_getMaxFieldSize(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getMaxFieldSize", new Object[0]);
        try {
            int ret = super.Statement_getMaxFieldSize(statement);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_getMaxRows(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getMaxRows", new Object[0]);
        try {
            int ret = super.Statement_getMaxRows(statement);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Statement_getMoreResults(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getMoreResults", new Object[0]);
        try {
            boolean ret = super.Statement_getMoreResults(statement);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Statement_getMoreResults(DmdbStatement statement, int current) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getMoreResults", current);
        try {
            boolean ret = super.Statement_getMoreResults(statement, current);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_getQueryTimeout(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getQueryTimeout", new Object[0]);
        try {
            int ret = super.Statement_getQueryTimeout(statement);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet Statement_getResultSet(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getResultSet", new Object[0]);
        try {
            ResultSet ret = super.Statement_getResultSet(statement);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_getResultSetConcurrency(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getResultSetConcurrency", new Object[0]);
        try {
            int ret = super.Statement_getResultSetConcurrency(statement);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_getResultSetHoldability(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getResultSetHoldability", new Object[0]);
        try {
            int ret = super.Statement_getResultSetHoldability(statement);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_getResultSetType(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getResultSetType", new Object[0]);
        try {
            int ret = super.Statement_getResultSetType(statement);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_getUpdateCount(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getUpdateCount", new Object[0]);
        try {
            int ret = super.Statement_getUpdateCount(statement);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public SQLWarning Statement_getWarnings(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getWarnings", new Object[0]);
        try {
            SQLWarning ret = super.Statement_getWarnings(statement);
            logRecord.setReturnValue(ret);
            SQLWarning sQLWarning = ret;
            return sQLWarning;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Statement_isCloseOnCompletion(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "isCloseOnCompletion", new Object[0]);
        try {
            boolean ret = super.Statement_isCloseOnCompletion(statement);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Statement_isClosed(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "isClosed", new Object[0]);
        try {
            boolean ret = super.Statement_isClosed(statement);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean Statement_isPoolable(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "isPoolable", new Object[0]);
        try {
            boolean ret = super.Statement_isPoolable(statement);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_setCursorName(DmdbStatement statement, String name) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "setCursorName", name);
        try {
            try {
                super.Statement_setCursorName(statement, name);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_setEscapeProcessing(DmdbStatement statement, boolean enable) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "setEscapeProcessing", enable);
        try {
            try {
                super.Statement_setEscapeProcessing(statement, enable);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_setFetchDirection(DmdbStatement statement, int direction) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "setFetchDirection", direction);
        try {
            try {
                super.Statement_setFetchDirection(statement, direction);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_setFetchSize(DmdbStatement statement, int rows) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "setFetchSize", rows);
        try {
            try {
                super.Statement_setFetchSize(statement, rows);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_setMaxFieldSize(DmdbStatement statement, int max) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "setMaxFieldSize", max);
        try {
            try {
                super.Statement_setMaxFieldSize(statement, max);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_setMaxRows(DmdbStatement statement, int max) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "setMaxRows", max);
        try {
            try {
                super.Statement_setMaxRows(statement, max);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_setPoolable(DmdbStatement statement, boolean poolable) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "setPoolable", poolable);
        try {
            try {
                super.Statement_setPoolable(statement, poolable);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_setQueryTimeout(DmdbStatement statement, int seconds) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "setQueryTimeout", seconds);
        try {
            try {
                super.Statement_setQueryTimeout(statement, seconds);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long Statement_getLargeUpdateCount(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getLargeUpdateCount", new Object[0]);
        try {
            long ret = super.Statement_getLargeUpdateCount(statement);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Statement_setLargeMaxRows(DmdbStatement statement, long max) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "setLargeMaxRows", max);
        try {
            try {
                super.Statement_setLargeMaxRows(statement, max);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long Statement_getLargeMaxRows(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getLargeMaxRows", new Object[0]);
        try {
            long ret = super.Statement_getLargeMaxRows(statement);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long[] Statement_executeLargeBatch(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeLargeBatch", new Object[0]);
        try {
            long[] ret = super.Statement_executeLargeBatch(statement);
            logRecord.setReturnValue(ret);
            long[] lArray = ret;
            return lArray;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, statement);
            this.doLog(logRecord);
        }
    }

    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeLargeUpdate", sql);
        logRecord.setSql(sql);
        try {
            long ret = super.Statement_executeLargeUpdate(statement, sql);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, statement);
            this.doLog(logRecord);
        }
    }

    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeLargeUpdate", sql, autoGeneratedKeys);
        logRecord.setSql(sql);
        try {
            long ret = super.Statement_executeLargeUpdate(statement, sql, autoGeneratedKeys);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, statement);
            this.doLog(logRecord);
        }
    }

    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeLargeUpdate", sql, columnIndexes);
        logRecord.setSql(sql);
        try {
            long ret = super.Statement_executeLargeUpdate(statement, sql, columnIndexes);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, statement);
            this.doLog(logRecord);
        }
    }

    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "executeLargeUpdate", sql, columnNames);
        logRecord.setSql(sql);
        try {
            long ret = super.Statement_executeLargeUpdate(statement, sql, columnNames);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.setExecuteId(logRecord, statement);
            this.doLog(logRecord);
        }
    }

    @Override
    public long Statement_getExecuteId(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getExecuteId", new Object[0]);
        try {
            long l2 = super.Statement_getExecuteId(statement);
            return l2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String Statement_getPrintMsg(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getPrintMsg", new Object[0]);
        try {
            String string = super.Statement_getPrintMsg(statement);
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Statement_getSqlType(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getSqlType", new Object[0]);
        try {
            int n2 = super.Statement_getSqlType(statement);
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public RowId Statement_getRowId(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getRowId", new Object[0]);
        try {
            RowId rowId = super.Statement_getRowId(statement);
            return rowId;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet[] Statement_getResultSets(DmdbStatement statement) throws SQLException {
        LogRecord logRecord = new LogRecord(statement, "getResultSets", new Object[0]);
        try {
            ResultSet[] resultSetArray = super.Statement_getResultSets(statement);
            return resultSetArray;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String Statement_getExplain(DmdbStatement dmdbStatement) {
        LogRecord logRecord = new LogRecord(dmdbStatement, "getExplain", new Object[0]);
        try {
            String string = super.Statement_getExplain(dmdbStatement);
            return string;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long Blob_length(DmdbBlob blob) throws SQLException {
        LogRecord logRecord = new LogRecord(blob, "length", new Object[0]);
        try {
            long ret = super.Blob_length(blob);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public byte[] Blob_getBytes(DmdbBlob blob, long pos, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(blob, "getBytes", pos, length);
        try {
            byte[] ret = super.Blob_getBytes(blob, pos, length);
            logRecord.setReturnValue(ret);
            byte[] byArray = ret;
            return byArray;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public InputStream Blob_getBinaryStream(DmdbBlob blob) throws SQLException {
        LogRecord logRecord = new LogRecord(blob, "getBinaryStream", new Object[0]);
        try {
            InputStream ret = super.Blob_getBinaryStream(blob);
            logRecord.setReturnValue(ret);
            InputStream inputStream = ret;
            return inputStream;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long Blob_position(DmdbBlob blob, byte[] pattern, long start) throws SQLException {
        LogRecord logRecord = new LogRecord(blob, "position", pattern, start);
        try {
            long ret = super.Blob_position(blob, pattern, start);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long Blob_position(DmdbBlob blob, Blob pattern, long start) throws SQLException {
        LogRecord logRecord = new LogRecord(blob, "position", pattern, start);
        try {
            long ret = super.Blob_position(blob, pattern, start);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Blob_setBytes(DmdbBlob blob, long pos, byte[] bytes) throws SQLException {
        LogRecord logRecord = new LogRecord(blob, "setBytes", pos, bytes);
        try {
            int ret = super.Blob_setBytes(blob, pos, bytes);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Blob_setBytes(DmdbBlob blob, long pos, byte[] bytes, int offset, int len) throws SQLException {
        LogRecord logRecord = new LogRecord(blob, "setBytes", pos, bytes, offset, len);
        try {
            int ret = super.Blob_setBytes(blob, pos, bytes, offset, len);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public OutputStream Blob_setBinaryStream(DmdbBlob blob, long pos) throws SQLException {
        LogRecord logRecord = new LogRecord(blob, "setBinaryStream", pos);
        try {
            OutputStream ret = super.Blob_setBinaryStream(blob, pos);
            logRecord.setReturnValue(ret);
            OutputStream outputStream = ret;
            return outputStream;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Blob_truncate(DmdbBlob blob, long len) throws SQLException {
        LogRecord logRecord = new LogRecord(blob, "truncate", len);
        try {
            try {
                super.Blob_truncate(blob, len);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Blob_free(DmdbBlob blob) throws SQLException {
        LogRecord logRecord = new LogRecord(blob, "free", new Object[0]);
        try {
            try {
                super.Blob_free(blob);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public InputStream Blob_getBinaryStream(DmdbBlob blob, long pos, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(blob, "getBinaryStream", pos, length);
        try {
            InputStream ret = super.Blob_getBinaryStream(blob, pos, length);
            logRecord.setReturnValue(ret);
            InputStream inputStream = ret;
            return inputStream;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long Clob_length(DmdbClob clob) throws SQLException {
        LogRecord logRecord = new LogRecord(clob, "length", new Object[0]);
        try {
            long ret = super.Clob_length(clob);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public String Clob_getSubString(DmdbClob clob, long pos, int length) throws SQLException {
        LogRecord logRecord = new LogRecord(clob, "getSubString", pos, length);
        try {
            String ret = super.Clob_getSubString(clob, pos, length);
            logRecord.setReturnValue(ret);
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Reader Clob_getCharacterStream(DmdbClob clob) throws SQLException {
        LogRecord logRecord = new LogRecord(clob, "getCharacterStream", new Object[0]);
        try {
            Reader ret = super.Clob_getCharacterStream(clob);
            logRecord.setReturnValue(ret);
            Reader reader = ret;
            return reader;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public InputStream Clob_getAsciiStream(DmdbClob clob) throws SQLException {
        LogRecord logRecord = new LogRecord(clob, "getAsciiStream", new Object[0]);
        try {
            InputStream ret = super.Clob_getAsciiStream(clob);
            logRecord.setReturnValue(ret);
            InputStream inputStream = ret;
            return inputStream;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long Clob_position(DmdbClob clob, String searchstr, long start) throws SQLException {
        LogRecord logRecord = new LogRecord(clob, "position", searchstr, start);
        try {
            long ret = super.Clob_position(clob, searchstr, start);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public long Clob_position(DmdbClob clob, Clob searchstr, long start) throws SQLException {
        LogRecord logRecord = new LogRecord(clob, "position", searchstr, start);
        try {
            long ret = super.Clob_position(clob, searchstr, start);
            logRecord.setReturnValue(ret);
            long l2 = ret;
            return l2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Clob_setString(DmdbClob clob, long pos, String str) throws SQLException {
        LogRecord logRecord = new LogRecord(clob, "setString", pos, str);
        try {
            int ret = super.Clob_setString(clob, pos, str);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int Clob_setString(DmdbClob clob, long pos, String str, int offset, int len) throws SQLException {
        LogRecord logRecord = new LogRecord(clob, "setString", pos, str, offset, len);
        try {
            int ret = super.Clob_setString(clob, pos, str, offset, len);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public OutputStream Clob_setAsciiStream(DmdbClob clob, long pos) throws SQLException {
        LogRecord logRecord = new LogRecord(clob, "setAsciiStream", pos);
        try {
            OutputStream ret = super.Clob_setAsciiStream(clob, pos);
            logRecord.setReturnValue(ret);
            OutputStream outputStream = ret;
            return outputStream;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Writer Clob_setCharacterStream(DmdbClob clob, long pos) throws SQLException {
        LogRecord logRecord = new LogRecord(clob, "setCharacterStream", pos);
        try {
            Writer ret = super.Clob_setCharacterStream(clob, pos);
            logRecord.setReturnValue(ret);
            Writer writer = ret;
            return writer;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Clob_truncate(DmdbClob clob, long len) throws SQLException {
        LogRecord logRecord = new LogRecord(clob, "truncate", len);
        try {
            try {
                super.Clob_truncate(clob, len);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void Clob_free(DmdbClob clob) throws SQLException {
        LogRecord logRecord = new LogRecord(clob, "free", new Object[0]);
        try {
            try {
                super.Clob_free(clob);
            }
            catch (Exception e2) {
                logRecord.setThrowable(e2);
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Reader Clob_getCharacterStream(DmdbClob clob, long pos, long length) throws SQLException {
        LogRecord logRecord = new LogRecord(clob, "getCharacterStream", pos, length);
        try {
            Reader ret = super.Clob_getCharacterStream(clob, pos, length);
            logRecord.setReturnValue(ret);
            Reader reader = ret;
            return reader;
        }
        catch (Exception e2) {
            logRecord.setThrowable(e2);
            throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Connection Driver_connect(DmDriver dmDriver, DmProperties props) throws SQLException {
        Connection connection;
        Connection conn = null;
        Exception ex = null;
        try {
            connection = conn = super.Driver_connect(dmDriver, props);
        }
        catch (Exception e2) {
            try {
                ex = e2;
                throw e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            }
            catch (Throwable throwable) {
                LogRecord logRecord = new LogRecord(dmDriver, "connect", props);
                logRecord.setReturnValue(conn);
                logRecord.setThrowable(ex);
                this.doLog(logRecord);
                throw throwable;
            }
        }
        LogRecord logRecord = new LogRecord(dmDriver, "connect", props);
        logRecord.setReturnValue(conn);
        logRecord.setThrowable(ex);
        this.doLog(logRecord);
        return connection;
    }

    @Override
    public void Connection_reset(DmdbConnection connection) throws SQLException {
        LogRecord logRecord = new LogRecord(connection, "reset", new Object[0]);
        try {
            try {
                super.Connection_reset(connection);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public ResultSet CallableStatement_getCursor(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getCursor", new Object[0]);
        try {
            ResultSet ret = super.CallableStatement_getCursor(callableStatement, parameterName);
            logRecord.setReturnValue(ret);
            ResultSet resultSet = ret;
            return resultSet;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setINTERVALDT(DmdbCallableStatement callableStatement, String paramName, DmdbIntervalDT x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setINTERVALDT", new Object[0]);
        try {
            try {
                super.CallableStatement_setINTERVALDT(callableStatement, paramName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setINTERVALYM(DmdbCallableStatement callableStatement, String paramName, DmdbIntervalYM x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setINTERVALYM", new Object[0]);
        try {
            try {
                super.CallableStatement_setINTERVALYM(callableStatement, paramName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void CallableStatement_setTIMESTAMP(DmdbCallableStatement callableStatement, String paramName, DmdbTimestamp x2) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "setTIMESTAMP", new Object[0]);
        try {
            try {
                super.CallableStatement_setTIMESTAMP(callableStatement, paramName, x2);
            }
            catch (SQLException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public DmdbTimestamp CallableStatement_getTIMESTAMP(DmdbCallableStatement callableStatement, String paramName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getTIMESTAMP", new Object[0]);
        try {
            DmdbTimestamp ret = super.CallableStatement_getTIMESTAMP(callableStatement, paramName);
            logRecord.setReturnValue(ret);
            DmdbTimestamp dmdbTimestamp = ret;
            return dmdbTimestamp;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public DmdbIntervalDT CallableStatement_getINTERVALDT(DmdbCallableStatement callableStatement, String paramName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getINTERVALDT", new Object[0]);
        try {
            DmdbIntervalDT ret = super.CallableStatement_getINTERVALDT(callableStatement, paramName);
            logRecord.setReturnValue(ret);
            DmdbIntervalDT dmdbIntervalDT = ret;
            return dmdbIntervalDT;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public DmdbIntervalYM CallableStatement_getINTERVALYM(DmdbCallableStatement callableStatement, String paramName) throws SQLException {
        LogRecord logRecord = new LogRecord(callableStatement, "getINTERVALYM", new Object[0]);
        try {
            DmdbIntervalYM ret = super.CallableStatement_getINTERVALYM(callableStatement, paramName);
            logRecord.setReturnValue(ret);
            DmdbIntervalYM dmdbIntervalYM = ret;
            return dmdbIntervalYM;
        }
        catch (SQLException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void XAResource_start(DmdbXAResource xaResource, Xid xid, int flags) throws XAException {
        LogRecord logRecord = new LogRecord(xaResource, "start", xid, flags);
        try {
            try {
                super.XAResource_start(xaResource, xid, flags);
            }
            catch (XAException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void XAResource_end(DmdbXAResource xaResource, Xid xid, int flags) throws XAException {
        LogRecord logRecord = new LogRecord(xaResource, "end", xid, flags);
        try {
            try {
                super.XAResource_end(xaResource, xid, flags);
            }
            catch (XAException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean XAResource_setTransactionTimeout(DmdbXAResource xaResource, int seconds) throws XAException {
        LogRecord logRecord = new LogRecord(xaResource, "setTransactionTimeout", seconds);
        try {
            boolean ret = super.XAResource_setTransactionTimeout(xaResource, seconds);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (XAException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int XAResource_getTransactionTimeout(DmdbXAResource xaResource) throws XAException {
        LogRecord logRecord = new LogRecord(xaResource, "getTransactionTimeout", new Object[0]);
        try {
            int ret = super.XAResource_getTransactionTimeout(xaResource);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (XAException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void XAResource_rollback(DmdbXAResource xaResource, Xid xid) throws XAException {
        LogRecord logRecord = new LogRecord(xaResource, "rollback", xid);
        try {
            try {
                super.XAResource_rollback(xaResource, xid);
            }
            catch (XAException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void XAResource_commit(DmdbXAResource xaResource, Xid xid, boolean onePhase) throws XAException {
        LogRecord logRecord = new LogRecord(xaResource, "commit", xid, onePhase);
        try {
            try {
                super.XAResource_commit(xaResource, xid, onePhase);
            }
            catch (XAException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public Xid[] XAResource_recover(DmdbXAResource xaResource, int flag) throws XAException {
        LogRecord logRecord = new LogRecord(xaResource, "recover", flag);
        try {
            Xid[] ret = super.XAResource_recover(xaResource, flag);
            logRecord.setReturnValue(ret);
            Xid[] xidArray = ret;
            return xidArray;
        }
        catch (XAException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public int XAResource_prepare(DmdbXAResource xaResource, Xid xid) throws XAException {
        LogRecord logRecord = new LogRecord(xaResource, "prepare", xid);
        try {
            int ret = super.XAResource_prepare(xaResource, xid);
            logRecord.setReturnValue(ret);
            int n2 = ret;
            return n2;
        }
        catch (XAException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public boolean XAResource_isSameRM(DmdbXAResource xaResource, XAResource xaRes) throws XAException {
        LogRecord logRecord = new LogRecord(xaResource, "isSameRM", xaRes);
        try {
            boolean ret = super.XAResource_isSameRM(xaResource, xaRes);
            logRecord.setReturnValue(ret);
            boolean bl = ret;
            return bl;
        }
        catch (XAException e2) {
            logRecord.setThrowable(e2);
            throw e2;
        }
        finally {
            this.doLog(logRecord);
        }
    }

    @Override
    public void XAResource_forget(DmdbXAResource xaResource, Xid xid) throws XAException {
        LogRecord logRecord = new LogRecord(xaResource, "forget", xid);
        try {
            try {
                super.XAResource_forget(xaResource, xid);
            }
            catch (XAException e2) {
                logRecord.setThrowable(e2);
                throw e2;
            }
        }
        finally {
            this.doLog(logRecord);
        }
    }
}

