/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.custom;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.filter.BaseFilter;
import dm.jdbc.filter.custom.ICustom;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomFilter
extends BaseFilter {
    private ICustom custom;
    private static final Map<Statement, Map<String, Object>> retMaps = new HashMap<Statement, Map<String, Object>>();
    private static final Map<Statement, List<Map<String, Object>>> batchRowParams = new HashMap<Statement, List<Map<String, Object>>>();
    private static final Map<Statement, Map<String, Object>> curRowParams = new HashMap<Statement, Map<String, Object>>();

    private CustomFilter(String className) {
        try {
            Class<?> cls = Class.forName(className);
            this.custom = (ICustom)cls.newInstance();
        }
        catch (Exception e2) {
            DBError.throwRuntimeException("Create custom filter error!", e2);
        }
    }

    public static CustomFilter getInstance(String customClass) {
        return new CustomFilter(customClass);
    }

    private Map<String, Object> beforePrepare(DmdbConnection connection, String sql) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (sql != null) {
            ret.put("sql", sql);
        }
        ret.put("prepare", true);
        ret.put("connection", connection);
        return ret;
    }

    private void afterPrepare(Statement statement, Map<String, Object> ret) {
        ret.put("statement", statement);
        this.custom.afterPrepare(ret);
    }

    private boolean beforeExecute(Statement statement, String sql) {
        Map<String, Object> ret = null;
        if (statement instanceof PreparedStatement) {
            ret = retMaps.get(statement);
        }
        if (ret == null) {
            ret = new HashMap<String, Object>();
            ret.put("statement", statement);
            retMaps.put(statement, ret);
        }
        if (sql != null) {
            ret.put("sql", sql);
        } else {
            ret.put("sql", ((DmdbStatement)statement).nativeSql);
        }
        try {
            ret.put("connection", statement.getConnection());
        }
        catch (SQLException sQLException) {
            ret.put("connection", null);
        }
        if (statement instanceof PreparedStatement) {
            List<Map<String, Object>> values = batchRowParams.get(statement);
            if (values == null) {
                values = new ArrayList<Map<String, Object>>();
                Map<String, Object> curRowValues = curRowParams.get(statement);
                if (curRowValues != null) {
                    values.add(curRowValues);
                }
            }
            ret.put("params", values);
        }
        ret.put("prepare", sql == null);
        return this.custom.beforeExecute(ret);
    }

    private void afterExecute(Statement statement) {
        try {
            Map<String, Object> ret = retMaps.get(statement);
            this.custom.afterExecute(ret);
        }
        finally {
            curRowParams.remove(statement);
            batchRowParams.remove(statement);
            retMaps.remove(statement);
        }
    }

    private void bindParam(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2) {
        Map<String, Object> values = curRowParams.get(preparedStatement);
        if (values == null) {
            values = new HashMap<String, Object>();
            curRowParams.put(preparedStatement, values);
        }
        values.put("" + parameterIndex, x2);
    }

    private void bindParam(DmdbPreparedStatement preparedStatement, String parameterName, Object x2) {
        Map<String, Object> values = curRowParams.get(preparedStatement);
        if (values == null) {
            values = new HashMap<String, Object>();
            curRowParams.put(preparedStatement, values);
        }
        values.put(parameterName, x2);
    }

    @Override
    public void PreparedStatement_addBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        Map<String, Object> curRowValues = curRowParams.get(preparedStatement);
        if (curRowValues != null) {
            List<Map<String, Object>> values = batchRowParams.get(preparedStatement);
            if (values == null) {
                values = new ArrayList<Map<String, Object>>();
                batchRowParams.put(preparedStatement, values);
            }
            values.add(curRowValues);
            curRowParams.remove(preparedStatement);
        }
        super.PreparedStatement_addBatch(preparedStatement);
    }

    @Override
    public void PreparedStatement_setNull(DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, null);
        super.PreparedStatement_setNull(preparedStatement, parameterIndex, sqlType);
    }

    @Override
    public void PreparedStatement_setBoolean(DmdbPreparedStatement preparedStatement, int parameterIndex, boolean x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setBoolean(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setByte(DmdbPreparedStatement preparedStatement, int parameterIndex, byte x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setByte(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setShort(DmdbPreparedStatement preparedStatement, int parameterIndex, short x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setShort(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setInt(DmdbPreparedStatement preparedStatement, int parameterIndex, int x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setInt(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setLong(DmdbPreparedStatement preparedStatement, int parameterIndex, long x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setLong(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setFloat(DmdbPreparedStatement preparedStatement, int parameterIndex, float x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)Float.valueOf(x2));
        super.PreparedStatement_setFloat(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setDouble(DmdbPreparedStatement preparedStatement, int parameterIndex, double x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setDouble(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBigDecimal(DmdbPreparedStatement preparedStatement, int parameterIndex, BigDecimal x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setBigDecimal(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setString(DmdbPreparedStatement preparedStatement, int parameterIndex, String x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setString(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBytes(DmdbPreparedStatement preparedStatement, int parameterIndex, byte[] x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setBytes(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setDate(DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setDate(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setTime(DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setTime(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setTimestamp(DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setTimestamp(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setUnicodeStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setUnicodeStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, x2);
        super.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType);
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, x2);
        super.PreparedStatement_setObject(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, int length) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)reader);
        super.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setRef(DmdbPreparedStatement preparedStatement, int parameterIndex, Ref x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setRef(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, Blob x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setBlob(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Clob x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setClob(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setArray(DmdbPreparedStatement preparedStatement, int parameterIndex, Array x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setArray(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setDate(DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2, Calendar cal) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setDate(preparedStatement, parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setTime(DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2, Calendar cal) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setTime(preparedStatement, parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setTimestamp(DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setTimestamp(preparedStatement, parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setNull(DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, null);
        super.PreparedStatement_setNull(preparedStatement, parameterIndex, sqlType, typeName);
    }

    @Override
    public void PreparedStatement_setURL(DmdbPreparedStatement preparedStatement, int parameterIndex, URL x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setURL(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setRowId(DmdbPreparedStatement preparedStatement, int parameterIndex, RowId x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setRowId(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setNString(DmdbPreparedStatement preparedStatement, int parameterIndex, String x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setNString(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setNCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader x2, long length) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setNCharacterStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, NClob x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setNClob(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader x2, long length) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setClob(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setBlob(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader x2, long length) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setNClob(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setSQLXML(DmdbPreparedStatement preparedStatement, int parameterIndex, SQLXML x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setSQLXML(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType, int scaleOrLength) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, x2);
        super.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader x2, long length) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setNCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setNCharacterStream(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setClob(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setBlob(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setNClob(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, x2);
        super.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, SQLType targetSqlType) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, x2);
        super.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType);
    }

    @Override
    public void PreparedStatement_setTIMESTAMP(DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbTimestamp x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setTIMESTAMP(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setINTERVALYM(DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbIntervalYM x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setINTERVALYM(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setINTERVALDT(DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbIntervalDT x2) throws SQLException {
        this.bindParam(preparedStatement, parameterIndex, (Object)x2);
        super.PreparedStatement_setINTERVALDT(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void CallableStatement_setINTERVALDT(DmdbCallableStatement callableStatement, String paramName, DmdbIntervalDT x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, paramName, (Object)x2);
        super.CallableStatement_setINTERVALDT(callableStatement, paramName, x2);
    }

    @Override
    public void CallableStatement_setINTERVALYM(DmdbCallableStatement callableStatement, String paramName, DmdbIntervalYM x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, paramName, (Object)x2);
        super.CallableStatement_setINTERVALYM(callableStatement, paramName, x2);
    }

    @Override
    public void CallableStatement_setTIMESTAMP(DmdbCallableStatement callableStatement, String paramName, DmdbTimestamp x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, paramName, (Object)x2);
        super.CallableStatement_setTIMESTAMP(callableStatement, paramName, x2);
    }

    @Override
    public void CallableStatement_setURL(DmdbCallableStatement callableStatement, String parameterName, URL x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setURL(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setNull(DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, null);
        super.CallableStatement_setNull(callableStatement, parameterName, sqlType);
    }

    @Override
    public void CallableStatement_setBoolean(DmdbCallableStatement callableStatement, String parameterName, boolean x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setBoolean(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setByte(DmdbCallableStatement callableStatement, String parameterName, byte x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setByte(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setShort(DmdbCallableStatement callableStatement, String parameterName, short x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setShort(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setInt(DmdbCallableStatement callableStatement, String parameterName, int x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setInt(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setLong(DmdbCallableStatement callableStatement, String parameterName, long x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setLong(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setFloat(DmdbCallableStatement callableStatement, String parameterName, float x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)Float.valueOf(x2));
        super.CallableStatement_setFloat(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setDouble(DmdbCallableStatement callableStatement, String parameterName, double x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setDouble(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setBigDecimal(DmdbCallableStatement callableStatement, String parameterName, BigDecimal x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setBigDecimal(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setString(DmdbCallableStatement callableStatement, String parameterName, String x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setString(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setBytes(DmdbCallableStatement callableStatement, String parameterName, byte[] x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setBytes(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setDate(DmdbCallableStatement callableStatement, String parameterName, Date x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setDate(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setTime(DmdbCallableStatement callableStatement, String parameterName, Time x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setTime(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setTimestamp(DmdbCallableStatement callableStatement, String parameterName, Timestamp x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setTimestamp(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setAsciiStream(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setBinaryStream(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType, int scale) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, x2);
        super.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType, scale);
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, x2);
        super.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType);
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, x2);
        super.CallableStatement_setObject(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader x2, int length) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setCharacterStream(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setDate(DmdbCallableStatement callableStatement, String parameterName, Date x2, Calendar cal) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setDate(callableStatement, parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setTime(DmdbCallableStatement callableStatement, String parameterName, Time x2, Calendar cal) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setTime(callableStatement, parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setTimestamp(DmdbCallableStatement callableStatement, String parameterName, Timestamp x2, Calendar cal) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setTimestamp(callableStatement, parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setNull(DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, null);
        super.CallableStatement_setNull(callableStatement, parameterName, sqlType, typeName);
    }

    @Override
    public void CallableStatement_setRowId(DmdbCallableStatement callableStatement, String parameterName, RowId x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setRowId(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setNString(DmdbCallableStatement callableStatement, String parameterName, String x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setNString(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setNCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader x2, long length) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setNCharacterStream(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, NClob x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setNClob(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Reader x2, long length) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setClob(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setBlob(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, Reader x2, long length) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setNClob(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setSQLXML(DmdbCallableStatement callableStatement, String parameterName, SQLXML x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setSQLXML(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, Blob x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setBlob(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Clob x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setClob(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setAsciiStream(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setBinaryStream(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader x2, long length) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setCharacterStream(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setAsciiStream(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setBinaryStream(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setCharacterStream(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setNCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setNCharacterStream(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Reader x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setClob(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setBlob(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, Reader x2) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, (Object)x2);
        super.CallableStatement_setNClob(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, x2);
        super.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, SQLType targetSqlType) throws SQLException {
        this.bindParam((DmdbPreparedStatement)callableStatement, parameterName, x2);
        super.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType);
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql) throws SQLException {
        PreparedStatement stmt;
        Map<String, Object> ret;
        block3: {
            ret = null;
            stmt = null;
            try {
                ret = this.beforePrepare(connection, sql);
                if (this.custom.beforePrepare(ret)) break block3;
                this.afterPrepare(stmt, ret);
                return null;
            }
            catch (Throwable throwable) {
                this.afterPrepare(stmt, ret);
                throw throwable;
            }
        }
        PreparedStatement preparedStatement = stmt = super.Connection_prepareStatement(connection, (String)ret.get("sql"));
        this.afterPrepare(stmt, ret);
        return preparedStatement;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement stmt;
        Map<String, Object> ret;
        block3: {
            ret = null;
            stmt = null;
            try {
                ret = this.beforePrepare(connection, sql);
                if (this.custom.beforePrepare(ret)) break block3;
                this.afterPrepare(stmt, ret);
                return null;
            }
            catch (Throwable throwable) {
                this.afterPrepare(stmt, ret);
                throw throwable;
            }
        }
        PreparedStatement preparedStatement = stmt = super.Connection_prepareStatement(connection, (String)ret.get("sql"), autoGeneratedKeys);
        this.afterPrepare(stmt, ret);
        return preparedStatement;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement stmt;
        Map<String, Object> ret;
        block3: {
            ret = null;
            stmt = null;
            try {
                ret = this.beforePrepare(connection, sql);
                if (this.custom.beforePrepare(ret)) break block3;
                this.afterPrepare(stmt, ret);
                return null;
            }
            catch (Throwable throwable) {
                this.afterPrepare(stmt, ret);
                throw throwable;
            }
        }
        PreparedStatement preparedStatement = stmt = super.Connection_prepareStatement(connection, (String)ret.get("sql"), resultSetType, resultSetConcurrency);
        this.afterPrepare(stmt, ret);
        return preparedStatement;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement stmt;
        Map<String, Object> ret;
        block3: {
            ret = null;
            stmt = null;
            try {
                ret = this.beforePrepare(connection, sql);
                if (this.custom.beforePrepare(ret)) break block3;
                this.afterPrepare(stmt, ret);
                return null;
            }
            catch (Throwable throwable) {
                this.afterPrepare(stmt, ret);
                throw throwable;
            }
        }
        PreparedStatement preparedStatement = stmt = super.Connection_prepareStatement(connection, (String)ret.get("sql"), resultSetType, resultSetConcurrency, resultSetHoldability);
        this.afterPrepare(stmt, ret);
        return preparedStatement;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement stmt;
        Map<String, Object> ret;
        block3: {
            ret = null;
            stmt = null;
            try {
                ret = this.beforePrepare(connection, sql);
                if (this.custom.beforePrepare(ret)) break block3;
                this.afterPrepare(stmt, ret);
                return null;
            }
            catch (Throwable throwable) {
                this.afterPrepare(stmt, ret);
                throw throwable;
            }
        }
        PreparedStatement preparedStatement = stmt = super.Connection_prepareStatement(connection, (String)ret.get("sql"), columnIndexes);
        this.afterPrepare(stmt, ret);
        return preparedStatement;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, String[] columnNames) throws SQLException {
        PreparedStatement stmt;
        Map<String, Object> ret;
        block3: {
            ret = null;
            stmt = null;
            try {
                ret = this.beforePrepare(connection, sql);
                if (this.custom.beforePrepare(ret)) break block3;
                this.afterPrepare(stmt, ret);
                return null;
            }
            catch (Throwable throwable) {
                this.afterPrepare(stmt, ret);
                throw throwable;
            }
        }
        PreparedStatement preparedStatement = stmt = super.Connection_prepareStatement(connection, (String)ret.get("sql"), columnNames);
        this.afterPrepare(stmt, ret);
        return preparedStatement;
    }

    @Override
    public CallableStatement Connection_prepareCall(DmdbConnection connection, String sql) throws SQLException {
        CallableStatement stmt;
        Map<String, Object> ret;
        block3: {
            ret = null;
            stmt = null;
            try {
                ret = this.beforePrepare(connection, sql);
                if (this.custom.beforePrepare(ret)) break block3;
                this.afterPrepare(stmt, ret);
                return null;
            }
            catch (Throwable throwable) {
                this.afterPrepare(stmt, ret);
                throw throwable;
            }
        }
        CallableStatement callableStatement = stmt = super.Connection_prepareCall(connection, (String)ret.get("sql"));
        this.afterPrepare(stmt, ret);
        return callableStatement;
    }

    @Override
    public CallableStatement Connection_prepareCall(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement stmt;
        Map<String, Object> ret;
        block3: {
            ret = null;
            stmt = null;
            try {
                ret = this.beforePrepare(connection, sql);
                if (this.custom.beforePrepare(ret)) break block3;
                this.afterPrepare(stmt, ret);
                return null;
            }
            catch (Throwable throwable) {
                this.afterPrepare(stmt, ret);
                throw throwable;
            }
        }
        CallableStatement callableStatement = stmt = super.Connection_prepareCall(connection, (String)ret.get("sql"), resultSetType, resultSetConcurrency);
        this.afterPrepare(stmt, ret);
        return callableStatement;
    }

    @Override
    public CallableStatement Connection_prepareCall(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement stmt;
        Map<String, Object> ret;
        block3: {
            ret = null;
            stmt = null;
            try {
                ret = this.beforePrepare(connection, sql);
                if (this.custom.beforePrepare(ret)) break block3;
                this.afterPrepare(stmt, ret);
                return null;
            }
            catch (Throwable throwable) {
                this.afterPrepare(stmt, ret);
                throw throwable;
            }
        }
        CallableStatement callableStatement = stmt = super.Connection_prepareCall(connection, (String)ret.get("sql"), resultSetType, resultSetConcurrency, resultSetHoldability);
        this.afterPrepare(stmt, ret);
        return callableStatement;
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql) throws SQLException {
        try {
            if (!this.beforeExecute(statement, sql)) {
                return false;
            }
            boolean bl = super.Statement_execute(statement, (String)retMaps.get(statement).get("sql"));
            return bl;
        }
        finally {
            this.afterExecute(statement);
        }
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        try {
            if (!this.beforeExecute(statement, sql)) {
                return false;
            }
            boolean bl = super.Statement_execute(statement, (String)retMaps.get(statement).get("sql"), columnIndexes);
            return bl;
        }
        finally {
            this.afterExecute(statement);
        }
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (!this.beforeExecute(statement, sql)) {
                return false;
            }
            boolean bl = super.Statement_execute(statement, (String)retMaps.get(statement).get("sql"), autoGeneratedKeys);
            return bl;
        }
        finally {
            this.afterExecute(statement);
        }
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        try {
            if (!this.beforeExecute(statement, sql)) {
                return false;
            }
            boolean bl = super.Statement_execute(statement, (String)retMaps.get(statement).get("sql"), columnNames);
            return bl;
        }
        finally {
            this.afterExecute(statement);
        }
    }

    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql) throws SQLException {
        try {
            if (!this.beforeExecute(statement, sql)) {
                return 0L;
            }
            long l2 = super.Statement_executeLargeUpdate(statement, (String)retMaps.get(statement).get("sql"));
            return l2;
        }
        finally {
            this.afterExecute(statement);
        }
    }

    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (!this.beforeExecute(statement, sql)) {
                return 0L;
            }
            long l2 = super.Statement_executeLargeUpdate(statement, (String)retMaps.get(statement).get("sql"), autoGeneratedKeys);
            return l2;
        }
        finally {
            this.afterExecute(statement);
        }
    }

    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        try {
            if (!this.beforeExecute(statement, sql)) {
                return 0L;
            }
            long l2 = super.Statement_executeLargeUpdate(statement, (String)retMaps.get(statement).get("sql"), columnIndexes);
            return l2;
        }
        finally {
            this.afterExecute(statement);
        }
    }

    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        try {
            if (!this.beforeExecute(statement, sql)) {
                return 0L;
            }
            long l2 = super.Statement_executeLargeUpdate(statement, (String)retMaps.get(statement).get("sql"), columnNames);
            return l2;
        }
        finally {
            this.afterExecute(statement);
        }
    }

    @Override
    public ResultSet Statement_executeQuery(DmdbStatement statement, String sql) throws SQLException {
        try {
            if (!this.beforeExecute(statement, sql)) {
                return null;
            }
            ResultSet resultSet = super.Statement_executeQuery(statement, (String)retMaps.get(statement).get("sql"));
            return resultSet;
        }
        finally {
            this.afterExecute(statement);
        }
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql) throws SQLException {
        try {
            if (!this.beforeExecute(statement, sql)) {
                return 0;
            }
            int n2 = super.Statement_executeUpdate(statement, (String)retMaps.get(statement).get("sql"));
            return n2;
        }
        finally {
            this.afterExecute(statement);
        }
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (!this.beforeExecute(statement, sql)) {
                return 0;
            }
            int n2 = super.Statement_executeUpdate(statement, (String)retMaps.get(statement).get("sql"), autoGeneratedKeys);
            return n2;
        }
        finally {
            this.afterExecute(statement);
        }
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        try {
            if (!this.beforeExecute(statement, sql)) {
                return 0;
            }
            int n2 = super.Statement_executeUpdate(statement, (String)retMaps.get(statement).get("sql"), columnIndexes);
            return n2;
        }
        finally {
            this.afterExecute(statement);
        }
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        try {
            if (!this.beforeExecute(statement, sql)) {
                return 0;
            }
            int n2 = super.Statement_executeUpdate(statement, (String)retMaps.get(statement).get("sql"), columnNames);
            return n2;
        }
        finally {
            this.afterExecute(statement);
        }
    }

    @Override
    public int[] Statement_executeBatch(DmdbStatement statement) throws SQLException {
        try {
            if (!this.beforeExecute(statement, Arrays.toString(statement.batchSqls.toArray()))) {
                return null;
            }
            int[] nArray = super.Statement_executeBatch(statement);
            return nArray;
        }
        finally {
            this.afterExecute(statement);
        }
    }

    @Override
    public long[] Statement_executeLargeBatch(DmdbStatement statement) throws SQLException {
        try {
            if (!this.beforeExecute(statement, Arrays.toString(statement.batchSqls.toArray()))) {
                return null;
            }
            long[] lArray = super.Statement_executeLargeBatch(statement);
            return lArray;
        }
        finally {
            this.afterExecute(statement);
        }
    }

    @Override
    public boolean PreparedStatement_execute(DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            if (!this.beforeExecute(preparedStatement, null)) {
                return false;
            }
            boolean bl = super.PreparedStatement_execute(preparedStatement);
            return bl;
        }
        finally {
            this.afterExecute(preparedStatement);
        }
    }

    @Override
    public int[] PreparedStatement_executeBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            if (!this.beforeExecute(preparedStatement, null)) {
                return null;
            }
            int[] nArray = super.PreparedStatement_executeBatch(preparedStatement);
            return nArray;
        }
        finally {
            this.afterExecute(preparedStatement);
        }
    }

    @Override
    public long[] PreparedStatement_executeLargeBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            if (!this.beforeExecute(preparedStatement, null)) {
                return null;
            }
            long[] lArray = super.PreparedStatement_executeLargeBatch(preparedStatement);
            return lArray;
        }
        finally {
            this.afterExecute(preparedStatement);
        }
    }

    @Override
    public long PreparedStatement_executeLargeUpdate(DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            if (!this.beforeExecute(preparedStatement, null)) {
                return 0L;
            }
            long l2 = super.PreparedStatement_executeLargeUpdate(preparedStatement);
            return l2;
        }
        finally {
            this.afterExecute(preparedStatement);
        }
    }

    @Override
    public ResultSet PreparedStatement_executeQuery(DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            if (!this.beforeExecute(preparedStatement, null)) {
                return null;
            }
            ResultSet resultSet = super.PreparedStatement_executeQuery(preparedStatement);
            return resultSet;
        }
        finally {
            this.afterExecute(preparedStatement);
        }
    }

    @Override
    public int PreparedStatement_executeUpdate(DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            if (!this.beforeExecute(preparedStatement, null)) {
                return 0;
            }
            int n2 = super.PreparedStatement_executeUpdate(preparedStatement);
            return n2;
        }
        finally {
            this.afterExecute(preparedStatement);
        }
    }
}

