/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter;

import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSetCachePool2;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.filter.BaseFilter;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ResultSetCacheFilter
extends BaseFilter {
    public static ResultSetCacheFilter getInstance() {
        return new ResultSetCacheFilter();
    }

    @Override
    public ResultSet PreparedStatement_executeQuery(DmdbPreparedStatement preparedStatement) throws SQLException {
        boolean sqlNeedCache = ResultSetCacheFilter.sqlNeedCache(preparedStatement.nativeSql);
        if (!sqlNeedCache) {
            if (this.next != null) {
                return this.next.PreparedStatement_executeQuery(preparedStatement);
            }
            return preparedStatement.do_executeQuery();
        }
        return DmdbResultSetCachePool2.getCachedResultSet(preparedStatement, null);
    }

    @Override
    public boolean PreparedStatement_execute(DmdbPreparedStatement preparedStatement) throws SQLException {
        boolean sqlNeedCache = ResultSetCacheFilter.sqlNeedCache(preparedStatement.nativeSql);
        if (!sqlNeedCache) {
            if (this.next != null) {
                return this.next.PreparedStatement_execute(preparedStatement);
            }
            return preparedStatement.do_execute();
        }
        return DmdbResultSetCachePool2.getCachedResultSet(preparedStatement, null) != null;
    }

    @Override
    public ResultSet Statement_executeQuery(DmdbStatement statement, String sql) throws SQLException {
        boolean sqlNeedCache = ResultSetCacheFilter.sqlNeedCache(sql);
        if (!sqlNeedCache) {
            if (this.next != null) {
                return this.next.Statement_executeQuery(statement, sql);
            }
            return statement.do_executeQuery(sql);
        }
        return DmdbResultSetCachePool2.getCachedResultSet(statement, sql);
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql) throws SQLException {
        boolean sqlNeedCache = ResultSetCacheFilter.sqlNeedCache(sql);
        if (!sqlNeedCache) {
            if (this.next != null) {
                return this.next.Statement_execute(statement, sql);
            }
            return statement.do_execute(sql);
        }
        return DmdbResultSetCachePool2.getCachedResultSet(statement, sql) != null;
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        boolean sqlNeedCache = ResultSetCacheFilter.sqlNeedCache(sql);
        if (!sqlNeedCache) {
            if (this.next != null) {
                return this.next.Statement_execute(statement, sql, autoGeneratedKeys);
            }
            return statement.do_execute(sql, autoGeneratedKeys);
        }
        return DmdbResultSetCachePool2.getCachedResultSet(statement, sql) != null;
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        boolean sqlNeedCache = ResultSetCacheFilter.sqlNeedCache(sql);
        if (!sqlNeedCache) {
            if (this.next != null) {
                return this.next.Statement_execute(statement, sql, columnIndexes);
            }
            return statement.do_execute(sql, columnIndexes);
        }
        return DmdbResultSetCachePool2.getCachedResultSet(statement, sql) != null;
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        boolean sqlNeedCache = ResultSetCacheFilter.sqlNeedCache(sql);
        if (!sqlNeedCache) {
            if (this.next != null) {
                return this.next.Statement_execute(statement, sql, columnNames);
            }
            return statement.do_execute(sql, columnNames);
        }
        return DmdbResultSetCachePool2.getCachedResultSet(statement, sql) != null;
    }

    public static boolean sqlNeedCache(String sql) {
        boolean sqlLengthLimit;
        boolean sqlHasHint = sql.contains("/*jdbcrscache*/");
        boolean sqlWithinList = DmdbResultSetCachePool2.sqlWithinList(sql);
        boolean bl = sqlLengthLimit = sql.length() <= 2000;
        return (sqlHasHint || sqlWithinList) && sqlLengthLimit;
    }
}

