/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SafeLinkedHashMap<K, V> {
    private LinkedHashMap<K, V> map = new LinkedHashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public V put(K key, V value) {
        this.lock.writeLock().lock();
        try {
            V v2 = this.map.put(key, value);
            return v2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public V putIfSizeBelowLimit(K key, V value, int limit) {
        this.lock.writeLock().lock();
        try {
            if (this.map.size() == limit) {
                Iterator<Map.Entry<K, V>> iterator = this.map.entrySet().iterator();
                iterator.next();
                iterator.remove();
            }
            V v2 = this.map.put(key, value);
            return v2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public V get(K key) {
        this.lock.readLock().lock();
        try {
            V v2 = this.map.get(key);
            return v2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.map = new LinkedHashMap();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public V remove(K key) {
        this.lock.writeLock().lock();
        try {
            Object v2 = this.map.remove(key);
            return v2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int size() {
        this.lock.readLock().lock();
        try {
            int n2 = this.map.size();
            return n2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

