/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.Configuration;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbXAException;
import dm.jdbc.filter.Filterable;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogFactory;
import dm.jdbc.filter.log.Logger;
import dm.jdbc.util.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class DmdbXAResource
extends Filterable
implements XAResource {
    protected ILogger LOG = (Logger)LogFactory.getLog(DmdbXAResource.class);
    public static AtomicLong IDGenerator = new AtomicLong(0L);
    public boolean recoverd = false;
    public DmdbConnection conn;
    int m_timeout;
    Xid m_xid;
    private boolean savedAutoCommit;
    private AtomicLong startCount = new AtomicLong(0L);
    public static final int RESTORE_AUTO_COMMIT_TYPE_END = 0;
    public static final int RESTORE_AUTO_COMMIT_TYPE_COMMIT = 1;
    private int restoreAutoCommit = 0;

    public DmdbXAResource(DmdbConnection connection) {
        super(connection, null);
        this.conn = connection;
        this.m_timeout = 60;
        this.restoreAutoCommit = connection.props.getInt(Configuration.xaRestoreAutoCommit);
    }

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = IDGenerator.incrementAndGet();
        }
        return this.ID;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void setRecoverd(boolean recoverd) {
        this.recoverd = recoverd;
    }

    public void checkClosed() throws DmdbXAException {
        if (this.conn == null) {
            DBError.throwXAException(DBError.ECJDBC_CONNECTION_CLOSED.errCode);
        }
        try {
            this.conn.checkClosed();
        }
        catch (SQLException e2) {
            DBError.throwXAException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void do_start(Xid xid, int flags) throws XAException {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            if (xid == null) {
                DBError.throwXAException(-5);
            }
            if (flags != 0 && flags != 0x200000 && flags != 0x8000000) {
                DBError.throwXAException(-5);
            }
            try {
                this.savedAutoCommit();
                this.startCount.incrementAndGet();
                this.conn.dbAccess.a(7, xid, flags);
            }
            catch (XAException e2) {
                this.startCount.decrementAndGet();
                this.restoreAutoCommit();
                throw e2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void do_end(Xid xid, int flags) throws XAException {
        try {
            this.checkClosed();
            DmdbConnection dmdbConnection = this.conn;
            synchronized (dmdbConnection) {
                if (xid == null || flags != 0x4000000 && flags != 0x20000000 && flags != 0x2000000) {
                    DBError.throwXAException(-5);
                }
                this.conn.dbAccess.a(2, xid, flags);
                try {
                    if (StringUtil.isNotEmpty(this.conn.switchToHost)) {
                        this.conn.reconnect();
                    }
                }
                catch (SQLException e2) {
                    DBError.throwXAException(e2);
                }
            }
        }
        finally {
            this.startCount.decrementAndGet();
            if (this.restoreAutoCommit == 0) {
                this.restoreAutoCommit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void do_commit(Xid xid, boolean onePhase) throws XAException {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            int k2;
            int n2 = k2 = onePhase ? 0x40000000 : 0;
            if (xid == null) {
                DBError.throwXAException(-5);
            }
            this.conn.dbAccess.a(1, xid, k2);
            this.conn.do_setTrxFinish(true);
            if (this.restoreAutoCommit == 1) {
                this.startCount.set(0L);
                this.restoreAutoCommit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void do_rollback(Xid xid) throws XAException {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            if (xid == null) {
                DBError.throwXAException(-5);
            }
            this.conn.dbAccess.a(6, xid, 0);
            this.conn.do_setTrxFinish(true);
            if (this.restoreAutoCommit == 1) {
                this.startCount.set(0L);
                this.restoreAutoCommit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void do_forget(Xid xid) throws XAException {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            if (xid == null) {
                DBError.throwXAException(-5);
            }
            this.conn.dbAccess.a(3, xid, 0);
        }
    }

    public boolean do_isSameRM(XAResource xares) throws XAException {
        Connection connection = null;
        if (xares instanceof DmdbXAResource) {
            connection = ((DmdbXAResource)xares).getConnection();
        }
        if (connection == null) {
            return false;
        }
        return connection.equals(this.conn) || ((DmdbConnection)connection).url.equals(this.conn.url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int do_prepare(Xid xid) throws XAException {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            int retcode = 0;
            if (xid == null) {
                DBError.throwXAException(-5);
            }
            if ((retcode = this.conn.dbAccess.a(4, xid, 0)) != 0 && retcode != 3) {
                DBError.throwXAException(retcode);
            }
            return retcode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid[] do_recover(int flag) throws XAException {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            ArrayList<Xid> rec_xids = new ArrayList<Xid>();
            Xid[] xids = null;
            Xid[] tmp = null;
            if (flag != 0x1000000 && flag != 0x800000 && flag != 0 && flag != 0x1800000) {
                DBError.throwXAException(-5);
            }
            this.recoverd = false;
            tmp = this.conn.dbAccess.a(this, 0x1000000);
            if (this.recoverd) {
                return tmp;
            }
            int i2 = 0;
            while (i2 < tmp.length) {
                rec_xids.add(tmp[i2]);
                ++i2;
            }
            do {
                tmp = this.conn.dbAccess.a(this, 0);
                i2 = 0;
                while (i2 < tmp.length) {
                    rec_xids.add(tmp[i2]);
                    ++i2;
                }
            } while (!this.recoverd);
            xids = new Xid[rec_xids.size()];
            xids = (Xid[])rec_xids.toArray();
            return xids;
        }
    }

    public int do_getTransactionTimeout() throws XAException {
        return this.m_timeout;
    }

    public boolean do_setTransactionTimeout(int seconds) throws XAException {
        if (seconds < 0) {
            DBError.throwXAException(-5);
        }
        this.m_timeout = seconds;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void heurCommit(Xid xid) throws XAException {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            if (xid == null) {
                DBError.throwXAException(-5);
            }
            this.conn.dbAccess.a(8, xid, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void heurRollback(Xid xid) throws XAException {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            if (xid == null) {
                DBError.throwXAException(-5);
            }
            this.conn.dbAccess.a(9, xid, 0);
        }
    }

    private void savedAutoCommit() {
        if (this.startCount.longValue() == 0L) {
            this.savedAutoCommit = this.conn.do_getAutoCommit();
            this.LOG.debug((Object)this, "savedAutoCommit", this.savedAutoCommit);
            this.LOG.debug((Object)this, "setAutoCommit", false);
            this.conn.do_setAutoCommit(false);
        }
    }

    private void restoreAutoCommit() {
        if (this.startCount.longValue() == 0L) {
            this.LOG.debug((Object)this, "restoreAutoCommit", this.savedAutoCommit);
            this.conn.do_setAutoCommit(this.savedAutoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Xid xid, int flags) throws XAException {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_start(xid, flags);
            } else {
                this.filterHead.XAResource_start(this, xid, flags);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int flags) throws XAException {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_end(xid, flags);
            } else {
                this.filterHead.XAResource_end(this, xid, flags);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forget(Xid xid) throws XAException {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_forget(xid);
            } else {
                this.filterHead.XAResource_forget(this, xid);
            }
        }
    }

    @Override
    public boolean isSameRM(XAResource xaRes) throws XAException {
        if (this.filterHead == null) {
            return this.do_isSameRM(xaRes);
        }
        return this.filterHead.XAResource_isSameRM(this, xaRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepare(Xid xid) throws XAException {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_prepare(xid);
            }
            return this.filterHead.XAResource_prepare(this, xid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Xid[] recover(int flag) throws XAException {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_recover(flag);
            }
            return this.filterHead.XAResource_recover(this, flag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_commit(xid, onePhase);
            } else {
                this.filterHead.XAResource_commit(this, xid, onePhase);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_rollback(xid);
            } else {
                this.filterHead.XAResource_rollback(this, xid);
            }
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        if (this.filterHead == null) {
            return this.do_getTransactionTimeout();
        }
        return this.filterHead.XAResource_getTransactionTimeout(this);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (this.filterHead == null) {
            return this.do_setTransactionTimeout(seconds);
        }
        return this.filterHead.XAResource_setTransactionTimeout(this, seconds);
    }
}

