/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.internal.convert.DB2J;
import dm.jdbc.internal.desc.ComplexTypeData;
import dm.jdbc.internal.desc.ComplexTypeDesc;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;
import java.util.Set;

public class DmdbStruct
extends ComplexTypeData
implements Struct {
    public ComplexTypeDesc m_strctDesc;
    public ComplexTypeData[] m_attribs;
    public int m_objCount;
    public int m_strCount;
    public Map<String, Object> indexTable;

    public DmdbStruct(ComplexTypeData[] atData, ComplexTypeDesc desc) {
        super(null, null);
        this.m_strctDesc = desc;
        this.m_attribs = atData;
    }

    public ComplexTypeData[] getAttribsTypeData() {
        return this.m_attribs;
    }

    public DmdbStruct(ComplexTypeDesc desc, DmdbConnection conn, Object[] objArr) throws SQLException {
        super(null, null);
        if (desc == null) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        conn.checkClosed();
        this.m_strctDesc = desc;
        if (objArr == null) {
            this.m_attribs = new ComplexTypeData[desc.getSize()];
        } else {
            if (desc.getSize() != objArr.length && desc.getObjId() != 4) {
                DBError.ECJDBC_STRUCT_MEM_NOT_MATCH.throwz(new Object[0]);
            }
            this.m_attribs = ComplexTypeData.toStruct(objArr, this.m_strctDesc);
        }
    }

    public DmdbStruct(ComplexTypeDesc desc, DmdbConnection conn, Map<String, Object> indexTable) throws SQLException {
        super(null, null);
        if (desc == null) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        conn.checkClosed();
        this.m_strctDesc = desc;
        this.indexTable = indexTable;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.m_strctDesc.getFulName();
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        if (this.m_attribs == null && this.indexTable != null) {
            return new Object[]{this.indexTable};
        }
        return this.toJavaArray(this);
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        Object[] objs = this.getAttributes();
        if (map == null || map.size() == 0) {
            return objs;
        }
        int i2 = 0;
        while (i2 < objs.length) {
            if (objs[i2] instanceof Struct) {
                Struct struct = (Struct)objs[i2];
                objs[i2] = DB2J.toSQLData(struct, map);
            }
            ++i2;
        }
        return objs;
    }

    private void checkCol(int col) throws SQLException {
        if (col < 1 || col > this.m_attribs.length) {
            DBError.ECJDBC_INVALID_SEQUENCE_NUMBER.throwz(new Object[0]);
        }
    }

    ComplexTypeData getAttrValue(int col) throws SQLException {
        this.checkCol(col);
        return this.m_attribs[col - 1];
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        try {
            switch (this.getDType()) {
                case 119: {
                    str.append(this.dmClassToString());
                    break;
                }
                case 121: {
                    str.append(this.defualtTostring(false));
                    break;
                }
                default: {
                    this.defualtTostring(true);
                    break;
                }
            }
        }
        catch (Exception exception) {}
        return str.toString();
    }

    private String dmClassToString() throws SQLException {
        StringBuilder str = new StringBuilder();
        if (this.m_strctDesc.getObjId() == 4) {
            str.append(this.getSQLTypeName()).append("(");
            switch (this.m_strctDesc.getCltnType()) {
                case 3: {
                    Set<Map.Entry<String, Object>> entrySet = this.indexTable.entrySet();
                    int size = entrySet.size();
                    int offset = 1;
                    for (Map.Entry<String, Object> entry : entrySet) {
                        str.append("[");
                        str.append(entry);
                        str.append("]");
                        if (offset < size) {
                            str.append(",");
                        }
                        ++offset;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    str.append(this.defualtTostring(true));
                    break;
                }
                default: {
                    DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
                }
            }
            str.append(")");
        } else {
            str.append(this.defualtTostring(true));
        }
        return str.toString();
    }

    private String defualtTostring(boolean appendFulName) throws SQLException {
        StringBuilder str = new StringBuilder();
        if (appendFulName) {
            str.append(this.m_strctDesc.getFulName());
        }
        str.append("(");
        int i2 = 0;
        while (i2 < this.m_attribs.length) {
            Object obj = this.m_attribs[i2].m_dumyData;
            if (obj instanceof byte[]) {
                obj = "0x" + StringUtil.bytesToHexString((byte[])obj);
            }
            if (i2 != 0) {
                str.append(", ");
            }
            str.append(obj);
            ++i2;
        }
        str.append(")");
        return str.toString();
    }

    public int getDType() {
        return this.m_strctDesc.getDType();
    }

    public ComplexTypeDesc getDesc() {
        return this.m_strctDesc;
    }

    public static Struct newInstanceOfLocal(ComplexTypeDesc desc, Object[] attributes) throws SQLException {
        return new DmdbStruct(desc, desc.m_conn, attributes);
    }
}

