/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DBWarning;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbResultSetCachePool;
import dm.jdbc.filter.Filterable;
import dm.jdbc.internal.cache.StmtCacheInfo;
import dm.jdbc.internal.desc.Column;
import dm.jdbc.internal.desc.Const;
import dm.jdbc.internal.desc.ExecuteRetInfo;
import dm.jdbc.internal.parser.SQLParameter;
import dm.jdbc.internal.parser.SQLProcessor;
import dm.jdbc.util.ConvertUtil;
import dm.jdbc.util.StringUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbStatement
extends Filterable
implements Statement {
    public int handle;
    public boolean innerExec = false;
    public String cursorName;
    public boolean readBaseColName;
    public ExecuteRetInfo execInfo = new ExecuteRetInfo();
    public DmdbConnection connection;
    public int resultSetType;
    public int resultSetConcurrency;
    public int resultSetHoldability;
    public String nativeSql;
    public String escapeSql;
    public int maxFieldSize;
    public long maxRows;
    public boolean escapeProcessing;
    public int queryTimeout;
    public int fetchDirection = 1000;
    public int fetchSize;
    public long cursorUpdateRow;
    public boolean closeOnCompletion = false;
    public boolean closed = true;
    public SQLWarning warnings;
    public List<String> batchSqls = null;
    public DmdbResultSet curResultSet;
    public List<DmdbResultSet> openedResultSets = new ArrayList<DmdbResultSet>(3);
    public boolean poolable = true;
    public Column[] columns = new Column[0];
    public int type = 1;
    public static final int STATEMENT = 1;
    public static final int PREPARED_STATEMENT = 2;
    public static final int CALLABLE_STATEMENT = 3;
    public boolean running = false;
    public static AtomicLong IDGenerator = new AtomicLong(0L);
    public boolean clearBatch = true;
    public Map<Integer, DmdbStatement> tempMap = new HashMap<Integer, DmdbStatement>();
    public int sqlType = -1;
    public DmdbPreparedStatement fePreparedStatement;
    public boolean multiRowsError = false;

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = IDGenerator.incrementAndGet();
        }
        return this.ID;
    }

    public DmdbStatement(DmdbConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean fromPool) throws SQLException {
        super(connection, null);
        if (resultSetType == 1005) {
            connection.addSQLWarning(DBWarning.getSQLWarning(DBError.ECJDBC_WARNING_UNSUPPORT_RESULTSET_TYPE));
            resultSetType = 1004;
        }
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.escapeProcessing = connection.escapeProcess;
        this.maxRows = connection.maxRows;
        this.queryTimeout = connection.sessionTimeout;
        this.allocateHandle(fromPool);
    }

    protected void allocateHandle(boolean fromPool) throws SQLException {
        StmtCacheInfo pool;
        StmtCacheInfo stmtCacheInfo = pool = this.connection.stmtPool != null && this.connection.stmtPool.size() > 0 ? this.connection.stmtPool.get() : null;
        if (pool != null && fromPool) {
            this.handle = pool.handle;
            this.cursorName = pool.cursorName;
            this.readBaseColName = pool.readBaseColName;
        } else {
            this.connection.dbAccess.a(this);
            long ttt = this.handle;
            if (this.handle < 0) {
                ttt = 0xFFFFFFFFL & ttt;
            }
            this.cursorName = "DM7CUR" + ttt;
        }
        this.closed = false;
    }

    public boolean do_execute(String sql) throws SQLException {
        return this.do_execute(sql, 2);
    }

    public boolean do_execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.beforeExecute();
            this.executeInner(sql, (short)0, autoGeneratedKeys == 1);
            boolean bl = this.curResultSet != null;
            return bl;
        }
        finally {
            this.afterExecute();
        }
    }

    public boolean do_execute(String sql, int[] columnIndexes) throws SQLException {
        int autoGeneratedKeys = columnIndexes != null && columnIndexes.length > 0 ? 1 : 2;
        return this.do_execute(sql, autoGeneratedKeys);
    }

    public boolean do_execute(String sql, String[] columnNames) throws SQLException {
        int autoGeneratedKeys = columnNames != null && columnNames.length > 0 ? 1 : 2;
        return this.do_execute(sql, autoGeneratedKeys);
    }

    public DmdbResultSet do_executeQuery(String sql) throws SQLException {
        try {
            this.beforeExecute();
            this.executeInner(sql, (short)1, false);
            DmdbResultSet dmdbResultSet = this.curResultSet == null ? DmdbResultSet.newEmptyResultSet(this) : this.curResultSet;
            return dmdbResultSet;
        }
        finally {
            this.afterExecute();
        }
    }

    public int do_executeUpdate(String sql) throws SQLException {
        return this.do_executeUpdate(sql, 2);
    }

    public int do_executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.beforeExecute();
            this.executeInner(sql, (short)2, autoGeneratedKeys == 1);
            int n2 = this.do_getUpdateCount();
            return n2;
        }
        finally {
            this.afterExecute();
        }
    }

    public int do_executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        int autoGeneratedKeys = columnIndexes != null && columnIndexes.length > 0 ? 1 : 2;
        return this.do_executeUpdate(sql, autoGeneratedKeys);
    }

    public int do_executeUpdate(String sql, String[] columnNames) throws SQLException {
        int autoGeneratedKeys = columnNames != null && columnNames.length > 0 ? 1 : 2;
        return this.do_executeUpdate(sql, autoGeneratedKeys);
    }

    public int[] do_executeBatch() throws SQLException {
        try {
            this.beforeExecute();
            if (this.connection.readOnly && !this.connection.compatibleOracle()) {
                DBError.ECJDBC_READ_ONLY_CONNECTION.throwz(new Object[0]);
            }
            if (this.batchSqls != null && this.batchSqls.size() > 0) {
                int count = this.batchSqls.size();
                int[] updateCounts = new int[count];
                ArrayList<String> sqlExList = new ArrayList<String>();
                SQLException e2 = null;
                int i2 = 0;
                while (i2 < count) {
                    e2 = null;
                    try {
                        this.executeInner(this.batchSqls.get(i2), (short)2, false);
                        updateCounts[i2] = ConvertUtil.toInt(this.do_getLargeUpdateCount());
                        if (this.execInfo.hasResultSet) {
                            DBError.ECJDBC_INVALID_SQL_TYPE.throwz(new Object[0]);
                        }
                    }
                    catch (SQLException ex) {
                        updateCounts[i2] = -3;
                        e2 = ex;
                    }
                    if (e2 != null) {
                        if (this.connection.batchContinueOnError) {
                            sqlExList.add("sql[" + i2 + "]:" + e2.getErrorCode() + ", " + e2.getMessage());
                            SQLWarning warning = new SQLWarning("sql[" + i2 + "]:" + e2.getErrorCode() + ", " + e2.getMessage());
                            this.addSQLWarning(warning);
                        } else {
                            int[] newUpdCounts = new int[i2];
                            System.arraycopy(updateCounts, 0, newUpdCounts, 0, i2);
                            DBError.throwBatchUpdateException(e2.getMessage(), e2.getSQLState(), e2.getErrorCode(), newUpdCounts, e2);
                        }
                    }
                    ++i2;
                }
                if (sqlExList.size() > 0) {
                    StringBuilder errMsg = new StringBuilder();
                    for (String temp : sqlExList) {
                        errMsg.append(StringUtil.LINE_SEPARATOR).append(temp);
                    }
                    DBError.throwBatchUpdateException(String.valueOf(DBError.EC_BP_WITH_ERROR.reason) + errMsg.toString(), DBError.EC_BP_WITH_ERROR.sqlState, DBError.EC_BP_WITH_ERROR.errCode, updateCounts, e2);
                }
                int[] nArray = updateCounts;
                return nArray;
            }
            int[] nArray = new int[]{};
            return nArray;
        }
        finally {
            if (this.clearBatch) {
                this.do_clearBatch();
            }
            this.afterExecute();
        }
    }

    public void do_addBatch(String sql) throws SQLException {
        if (StringUtil.isEmpty(sql)) {
            DBError.ECJDBC_SQL_IS_EMPTY.throwz(new Object[0]);
        }
        if (this.batchSqls == null) {
            this.batchSqls = new ArrayList<String>(10);
        }
        this.batchSqls.add(sql);
    }

    public void do_clearBatch() {
        if (this.batchSqls != null && this.batchSqls.size() > 0) {
            this.batchSqls.clear();
        }
    }

    public void do_setPoolable(boolean poolable) {
        this.poolable = poolable;
    }

    public boolean do_isPoolable() {
        return this.poolable;
    }

    public void reconnect(boolean fromPool) throws SQLException {
        this.free();
        this.allocateHandle(fromPool);
    }

    public void do_close() throws SQLException {
        this.do_clearBatch();
        this.do_clearWarnings();
        this.clearResultSets();
        try {
            if (!this.pool()) {
                this.free();
            } else if (this.execInfo.resultSetUnfinish) {
                this.clearStatement();
            }
        }
        finally {
            if (this.connection != null && this.connection.activeStmtList != null) {
                this.connection.activeStmtList.remove(this);
            }
            this.connection = null;
            this.closed = true;
        }
    }

    public boolean pool() {
        if (!this.closed && this.poolable && this.connection.stmtPoolSize > 0) {
            return this.connection.stmtPool.put(new StmtCacheInfo(this.handle, this.cursorName, this.readBaseColName));
        }
        return false;
    }

    public void free() {
        this.clearResultSets();
        try {
            if (!this.closed && this.connection != null && this.connection.dbAccess != null && !this.connection.closed) {
                this.connection.dbAccess.b(this.handle);
            }
        }
        catch (Throwable throwable) {}
        this.closed = true;
    }

    public void clearResultSets() {
        for (DmdbResultSet openResultSet : this.openedResultSets) {
            if (openResultSet == null) continue;
            openResultSet.closed = true;
        }
        this.openedResultSets.clear();
        if (this.curResultSet != null) {
            this.curResultSet.closed = true;
            this.curResultSet = null;
        }
    }

    public void do_clearWarnings() {
        this.warnings = null;
    }

    public void addSQLWarning(SQLWarning warning) {
        if (this.warnings == warning) {
            return;
        }
        if (this.warnings == null) {
            this.warnings = warning;
        } else {
            this.warnings.setNextWarning(warning);
        }
    }

    public void do_cancel() throws SQLException {
        this.checkClosed();
        if (this.running) {
            this.connection.do_reset();
        }
    }

    public void do_setCursorName(String name) throws SQLException {
        if (StringUtil.isEmpty(name)) {
            return;
        }
        this.checkClosed();
        this.connection.dbAccess.a(this, name);
    }

    public DmdbResultSet do_getResultSet() {
        return this.curResultSet;
    }

    public int do_getUpdateCount() {
        if (162 == this.execInfo.retSqlType && this.connection.compatibleOracle11()) {
            return 1;
        }
        if (this.connection.compatibleOracle() && !Const.hasUpdateCount(this.execInfo.retSqlType)) {
            return -1;
        }
        return this.execInfo.hasResultSet ? -1 : ConvertUtil.toInt(this.execInfo.updateCount);
    }

    public boolean do_getMoreResults() throws SQLException {
        return this.do_getMoreResults(this.connection.afterGetMoreResults);
    }

    public void do_setFetchDirection(int direction) throws SQLException {
        if (direction == 1000 || direction == 1001) {
            this.fetchDirection = direction;
        } else if (direction == 1002) {
            this.fetchDirection = 1000;
        } else {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
    }

    public void do_setFetchSize(int rows) throws SQLException {
        if (rows < 0 && rows != Integer.MIN_VALUE || this.maxRows != 0L && this.maxRows != -1L && (long)rows > this.maxRows) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        this.fetchSize = rows;
    }

    public boolean do_getMoreResults(int current) throws SQLException {
        this.checkClosed();
        this.execInfo.updateCount = -1L;
        if (!this.execInfo.hasResultSet || 1 == this.do_getSqlType()) {
            this.afterGetMoreResults(current, this.curResultSet);
            return false;
        }
        DmdbResultSet lastResultSet = this.curResultSet;
        this.curResultSet = null;
        ExecuteRetInfo tmpExecInfo = this.connection.dbAccess.a(this, (short)0);
        this.execInfo.hasResultSet = tmpExecInfo.hasResultSet;
        if (tmpExecInfo.hasResultSet) {
            short rsId = (short)(lastResultSet.id + 1);
            this.curResultSet = new DmdbResultSet(rsId, this, tmpExecInfo);
        }
        this.afterGetMoreResults(current, lastResultSet);
        return tmpExecInfo.hasResultSet;
    }

    private void afterGetMoreResults(int current, DmdbResultSet lastResultSet) throws SQLException {
        switch (current) {
            case 1: {
                if (lastResultSet == null) break;
                lastResultSet.do_close();
                break;
            }
            case 3: {
                DmdbResultSet[] openResults;
                if (lastResultSet != null) {
                    lastResultSet.do_close();
                }
                DmdbResultSet[] dmdbResultSetArray = openResults = this.openedResultSets.toArray(new DmdbResultSet[0]);
                int n2 = openResults.length;
                int n3 = 0;
                while (n3 < n2) {
                    DmdbResultSet openResultSet = dmdbResultSetArray[n3];
                    openResultSet.do_close();
                    ++n3;
                }
                this.openedResultSets.clear();
                break;
            }
            case 2: {
                if (lastResultSet == null) break;
                this.openedResultSets.add(lastResultSet);
                break;
            }
            default: {
                DBError.ECJDBC_UNSUPPORTED_PARAM.throwz(new Object[0]);
            }
        }
    }

    public DmdbResultSet do_getGeneratedKeys() throws SQLException {
        Column[] colInfos = null;
        Object rsDatas = null;
        if (this.connection.compatibleMybatis) {
            this.execInfo.gkColumns = null;
        }
        if (this.execInfo.gkColumns != null) {
            colInfos = this.execInfo.gkColumns;
            rsDatas = (byte[][][])this.execInfo.gkDatas.toArray((T[])new byte[0][][]);
            return DmdbResultSet.newLocalResultSet(this, colInfos, rsDatas);
        }
        colInfos = new Column[]{new Column()};
        colInfos[0].type = 8;
        colInfos[0].prec = 8;
        colInfos[0].scale = 0;
        colInfos[0].typeName = "BIGINT";
        colInfos[0].name = "AUTO_GEN_KEY";
        colInfos[0].nullable = false;
        rsDatas = new byte[0][][];
        return DmdbResultSet.newLocalResultSet(this, colInfos, rsDatas);
    }

    protected void beforeExecute() throws SQLException {
        this.checkClosed();
        this.do_clearWarnings();
        this.clearResultSets();
        this.running = true;
    }

    protected void afterExecute() {
        this.running = false;
    }

    protected void executeInner(String sql, short execType, boolean returnGeneratedKeys) throws SQLException {
        if (StringUtil.isEmpty(sql)) {
            DBError.ECJDBC_SQL_IS_EMPTY.throwz(new Object[0]);
        }
        this.nativeSql = sql;
        if (this.connection.quoteReplace == 1 && !sql.startsWith("/*DMJDBC*/")) {
            try {
                this.nativeSql = SQLProcessor.toMysql(this.nativeSql);
            }
            catch (Exception exception) {}
        }
        if (this.escapeProcessing) {
            try {
                this.escapeSql = this.nativeSql = this.connection.do_nativeSQL(this.nativeSql);
            }
            catch (Exception exception) {}
        }
        LinkedList<SQLParameter> optParamList = null;
        if (this.connection.constParaOpt) {
            optParamList = new LinkedList<SQLParameter>();
            LinkedHashMap<Integer, Integer> indexMap = new LinkedHashMap<Integer, Integer>();
            try {
                this.nativeSql = SQLProcessor.execOpt(this.nativeSql, optParamList, this.connection.getServerEncoding(), false, this.connection.backSlashFlag, indexMap);
            }
            catch (Exception exception) {}
        }
        if (this.findResultCache(this.nativeSql)) {
            return;
        }
        if (optParamList != null && optParamList.size() > 0) {
            try {
                this.execInfo = this.connection.dbAccess.a(this, returnGeneratedKeys, optParamList, (int)execType);
            }
            catch (SQLException e2) {
                if (DBError.ECJDBC_COMMUNITION_ERROR.errCode == e2.getErrorCode() || DBError.EC_RN_OPERATION_CANCELED.errCode == e2.getErrorCode() || DBError.EC_EXCEED_SESSION_REQUEST_LIMIT.errCode == e2.getErrorCode()) {
                    throw e2;
                }
                this.nativeSql = this.escapeProcessing ? this.escapeSql : sql;
                this.execInfo = this.connection.dbAccess.a(this, execType, returnGeneratedKeys);
            }
        } else {
            this.execInfo = this.connection.dbAccess.a(this, execType, returnGeneratedKeys);
        }
        if (this.execInfo.hasResultSet) {
            this.curResultSet = this.createAndCacheResultSet((short)1, this.execInfo);
        }
        if (this.connection.checkExecType && execType == 2 && this.curResultSet != null) {
            DBError.ECJDBC_INVALID_SQL_TYPE.throwz(new Object[0]);
        }
    }

    public DmdbResultSet do_executeQueryWithConst(String sql, List<SQLParameter> constParamList) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            DmdbResultSet dmdbResultSet;
            try {
                this.beforeExecute();
                if (StringUtil.isEmpty(sql)) {
                    DBError.ECJDBC_SQL_IS_EMPTY.throwz(new Object[0]);
                }
                this.nativeSql = sql;
                if (!this.findResultCache(this.nativeSql)) {
                    this.execInfo = this.connection.dbAccess.a(this, false, constParamList, 1);
                    if (this.execInfo.hasResultSet) {
                        this.curResultSet = this.createAndCacheResultSet((short)1, this.execInfo);
                    }
                }
                dmdbResultSet = this.curResultSet == null ? DmdbResultSet.newEmptyResultSet(this) : this.curResultSet;
                this.afterExecute();
            }
            catch (Throwable throwable) {
                this.afterExecute();
                throw throwable;
            }
            return dmdbResultSet;
        }
    }

    protected boolean findResultCache(String sql) throws SQLException {
        DmdbResultSetCache rsCache;
        if (this.connection.enRsCache && (rsCache = DmdbResultSetCachePool.getResultSetCache(this.connection.guid, this.connection.schema, sql, this)) != null) {
            this.curResultSet = rsCache.getResultSet(this);
            this.execInfo = rsCache.execInfo;
            return true;
        }
        return false;
    }

    protected DmdbResultSet createAndCacheResultSet(short rsID, ExecuteRetInfo execInfo) throws SQLException {
        if (this.connection.enRsCache && execInfo.rsCacheOffset > 0 && execInfo.rsDatas != null && (long)execInfo.rsDatas.length == execInfo.updateCount) {
            DmdbResultSetCachePool.addResultSet(this, this.nativeSql, execInfo);
        }
        return new DmdbResultSet(rsID, this, execInfo);
    }

    public void checkClosed() throws SQLException {
        if (this.connection == null || this.do_isClosed()) {
            DBError.ECJDBC_STATEMENT_HANDLE_CLOSED.throwz(new Object[0]);
        }
        this.connection.checkClosed();
    }

    public int do_getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public void do_setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        this.maxFieldSize = max;
    }

    public int do_getMaxRows() {
        return ConvertUtil.toInt(this.maxRows);
    }

    public void do_setMaxRows(int max) throws SQLException {
        if (max < 0) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        this.maxRows = max;
    }

    public void do_setEscapeProcessing(boolean enable) {
        this.escapeProcessing = enable;
    }

    public int do_getQueryTimeout() {
        return this.queryTimeout;
    }

    public void do_setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        this.queryTimeout = seconds;
    }

    public SQLWarning do_getWarnings() {
        return this.warnings;
    }

    public int do_getFetchDirection() {
        return this.fetchDirection;
    }

    public int do_getFetchSize() {
        return this.fetchSize;
    }

    public int do_getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public int do_getResultSetType() {
        return this.resultSetType;
    }

    public DmdbConnection do_getConnection() {
        return this.connection;
    }

    public int do_getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public boolean do_isClosed() {
        return this.closed;
    }

    public void do_closeOnCompletion() {
        this.closeOnCompletion = true;
    }

    public boolean do_isCloseOnCompletion() {
        return this.closeOnCompletion;
    }

    public long do_getLargeUpdateCount() {
        return this.execInfo.hasResultSet ? -1L : this.execInfo.updateCount;
    }

    public void do_setLargeMaxRows(long max) throws SQLException {
        if (max < 0L) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        this.maxRows = max;
    }

    public long do_getLargeMaxRows() {
        return this.maxRows;
    }

    public long[] do_executeLargeBatch() throws SQLException {
        long[] retUpdateCounts;
        block14: {
            retUpdateCounts = new long[]{};
            try {
                this.beforeExecute();
                if (this.connection.readOnly && !this.connection.compatibleOracle()) {
                    DBError.ECJDBC_READ_ONLY_CONNECTION.throwz(new Object[0]);
                }
                if (this.batchSqls == null || this.batchSqls.size() <= 0) break block14;
                int count = this.batchSqls.size();
                long[] updateCounts = new long[count];
                ArrayList<String> sqlExList = new ArrayList<String>();
                SQLException e2 = null;
                int i2 = 0;
                while (i2 < count) {
                    e2 = null;
                    try {
                        this.executeInner(this.batchSqls.get(i2), (short)2, false);
                        updateCounts[i2] = this.do_getLargeUpdateCount();
                        if (this.execInfo.hasResultSet) {
                            DBError.ECJDBC_INVALID_SQL_TYPE.throwz(new Object[0]);
                        }
                    }
                    catch (SQLException ex) {
                        updateCounts[i2] = -3L;
                        e2 = ex;
                    }
                    if (e2 != null) {
                        if (this.connection.batchContinueOnError) {
                            sqlExList.add("sql[" + i2 + "]:" + e2.getErrorCode() + ", " + e2.getMessage());
                            SQLWarning warning = new SQLWarning("sql[" + i2 + "]:" + e2.getErrorCode() + ", " + e2.getMessage());
                            this.addSQLWarning(warning);
                        } else {
                            long[] newUpdCounts = new long[i2];
                            System.arraycopy(updateCounts, 0, newUpdCounts, 0, i2);
                            DBError.throwBatchUpdateException(e2.getMessage(), e2.getSQLState(), e2.getErrorCode(), newUpdCounts, e2);
                        }
                    }
                    ++i2;
                }
                if (sqlExList.size() > 0) {
                    StringBuilder errMsg = new StringBuilder();
                    for (String temp : sqlExList) {
                        errMsg.append(StringUtil.LINE_SEPARATOR).append(temp);
                    }
                    DBError.throwBatchUpdateException(String.valueOf(DBError.EC_BP_WITH_ERROR.reason) + errMsg.toString(), DBError.EC_BP_WITH_ERROR.sqlState, DBError.EC_BP_WITH_ERROR.errCode, updateCounts, e2);
                }
                retUpdateCounts = updateCounts;
            }
            finally {
                if (this.clearBatch) {
                    this.do_clearBatch();
                }
                this.afterExecute();
            }
        }
        return retUpdateCounts;
    }

    public long do_executeLargeUpdate(String sql) throws SQLException {
        return this.do_executeLargeUpdate(sql, 2);
    }

    public long do_executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.beforeExecute();
            this.executeInner(sql, (short)2, autoGeneratedKeys == 1);
            long l2 = this.do_getLargeUpdateCount();
            return l2;
        }
        finally {
            this.afterExecute();
        }
    }

    public long do_executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        int autoGeneratedKeys = columnIndexes != null && columnIndexes.length > 0 ? 1 : 2;
        return this.do_executeLargeUpdate(sql, autoGeneratedKeys);
    }

    public long do_executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        int autoGeneratedKeys = columnNames != null && columnNames.length > 0 ? 1 : 2;
        return this.do_executeLargeUpdate(sql, autoGeneratedKeys);
    }

    protected void checkConnection() throws SQLException {
        if (this.connection == null) {
            DBError.ECJDBC_CONNECTION_CLOSED.throwz(new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_executeQuery(sql);
            }
            return this.filterHead.Statement_executeQuery(this, sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int executeUpdate(String sql) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_executeUpdate(sql);
            }
            return this.filterHead.Statement_executeUpdate(this, sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void close() throws SQLException {
        if (this.connection == null) {
            return;
        }
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_close();
            } else {
                this.filterHead.Statement_close(this);
            }
        }
    }

    @Override
    @Deprecated
    public int getMaxFieldSize() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getMaxFieldSize();
        }
        return this.filterHead.Statement_getMaxFieldSize(this);
    }

    @Override
    @Deprecated
    public void setMaxFieldSize(int max) throws SQLException {
        if (this.filterHead == null) {
            this.do_setMaxFieldSize(max);
        } else {
            this.filterHead.Statement_setMaxFieldSize(this, max);
        }
    }

    @Override
    @Deprecated
    public int getMaxRows() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getMaxRows();
        }
        return this.filterHead.Statement_getMaxRows(this);
    }

    @Override
    @Deprecated
    public void setMaxRows(int max) throws SQLException {
        if (this.filterHead == null) {
            this.do_setMaxRows(max);
        } else {
            this.filterHead.Statement_setMaxRows(this, max);
        }
    }

    @Override
    @Deprecated
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (this.filterHead == null) {
            this.do_setEscapeProcessing(enable);
        } else {
            this.filterHead.Statement_setEscapeProcessing(this, enable);
        }
    }

    @Override
    @Deprecated
    public int getQueryTimeout() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getQueryTimeout();
        }
        return this.filterHead.Statement_getQueryTimeout(this);
    }

    @Override
    @Deprecated
    public void setQueryTimeout(int seconds) throws SQLException {
        if (this.filterHead == null) {
            this.do_setQueryTimeout(seconds);
        } else {
            this.filterHead.Statement_setQueryTimeout(this, seconds);
        }
    }

    @Override
    @Deprecated
    public void cancel() throws SQLException {
        if (this.filterHead == null) {
            this.do_cancel();
        } else {
            this.filterHead.Statement_cancel(this);
        }
    }

    @Override
    @Deprecated
    public SQLWarning getWarnings() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getWarnings();
        }
        return this.filterHead.Statement_getWarnings(this);
    }

    @Override
    @Deprecated
    public void clearWarnings() throws SQLException {
        if (this.filterHead == null) {
            this.do_clearWarnings();
        } else {
            this.filterHead.Statement_clearWarnings(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setCursorName(String name) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_setCursorName(name);
            } else {
                this.filterHead.Statement_setCursorName(this, name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean execute(String sql) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_execute(sql);
            }
            return this.filterHead.Statement_execute(this, sql);
        }
    }

    @Override
    @Deprecated
    public ResultSet getResultSet() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getResultSet();
        }
        return this.filterHead.Statement_getResultSet(this);
    }

    @Override
    @Deprecated
    public int getUpdateCount() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getUpdateCount();
        }
        return this.filterHead.Statement_getUpdateCount(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean getMoreResults() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_getMoreResults();
            }
            return this.filterHead.Statement_getMoreResults(this);
        }
    }

    @Override
    @Deprecated
    public void setFetchDirection(int direction) throws SQLException {
        if (this.filterHead == null) {
            this.do_setFetchDirection(direction);
        } else {
            this.filterHead.Statement_setFetchDirection(this, direction);
        }
    }

    @Override
    @Deprecated
    public int getFetchDirection() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getFetchDirection();
        }
        return this.filterHead.Statement_getFetchDirection(this);
    }

    @Override
    @Deprecated
    public void setFetchSize(int rows) throws SQLException {
        if (this.filterHead == null) {
            this.do_setFetchSize(rows);
        } else {
            this.filterHead.Statement_setFetchSize(this, rows);
        }
    }

    @Override
    @Deprecated
    public int getFetchSize() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getFetchSize();
        }
        return this.filterHead.Statement_getFetchSize(this);
    }

    @Override
    @Deprecated
    public int getResultSetConcurrency() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getResultSetConcurrency();
        }
        return this.filterHead.Statement_getResultSetConcurrency(this);
    }

    @Override
    @Deprecated
    public int getResultSetType() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getResultSetType();
        }
        return this.filterHead.Statement_getResultSetType(this);
    }

    @Override
    @Deprecated
    public void addBatch(String sql) throws SQLException {
        if (this.filterHead == null) {
            this.do_addBatch(sql);
        } else {
            this.filterHead.Statement_addBatch(this, sql);
        }
    }

    @Override
    @Deprecated
    public void clearBatch() throws SQLException {
        if (this.filterHead == null) {
            this.do_clearBatch();
        } else {
            this.filterHead.Statement_clearBatch(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int[] executeBatch() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_executeBatch();
            }
            return this.filterHead.Statement_executeBatch(this);
        }
    }

    @Override
    @Deprecated
    public Connection getConnection() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getConnection();
        }
        return this.filterHead.Statement_getConnection(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean getMoreResults(int current) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_getMoreResults(current);
            }
            return this.filterHead.Statement_getMoreResults(this, current);
        }
    }

    @Override
    @Deprecated
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getGeneratedKeys();
        }
        return this.filterHead.Statement_getGeneratedKeys(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_executeUpdate(sql, autoGeneratedKeys);
            }
            return this.filterHead.Statement_executeUpdate(this, sql, autoGeneratedKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_executeUpdate(sql, columnIndexes);
            }
            return this.filterHead.Statement_executeUpdate(this, sql, columnIndexes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_executeUpdate(sql, columnNames);
            }
            return this.filterHead.Statement_executeUpdate(this, sql, columnNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_execute(sql, autoGeneratedKeys);
            }
            return this.filterHead.Statement_execute(this, sql, autoGeneratedKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_execute(sql, columnIndexes);
            }
            return this.filterHead.Statement_execute(this, sql, columnIndexes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_execute(sql, columnNames);
            }
            return this.filterHead.Statement_execute(this, sql, columnNames);
        }
    }

    @Override
    @Deprecated
    public int getResultSetHoldability() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getResultSetHoldability();
        }
        return this.filterHead.Statement_getResultSetHoldability(this);
    }

    @Override
    @Deprecated
    public boolean isClosed() throws SQLException {
        if (this.filterHead == null) {
            return this.do_isClosed();
        }
        return this.filterHead.Statement_isClosed(this);
    }

    @Override
    @Deprecated
    public void setPoolable(boolean poolable) throws SQLException {
        if (this.filterHead == null) {
            this.do_setPoolable(poolable);
        } else {
            this.filterHead.Statement_setPoolable(this, poolable);
        }
    }

    @Override
    @Deprecated
    public boolean isPoolable() throws SQLException {
        if (this.filterHead == null) {
            return this.do_isPoolable();
        }
        return this.filterHead.Statement_isPoolable(this);
    }

    @Override
    @Deprecated
    public void closeOnCompletion() throws SQLException {
        if (this.filterHead == null) {
            this.do_closeOnCompletion();
        } else {
            this.filterHead.Statement_closeOnCompletion(this);
        }
    }

    @Override
    @Deprecated
    public boolean isCloseOnCompletion() throws SQLException {
        if (this.filterHead == null) {
            return this.do_isCloseOnCompletion();
        }
        return this.filterHead.Statement_isCloseOnCompletion(this);
    }

    @Override
    @Deprecated
    public long getLargeUpdateCount() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getLargeUpdateCount();
        }
        return this.filterHead.Statement_getLargeUpdateCount(this);
    }

    @Override
    @Deprecated
    public void setLargeMaxRows(long max) throws SQLException {
        if (this.filterHead == null) {
            this.do_setLargeMaxRows(max);
        } else {
            this.filterHead.Statement_setLargeMaxRows(this, max);
        }
    }

    @Override
    @Deprecated
    public long getLargeMaxRows() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getLargeMaxRows();
        }
        return this.filterHead.Statement_getLargeMaxRows(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public long[] executeLargeBatch() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_executeLargeBatch();
            }
            return this.filterHead.Statement_executeLargeBatch(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public long executeLargeUpdate(String sql) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_executeLargeUpdate(sql);
            }
            return this.filterHead.Statement_executeLargeUpdate(this, sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_executeLargeUpdate(sql, autoGeneratedKeys);
            }
            return this.filterHead.Statement_executeLargeUpdate(this, sql, autoGeneratedKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_executeLargeUpdate(sql, columnIndexes);
            }
            return this.filterHead.Statement_executeLargeUpdate(this, sql, columnIndexes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_executeLargeUpdate(sql, columnNames);
            }
            return this.filterHead.Statement_executeLargeUpdate(this, sql, columnNames);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public RowId getRowId() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getRowId();
        }
        return this.filterHead.Statement_getRowId(this);
    }

    public RowId do_getRowId() {
        return this.execInfo != null ? this.execInfo.rowid : null;
    }

    public ResultSet[] getResultSets() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getResultSets();
        }
        return this.filterHead.Statement_getResultSets(this);
    }

    public ResultSet[] do_getResultSets() {
        return this.openedResultSets != null ? this.openedResultSets.toArray(new ResultSet[0]) : new ResultSet[]{};
    }

    public String getPrintMsg() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getPrintMsg();
        }
        return this.filterHead.Statement_getPrintMsg(this);
    }

    public String do_getPrintMsg() {
        return this.execInfo != null ? this.execInfo.printMsg : "";
    }

    public String getExplain() {
        if (this.filterHead == null) {
            return this.do_getExplain();
        }
        return this.filterHead.Statement_getExplain(this);
    }

    public String do_getExplain() {
        return this.execInfo != null ? this.execInfo.explain : "";
    }

    @Deprecated
    public long getExecuteId() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getExecuteId();
        }
        return this.filterHead.Statement_getExecuteId(this);
    }

    public long do_getExecuteId() {
        return this.execInfo != null ? this.execInfo.execId : -1L;
    }

    public int getSqlType() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getSqlType();
        }
        return this.filterHead.Statement_getSqlType(this);
    }

    public int do_getSqlType() throws SQLException {
        int sqlType;
        short retType = this.execInfo.retSqlType;
        switch (retType) {
            case 162: 
            case 178: {
                sqlType = 3;
                break;
            }
            case 160: {
                sqlType = 1;
                break;
            }
            case 152: {
                sqlType = 4;
                break;
            }
            default: {
                sqlType = 2;
            }
        }
        return sqlType;
    }

    public int getRetType() {
        return this.execInfo != null ? (int)this.execInfo.retSqlType : 0;
    }

    public void clearStatement() throws SQLException {
        this.connection.dbAccess.c(this.handle);
    }

    public void resetParams(DmdbStatement srcStmt) throws SQLException {
        if (srcStmt.batchSqls != null && srcStmt.batchSqls.size() > 0) {
            this.batchSqls = this.batchSqls == null ? new ArrayList() : this.batchSqls;
            this.batchSqls.clear();
            this.batchSqls.addAll(srcStmt.batchSqls);
        }
    }
}

