/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbCachedData;
import dm.jdbc.driver.DmdbCachedResultSet;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.SafeLinkedHashMap;
import dm.jdbc.internal.conf.DmSvcConf;
import dm.jdbc.internal.convert.OffRowData;
import dm.jdbc.internal.desc.ExecuteRetInfo;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;

public class DmdbResultSetCachePool2 {
    public static final ConcurrentHashMap<String, SafeLinkedHashMap<String, DmdbCachedData>> CACHED_SQL = new ConcurrentHashMap();
    public static final HashSet<String> SQL_LIST = new HashSet();

    public static void setSqlList(ArrayList<String> sqlList) {
        for (String sql : sqlList) {
            SQL_LIST.add(StringUtil.endWithSemicolon(sql));
        }
    }

    public static boolean isSqlListEmpty() {
        return SQL_LIST.isEmpty();
    }

    public static boolean sqlWithinList(String sql) {
        return SQL_LIST.contains(StringUtil.endWithSemicolon(sql));
    }

    public static DmdbCachedResultSet getCachedResultSet(DmdbStatement statement, String sql) throws SQLException {
        String paraKey;
        DmdbCachedData cachedData;
        DmdbConnection connection = statement.connection;
        String sqlKey = statement.nativeSql == null ? sql : String.valueOf(statement.nativeSql) + connection.uniqueKey;
        SafeLinkedHashMap<String, DmdbCachedData> cachedPara = CACHED_SQL.get(sqlKey);
        if (cachedPara == null) {
            cachedPara = new SafeLinkedHashMap();
            CACHED_SQL.put(sqlKey, cachedPara);
        }
        if (!DmdbResultSetCachePool2.cachedDataIsValid(cachedData = cachedPara.get(paraKey = DmdbResultSetCachePool2.getParaKey(statement)))) {
            ArrayList<byte[][][]> datas = new ArrayList<byte[][][]>();
            DmdbResultSet resultSet = null;
            if (statement instanceof DmdbPreparedStatement) {
                resultSet = sql == null ? ((DmdbPreparedStatement)statement).do_executeQuery() : statement.do_executeQuery(sql);
            } else if (statement.getClass().equals(DmdbStatement.class)) {
                resultSet = statement.do_executeQuery(sql);
            } else {
                DBError.throwException(String.valueOf(statement.getClass().getSimpleName()) + "\u5bf9\u8c61\u4e0d\u652f\u6301\u7ed3\u679c\u96c6\u7f13\u5b58");
            }
            long count = 0L;
            ExecuteRetInfo execInfo = statement.execInfo;
            while (execInfo.rsDatas != null) {
                datas.add(execInfo.rsDatas);
                if ((count += (long)execInfo.rsDatas.length) == execInfo.updateCount) break;
                execInfo = connection.dbAccess.a(resultSet, count);
            }
            cachedData = new DmdbCachedData(datas);
            cachedPara.putIfSizeBelowLimit(paraKey, cachedData, DmSvcConf.GLOBAL.rsCacheLimit);
        }
        statement.curResultSet = DmdbCachedResultSet.newLocalResultSet(statement, cachedData.dataList);
        return (DmdbCachedResultSet)statement.curResultSet;
    }

    public static String getParaKey(DmdbStatement statement) throws SQLException {
        if (statement instanceof DmdbPreparedStatement) {
            Object[] paraDatas = ((DmdbPreparedStatement)statement).curRowDatas;
            if (paraDatas == null || paraDatas.length == 0) {
                return "default";
            }
            StringBuilder para = new StringBuilder();
            Object[] objectArray = paraDatas;
            int n2 = paraDatas.length;
            int n3 = 0;
            while (n3 < n2) {
                Object paraData = objectArray[n3];
                if (paraData instanceof OffRowData) {
                    DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
                }
                para.append(ByteUtil.toString((byte[])paraData, statement.connection.getServerEncoding())).append(" ");
                ++n3;
            }
            return para.toString();
        }
        return "default";
    }

    public static boolean cachedDataIsValid(DmdbCachedData cachedData) throws SQLException {
        return cachedData != null && !DmdbResultSetCachePool2.cachedDataExpired(cachedData);
    }

    public static boolean cachedDataExpired(DmdbCachedData cachedData) throws SQLException {
        switch (DmSvcConf.GLOBAL.rsCacheTimeoutUnit) {
            case 0: {
                return System.currentTimeMillis() - cachedData.generatedTime > (long)DmSvcConf.GLOBAL.rsCacheTimeout * 1000L;
            }
            case 1: {
                return System.currentTimeMillis() - cachedData.generatedTime > (long)DmSvcConf.GLOBAL.rsCacheTimeout * 1000L * 60L;
            }
            case 2: {
                return System.currentTimeMillis() - cachedData.generatedTime > (long)DmSvcConf.GLOBAL.rsCacheTimeout * 1000L * 60L * 60L;
            }
        }
        DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        return true;
    }
}

