/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbBFile;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbNumeric;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbSQLOutput;
import dm.jdbc.driver.DmdbSQLXML;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbStruct;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.internal.AbstractLob;
import dm.jdbc.internal.cache.PStmtCacheInfo;
import dm.jdbc.internal.convert.J2DB;
import dm.jdbc.internal.convert.OffRowData;
import dm.jdbc.internal.desc.Column;
import dm.jdbc.internal.desc.ComplexTypeDesc;
import dm.jdbc.internal.desc.ExecuteRetInfo;
import dm.jdbc.internal.desc.Parameter;
import dm.jdbc.internal.parser.FeSQLParameter;
import dm.jdbc.internal.parser.SQLParameter;
import dm.jdbc.internal.parser.SQLProcessor;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.CallBack;
import dm.jdbc.util.ConvertUtil;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.MathUtil;
import dm.jdbc.util.MiscUtil;
import dm.jdbc.util.StringUtil;
import dm.jdbc.util.flow.Flows;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Flow;

public class DmdbPreparedStatement
extends DmdbStatement
implements PreparedStatement {
    public Parameter[] serverParameters = new Parameter[0];
    public Parameter[] bindParameters = new Parameter[0];
    public int paramCount = 0;
    public int irow = 0;
    public Object[] curRowDatas = null;
    public boolean fromObject = false;
    private String originalSql;
    public List<Object[]> multiRowDatas = new ArrayList<Object[]>();
    public TreeSet<DmdbConnection> toBeLockedConnections = new TreeSet<DmdbConnection>(new Comparator<DmdbConnection>(){

        @Override
        public int compare(DmdbConnection o1, DmdbConnection o2) {
            return MathUtil.compare(o1.getID(), o2.getID());
        }
    });
    public int autoGeneratedKeys = 2;
    public int[] gkColumnIndexes;
    public String[] gkColumnNames;
    public String[] generateKeyColumnNames = null;
    public boolean hasPrepared = false;
    public boolean preExec = false;
    public boolean executeError;
    public PStmtCacheInfo poolInfo;
    private LinkedList<SQLParameter> constParamList;

    protected DmdbPreparedStatement(DmdbConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean fromPool) throws SQLException {
        super(connection, resultSetType, resultSetConcurrency, resultSetHoldability, fromPool);
    }

    protected DmdbPreparedStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, boolean fromPool) throws SQLException {
        super(connection, resultSetType, resultSetConcurrency, resultSetHoldability, fromPool);
        this.type = 2;
        this.autoGeneratedKeys = autoGeneratedKeys;
        this.allocateHandle(fromPool, sql);
    }

    public DmdbPreparedStatement(DmdbConnection connection, String sql, int autoGeneratedKeys, boolean fromPool) throws SQLException {
        this(connection, sql, connection.resultSetType, 1007, connection.resultSetHoldability, autoGeneratedKeys, fromPool);
    }

    public DmdbPreparedStatement(DmdbConnection connection, String sql, int[] columnIndexes, boolean fromPool) throws SQLException {
        super(connection, connection.resultSetType, 1007, connection.resultSetHoldability, fromPool);
        if (columnIndexes != null && columnIndexes.length > 0) {
            this.autoGeneratedKeys = 1;
            this.gkColumnIndexes = columnIndexes;
        } else {
            this.autoGeneratedKeys = 2;
        }
        this.allocateHandle(fromPool, sql);
    }

    public DmdbPreparedStatement(DmdbConnection connection, String sql, String[] columnNames, boolean fromPool) throws SQLException {
        super(connection, connection.resultSetType, 1007, connection.resultSetHoldability, fromPool);
        if (columnNames != null && columnNames.length > 0) {
            this.autoGeneratedKeys = 1;
            this.gkColumnNames = columnNames;
        } else {
            this.autoGeneratedKeys = 2;
        }
        this.allocateHandle(fromPool, sql);
    }

    public DmdbPreparedStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean fromPool) throws SQLException {
        this(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, 2, fromPool);
    }

    @Override
    protected void allocateHandle(boolean fromPool) throws SQLException {
    }

    protected void allocateHandle(boolean fromPool, String sql) throws SQLException {
        try {
            if (this.escapeProcessing) {
                sql = this.connection.do_nativeSQL(sql);
            }
        }
        catch (Exception exception) {}
        PStmtCacheInfo pStmtCacheInfo = this.poolInfo = this.connection.pstmtPool != null && this.connection.pstmtPool.size() > 0 ? this.connection.pstmtPool.get(sql) : null;
        if (this.poolInfo != null) {
            this.handle = this.poolInfo.handle;
            this.cursorName = this.poolInfo.cursorName;
            this.readBaseColName = this.poolInfo.readBaseColName;
            this.nativeSql = sql;
            this.serverParameters = this.poolInfo.params;
            this.paramCount = this.poolInfo.paramCount;
            this.irow = 0;
            this.multiRowDatas = new ArrayList<Object[]>();
            this.curRowDatas = new Object[this.poolInfo.paramCount];
            this.execInfo = this.poolInfo.execInfo;
            this.closed = false;
            if (this.poolInfo.columns != null) {
                this.columns = this.poolInfo.columns;
            }
        } else {
            super.allocateHandle(fromPool);
            try {
                this.prepareSql(sql);
            }
            catch (SQLException e2) {
                this.free();
                throw e2;
            }
        }
        this.curRowDatas = new Object[this.paramCount];
        this.bindParameters = new Parameter[this.paramCount];
        int i2 = 0;
        while (i2 < this.paramCount) {
            this.bindParameters[i2] = new Parameter();
            ++i2;
        }
        this.toBeLockedConnections.clear();
    }

    protected void prepareSql(String sql) throws SQLException {
        block15: {
            if (StringUtil.isEmpty(sql)) {
                DBError.ECJDBC_SQL_IS_EMPTY.throwz(new Object[0]);
            }
            this.originalSql = sql;
            this.nativeSql = sql;
            if (this.connection.quoteReplace == 1) {
                try {
                    this.nativeSql = SQLProcessor.toMysql(this.nativeSql);
                }
                catch (Exception exception) {}
            }
            try {
                if (!this.connection.prepareOptimize || this.nativeSql.startsWith("/*DMJDBC*/")) break block15;
                if (this.connection.constParaOpt) {
                    try {
                        this.constParamList = new LinkedList();
                        this.indexMap = new LinkedHashMap();
                        this.nativeSql = SQLProcessor.execOpt(this.nativeSql, this.constParamList, this.connection.getServerEncoding(), true, this.connection.backSlashFlag, this.indexMap);
                        if (!this.originalSql.equals(this.nativeSql)) {
                            if (this.indexMap.isEmpty()) {
                                this.paramCount = 0;
                            } else {
                                this.paramCount = this.indexMap.size() + this.constParamList.size();
                                if (!this.constParamList.isEmpty()) {
                                    this.do_prepareSql();
                                }
                            }
                        } else {
                            this.indexMap = null;
                            this.constParamList = null;
                        }
                    }
                    catch (Exception exception) {
                        this.nativeSql = this.originalSql;
                        this.indexMap = null;
                        this.constParamList = null;
                        this.do_prepareSql();
                        return;
                    }
                }
                if ((this.constParamList == null || this.constParamList.size() == 0) && this.paramCount == 0) {
                    this.paramCount = SQLProcessor.getParameterCount(this.nativeSql);
                }
                this.serverParameters = new Parameter[this.paramCount];
                this.hasPrepared = false;
                return;
            }
            catch (Exception exception) {}
        }
        this.do_prepareSql();
    }

    private void do_prepareSql() throws SQLException {
        this.execInfo = this.connection.dbAccess.a(this);
        this.serverParameters = this.execInfo.serverParameters;
        this.paramCount = this.serverParameters.length;
        this.hasPrepared = true;
    }

    @Override
    public boolean do_execute(String sql, int autoGeneratedKeys) throws SQLException {
        return super.do_execute(sql, autoGeneratedKeys);
    }

    @Override
    public void do_close() throws SQLException {
        Parameter param;
        int n2;
        int n3;
        Parameter[] parameterArray;
        this.do_clearParameters();
        if (this.serverParameters != null) {
            parameterArray = this.serverParameters;
            n3 = this.serverParameters.length;
            n2 = 0;
            while (n2 < n3) {
                param = parameterArray[n2];
                MiscUtil.close(param);
                ++n2;
            }
        }
        if (this.bindParameters != null) {
            parameterArray = this.bindParameters;
            n3 = this.bindParameters.length;
            n2 = 0;
            while (n2 < n3) {
                param = parameterArray[n2];
                MiscUtil.close(param);
                ++n2;
            }
        }
        this.indexMap = null;
        super.do_close();
    }

    @Override
    public boolean pool() {
        if (!this.closed && this.poolable && !this.executeError && this.connection.pstmtPoolSize > 0) {
            this.connection.pstmtPool.put(this.nativeSql, this.poolInfo != null ? this.poolInfo : new PStmtCacheInfo(this.handle, this.cursorName, this.readBaseColName, this.nativeSql, this.serverParameters, this.execInfo, this.columns));
            return true;
        }
        return super.pool();
    }

    @Override
    public void reconnect(boolean fromPool) throws SQLException {
        Object[] curRowDatas = this.curRowDatas;
        Parameter[] bindParameters = this.bindParameters;
        super.reconnect(fromPool);
        this.allocateHandle(fromPool, this.nativeSql);
        this.curRowDatas = curRowDatas;
        this.bindParameters = bindParameters;
    }

    protected void checkBindParameters() throws SQLException {
        int iparam = 0;
        while (iparam < this.paramCount) {
            if (this.bindParameters[iparam].ioType == -1) {
                if (this.serverParameters[iparam] != null && this.serverParameters[iparam].ioType == 1) {
                    this.do_setNull(iparam + 1, 0);
                } else {
                    DBError.ECJDBC_UNBINDED_PARAMETER.throwz(iparam);
                }
            }
            if (this.bindParameters[iparam].type == 120) {
                this.bindParameters[iparam].ioType = (byte)2;
            } else if (this.serverParameters[iparam] != null && this.serverParameters[iparam].ioType != this.bindParameters[iparam].ioType) {
                this.bindParameters[iparam].ioType = this.serverParameters[iparam].ioType;
            }
            ++iparam;
        }
        iparam = 0;
        while (iparam < this.paramCount) {
            switch (this.bindParameters[iparam].type) {
                case 0: 
                case 1: 
                case 2: {
                    int len;
                    int n2 = len = this.curRowDatas[iparam] instanceof byte[] ? ((byte[])this.curRowDatas[iparam]).length : -1;
                    if (len > Short.MAX_VALUE) {
                        DBError.ECJDBC_STRING_CUT.throwz(new Object[0]);
                    }
                    if (len <= this.bindParameters[iparam].prec) break;
                    if (len < 8191) {
                        this.bindParameters[iparam].prec = 8191;
                        break;
                    }
                    if (len < 16383) {
                        this.bindParameters[iparam].prec = 16383;
                        break;
                    }
                    if (len < 24575) {
                        this.bindParameters[iparam].prec = 24575;
                        break;
                    }
                    this.bindParameters[iparam].prec = Short.MAX_VALUE;
                    break;
                }
            }
            ++iparam;
        }
    }

    protected void beforeExectueWithParameters(boolean batch) throws SQLException {
        if (!batch) {
            this.checkBindParameters();
        }
    }

    @Override
    protected void executeInner(String sql, short execType, boolean returnGeneratedKeys) throws SQLException {
        String orgSql = this.nativeSql;
        try {
            super.executeInner(sql, execType, returnGeneratedKeys);
        }
        finally {
            if (!StringUtil.equals(this.nativeSql, orgSql)) {
                this.do_clearParameters();
                this.do_clearBatch();
                this.hasPrepared = false;
                this.paramCount = 0;
                this.serverParameters = new Parameter[0];
                this.bindParameters = new Parameter[0];
                this.curRowDatas = new Object[0];
            }
        }
    }

    protected void executeInner(short execType) throws SQLException {
        try {
            try {
                if (this.constParamList != null && this.constParamList.size() > 0 && (this.indexMap == null || this.indexMap.isEmpty())) {
                    this.processAllConstParaSQl(execType);
                } else {
                    this.execInfo = this.connection.dbAccess.a(this, this.bindParameters, this.curRowDatas, execType);
                }
                if (this.execInfo.hasResultSet) {
                    this.curResultSet = this.createAndCacheResultSet((short)1, this.execInfo);
                }
            }
            catch (SQLException e2) {
                if (e2.getErrorCode() != DBError.EC_SRC_MULTI_ROWS.errCode || this.multiRowsError || this.execInfo.retSqlType == 164) {
                    throw e2;
                }
                this.multiRowsError = true;
                this.executeInner(execType);
                this.multiRowsError = false;
            }
        }
        finally {
            this.multiRowsError = false;
        }
    }

    private void processAllConstParaSQl(short execType) throws SQLException {
        try {
            this.execInfo = this.connection.dbAccess.a((DmdbStatement)this, this.isReturnGeneratedKeys(), this.constParamList, (int)execType);
        }
        catch (SQLException sQLException) {
            this.nativeSql = this.originalSql;
            this.execInfo = this.connection.dbAccess.a(this, this.bindParameters, this.curRowDatas, execType);
        }
    }

    @Override
    protected void afterExecute() {
        super.afterExecute();
        this.preExec = false;
    }

    private long[] executeBatchByRow() throws BatchUpdateException {
        if (this.irow > 0) {
            int count = this.irow;
            this.execInfo = new ExecuteRetInfo();
            ArrayList<String> sqlExList = new ArrayList<String>();
            int i2 = 0;
            while (i2 < count) {
                try {
                    ExecuteRetInfo tmpExecInfo = this.connection.dbAccess.a(this, this.bindParameters, this.multiRowDatas.get(i2), (short)0);
                    this.execInfo.gkColumns = tmpExecInfo.gkColumns;
                    this.execInfo.union(tmpExecInfo, count, i2, 1);
                }
                catch (SQLException sqlex) {
                    this.execInfo.union(-3, count, i2, 1);
                    if (this.connection.batchContinueOnError) {
                        sqlExList.add("row[" + i2 + "]:" + sqlex.getErrorCode() + ", " + sqlex.getMessage());
                        SQLWarning warning = new SQLWarning("row[" + i2 + "]:" + sqlex.getErrorCode() + ", " + sqlex.getMessage());
                        this.addSQLWarning(warning);
                    }
                    long[] newUpdateCounts = new long[i2 + 1];
                    System.arraycopy(this.execInfo.updateCounts, 0, newUpdateCounts, 0, newUpdateCounts.length);
                    DBError.throwBatchUpdateException(sqlex.getMessage(), sqlex.getSQLState(), sqlex.getErrorCode(), newUpdateCounts, sqlex);
                }
                ++i2;
            }
            if (sqlExList.size() > 0) {
                StringBuilder errMsg = new StringBuilder();
                for (String temp : sqlExList) {
                    errMsg.append(StringUtil.LINE_SEPARATOR).append(temp);
                }
                DBError.throwBatchUpdateException(String.valueOf(DBError.EC_BP_WITH_ERROR.reason) + errMsg.toString(), DBError.EC_BP_WITH_ERROR.sqlState, DBError.EC_BP_WITH_ERROR.errCode, this.execInfo.updateCounts, null);
            }
            return this.execInfo.updateCounts;
        }
        return new long[0];
    }

    public boolean do_execute() throws SQLException {
        try {
            this.beforeExecute();
            this.beforeExectueWithParameters(false);
            this.executeInner((short)0);
            boolean bl = this.curResultSet != null;
            return bl;
        }
        finally {
            this.afterExecute();
        }
    }

    public DmdbResultSet do_executeQuery() throws SQLException {
        try {
            this.beforeExecute();
            this.beforeExectueWithParameters(false);
            this.executeInner((short)1);
            DmdbResultSet dmdbResultSet = this.curResultSet == null ? DmdbResultSet.newEmptyResultSet(this) : this.curResultSet;
            return dmdbResultSet;
        }
        finally {
            this.afterExecute();
        }
    }

    public int do_executeUpdate() throws SQLException {
        try {
            this.beforeExecute();
            this.beforeExectueWithParameters(false);
            this.executeInner((short)2);
            if (!this.connection.compatibleOracle() && this.curResultSet != null) {
                DBError.ECJDBC_INVALID_SQL_TYPE.throwz(new Object[0]);
            }
            int n2 = this.do_getUpdateCount();
            return n2;
        }
        finally {
            this.afterExecute();
        }
    }

    @Override
    public int[] do_executeBatch() throws SQLException {
        long[] updateCounts = this.do_executeLargeBatch();
        int[] upds = updateCounts == null ? new int[]{} : new int[updateCounts.length];
        int i2 = 0;
        while (i2 < upds.length) {
            upds[i2] = ConvertUtil.toInt(updateCounts[i2]);
            ++i2;
        }
        return upds;
    }

    @Override
    public long[] do_executeLargeBatch() throws SQLException {
        if (this.batchSqls != null && this.batchSqls.size() > 0) {
            return super.do_executeLargeBatch();
        }
        long[] retUpdateCounts = new long[]{};
        try {
            try {
                int batchSize;
                this.beforeExecute();
                if (this.connection.readOnly && !this.connection.compatibleOracle()) {
                    DBError.ECJDBC_READ_ONLY_CONNECTION.throwz(new Object[0]);
                }
                if (this.execInfo.retSqlType == 160 || this.execInfo.retSqlType == 198) {
                    DBError.throwBatchUpdateException(DBError.ECJDBC_INVALID_SQL_TYPE.reason, DBError.ECJDBC_INVALID_SQL_TYPE.sqlState, DBError.ECJDBC_INVALID_SQL_TYPE.errCode, new long[0], null);
                }
                int n2 = batchSize = this.irow > 0 ? this.irow : 0;
                if (batchSize > 0) {
                    this.beforeExectueWithParameters(true);
                    if (batchSize == 1 || this.connection.batchType == 2 || this.connection.batchNotOnCall && this.execInfo.retSqlType == 162) {
                        retUpdateCounts = this.executeBatchByRow();
                    } else {
                        this.execInfo = this.connection.dbAccess.a(this, this.bindParameters, this.multiRowDatas);
                        retUpdateCounts = this.execInfo.updateCounts;
                    }
                    if (MiscUtil.contains(retUpdateCounts, -3L)) {
                        DBError.throwBatchUpdateException(DBError.EC_BP_WITH_ERROR.reason, DBError.EC_BP_WITH_ERROR.sqlState, DBError.EC_BP_WITH_ERROR.errCode, retUpdateCounts, null);
                    }
                }
            }
            catch (SQLException e2) {
                if (e2.getErrorCode() != DBError.EC_SRC_MULTI_ROWS.errCode || this.multiRowsError || this.execInfo.retSqlType == 164) {
                    throw e2;
                }
                this.multiRowsError = true;
                this.do_executeLargeBatch();
                if (this.connection.compatibleOracle()) {
                    retUpdateCounts = DriverUtil.toOracleUpdateCounts(this.connection, retUpdateCounts);
                }
                if (this.clearBatch) {
                    this.do_clearBatch();
                }
                this.afterExecute();
                this.multiRowsError = false;
            }
        }
        finally {
            if (this.connection.compatibleOracle()) {
                retUpdateCounts = DriverUtil.toOracleUpdateCounts(this.connection, retUpdateCounts);
            }
            if (this.clearBatch) {
                this.do_clearBatch();
            }
            this.afterExecute();
            this.multiRowsError = false;
        }
        return retUpdateCounts;
    }

    public void do_addBatch() throws SQLException {
        this.checkBindParameters();
        this.multiRowDatas.add(this.curRowDatas);
        ++this.irow;
        Object[] tmp = new Object[this.paramCount];
        System.arraycopy(this.curRowDatas, 0, tmp, 0, tmp.length);
        this.curRowDatas = tmp;
    }

    @Override
    public void do_clearBatch() {
        this.irow = 0;
        if (this.multiRowDatas != null) {
            if (this.connection.trxRetryFlag > 0) {
                this.multiRowDatas = new ArrayList<Object[]>(0);
            } else {
                this.multiRowDatas.clear();
            }
        }
        super.do_clearBatch();
    }

    public void do_clearParameters() {
        Arrays.fill(this.curRowDatas, null);
        if (this.multiRowDatas.size() == 0) {
            Parameter[] parameterArray = this.bindParameters;
            int n2 = this.bindParameters.length;
            int n3 = 0;
            while (n3 < n2) {
                Parameter param = parameterArray[n3];
                param.clear();
                ++n3;
            }
        }
        this.toBeLockedConnections.clear();
    }

    public DmdbResultSetMetaData do_getMetaData() throws SQLException {
        if (!this.hasPrepared) {
            this.connection.dbAccess.a(this);
        }
        return new DmdbResultSetMetaData(this.connection, this.columns);
    }

    public DmdbParameterMetaData do_getParameterMetaData() throws SQLException {
        if (!this.hasPrepared) {
            ExecuteRetInfo execInfo = this.connection.dbAccess.a(this);
            return new DmdbParameterMetaData(this.connection, execInfo.serverParameters);
        }
        return new DmdbParameterMetaData(this.connection, this.serverParameters);
    }

    @Override
    public DmdbResultSet do_getGeneratedKeys() throws SQLException {
        if (this.generateKeyColumnNames != null && this.execInfo.outParamDatas != null && this.execInfo.outParamDatas.size() > 0) {
            Column[] colInfos = new Column[this.generateKeyColumnNames.length];
            byte[][][] rsDatas = new byte[this.execInfo.outParamDatas.size()][this.generateKeyColumnNames.length + 1][];
            int colIndex = 0;
            byte[][] rowData = null;
            int irow = 0;
            while (irow < this.execInfo.outParamDatas.size()) {
                rowData = this.execInfo.outParamDatas.get(irow);
                int i2 = 0;
                while (i2 < this.generateKeyColumnNames.length) {
                    colIndex = this.paramCount - this.generateKeyColumnNames.length + i2;
                    colInfos[i2] = new Column();
                    colInfos[i2].type = this.bindParameters[colIndex].type;
                    colInfos[i2].prec = this.bindParameters[colIndex].prec;
                    colInfos[i2].scale = this.bindParameters[colIndex].scale;
                    colInfos[i2].typeName = this.bindParameters[colIndex].typeName;
                    colInfos[i2].name = this.generateKeyColumnNames[i2];
                    colInfos[i2].nullable = this.bindParameters[colIndex].nullable;
                    colInfos[i2].schemaName = this.bindParameters[colIndex].schemaName;
                    colInfos[i2].tableName = this.bindParameters[colIndex].tableName;
                    rsDatas[irow][i2 + 1] = new byte[rowData[colIndex].length];
                    ByteUtil.setBytes(rsDatas[irow][i2 + 1], 0, rowData[colIndex]);
                    ++i2;
                }
                ++irow;
            }
            return DmdbResultSet.newLocalResultSet(this, colInfos, rsDatas);
        }
        return super.do_getGeneratedKeys();
    }

    protected int bindInParam(int paramIndex, int dtype, boolean isNull) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.paramCount) {
            DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
        }
        if (this.connection.constParaOpt) {
            boolean rowStart;
            boolean bl = rowStart = paramIndex == 1;
            if (this.indexMap != null) {
                Integer index = (Integer)this.indexMap.get(paramIndex);
                if (index == null) {
                    DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
                }
                paramIndex = index;
            }
            if (this.constParamList != null && this.constParamList.size() > 0 && rowStart) {
                for (SQLParameter parameter : this.constParamList) {
                    this.bindInParamInternal(this.serverParameters[parameter.index - 1], this.bindParameters[parameter.index - 1], parameter.type, parameter.bytes == null);
                    this.curRowDatas[parameter.index - 1] = parameter.bytes;
                }
            }
        }
        this.bindInParamInternal(this.serverParameters[paramIndex - 1], this.bindParameters[paramIndex - 1], dtype, isNull);
        return paramIndex - 1;
    }

    protected boolean bindInParamInternal(Parameter serverParam, Parameter bindParam, int dtype, boolean isNull) throws SQLException {
        if (this.irow > 0) {
            if (DmdbType.isCharacter(bindParam.type) && dtype == 19 || DmdbType.isBinary(bindParam.type) && dtype == 12) {
                bindParam.type = dtype;
                return true;
            }
            return true;
        }
        if (serverParam == null) {
            bindParam.resetType(dtype);
        } else {
            bindParam.name = serverParam.name;
            bindParam.typeDescriptor = serverParam.typeDescriptor;
            bindParam.mask = serverParam.mask;
            bindParam.typeFlag = serverParam.typeFlag;
            bindParam.recommendType(this.connection, serverParam, dtype, isNull, this.fromObject);
        }
        bindParam.ioType = (byte)(bindParam.ioType == 1 || bindParam.ioType == 2 ? 2 : 0);
        return true;
    }

    protected void bindInParamAfter(int icol) {
        Parameter bindParam = this.bindParameters[icol];
        if (this.irow == 0 && !(this.curRowDatas[icol] instanceof OffRowData)) {
            if (bindParam.type == 19) {
                bindParam.recommendType(this.connection, this.serverParameters[icol], 2, false, this.fromObject);
            } else if (bindParam.type == 12) {
                bindParam.recommendType(this.connection, this.serverParameters[icol], 18, false, this.fromObject);
            }
        }
    }

    public void do_setNull(int parameterIndex, int sqlType) throws SQLException {
        int iparam = this.bindInParam(parameterIndex, DmdbType.j2dType(sqlType), true);
        this.curRowDatas[iparam] = null;
    }

    public void do_setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.do_setNull(parameterIndex, sqlType);
    }

    public void do_setBoolean(int parameterIndex, boolean x2) throws SQLException {
        int iparam = this.bindInParam(parameterIndex, 5, false);
        this.curRowDatas[iparam] = J2DB.fromBoolean(x2, this.bindParameters[iparam], this.connection);
    }

    public void do_setByte(int parameterIndex, byte x2) throws SQLException {
        int iparam = this.bindInParam(parameterIndex, 5, false);
        this.curRowDatas[iparam] = J2DB.fromLong(x2, this.bindParameters[iparam], this.connection);
    }

    public void do_setShort(int parameterIndex, short x2) throws SQLException {
        int iparam = this.bindInParam(parameterIndex, 6, false);
        this.curRowDatas[iparam] = J2DB.fromLong(x2, this.bindParameters[iparam], this.connection);
    }

    public void do_setInt(int parameterIndex, int x2) throws SQLException {
        int iparam = this.bindInParam(parameterIndex, 7, false);
        this.curRowDatas[iparam] = J2DB.fromLong(x2, this.bindParameters[iparam], this.connection);
    }

    public void do_setLong(int parameterIndex, long x2) throws SQLException {
        int iparam = this.bindInParam(parameterIndex, 8, false);
        this.curRowDatas[iparam] = J2DB.fromLong(x2, this.bindParameters[iparam], this.connection);
    }

    public void do_setFloat(int parameterIndex, float x2) throws SQLException {
        int iparam = this.bindInParam(parameterIndex, 10, false);
        this.curRowDatas[iparam] = J2DB.fromFloat(x2, this.bindParameters[iparam], this.connection);
    }

    public void do_setDouble(int parameterIndex, double x2) throws SQLException {
        int iparam = this.bindInParam(parameterIndex, 11, false);
        this.curRowDatas[iparam] = J2DB.fromDouble(x2, this.bindParameters[iparam], this.connection);
    }

    public void do_setBigDecimal(int parameterIndex, BigDecimal x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterIndex, 3);
            return;
        }
        int destType = 9;
        if (x2.compareTo(DmdbNumeric.MAX_VALUE) > 0 || x2.compareTo(DmdbNumeric.MIN_VALUE) < 0) {
            destType = 2;
        }
        int iparam = this.bindInParam(parameterIndex, destType, false);
        this.curRowDatas[iparam] = J2DB.fromBigDecimal(x2, this.bindParameters[iparam], this.connection);
    }

    public void do_setString(int parameterIndex, String x2) throws SQLException {
        if (x2 == null || x2.length() == 0 && this.serverParameters[parameterIndex - 1] != null && DmdbType.emptyStringToNull(this.serverParameters[parameterIndex - 1].type)) {
            this.do_setNull(parameterIndex, 12);
            return;
        }
        if (Parameter.useClientBind(this.connection, this.serverParameters[parameterIndex - 1], false)) {
            byte[] xBytes = ByteUtil.fromString(x2, this.connection.getServerEncoding());
            int dtype = xBytes.length < Short.MAX_VALUE ? 2 : 19;
            int iparam = this.bindInParam(parameterIndex, dtype, false);
            this.curRowDatas[iparam] = J2DB.fromStringBytes(x2, xBytes, this.bindParameters[iparam], this.connection);
        } else {
            long len = x2.length();
            int dtype = len < 32767L ? 2 : 19;
            int iparam = this.bindInParam(parameterIndex, dtype, false);
            this.curRowDatas[iparam] = J2DB.fromString(x2, this.bindParameters[iparam], this.connection);
        }
    }

    public void do_setFixedCHAR(int parameterIndex, String x2) throws SQLException {
        if (x2 == null || x2.length() == 0 && this.serverParameters[parameterIndex - 1] != null && DmdbType.emptyStringToNull(this.serverParameters[parameterIndex - 1].type)) {
            this.do_setNull(parameterIndex, 1);
            return;
        }
        byte[] xBytes = ByteUtil.fromString(x2, this.connection.getServerEncoding());
        int dtype = 0;
        int iparam = this.bindInParam(parameterIndex, dtype, false);
        this.curRowDatas[iparam] = J2DB.fromStringBytes(x2, xBytes, this.bindParameters[iparam], this.connection);
    }

    public void do_setBytes(int parameterIndex, byte[] x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterIndex, -3);
            return;
        }
        long avilable = x2.length;
        int dtype = avilable > 0L && avilable < 32767L ? 18 : 12;
        int iparam = this.bindInParam(parameterIndex, dtype, false);
        this.curRowDatas[iparam] = J2DB.fromBytes(x2, this.bindParameters[iparam], this.connection);
    }

    public void do_setCharBytes(int parameterIndex, byte[] x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterIndex, -3);
            return;
        }
        long avilable = x2.length;
        int dtype = avilable > 0L && avilable < 32767L ? 18 : 12;
        int iparam = this.bindInParam(parameterIndex, dtype, false);
        this.curRowDatas[iparam] = J2DB.fromStringBytes("", x2, this.bindParameters[iparam], this.connection);
    }

    public void do_setDate(int parameterIndex, java.sql.Date x2) throws SQLException {
        this.do_setDate(parameterIndex, x2, null);
    }

    public void do_setDate(int parameterIndex, java.sql.Date x2, Calendar cal) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterIndex, 91);
            return;
        }
        int icol = this.bindInParam(parameterIndex, 14, false);
        this.curRowDatas[icol] = J2DB.fromDate(x2, this.bindParameters[icol], this.connection, cal);
    }

    public void do_setTime(int parameterIndex, Time x2) throws SQLException {
        this.do_setTime(parameterIndex, x2, null);
    }

    public void do_setTime(int parameterIndex, Time x2, Calendar cal) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterIndex, 92);
            return;
        }
        int iparam = this.bindInParam(parameterIndex, 15, false);
        this.curRowDatas[iparam] = J2DB.fromDate(x2, this.bindParameters[iparam], this.connection, cal != null ? (Calendar)cal.clone() : null);
    }

    public void do_setTimestamp(int parameterIndex, Timestamp x2) throws SQLException {
        this.do_setTimestamp(parameterIndex, x2, null);
    }

    public void do_setTimestamp(int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        if (x2 instanceof DmdbTimestamp) {
            this.do_setTIMESTAMP(parameterIndex, (DmdbTimestamp)x2);
            return;
        }
        if (x2 == null) {
            this.do_setNull(parameterIndex, 93);
            return;
        }
        int iparam = this.bindInParam(parameterIndex, 16, false);
        this.curRowDatas[iparam] = J2DB.fromDate(x2, this.bindParameters[iparam], this.connection, cal != null ? (Calendar)cal.clone() : null);
    }

    public void do_setAsciiStream(int parameterIndex, InputStream x2) throws SQLException {
        this.do_setAsciiStream(parameterIndex, x2, -1);
    }

    public void do_setAsciiStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.do_setAsciiStream(parameterIndex, x2, (long)length);
    }

    public void do_setAsciiStream(int parameterIndex, InputStream x2, long length) throws SQLException {
        this.do_setInputStream(parameterIndex, x2, length, 2, 2);
    }

    public void do_setUnicodeStream(int parameterIndex, InputStream x2) throws SQLException {
        this.do_setUnicodeStream(parameterIndex, x2, -1);
    }

    public void do_setUnicodeStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.do_setInputStream(parameterIndex, x2, length, 2, 3);
    }

    public void do_setBinaryStream(int parameterIndex, InputStream x2) throws SQLException {
        this.do_setBinaryStream(parameterIndex, x2, -1);
    }

    public void do_setBinaryStream(int parameterIndex, InputStream x2, long length) throws SQLException {
        this.do_setInputStream(parameterIndex, x2, length, 18, 1);
    }

    public void do_setInputStream(int parameterIndex, InputStream x2, long length, int dtype, int streamType) throws SQLException {
        if (x2 instanceof DmdbInputStream) {
            DmdbInputStream dmStream = (DmdbInputStream)x2;
            Object obj = dmStream.useRealObject(length);
            if (obj instanceof DmdbBlob) {
                this.do_setBlob(parameterIndex, (Blob)obj);
                return;
            }
            if (obj instanceof DmdbClob) {
                this.do_setClob(parameterIndex, (Clob)obj);
                return;
            }
            if (obj instanceof byte[]) {
                this.do_setBytes(parameterIndex, (byte[])obj);
                return;
            }
        }
        if (x2 == null) {
            this.do_setNull(parameterIndex, -3);
            return;
        }
        long avilable = length != -1L ? length : MiscUtil.available(x2);
        int recDtype = dtype;
        if (dtype == 18) {
            recDtype = avilable > 0L && avilable < 32767L ? 18 : 12;
        } else if (dtype == 2) {
            recDtype = avilable > 0L && avilable < 32767L ? 2 : 19;
        }
        int iparam = this.bindInParam(parameterIndex, recDtype, false);
        switch (streamType) {
            case 2: {
                this.curRowDatas[iparam] = J2DB.fromAsciiStream(x2, this.bindParameters[iparam], this.connection, length);
                break;
            }
            case 3: {
                this.curRowDatas[iparam] = J2DB.fromUnicodeStream(x2, this.bindParameters[iparam], this.connection, length);
                break;
            }
            case 1: {
                this.curRowDatas[iparam] = J2DB.fromBinaryStream(x2, this.bindParameters[iparam], this.connection, length);
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
        }
        this.bindInParamAfter(iparam);
    }

    public void do_setBinaryStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.do_setBinaryStream(parameterIndex, x2, (long)length);
    }

    public void do_setCharacterStream(int parameterIndex, Reader x2) throws SQLException {
        this.do_setCharacterStream(parameterIndex, x2, -1);
    }

    public void do_setCharacterStream(int parameterIndex, Reader x2, int length) throws SQLException {
        this.do_setCharacterStream(parameterIndex, x2, (long)length);
    }

    public void do_setCharacterStream(int parameterIndex, Reader x2, long length) throws SQLException {
        int dtype;
        int n2 = dtype = length != -1L && length < 32767L ? 2 : 19;
        if (x2 == null) {
            this.do_setNull(parameterIndex, 12);
            return;
        }
        int iparam = this.bindInParam(parameterIndex, dtype, false);
        this.curRowDatas[iparam] = J2DB.fromReader(x2, this.bindParameters[iparam], this.connection, length);
        this.bindInParamAfter(iparam);
    }

    public void do_setBlob(int parameterIndex, Blob x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterIndex, 2004);
            return;
        }
        int iparam = this.bindInParam(parameterIndex, 12, false);
        this.curRowDatas[iparam] = x2 instanceof DmdbBlob ? J2DB.fromBlob((DmdbBlob)x2, this.bindParameters[iparam], this.connection) : J2DB.fromBinaryStream(x2.getBinaryStream(), this.bindParameters[iparam], this.connection, -1L);
    }

    public void do_setClob(int parameterIndex, Clob x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterIndex, 2005);
            return;
        }
        int iparam = this.bindInParam(parameterIndex, 19, false);
        this.curRowDatas[iparam] = x2 instanceof DmdbClob ? J2DB.fromClob((DmdbClob)x2, this.bindParameters[iparam], this.connection) : J2DB.fromReader(x2.getCharacterStream(), this.bindParameters[iparam], this.connection, -1L);
    }

    public void do_setArray(int parameterIndex, Array x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterIndex, 2003);
            return;
        }
        int iparam = this.bindInParam(parameterIndex, ((DmdbArray)x2).getDType(), false);
        if (this.bindParameters[iparam].typeDescriptor == null) {
            this.bindParameters[iparam].typeDescriptor = ((DmdbArray)x2).m_arrDesc;
        }
        this.curRowDatas[iparam] = J2DB.fromArray((DmdbArray)x2, this.bindParameters[iparam], this.connection);
    }

    public void do_setStruct(int parameterIndex, Struct x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterIndex, 2002);
            return;
        }
        int iparam = this.bindInParam(parameterIndex, ((DmdbStruct)x2).getDType(), false);
        if (this.bindParameters[iparam].typeDescriptor == null) {
            this.bindParameters[iparam].typeDescriptor = ((DmdbStruct)x2).m_strctDesc;
        }
        this.curRowDatas[iparam] = J2DB.fromStruct((DmdbStruct)x2, this.bindParameters[iparam], this.connection);
    }

    public void do_setObject(int parameterIndex, Object x2) throws SQLException {
        this.do_setObject(parameterIndex, x2, 0, -1);
    }

    public void do_setObject(int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        this.do_setObject(parameterIndex, x2, targetSqlType, -1);
    }

    public void do_setObject(int parameterIndex, Object x2, int targetSqlType, int scaleOrLength) throws SQLException {
        this.do_setObject(parameterIndex, x2, targetSqlType, (long)scaleOrLength);
    }

    public void do_setObject(int parameterIndex, Object x2, int targetSqlType, long scaleOrLength) throws SQLException {
        this.fromObject = true;
        if (scaleOrLength != -1L && (targetSqlType == 3 || targetSqlType == 2) && DmdbType.canCastToDecimal(x2)) {
            String strValue = "";
            strValue = x2 instanceof Boolean ? ((Boolean)x2 != false ? "1" : "0") : String.valueOf(x2);
            BigDecimal bgd = new BigDecimal(strValue);
            x2 = bgd.setScale((int)scaleOrLength, 4);
        }
        if (x2 instanceof FeSQLParameter) {
            FeSQLParameter fp = (FeSQLParameter)x2;
            x2 = fp.hexFlag ? fp.bytes : (byte[])fp.data;
        }
        if (x2 == null) {
            this.do_setNull(parameterIndex, targetSqlType);
        } else if (x2 instanceof Boolean) {
            this.do_setBoolean(parameterIndex, (Boolean)x2);
        } else if (x2 instanceof Byte) {
            this.do_setByte(parameterIndex, (Byte)x2);
        } else if (x2 instanceof Short) {
            this.do_setShort(parameterIndex, (Short)x2);
        } else if (x2 instanceof Integer) {
            this.do_setInt(parameterIndex, (Integer)x2);
        } else if (x2 instanceof Long) {
            this.do_setLong(parameterIndex, (Long)x2);
        } else if (x2 instanceof Float) {
            this.do_setFloat(parameterIndex, ((Float)x2).floatValue());
        } else if (x2 instanceof Double) {
            this.do_setDouble(parameterIndex, (Double)x2);
        } else if (x2 instanceof BigDecimal) {
            this.do_setBigDecimal(parameterIndex, (BigDecimal)x2);
        } else if (x2 instanceof byte[]) {
            this.do_setBytes(parameterIndex, (byte[])x2);
        } else if (x2 instanceof String) {
            this.do_setString(parameterIndex, (String)x2);
        } else if (x2 instanceof Clob) {
            this.do_setClob(parameterIndex, (Clob)x2);
        } else if (x2 instanceof Blob) {
            this.do_setBlob(parameterIndex, (Blob)x2);
        } else if (x2 instanceof InputStream) {
            this.do_setBinaryStream(parameterIndex, (InputStream)x2, scaleOrLength);
        } else if (x2 instanceof Reader) {
            this.do_setCharacterStream(parameterIndex, (Reader)x2, scaleOrLength);
        } else if (x2 instanceof Array) {
            this.do_setArray(parameterIndex, (Array)x2);
        } else if (x2 instanceof BigInteger) {
            this.do_setBigDecimal(parameterIndex, new BigDecimal((BigInteger)x2));
        } else if (x2 instanceof Character) {
            this.do_setString(parameterIndex, x2.toString());
        } else if (x2 instanceof DmdbBFile) {
            this.do_setString(parameterIndex, ((DmdbBFile)x2).getFileName());
        } else if (x2 instanceof Struct) {
            this.do_setStruct(parameterIndex, (Struct)x2);
        } else if (x2 instanceof SQLData) {
            this.do_setSQLData(parameterIndex, (SQLData)x2);
        } else if (x2 instanceof RowId) {
            this.do_setRowId(parameterIndex, (RowId)x2);
        } else if (x2 instanceof DmdbTimestamp) {
            this.do_setTIMESTAMP(parameterIndex, (DmdbTimestamp)x2);
        } else if (x2 instanceof DmdbIntervalDT) {
            this.do_setINTERVALDT(parameterIndex, (DmdbIntervalDT)x2);
        } else if (x2 instanceof DmdbIntervalYM) {
            this.do_setINTERVALYM(parameterIndex, (DmdbIntervalYM)x2);
        } else if (x2 instanceof java.sql.Date) {
            this.do_setDate(parameterIndex, (java.sql.Date)x2);
        } else if (x2 instanceof Time) {
            this.do_setTime(parameterIndex, (Time)x2);
        } else if (x2 instanceof Timestamp) {
            this.do_setTimestamp(parameterIndex, (Timestamp)x2);
        } else if (x2 instanceof Date) {
            this.do_setTIMESTAMP(parameterIndex, DmdbTimestamp.valueOf((Date)x2));
        } else if (x2 instanceof LocalDate) {
            this.do_setTIMESTAMP(parameterIndex, DmdbTimestamp.valueOf((LocalDate)x2));
        } else if (x2 instanceof LocalTime) {
            this.do_setTIMESTAMP(parameterIndex, DmdbTimestamp.valueOf((LocalTime)x2));
        } else if (x2 instanceof LocalDateTime) {
            this.do_setTIMESTAMP(parameterIndex, DmdbTimestamp.valueOf((LocalDateTime)x2));
        } else if (x2 instanceof ZonedDateTime) {
            this.do_setTIMESTAMP(parameterIndex, DmdbTimestamp.valueOf((ZonedDateTime)x2));
        } else if (x2 instanceof OffsetDateTime) {
            this.do_setTIMESTAMP(parameterIndex, DmdbTimestamp.valueOf((OffsetDateTime)x2));
        } else if (x2 instanceof OffsetTime) {
            this.do_setTIMESTAMP(parameterIndex, DmdbTimestamp.valueOf((OffsetTime)x2));
        } else if (x2 instanceof SQLXML) {
            this.do_setSQLXML(parameterIndex, (SQLXML)x2);
        } else if (x2 instanceof Ref) {
            this.do_setRef(parameterIndex, (Ref)x2);
        } else if (x2 instanceof URL) {
            this.do_setURL(parameterIndex, (URL)x2);
        } else {
            this.fromObject = false;
            DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
        }
        this.fromObject = false;
    }

    public void do_setSQLData(int parameterIndex, SQLData x2) throws SQLException {
        String typeName = x2.getSQLTypeName();
        if (this.connection.do_getTypeMap().containsKey(typeName) && x2.getClass() == this.connection.do_getTypeMap().get(typeName)) {
            ComplexTypeDesc desc = new ComplexTypeDesc(typeName, this.connection);
            DmdbSQLOutput stream = new DmdbSQLOutput();
            x2.writeSQL(stream);
            DmdbStruct struct = new DmdbStruct(desc, this.connection, stream.getAttribs());
            this.do_setStruct(parameterIndex, struct);
        } else {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
    }

    public void do_setURL(int parameterIndex, URL x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterIndex, 70);
            return;
        }
        this.do_setString(parameterIndex, x2.toString());
    }

    public void do_setRef(int parameterIndex, Ref x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterIndex, 2006);
            return;
        }
        this.do_setObject(parameterIndex, x2.getObject());
    }

    public boolean isReturnGeneratedKeys() {
        return this.autoGeneratedKeys == 1;
    }

    public void do_setNString(int parameterIndex, String value) throws SQLException {
        this.do_setString(parameterIndex, value);
    }

    public void do_setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.do_setCharacterStream(parameterIndex, value, length);
    }

    public void do_setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.do_setClob(parameterIndex, reader, length);
    }

    public void do_setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.do_setCharacterStream(parameterIndex, value);
    }

    public void do_setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.do_setClob(parameterIndex, reader);
    }

    public void do_setRowId(int parameterIndex, RowId x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterIndex, -8);
        } else {
            int dtype = this.connection.msgVersion >= 9 ? 28 : 8;
            int iparam = this.bindInParam(parameterIndex, dtype, false);
            this.curRowDatas[iparam] = J2DB.fromRowId(x2, this.bindParameters[iparam], this.connection);
        }
    }

    public void do_setNClob(int parameterIndex, NClob value) throws SQLException {
        this.do_setClob(parameterIndex, value);
    }

    public void do_setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.do_setCharacterStream(parameterIndex, reader, length);
    }

    public void do_setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.do_setBinaryStream(parameterIndex, inputStream, length);
    }

    public void do_setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        if (xmlObject == null) {
            this.do_setNull(parameterIndex, 2009);
        } else {
            this.do_setCharacterStream(parameterIndex, ((DmdbSQLXML)xmlObject).serializeAsCharacterStream());
        }
    }

    public void do_setClob(int parameterIndex, Reader reader) throws SQLException {
        this.do_setCharacterStream(parameterIndex, reader);
    }

    public void do_setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.do_setBinaryStream(parameterIndex, inputStream);
    }

    public void do_setObject(int parameterIndex, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public void do_setObject(int parameterIndex, Object x2, SQLType targetSqlType) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public void do_setOriginal(int parameterIndex, Parameter parameter, Object x2) throws SQLException {
        int iparam = this.bindInParam(parameterIndex, parameter.type, false);
        this.curRowDatas[iparam] = x2;
    }

    public long do_executeLargeUpdate() throws SQLException {
        try {
            this.beforeExecute();
            this.beforeExectueWithParameters(false);
            this.executeInner((short)2);
            if (!this.connection.compatibleOracle() && this.curResultSet != null) {
                DBError.ECJDBC_INVALID_SQL_TYPE.throwz(new Object[0]);
            }
            long l2 = this.do_getLargeUpdateCount();
            return l2;
        }
        finally {
            this.afterExecute();
        }
    }

    private void getToBeLockedConnections() {
        this.toBeLockedConnections.clear();
        List<Object[]> rows = null;
        if (this.getBatchSize() > 0) {
            rows = this.multiRowDatas;
        } else {
            rows = new ArrayList<Object[]>(1);
            rows.add(this.curRowDatas);
        }
        Iterator<Object[]> iterator = rows.iterator();
        while (iterator.hasNext()) {
            Object[] row;
            Object[] objectArray = row = iterator.next();
            int n2 = row.length;
            int n3 = 0;
            while (n3 < n2) {
                Object data = objectArray[n3];
                if (data instanceof OffRowData) {
                    OffRowData offRowData = (OffRowData)data;
                    if (offRowData.obj instanceof AbstractLob) {
                        AbstractLob lob = (AbstractLob)offRowData.obj;
                        if (lob.connection != null) {
                            this.toBeLockedConnections.add(lob.connection);
                        }
                    }
                }
                ++n3;
            }
        }
    }

    private <T> T execute(CallBack<T> callback) throws SQLException {
        this.getToBeLockedConnections();
        this.toBeLockedConnections.add(this.connection);
        SyncConnectionCallBack<T> syncCallback = new SyncConnectionCallBack<T>(callback, this.connection);
        Iterator<DmdbConnection> iterator = this.toBeLockedConnections.iterator();
        while (iterator.hasNext()) {
            syncCallback = new SyncConnectionCallBack<T>(syncCallback, iterator.next());
        }
        return syncCallback.run();
    }

    @Override
    @Deprecated
    public ResultSet executeQuery() throws SQLException {
        this.checkConnection();
        CallBack<ResultSet> callback = new CallBack<ResultSet>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ResultSet run() throws SQLException {
                DmdbConnection dmdbConnection = DmdbPreparedStatement.this.connection;
                synchronized (dmdbConnection) {
                    if (DmdbPreparedStatement.this.filterHead == null) {
                        return DmdbPreparedStatement.this.do_executeQuery();
                    }
                    return DmdbPreparedStatement.this.filterHead.PreparedStatement_executeQuery(DmdbPreparedStatement.this);
                }
            }
        };
        if (this.connection.highConcurrency) {
            return this.execute(callback);
        }
        return (ResultSet)callback.run();
    }

    @Override
    @Deprecated
    public int executeUpdate() throws SQLException {
        this.checkConnection();
        CallBack<Integer> callback = new CallBack<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer run() throws SQLException {
                DmdbConnection dmdbConnection = DmdbPreparedStatement.this.connection;
                synchronized (dmdbConnection) {
                    if (DmdbPreparedStatement.this.filterHead == null) {
                        return DmdbPreparedStatement.this.do_executeUpdate();
                    }
                    return DmdbPreparedStatement.this.filterHead.PreparedStatement_executeUpdate(DmdbPreparedStatement.this);
                }
            }
        };
        if (this.connection.highConcurrency) {
            return this.execute(callback);
        }
        return (Integer)callback.run();
    }

    @Override
    @Deprecated
    public int[] executeBatch() throws SQLException {
        this.checkConnection();
        CallBack<int[]> callback = new CallBack<int[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] run() throws SQLException {
                DmdbConnection dmdbConnection = DmdbPreparedStatement.this.connection;
                synchronized (dmdbConnection) {
                    if (DmdbPreparedStatement.this.filterHead == null) {
                        return DmdbPreparedStatement.this.do_executeBatch();
                    }
                    return DmdbPreparedStatement.this.filterHead.PreparedStatement_executeBatch(DmdbPreparedStatement.this);
                }
            }
        };
        if (this.connection.highConcurrency) {
            return this.execute(callback);
        }
        return (int[])callback.run();
    }

    @Override
    @Deprecated
    public long[] executeLargeBatch() throws SQLException {
        this.checkConnection();
        CallBack<long[]> callback = new CallBack<long[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long[] run() throws SQLException {
                DmdbConnection dmdbConnection = DmdbPreparedStatement.this.connection;
                synchronized (dmdbConnection) {
                    if (DmdbPreparedStatement.this.filterHead == null) {
                        return DmdbPreparedStatement.this.do_executeLargeBatch();
                    }
                    return DmdbPreparedStatement.this.filterHead.PreparedStatement_executeLargeBatch(DmdbPreparedStatement.this);
                }
            }
        };
        if (this.connection.highConcurrency) {
            return this.execute(callback);
        }
        return (long[])callback.run();
    }

    @Override
    @Deprecated
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (this.filterHead == null) {
            this.do_setNull(parameterIndex, sqlType);
        } else {
            this.filterHead.PreparedStatement_setNull(this, parameterIndex, sqlType);
        }
    }

    @Override
    @Deprecated
    public void setBoolean(int parameterIndex, boolean x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setBoolean(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setBoolean(this, parameterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public void setByte(int parameterIndex, byte x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setByte(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setByte(this, parameterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public void setShort(int parameterIndex, short x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setShort(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setShort(this, parameterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public void setInt(int parameterIndex, int x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setInt(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setInt(this, parameterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public void setLong(int parameterIndex, long x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setLong(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setLong(this, parameterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public void setFloat(int parameterIndex, float x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setFloat(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setFloat(this, parameterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public void setDouble(int parameterIndex, double x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setDouble(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setDouble(this, parameterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public void setBigDecimal(int parameterIndex, BigDecimal x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setBigDecimal(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setBigDecimal(this, parameterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public void setString(int parameterIndex, String x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setString(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setString(this, parameterIndex, x2);
        }
    }

    public void setFixedCHAR(int parameterIndex, String x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setFixedCHAR(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setFixedCHAR(this, parameterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public void setBytes(int parameterIndex, byte[] x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setBytes(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setBytes(this, parameterIndex, x2);
        }
    }

    public void setCharBytes(int paramterIndex, byte[] x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setCharBytes(paramterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setCharBytes(this, paramterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public void setDate(int parameterIndex, java.sql.Date x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setDate(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setDate(this, parameterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public void setTime(int parameterIndex, Time x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setTime(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setTime(this, parameterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public void setTimestamp(int parameterIndex, Timestamp x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setTimestamp(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setTimestamp(this, parameterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public void setAsciiStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        if (this.filterHead == null) {
            this.do_setAsciiStream(parameterIndex, x2, length);
        } else {
            this.filterHead.PreparedStatement_setAsciiStream(this, parameterIndex, x2, length);
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        if (this.filterHead == null) {
            this.do_setUnicodeStream(parameterIndex, x2, length);
        } else {
            this.filterHead.PreparedStatement_setUnicodeStream(this, parameterIndex, x2, length);
        }
    }

    @Override
    @Deprecated
    public void setBinaryStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        if (this.filterHead == null) {
            this.do_setBinaryStream(parameterIndex, x2, length);
        } else {
            this.filterHead.PreparedStatement_setBinaryStream(this, parameterIndex, x2, length);
        }
    }

    @Override
    @Deprecated
    public void clearParameters() throws SQLException {
        if (this.filterHead == null) {
            this.do_clearParameters();
        } else {
            this.filterHead.PreparedStatement_clearParameters(this);
        }
    }

    @Override
    @Deprecated
    public void setObject(int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        if (this.filterHead == null) {
            this.do_setObject(parameterIndex, x2, targetSqlType);
        } else {
            this.filterHead.PreparedStatement_setObject(this, parameterIndex, x2, targetSqlType);
        }
    }

    @Override
    @Deprecated
    public void setObject(int parameterIndex, Object x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setObject(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setObject(this, parameterIndex, x2);
        }
    }

    @Deprecated
    public Flow.Publisher<Boolean> executeAsyncDm() throws SQLException {
        return Flows.from(this.execute());
    }

    @Deprecated
    public Flow.Publisher<Long> executeBatchAsyncDm() throws SQLException {
        return Flows.fromArray(this.executeBatch());
    }

    @Override
    @Deprecated
    public boolean execute() throws SQLException {
        this.checkConnection();
        CallBack<Boolean> callback = new CallBack<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean run() throws SQLException {
                DmdbConnection dmdbConnection = DmdbPreparedStatement.this.connection;
                synchronized (dmdbConnection) {
                    if (DmdbPreparedStatement.this.filterHead == null) {
                        return DmdbPreparedStatement.this.do_execute();
                    }
                    return DmdbPreparedStatement.this.filterHead.PreparedStatement_execute(DmdbPreparedStatement.this);
                }
            }
        };
        if (this.connection.highConcurrency) {
            return this.execute(callback);
        }
        return (Boolean)callback.run();
    }

    @Override
    @Deprecated
    public void addBatch() throws SQLException {
        if (this.filterHead == null) {
            this.do_addBatch();
        } else {
            this.filterHead.PreparedStatement_addBatch(this);
        }
    }

    @Override
    @Deprecated
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (this.filterHead == null) {
            this.do_setCharacterStream(parameterIndex, reader, length);
        } else {
            this.filterHead.PreparedStatement_setCharacterStream(this, parameterIndex, reader, length);
        }
    }

    @Override
    @Deprecated
    public void setRef(int parameterIndex, Ref x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setRef(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setRef(this, parameterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public void setBlob(int parameterIndex, Blob x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setBlob(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setBlob(this, parameterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public void setClob(int parameterIndex, Clob x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setClob(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setClob(this, parameterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public void setArray(int parameterIndex, Array x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setArray(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setArray(this, parameterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getMetaData();
        }
        return this.filterHead.PreparedStatement_getMetaData(this);
    }

    @Override
    @Deprecated
    public void setDate(int parameterIndex, java.sql.Date x2, Calendar cal) throws SQLException {
        if (this.filterHead == null) {
            this.do_setDate(parameterIndex, x2, cal);
        } else {
            this.filterHead.PreparedStatement_setDate(this, parameterIndex, x2, cal);
        }
    }

    @Override
    @Deprecated
    public void setTime(int parameterIndex, Time x2, Calendar cal) throws SQLException {
        if (this.filterHead == null) {
            this.do_setTime(parameterIndex, x2, cal);
        } else {
            this.filterHead.PreparedStatement_setTime(this, parameterIndex, x2, cal);
        }
    }

    @Override
    @Deprecated
    public void setTimestamp(int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        if (this.filterHead == null) {
            this.do_setTimestamp(parameterIndex, x2, cal);
        } else {
            this.filterHead.PreparedStatement_setTimestamp(this, parameterIndex, x2, cal);
        }
    }

    @Override
    @Deprecated
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        if (this.filterHead == null) {
            this.do_setNull(parameterIndex, sqlType, typeName);
        } else {
            this.filterHead.PreparedStatement_setNull(this, parameterIndex, sqlType, typeName);
        }
    }

    @Override
    @Deprecated
    public void setURL(int parameterIndex, URL x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setURL(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setURL(this, parameterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getParameterMetaData();
        }
        return this.filterHead.PreparedStatement_getParameterMetaData(this);
    }

    @Override
    @Deprecated
    public void setRowId(int parameterIndex, RowId x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setRowId(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setRowId(this, parameterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public void setNString(int parameterIndex, String value) throws SQLException {
        if (this.filterHead == null) {
            this.do_setNString(parameterIndex, value);
        } else {
            this.filterHead.PreparedStatement_setNString(this, parameterIndex, value);
        }
    }

    @Override
    @Deprecated
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        if (this.filterHead == null) {
            this.do_setNCharacterStream(parameterIndex, value, length);
        } else {
            this.filterHead.PreparedStatement_setNCharacterStream(this, parameterIndex, value, length);
        }
    }

    @Override
    @Deprecated
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        if (this.filterHead == null) {
            this.do_setNClob(parameterIndex, value);
        } else {
            this.filterHead.PreparedStatement_setNClob(this, parameterIndex, value);
        }
    }

    @Override
    @Deprecated
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.filterHead == null) {
            this.do_setClob(parameterIndex, reader, length);
        } else {
            this.filterHead.PreparedStatement_setClob(this, parameterIndex, reader, length);
        }
    }

    @Override
    @Deprecated
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (this.filterHead == null) {
            this.do_setBlob(parameterIndex, inputStream, length);
        } else {
            this.filterHead.PreparedStatement_setBlob(this, parameterIndex, inputStream, length);
        }
    }

    @Override
    @Deprecated
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.filterHead == null) {
            this.do_setNClob(parameterIndex, reader, length);
        } else {
            this.filterHead.PreparedStatement_setNClob(this, parameterIndex, reader, length);
        }
    }

    @Override
    @Deprecated
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        if (this.filterHead == null) {
            this.do_setSQLXML(parameterIndex, xmlObject);
        } else {
            this.filterHead.PreparedStatement_setSQLXML(this, parameterIndex, xmlObject);
        }
    }

    @Override
    @Deprecated
    public void setObject(int parameterIndex, Object x2, int targetSqlType, int scaleOrLength) throws SQLException {
        if (this.filterHead == null) {
            this.do_setObject(parameterIndex, x2, targetSqlType, scaleOrLength);
        } else {
            this.filterHead.PreparedStatement_setObject(this, parameterIndex, x2, targetSqlType, scaleOrLength);
        }
    }

    @Override
    @Deprecated
    public void setAsciiStream(int parameterIndex, InputStream x2, long length) throws SQLException {
        if (this.filterHead == null) {
            this.do_setAsciiStream(parameterIndex, x2, length);
        } else {
            this.filterHead.PreparedStatement_setAsciiStream(this, parameterIndex, x2, length);
        }
    }

    @Override
    @Deprecated
    public void setBinaryStream(int parameterIndex, InputStream x2, long length) throws SQLException {
        if (this.filterHead == null) {
            this.do_setBinaryStream(parameterIndex, x2, length);
        } else {
            this.filterHead.PreparedStatement_setBinaryStream(this, parameterIndex, x2, length);
        }
    }

    @Override
    @Deprecated
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.filterHead == null) {
            this.do_setCharacterStream(parameterIndex, reader, length);
        } else {
            this.filterHead.PreparedStatement_setCharacterStream(this, parameterIndex, reader, length);
        }
    }

    @Override
    @Deprecated
    public void setAsciiStream(int parameterIndex, InputStream x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setAsciiStream(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setAsciiStream(this, parameterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public void setBinaryStream(int parameterIndex, InputStream x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setBinaryStream(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setBinaryStream(this, parameterIndex, x2);
        }
    }

    @Override
    @Deprecated
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        if (this.filterHead == null) {
            this.do_setCharacterStream(parameterIndex, reader);
        } else {
            this.filterHead.PreparedStatement_setCharacterStream(this, parameterIndex, reader);
        }
    }

    @Override
    @Deprecated
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        if (this.filterHead == null) {
            this.do_setNCharacterStream(parameterIndex, value);
        } else {
            this.filterHead.PreparedStatement_setNCharacterStream(this, parameterIndex, value);
        }
    }

    @Override
    @Deprecated
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        if (this.filterHead == null) {
            this.do_setClob(parameterIndex, reader);
        } else {
            this.filterHead.PreparedStatement_setClob(this, parameterIndex, reader);
        }
    }

    @Override
    @Deprecated
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        if (this.filterHead == null) {
            this.do_setBlob(parameterIndex, inputStream);
        } else {
            this.filterHead.PreparedStatement_setBlob(this, parameterIndex, inputStream);
        }
    }

    @Override
    @Deprecated
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        if (this.filterHead == null) {
            this.do_setNClob(parameterIndex, reader);
        } else {
            this.filterHead.PreparedStatement_setNClob(this, parameterIndex, reader);
        }
    }

    @Override
    @Deprecated
    public void setObject(int parameterIndex, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        if (this.filterHead == null) {
            this.do_setObject(parameterIndex, x2, targetSqlType, scaleOrLength);
        } else {
            this.filterHead.PreparedStatement_setObject(this, parameterIndex, x2, targetSqlType, scaleOrLength);
        }
    }

    @Override
    @Deprecated
    public void setObject(int parameterIndex, Object x2, SQLType targetSqlType) throws SQLException {
        if (this.filterHead == null) {
            this.do_setObject(parameterIndex, x2, targetSqlType);
        } else {
            this.filterHead.PreparedStatement_setObject(this, parameterIndex, x2, targetSqlType);
        }
    }

    @Override
    @Deprecated
    public long executeLargeUpdate() throws SQLException {
        this.checkConnection();
        CallBack<Long> callback = new CallBack<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long run() throws SQLException {
                DmdbConnection dmdbConnection = DmdbPreparedStatement.this.connection;
                synchronized (dmdbConnection) {
                    if (DmdbPreparedStatement.this.filterHead == null) {
                        return DmdbPreparedStatement.this.do_executeLargeUpdate();
                    }
                    return DmdbPreparedStatement.this.filterHead.PreparedStatement_executeLargeUpdate(DmdbPreparedStatement.this);
                }
            }
        };
        if (this.connection.highConcurrency) {
            return this.execute(callback);
        }
        return (Long)callback.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCompile(String sql) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_preCompile(sql);
            } else {
                this.filterHead.PreparedStatement_preCompile(this, sql);
            }
        }
    }

    public void do_preCompile(String sql) throws SQLException {
        try {
            this.beforeExecute();
            this.prepareSql(sql);
        }
        finally {
            this.afterExecute();
        }
    }

    public void executeDirect() throws SQLException {
        this.execute();
    }

    public void setINTERVALDT(int parameterIndex, DmdbIntervalDT x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setINTERVALDT(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setINTERVALDT(this, parameterIndex, x2);
        }
    }

    public void do_setINTERVALDT(int parameterIndex, DmdbIntervalDT x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterIndex, 1111);
            return;
        }
        int iparam = this.bindInParam(parameterIndex, 21, false);
        if (this.bindParameters[iparam].typeFlag != 1) {
            this.bindParameters[iparam].scale = x2.getScaleForSvr();
        }
        this.curRowDatas[iparam] = J2DB.fromDmdbIntervalDT(x2, this.bindParameters[iparam], this.connection);
    }

    public void setINTERVALYM(int parameterIndex, DmdbIntervalYM x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setINTERVALYM(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setINTERVALYM(this, parameterIndex, x2);
        }
    }

    public void do_setINTERVALYM(int parameterIndex, DmdbIntervalYM x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterIndex, 1111);
            return;
        }
        int iparam = this.bindInParam(parameterIndex, 20, false);
        if (this.bindParameters[iparam].typeFlag != 1) {
            this.bindParameters[iparam].scale = x2.getScaleForSvr();
        }
        this.curRowDatas[iparam] = J2DB.fromDmdbIntervalYM(x2, this.bindParameters[iparam], this.connection);
    }

    public void setTIMESTAMP(int parameterIndex, DmdbTimestamp x2) throws SQLException {
        if (this.filterHead == null) {
            this.do_setTIMESTAMP(parameterIndex, x2);
        } else {
            this.filterHead.PreparedStatement_setTIMESTAMP(this, parameterIndex, x2);
        }
    }

    public void do_setTIMESTAMP(int parameterIndex, DmdbTimestamp x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterIndex, 93);
            return;
        }
        int iparam = this.bindInParam(parameterIndex, x2.dtype, false);
        this.curRowDatas[iparam] = J2DB.fromDmdbTimestamp(x2, this.bindParameters[iparam], this.connection);
    }

    public Parameter[] getParameters() {
        return this.serverParameters;
    }

    public int getBatchSize() {
        return this.irow > 0 ? this.irow : 0;
    }

    @Override
    public void resetParams(DmdbStatement srcStmt) throws SQLException {
        super.resetParams(srcStmt);
        if (srcStmt instanceof DmdbPreparedStatement) {
            DmdbPreparedStatement srcPstmt = (DmdbPreparedStatement)srcStmt;
            this.nativeSql = srcPstmt.nativeSql;
            boolean hasBind = false;
            int i2 = 0;
            while (i2 < this.paramCount) {
                if (this.bindParameters[i2] != null) {
                    this.bindParameters[i2].clear();
                }
                ++i2;
            }
            this.bindParameters = new Parameter[srcPstmt.bindParameters.length];
            i2 = 0;
            while (i2 < this.paramCount) {
                this.bindParameters[i2] = srcPstmt.bindParameters[i2].clone(this.connection, srcPstmt);
                if (!hasBind && this.bindParameters[i2].ioType != -1) {
                    hasBind = true;
                }
                ++i2;
            }
            if (hasBind) {
                this.irow = srcPstmt.irow;
                this.curRowDatas = Arrays.copyOf(srcPstmt.curRowDatas, srcPstmt.curRowDatas.length);
                this.multiRowDatas.clear();
                this.multiRowDatas.addAll(srcPstmt.multiRowDatas);
                this.toBeLockedConnections.clear();
                this.toBeLockedConnections.addAll(srcPstmt.toBeLockedConnections);
            }
        }
    }

    public static class SyncConnectionCallBack<T>
    extends CallBack<T> {
        private CallBack<T> parent;
        private DmdbConnection conn;

        public SyncConnectionCallBack(CallBack<T> parent, DmdbConnection conn) {
            this.parent = parent;
            this.conn = conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T run() throws SQLException {
            DmdbConnection dmdbConnection = this.conn;
            synchronized (dmdbConnection) {
                if (this.parent != null) {
                    return this.parent.run();
                }
                return null;
            }
        }
    }
}

