/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbOutputStream;
import dm.jdbc.driver.DmdbReader;
import dm.jdbc.driver.DmdbWriter;
import dm.jdbc.internal.AbstractLob;
import dm.jdbc.internal.desc.Column;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbClob
extends AbstractLob
implements Serializable,
Clob {
    public String data = "";
    public Charset serverEncoding = null;
    public static AtomicLong IDGenerator = new AtomicLong(0L);

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = IDGenerator.incrementAndGet();
        }
        return this.ID;
    }

    protected DmdbClob(byte[] value, DmdbConnection conn, Column column, boolean fetchAll) throws SQLException {
        super(value, (byte)1, conn, column);
        this.serverEncoding = conn.getServerEncoding();
        if (this.storageType == 1 || value != null && (long)value.length == (long)this.getHeadSize() + this.bytesLength) {
            int headSize = this.getHeadSize();
            this.data = ByteUtil.getString(value, headSize, (int)this.bytesLength, this.serverEncoding);
            this.length = this.data.length();
            if (this.connection.lobFetchOptimize) {
                this.optimizeFetchAll = true;
            }
        } else if (fetchAll) {
            this.loadAllData();
        }
    }

    protected DmdbClob(String data, DmdbConnection connection) {
        super((byte)0, connection);
        this.serverEncoding = connection.getServerEncoding();
        this.data = data;
        this.length = this.data.length();
    }

    public static DmdbClob newInstance(byte[] data, DmdbConnection conn, Column column, boolean fetchAll) throws SQLException {
        return new DmdbClob(data, conn, column, fetchAll);
    }

    public static DmdbClob newInstance(String data, DmdbConnection connection) {
        return new DmdbClob(data, connection);
    }

    public static DmdbClob getEmptyClob() {
        try {
            DmdbClob clob = new DmdbClob("", new DmdbConnection(null));
            clob.empty = true;
            return clob;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String do_getSubString(long pos, int len) throws SQLException {
        long leaveLength;
        this.checkFreed();
        if (pos < 1L || len < 0) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        if ((leaveLength = this.do_length() - --pos) < 0L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        len = (int)((long)len > leaveLength ? leaveLength : (long)len);
        if (this.local || this.storageType == 1 || this.fetchAll || this.optimizeFetchAll) {
            if (pos > this.do_length()) {
                DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
            }
            return this.data.substring((int)pos, (int)pos + len);
        }
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            return this.connection.dbAccess.a(this, pos, len);
        }
    }

    public DmdbReader do_getCharacterStream() throws SQLException {
        this.checkFreed();
        return new DmdbReader(this);
    }

    public DmdbInputStream do_getAsciiStream() throws SQLException {
        this.checkFreed();
        return new DmdbInputStream(this, 2);
    }

    public DmdbInputStream do_getBinaryStream() throws SQLException {
        this.checkFreed();
        return new DmdbInputStream(this, 1);
    }

    public long do_position(String searchstr, long start) throws SQLException {
        long indexOf;
        this.checkFreed();
        if (start < 1L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        if (StringUtil.isEmpty(searchstr)) {
            return -1L;
        }
        if (this.local || this.storageType == 1 || this.fetchAll) {
            if ((long)searchstr.length() > this.do_length() - start + 1L) {
                return -1L;
            }
            indexOf = this.data.indexOf(searchstr, (int)start);
        } else {
            String valStr = this.do_getSubString(start, (int)(this.do_length() - start + 1L));
            if (valStr.length() < searchstr.length()) {
                return -1L;
            }
            indexOf = valStr.indexOf(searchstr);
        }
        if (indexOf >= 0L) {
            ++indexOf;
        }
        return indexOf;
    }

    public long do_position(Clob searchstr, long start) throws SQLException {
        return this.do_position(searchstr.getSubString(1L, (int)searchstr.length()), start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int do_setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkFreed();
        if (pos < 1L || offset < 0 || len < 0 || offset + len > str.length()) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        if (!this.updateable) {
            DBError.ECJDBC_RESULTSET_IS_READ_ONLY.throwz(new Object[0]);
        }
        str = str.substring(offset, offset + len);
        --pos;
        int retLen = 0;
        if (this.local || this.fetchAll) {
            if (pos > this.do_length()) {
                DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
            }
            this.setLocalData((int)pos, str);
            retLen = str.length();
        } else {
            this.checkConnection();
            DmdbConnection dmdbConnection = this.connection;
            synchronized (dmdbConnection) {
                int writeLen = this.connection.dbAccess.a(this, pos, str, this.serverEncoding);
                if (this.storageType == 1) {
                    this.setLocalData((int)pos, str);
                }
                retLen = writeLen;
            }
        }
        this.modify = true;
        this.optimizeFetchAll = false;
        return retLen;
    }

    public int do_setString(long pos, String str) throws SQLException {
        if (str == null) {
            return this.do_setString(pos, "", 0, 0);
        }
        return this.do_setString(pos, str, 0, str.length());
    }

    public DmdbOutputStream do_setAsciiStream(long pos) throws SQLException {
        this.checkFreed();
        if (this.connection.compatibleOracle() && pos == 0L) {
            pos = 1L;
        }
        if (pos < 1L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        return new DmdbOutputStream(this, pos, 2);
    }

    @Deprecated
    public DmdbOutputStream getAsciiOutputStream() throws SQLException {
        return this.do_setAsciiStream(1L);
    }

    @Deprecated
    public DmdbOutputStream getAsciiOutputStream(long pos) throws SQLException {
        return this.do_setAsciiStream(pos);
    }

    public DmdbWriter do_setCharacterStream(long pos) throws SQLException {
        this.checkFreed();
        if (this.connection.compatibleOracle() && pos == 0L) {
            pos = 1L;
        }
        if (pos < 1L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        return new DmdbWriter(this, pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void do_truncate(long len) throws SQLException {
        this.checkFreed();
        if (len < 0L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        if (!this.updateable) {
            DBError.ECJDBC_RESULTSET_IS_READ_ONLY.throwz(new Object[0]);
        }
        if (this.local || this.fetchAll) {
            if (len > this.do_length()) {
                return;
            }
            this.data = this.data.substring(0, (int)len);
            this.length = this.data.length();
        } else {
            this.checkConnection();
            DmdbConnection dmdbConnection = this.connection;
            synchronized (dmdbConnection) {
                this.length = this.connection.dbAccess.a(this, len);
                if (this.storageType == 1) {
                    this.data = this.data.substring(0, (int)this.length);
                }
            }
        }
        this.modify = true;
        this.optimizeFetchAll = false;
    }

    @Override
    public void do_free() throws SQLException {
        super.do_free();
        this.data = null;
    }

    public DmdbReader do_getCharacterStream(long pos, long length) throws SQLException {
        this.checkFreed();
        return new DmdbReader(this, pos, length);
    }

    @Override
    protected void loadAllData() throws SQLException {
        this.checkFreed();
        if (this.local || this.storageType == 1 || this.fetchAll || this.optimizeFetchAll) {
            return;
        }
        this.data = this.do_getSubString(1L, (int)this.do_length());
        this.length = this.data.length();
        this.fetchAll = true;
    }

    private void setLocalData(int pos, String str) throws SQLException {
        this.data = (long)(pos + str.length()) >= this.length ? String.valueOf(this.data.substring(0, pos)) + str : String.valueOf(this.data.substring(0, pos)) + str + this.data.substring(pos + str.length(), this.data.length());
        this.length = this.data.length();
    }

    public byte[] getBytes(long pos, int len) throws SQLException {
        String str = this.do_getSubString(pos, len);
        return ByteUtil.fromString(str, this.serverEncoding);
    }

    @Override
    @Deprecated
    public long length() throws SQLException {
        if (this.filterHead == null) {
            return this.do_length();
        }
        return this.filterHead.Clob_length(this);
    }

    @Override
    @Deprecated
    public String getSubString(long pos, int length) throws SQLException {
        if (this.filterHead == null) {
            return this.do_getSubString(pos, length);
        }
        return this.filterHead.Clob_getSubString(this, pos, length);
    }

    @Override
    @Deprecated
    public Reader getCharacterStream() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getCharacterStream();
        }
        return this.filterHead.Clob_getCharacterStream(this);
    }

    @Override
    @Deprecated
    public InputStream getAsciiStream() throws SQLException {
        if (this.filterHead == null) {
            return this.do_getAsciiStream();
        }
        return this.filterHead.Clob_getAsciiStream(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public long position(String searchstr, long start) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                return this.do_position(searchstr, start);
            }
            return this.filterHead.Clob_position(this, searchstr, start);
        }
    }

    @Override
    @Deprecated
    public long position(Clob searchstr, long start) throws SQLException {
        if (this.filterHead == null) {
            return this.do_position(searchstr, start);
        }
        return this.filterHead.Clob_position(this, searchstr, start);
    }

    @Override
    @Deprecated
    public int setString(long pos, String str) throws SQLException {
        if (this.filterHead == null) {
            return this.do_setString(pos, str);
        }
        return this.filterHead.Clob_setString(this, pos, str);
    }

    @Override
    @Deprecated
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        if (this.filterHead == null) {
            return this.do_setString(pos, str, offset, len);
        }
        return this.filterHead.Clob_setString(this, pos, str, offset, len);
    }

    @Override
    @Deprecated
    public OutputStream setAsciiStream(long pos) throws SQLException {
        if (this.filterHead == null) {
            return this.do_setAsciiStream(pos);
        }
        return this.filterHead.Clob_setAsciiStream(this, pos);
    }

    @Override
    @Deprecated
    public Writer setCharacterStream(long pos) throws SQLException {
        if (this.filterHead == null) {
            return this.do_setCharacterStream(pos);
        }
        return this.filterHead.Clob_setCharacterStream(this, pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void truncate(long len) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterHead == null) {
                this.do_truncate(len);
            } else {
                this.filterHead.Clob_truncate(this, len);
            }
        }
    }

    @Override
    @Deprecated
    public void free() throws SQLException {
        if (this.filterHead == null) {
            this.do_free();
        } else {
            this.filterHead.Clob_free(this);
        }
    }

    @Override
    @Deprecated
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        if (this.filterHead == null) {
            return this.do_getCharacterStream(pos, length);
        }
        return this.filterHead.Clob_getCharacterStream(this, pos, length);
    }
}

