/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.internal.desc.Column;
import java.sql.SQLException;
import java.util.List;

public class DmdbCachedResultSet
extends DmdbResultSet {
    public List<byte[][][]> cachedDatas;
    public byte[][][] curCachedData;
    public int curCachedDataIndex;

    protected DmdbCachedResultSet(DmdbStatement stmt, Column[] columns, byte[][][] datas) throws SQLException {
        super(stmt, columns, datas);
    }

    public DmdbCachedResultSet(DmdbStatement stmt, List<byte[][][]> cachedDatas) throws SQLException {
        super(stmt, stmt.columns, null);
        this.cachedDatas = cachedDatas;
        this.totalRowCount = 0L;
        for (byte[][][] data : cachedDatas) {
            this.totalRowCount += (long)data.length;
        }
        if (!cachedDatas.isEmpty()) {
            this.curCachedDataIndex = 0;
            this.curCachedData = cachedDatas.get(this.curCachedDataIndex);
        }
    }

    public static DmdbCachedResultSet newLocalResultSet(DmdbStatement stmt, List<byte[][][]> datas) throws SQLException {
        return new DmdbCachedResultSet(stmt, datas);
    }

    public static DmdbCachedResultSet newEmptyResultSet(DmdbStatement stmt) throws SQLException {
        return new DmdbCachedResultSet(stmt, null, null);
    }

    @Override
    public void do_close() throws SQLException {
        this.closed = true;
        if (this.statement != null && this.statement.openedResultSets != null && this.statement.openedResultSets.contains(this)) {
            this.statement.openedResultSets.remove(this);
        }
        if (this.statement != null && this.statement.do_isCloseOnCompletion() && (this.statement.openedResultSets == null || this.statement.openedResultSets.size() == 0) && (this.statement.curResultSet == null || this.statement.curResultSet.closed)) {
            this.statement.do_close();
        }
        this.statement = null;
        this.columns = null;
        this.datas = null;
        this.cachedDatas = null;
        this.insertRow = null;
        this.insertRowBindIndicator = null;
        this.updateRow = null;
        this.updateRowBindIndicator = null;
    }

    @Override
    public void do_beforeFirst() throws SQLException {
        this.checkClosed();
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwz(new Object[0]);
        }
        this.currentPos = -1L;
        this.curCachedDataIndex = 0;
        this.curCachedData = this.cachedDatas.get(this.curCachedDataIndex);
        this.datasOffset = -1;
    }

    @Override
    public void do_afterLast() throws SQLException {
        this.checkClosed();
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwz(new Object[0]);
        }
        this.currentPos = this.totalRowCount;
        if (!this.cachedDatas.isEmpty()) {
            this.curCachedDataIndex = this.cachedDatas.size() - 1;
            this.curCachedData = this.cachedDatas.get(this.curCachedDataIndex);
            this.datasOffset = this.curCachedData.length;
        }
    }

    @Override
    public boolean do_absolute(int row) throws SQLException {
        this.checkClosed();
        if (row == 0) {
            DBError.ECJDBC_INVALUID_ROW_NUMBER.throwz(new Object[0]);
        }
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwz(new Object[0]);
        }
        long destRow = row;
        destRow = row < 0 ? this.totalRowCount + (long)row : --destRow;
        long begin = this.currentPos - (long)this.datasOffset;
        long end = begin + (long)this.curCachedData.length - 1L;
        if (begin <= destRow && destRow <= end) {
            this.currentPos = destRow;
            this.datasOffset = (int)(this.currentPos - begin);
            return true;
        }
        if (0L <= destRow && destRow < this.totalRowCount) {
            this.curCachedDataIndex = 0;
            this.curCachedData = this.cachedDatas.get(this.curCachedDataIndex);
            while (destRow >= (long)this.curCachedData.length) {
                destRow -= (long)this.curCachedData.length;
                ++this.curCachedDataIndex;
                this.curCachedData = this.cachedDatas.get(this.curCachedDataIndex);
            }
            this.datasOffset = (int)destRow;
            return true;
        }
        if (row > 0) {
            this.currentPos = this.totalRowCount;
            this.curCachedDataIndex = this.cachedDatas.size() - 1;
            this.curCachedData = this.cachedDatas.get(this.curCachedDataIndex);
            this.datasOffset = this.curCachedData.length;
        } else {
            this.currentPos = -1L;
            this.curCachedDataIndex = 0;
            this.curCachedData = this.cachedDatas.get(this.curCachedDataIndex);
            this.datasOffset = -1;
        }
        return false;
    }

    @Override
    public boolean do_next() throws SQLException {
        this.checkClosed();
        if (this.totalRowCount == 0L) {
            return false;
        }
        if (this.currentPos >= this.totalRowCount) {
            return false;
        }
        if (this.currentPos == this.totalRowCount - 1L) {
            ++this.currentPos;
            ++this.datasOffset;
            return false;
        }
        if (this.datasOffset + 1 < this.curCachedData.length) {
            ++this.datasOffset;
        } else {
            ++this.curCachedDataIndex;
            this.curCachedData = this.cachedDatas.get(this.curCachedDataIndex);
            this.datasOffset = 0;
        }
        ++this.currentPos;
        return true;
    }

    @Override
    public boolean do_previous() throws SQLException {
        this.checkClosed();
        if (this.type == 1003) {
            DBError.ECJDBC_INVALID_RESULTSET_TYPE.throwz(new Object[0]);
        }
        if (this.totalRowCount == 0L) {
            return false;
        }
        if (this.currentPos <= -1L) {
            return false;
        }
        --this.currentPos;
        --this.datasOffset;
        if (this.datasOffset == -1) {
            if (this.currentPos == -1L) {
                return false;
            }
            --this.curCachedDataIndex;
            this.curCachedData = this.cachedDatas.get(this.curCachedDataIndex);
            this.datasOffset = this.curCachedData.length - 1;
        }
        return true;
    }

    @Override
    public boolean fetchData(long startPos) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public byte[] getColumnData(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkCurrentRow();
        this.checkColumnIndex(columnIndex);
        byte[] data = this.curCachedData[this.datasOffset][columnIndex];
        this.wasNull = data == null;
        this.columns[columnIndex - 1].isBdta = this.bdta;
        return data;
    }

    @Override
    public void do_insertRow() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void do_updateRow() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void do_deleteRow() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void do_refreshRow() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void do_cancelRowUpdates() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void do_moveToInsertRow() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void do_moveToCurrentRow() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }
}

