/*
 * Decompiled with CFR 0.152.
 */
package dm.sql;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;

public class DmdbIntervalDT
implements Cloneable {
    public static final byte QUA_D = 3;
    public static final byte QUA_DH = 4;
    public static final byte QUA_DHM = 5;
    public static final byte QUA_DHMS = 6;
    public static final byte QUA_H = 7;
    public static final byte QUA_HM = 8;
    public static final byte QUA_HMS = 9;
    public static final byte QUA_M = 10;
    public static final byte QUA_MS = 11;
    public static final byte QUA_S = 12;
    private byte[] dt = new byte[24];
    public byte type = (byte)3;
    private int loadPrec = 2;
    private boolean isLoadPrecSet = false;
    private int secPrec = 6;
    private boolean isSecPrecSet = false;
    private boolean m_negative = false;
    public int days = 0;
    public int hours = 0;
    public int minutes = 0;
    public int seconds = 0;
    public int fraction = 0;
    private int precForSvr = 0;

    public final Object clone() {
        DmdbIntervalDT o = null;
        try {
            o = (DmdbIntervalDT)super.clone();
            if (this.dt != null) {
                o.dt = (byte[])this.dt.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return o;
    }

    public int hashCode() {
        return this.getDTString().hashCode();
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof DmdbIntervalDT) {
            DmdbIntervalDT tm = (DmdbIntervalDT)o;
            if (tm.type == this.type) {
                switch (this.type) {
                    case 3: {
                        if (this.days != tm.days) break;
                        return true;
                    }
                    case 4: {
                        if (this.days != tm.days || this.hours != tm.hours) break;
                        return true;
                    }
                    case 5: {
                        if (this.days != tm.days || this.hours != tm.hours || this.minutes != tm.minutes) break;
                        return true;
                    }
                    case 6: {
                        if (this.days != tm.days || this.hours != tm.hours || this.minutes != tm.minutes || this.seconds != tm.seconds || !this.getMsecString().equals(tm.getMsecString())) break;
                        return true;
                    }
                    case 7: {
                        if (this.hours != tm.hours) break;
                        return true;
                    }
                    case 8: {
                        if (this.hours != tm.hours || this.minutes != tm.minutes) break;
                        return true;
                    }
                    case 9: {
                        if (this.hours != tm.hours || this.minutes != tm.minutes || this.seconds != tm.seconds || !this.getMsecString().equals(tm.getMsecString())) break;
                        return true;
                    }
                    case 10: {
                        if (this.minutes != tm.minutes) break;
                        return true;
                    }
                    case 11: {
                        if (this.minutes != tm.minutes || this.seconds != tm.seconds || !this.getMsecString().equals(tm.getMsecString())) break;
                        return true;
                    }
                    case 12: {
                        if (this.seconds != tm.seconds || !this.getMsecString().equals(tm.getMsecString())) break;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public int getPrecForSvr() {
        return this.precForSvr;
    }

    public DmdbIntervalDT(byte[] interval, int loadPre, int secPre) {
        this.reset(interval, loadPre, secPre);
    }

    public void reset(byte[] interval, int loadPre, int secPre) {
        this.dt = interval;
        this.loadPrec = loadPre;
        this.secPrec = secPre;
        this.type = this.dt[21];
        switch (this.type) {
            case 3: {
                this.days = this.decodeDay();
                break;
            }
            case 4: {
                this.days = this.decodeDay();
                this.hours = this.decodeHour();
                break;
            }
            case 5: {
                this.days = this.decodeDay();
                this.hours = this.decodeHour();
                this.minutes = this.decodeMinute();
                break;
            }
            case 6: {
                this.days = this.decodeDay();
                this.hours = this.decodeHour();
                this.minutes = this.decodeMinute();
                this.seconds = this.decodeSecond();
                this.fraction = this.decodeMsec();
                break;
            }
            case 7: {
                this.hours = this.decodeHour();
                break;
            }
            case 8: {
                this.hours = this.decodeHour();
                this.minutes = this.decodeMinute();
                break;
            }
            case 9: {
                this.hours = this.decodeHour();
                this.minutes = this.decodeMinute();
                this.seconds = this.decodeSecond();
                this.fraction = this.decodeMsec();
                break;
            }
            case 10: {
                this.minutes = this.decodeMinute();
                break;
            }
            case 11: {
                this.minutes = this.decodeMinute();
                this.seconds = this.decodeSecond();
                this.fraction = this.decodeMsec();
                break;
            }
            case 12: {
                this.seconds = this.decodeSecond();
                this.fraction = this.decodeMsec();
            }
        }
        this.precForSvr = Convertion.getInt(this.dt, 20);
    }

    public DmdbIntervalDT(String str) throws SQLException {
        this.parseIntervDTString(str);
    }

    public DmdbIntervalDT(String str, int loadPre, int secPre) throws SQLException {
        this.loadPrec = loadPre;
        this.secPrec = secPre;
        this.isLoadPrecSet = true;
        this.isSecPrecSet = true;
        this.parseIntervDTString(str);
    }

    private void setDay(String value) {
        this.type = (byte)3;
        value = value.substring(1, value.length() - 1);
        int i = Integer.parseInt(value);
        if (this.m_negative) {
            i *= -1;
        }
        this.days = i;
    }

    private void setHour(String value) {
        this.type = (byte)7;
        value = value.substring(1, value.length() - 1);
        int i = Integer.parseInt(value);
        if (this.m_negative) {
            i *= -1;
        }
        this.hours = i;
    }

    private void setMinute(String value) throws SQLException {
        this.type = (byte)10;
        value = value.substring(1, value.length() - 1);
        int i = Integer.parseInt(value);
        if (this.m_negative) {
            i *= -1;
        }
        this.minutes = i;
    }

    private void setSecond(String value) {
        this.type = (byte)12;
        value = value.substring(1, value.length() - 1);
        String[] list = StringUtil.split(value, ".");
        int i = Integer.parseInt(list[0]);
        if (this.m_negative) {
            i *= -1;
        }
        int nano = 0;
        if (list.length > 1) {
            StringBuffer strNano = new StringBuffer(10);
            strNano.append("0");
            strNano.append(".");
            strNano.append(list[1]);
            double d_v = Double.valueOf(strNano.toString());
            int nx = (int)Math.pow(10.0, this.secPrec);
            nano = (int)(d_v * (double)nx);
        }
        this.seconds = i;
        this.fraction = nano;
    }

    private void setHourToSecond(String value) {
        this.type = (byte)9;
        value = value.substring(1, value.length() - 1);
        String[] list = StringUtil.split(value, ":.");
        int h = Integer.parseInt(list[0]);
        if (this.m_negative) {
            h *= -1;
        }
        int m = Integer.parseInt(list[1]);
        int s = Integer.parseInt(list[2]);
        int nano = 0;
        if (list.length > 3) {
            StringBuffer strNano = new StringBuffer(10);
            strNano.append("0");
            strNano.append(".");
            strNano.append(list[3]);
            double d_v = Double.valueOf(strNano.toString());
            int nx = (int)Math.pow(10.0, this.secPrec);
            nano = (int)(d_v * (double)nx);
        }
        this.hours = h;
        this.minutes = m;
        this.seconds = s;
        this.fraction = nano;
    }

    private void setHourToMinute(String value) {
        this.type = (byte)8;
        value = value.substring(1, value.length() - 1);
        String[] list = StringUtil.split(value, ":");
        int h = Integer.parseInt(list[0]);
        if (this.m_negative) {
            h *= -1;
        }
        int m = Integer.parseInt(list[1]);
        this.hours = h;
        this.minutes = m;
    }

    private void setMinuteToSecond(String value) throws SQLException {
        this.type = (byte)11;
        value = value.substring(1, value.length() - 1);
        String[] list = StringUtil.split(value, ":.");
        int m = Integer.parseInt(list[0]);
        if (this.m_negative) {
            m *= -1;
        }
        int s = Integer.parseInt(list[1]);
        int nano = 0;
        if (list.length > 2) {
            StringBuffer strNano = new StringBuffer(10);
            strNano.append("0");
            strNano.append(".");
            strNano.append(list[2]);
            double d_v = Double.valueOf(strNano.toString());
            int nx = (int)Math.pow(10.0, this.secPrec);
            nano = (int)(d_v * (double)nx);
        }
        this.minutes = m;
        this.seconds = s;
        this.fraction = nano;
    }

    private void setDayToHour(String value) {
        this.type = (byte)4;
        value = value.substring(1, value.length() - 1);
        String[] list = StringUtil.split(value, " ");
        int d = Integer.parseInt(list[0]);
        if (this.m_negative) {
            d *= -1;
        }
        int h = Integer.parseInt(list[1]);
        this.days = d;
        this.hours = h;
    }

    private void setDayToMinute(String value) {
        this.type = (byte)5;
        value = value.substring(1, value.length() - 1);
        String[] list = StringUtil.split(value, ": ");
        int d = Integer.parseInt(list[0]);
        if (this.m_negative) {
            d *= -1;
        }
        int h = Integer.parseInt(list[1]);
        int m = Integer.parseInt(list[2]);
        this.days = d;
        this.hours = h;
        this.minutes = m;
    }

    private void setDayToSecond(String value) {
        this.type = (byte)6;
        value = value.substring(1, value.length() - 1);
        String[] list = StringUtil.split(value, ": .");
        int d = Integer.parseInt(list[0]);
        if (this.m_negative) {
            d *= -1;
        }
        int h = Integer.parseInt(list[1]);
        int m = Integer.parseInt(list[2]);
        int s = Integer.parseInt(list[3]);
        int nano = 0;
        if (list.length > 4) {
            StringBuffer strNano = new StringBuffer(10);
            strNano.append("0");
            strNano.append(".");
            strNano.append(list[4]);
            double d_v = Double.valueOf(strNano.toString());
            int nx = (int)Math.pow(10.0, this.secPrec);
            nano = (int)(d_v * (double)nx);
        }
        this.days = d;
        this.hours = h;
        this.minutes = m;
        this.seconds = s;
        this.fraction = nano;
    }

    private int decodeDay() {
        byte[] bs = new byte[4];
        System.arraycopy(this.dt, 0, bs, 0, 4);
        int i = Convertion.fourByteToInt(bs);
        return i;
    }

    public final int getDay() {
        return this.days;
    }

    public final int getHour() {
        return this.hours;
    }

    private int decodeHour() {
        byte[] bs = new byte[4];
        System.arraycopy(this.dt, 4, bs, 0, 4);
        int i = Convertion.fourByteToInt(bs);
        return i;
    }

    public final int getMinute() {
        return this.minutes;
    }

    private int decodeMinute() {
        byte[] bs = new byte[4];
        System.arraycopy(this.dt, 8, bs, 0, 4);
        int i = Convertion.fourByteToInt(bs);
        return i;
    }

    public final int getSecond() {
        return this.seconds;
    }

    private int decodeSecond() {
        byte[] bs = new byte[4];
        System.arraycopy(this.dt, 12, bs, 0, 4);
        int i = Convertion.fourByteToInt(bs);
        return i;
    }

    public final int getMsec() {
        return this.fraction;
    }

    private int decodeMsec() {
        byte[] bs = new byte[4];
        System.arraycopy(this.dt, 16, bs, 0, 4);
        int tmp = Convertion.fourByteToInt(bs);
        return tmp;
    }

    public final byte getDTType() {
        return this.type;
    }

    public final int getSecPrec() {
        return this.secPrec;
    }

    public final int getLoadPrec() {
        return this.loadPrec;
    }

    public final int abs(int i) {
        if (i < 0) {
            i = -i;
        }
        return i;
    }

    public final String getDTString() {
        String interval = "INTERVAL ";
        switch (this.type) {
            case 3: {
                String dStr = String.valueOf(this.abs(this.days));
                if (this.days < 0) {
                    interval = interval + "-";
                }
                if (dStr.length() < this.loadPrec) {
                    int len = dStr.length();
                    int destLen = this.loadPrec;
                    while (destLen-- > len) {
                        dStr = "0" + dStr;
                    }
                }
                interval = interval + "'" + dStr + "' DAY(" + this.loadPrec + ")";
                break;
            }
            case 4: {
                String dStr = String.valueOf(this.abs(this.days));
                String hStr = String.valueOf(this.abs(this.hours));
                if (this.days < 0 || this.hours < 0) {
                    interval = interval + "-";
                }
                if (dStr.length() < this.loadPrec) {
                    int len = dStr.length();
                    int destLen = this.loadPrec;
                    while (destLen-- > len) {
                        dStr = "0" + dStr;
                    }
                }
                if (hStr.length() < 2) {
                    hStr = "0" + hStr;
                }
                interval = interval + "'" + dStr + " " + hStr + "' DAY(" + this.loadPrec + ") TO HOUR";
                break;
            }
            case 5: {
                String dStr = String.valueOf(this.abs(this.days));
                String hStr = String.valueOf(this.abs(this.hours));
                String mStr = String.valueOf(this.abs(this.minutes));
                if (this.days < 0 || this.days < 0 || this.minutes < 0) {
                    interval = interval + "-";
                }
                if (dStr.length() < this.loadPrec) {
                    int len = dStr.length();
                    int destLen = this.loadPrec;
                    while (destLen-- > len) {
                        dStr = "0" + dStr;
                    }
                }
                if (hStr.length() < 2) {
                    hStr = "0" + hStr;
                }
                if (mStr.length() < 2) {
                    mStr = "0" + mStr;
                }
                interval = interval + "'" + dStr + " " + hStr + ":" + mStr + "' DAY(" + this.loadPrec + ") TO MINUTE";
                break;
            }
            case 6: {
                String dStr = String.valueOf(this.abs(this.days));
                String hStr = String.valueOf(this.abs(this.hours));
                String mStr = String.valueOf(this.abs(this.minutes));
                String sStr = String.valueOf(this.abs(this.seconds));
                String nStr = this.getMsecString();
                if (this.days < 0 || this.hours < 0 || this.minutes < 0 || this.seconds < 0 || this.fraction < 0) {
                    interval = interval + "-";
                }
                if (dStr.length() < this.loadPrec) {
                    int len = dStr.length();
                    int destLen = this.loadPrec;
                    while (destLen-- > len) {
                        dStr = "0" + dStr;
                    }
                }
                if (hStr.length() < 2) {
                    hStr = "0" + hStr;
                }
                if (mStr.length() < 2) {
                    mStr = "0" + mStr;
                }
                if (sStr.length() < 2) {
                    sStr = "0" + sStr;
                }
                interval = interval + "'" + dStr + " " + hStr + ":" + mStr + ":" + sStr + (StringUtil.isNotEmpty(nStr) ? "." + nStr : "") + "' DAY(" + this.loadPrec + ") TO SECOND(" + this.secPrec + ")";
                break;
            }
            case 7: {
                String hStr = String.valueOf(this.abs(this.hours));
                if (this.hours < 0) {
                    interval = interval + "-";
                }
                if (hStr.length() < this.loadPrec) {
                    int len = hStr.length();
                    int destLen = this.loadPrec;
                    while (destLen-- > len) {
                        hStr = "0" + hStr;
                    }
                }
                interval = interval + "'" + hStr + "' HOUR(" + this.loadPrec + ")";
                break;
            }
            case 8: {
                String hStr = String.valueOf(this.abs(this.hours));
                String mStr = String.valueOf(this.abs(this.minutes));
                if (this.hours < 0 || this.minutes < 0) {
                    interval = interval + "-";
                }
                if (hStr.length() < this.loadPrec) {
                    int len = hStr.length();
                    int destLen = this.loadPrec;
                    while (destLen-- > len) {
                        hStr = "0" + hStr;
                    }
                }
                if (mStr.length() < 2) {
                    mStr = "0" + mStr;
                }
                interval = interval + "'" + hStr + ":" + mStr + "' HOUR(" + this.loadPrec + ") TO MINUTE";
                break;
            }
            case 9: {
                String nStr = this.getMsecString();
                String hStr = String.valueOf(this.abs(this.hours));
                String mStr = String.valueOf(this.abs(this.minutes));
                String sStr = String.valueOf(this.abs(this.seconds));
                if (this.hours < 0 || this.minutes < 0 || this.seconds < 0 || this.fraction < 0) {
                    interval = interval + "-";
                }
                if (hStr.length() < this.loadPrec) {
                    int len = hStr.length();
                    int destLen = this.loadPrec;
                    while (destLen-- > len) {
                        hStr = "0" + hStr;
                    }
                }
                if (mStr.length() < 2) {
                    mStr = "0" + mStr;
                }
                if (sStr.length() < 2) {
                    sStr = "0" + sStr;
                }
                interval = interval + "'" + hStr + ":" + mStr + ":" + sStr + (StringUtil.isNotEmpty(nStr) ? "." + nStr : "") + "' HOUR(" + this.loadPrec + ") TO SECOND(" + this.secPrec + ")";
                break;
            }
            case 10: {
                String mStr = String.valueOf(this.abs(this.minutes));
                if (this.minutes < 0) {
                    interval = interval + "-";
                }
                if (mStr.length() < this.loadPrec) {
                    int len = mStr.length();
                    int destLen = this.loadPrec;
                    while (destLen-- > len) {
                        mStr = "0" + mStr;
                    }
                }
                interval = interval + "'" + mStr + "' MINUTE(" + this.loadPrec + ")";
                break;
            }
            case 11: {
                String nStr = this.getMsecString();
                String mStr = String.valueOf(this.abs(this.minutes));
                String sStr = String.valueOf(this.abs(this.seconds));
                if (this.minutes < 0 || this.seconds < 0 || this.fraction < 0) {
                    interval = interval + "-";
                }
                if (mStr.length() < this.loadPrec) {
                    int len = mStr.length();
                    int destLen = this.loadPrec;
                    while (destLen-- > len) {
                        mStr = "0" + mStr;
                    }
                }
                if (sStr.length() < 2) {
                    sStr = "0" + sStr;
                }
                interval = interval + "'" + mStr + ":" + sStr + (StringUtil.isNotEmpty(nStr) ? "." + nStr : "") + "' MINUTE(" + this.loadPrec + ") TO SECOND(" + this.secPrec + ")";
                break;
            }
            case 12: {
                String nStr = this.getMsecString();
                String sStr = String.valueOf(this.abs(this.seconds));
                if (this.seconds < 0 || this.fraction < 0) {
                    interval = interval + "-";
                }
                if (sStr.length() < this.loadPrec) {
                    int len = sStr.length();
                    int destLen = this.loadPrec;
                    while (destLen-- > len) {
                        sStr = "0" + sStr;
                    }
                }
                interval = interval + "'" + sStr + (StringUtil.isNotEmpty(nStr) ? "." + nStr : "") + "' SECOND(" + this.loadPrec + ", " + this.secPrec + ")";
            }
        }
        return interval;
    }

    private String getMsecString() {
        String nano = "" + this.abs(this.fraction);
        for (int i = 6 - nano.length(); i > 0; --i) {
            nano = "0" + nano;
        }
        if (nano.length() > this.secPrec) {
            nano = nano.substring(0, this.secPrec);
        }
        return nano;
    }

    public final String toString() {
        return this.getDTString();
    }

    public byte[] encode(int prec) throws SQLException {
        int secPrec = prec & 0xF;
        int loadPrec = prec >> 4 & 0xF;
        this.checkPrec(loadPrec, secPrec);
        byte[] ym = new byte[24];
        System.arraycopy(Convertion.intToByteArray(this.days), 0, ym, 0, 4);
        System.arraycopy(Convertion.intToByteArray(this.hours), 0, ym, 4, 4);
        System.arraycopy(Convertion.intToByteArray(this.minutes), 0, ym, 8, 4);
        System.arraycopy(Convertion.intToByteArray(this.seconds), 0, ym, 12, 4);
        System.arraycopy(Convertion.intToByteArray(this.fraction), 0, ym, 16, 4);
        System.arraycopy(Convertion.intToByteArray(prec), 0, ym, 20, 4);
        return ym;
    }

    public void clear() {
        this.days = 0;
        this.hours = 0;
        this.minutes = 0;
        this.seconds = 0;
        this.fraction = 0;
    }

    private int getPrec(String str, boolean isLeadPrec) throws SQLException {
        if (isLeadPrec) {
            if (this.isLoadPrecSet) {
                return this.loadPrec;
            }
        } else if (this.isSecPrecSet) {
            return this.secPrec;
        }
        int leftBtId = -1;
        int rightBtId = -1;
        int prec = 0;
        leftBtId = str.indexOf("(");
        rightBtId = str.indexOf(")");
        if (rightBtId == -1 && leftBtId == -1) {
            prec = isLeadPrec ? 2 : 6;
        } else if (rightBtId != -1 && leftBtId != -1 && rightBtId > leftBtId + 1) {
            String strPrec = str.substring(leftBtId + 1, rightBtId).trim();
            prec = Integer.parseInt(strPrec);
        } else {
            DBError.throwSQLException(6005);
        }
        return prec;
    }

    private void checkPrec(int loadPrec, int secPrec) throws SQLException {
        switch (this.type) {
            case 3: {
                if (loadPrec >= String.valueOf(this.abs(this.days)).length()) break;
                DBError.throwSQLException(6005);
                break;
            }
            case 4: {
                if (loadPrec < String.valueOf(this.abs(this.days)).length()) {
                    DBError.throwSQLException(6005);
                }
                if (this.abs(this.hours) <= 23) break;
                DBError.throwSQLException(6005);
                break;
            }
            case 5: {
                if (loadPrec < String.valueOf(this.abs(this.days)).length()) {
                    DBError.throwSQLException(6005);
                }
                if (this.abs(this.hours) <= 23 && this.abs(this.minutes) <= 59) break;
                DBError.throwSQLException(6005);
                break;
            }
            case 6: {
                if (loadPrec < String.valueOf(this.abs(this.days)).length()) {
                    DBError.throwSQLException(6005);
                }
                if (this.abs(this.hours) <= 23 && this.abs(this.minutes) <= 59 && this.abs(this.seconds) <= 59) break;
                DBError.throwSQLException(6005);
                break;
            }
            case 7: {
                if (loadPrec >= String.valueOf(this.abs(this.hours)).length()) break;
                DBError.throwSQLException(6005);
                break;
            }
            case 8: {
                if (loadPrec < String.valueOf(this.abs(this.hours)).length()) {
                    DBError.throwSQLException(6005);
                }
                if (this.abs(this.minutes) <= 59) break;
                DBError.throwSQLException(6005);
                break;
            }
            case 9: {
                if (loadPrec < String.valueOf(this.abs(this.hours)).length()) {
                    DBError.throwSQLException(6005);
                }
                if (this.abs(this.minutes) <= 59 && this.abs(this.seconds) <= 59) break;
                DBError.throwSQLException(6005);
                break;
            }
            case 10: {
                if (loadPrec >= String.valueOf(this.abs(this.minutes)).length()) break;
                DBError.throwSQLException(6005);
                break;
            }
            case 11: {
                if (loadPrec < String.valueOf(this.abs(this.minutes)).length()) {
                    DBError.throwSQLException(6005);
                }
                if (this.abs(this.seconds) <= 59) break;
                DBError.throwSQLException(6005);
                break;
            }
            case 12: {
                if (loadPrec >= String.valueOf(this.abs(this.seconds)).length()) break;
                DBError.throwSQLException(6005);
            }
        }
    }

    private void setPrecForSvr(String leadPrec, String secPrec) throws SQLException {
        this.loadPrec = this.getPrec(leadPrec, true);
        this.secPrec = this.getPrec(secPrec, false);
        this.checkPrec(this.loadPrec, this.secPrec);
        this.precForSvr = (this.type << 8) + (this.loadPrec << 4) + this.secPrec;
    }

    private String checkSign(String str) throws SQLException {
        int signIndex;
        int qlindex;
        int qindex = str.indexOf("'");
        if (qindex == (qlindex = str.lastIndexOf("'")) || qindex == -1) {
            DBError.throwSQLException(6005);
        }
        if ((signIndex = str.lastIndexOf("-", qindex)) != -1) {
            this.m_negative = true;
            str = str.replaceFirst("-", "");
        }
        int signIndex2 = str.lastIndexOf("+", qindex);
        if (signIndex != -1 && signIndex2 != -1) {
            DBError.throwSQLException(6005);
        }
        if (signIndex2 != -1) {
            this.m_negative = false;
            str = str.replaceFirst("+", "");
        }
        return str;
    }

    private void parseIntervDTString(String str) throws SQLException {
        String[] subStr;
        if (str == null) {
            DBError.throwSQLException(6005);
        }
        if ((subStr = (str = str.toUpperCase().trim()).split(" ")).length < 3 || !subStr[0].equalsIgnoreCase("INTERVAL")) {
            DBError.throwSQLException(6005);
        }
        str = this.checkSign(str);
        String strLeadPrec = "";
        String strSecPrec = "";
        int leadPrecIndex = 0;
        int secPrecIndex = 0;
        int toIndex = 0;
        int valueIndex = str.indexOf(" ");
        String strvalue = null;
        leadPrecIndex = str.indexOf("DAY");
        if (leadPrecIndex != -1) {
            toIndex = str.indexOf("TO", leadPrecIndex);
            strvalue = str.substring(valueIndex, leadPrecIndex).trim();
            if (toIndex == -1) {
                strLeadPrec = str.substring(leadPrecIndex).trim();
                this.setDay(strvalue);
            } else {
                strLeadPrec = str.substring(leadPrecIndex, toIndex).trim();
                if (str.indexOf("HOUR", toIndex) != -1) {
                    this.setDayToHour(strvalue);
                } else if (str.indexOf("MINUTE", toIndex) != -1) {
                    this.setDayToMinute(strvalue);
                } else {
                    secPrecIndex = str.indexOf("SECOND", toIndex);
                    if (secPrecIndex != -1) {
                        strSecPrec = str.substring(secPrecIndex);
                        this.setDayToSecond(strvalue);
                    } else {
                        DBError.throwSQLException(6005);
                    }
                }
            }
            this.setPrecForSvr(strLeadPrec, strSecPrec);
            return;
        }
        leadPrecIndex = str.indexOf("HOUR");
        if (leadPrecIndex != -1) {
            toIndex = str.indexOf("TO", leadPrecIndex);
            strvalue = str.substring(valueIndex, leadPrecIndex).trim();
            if (toIndex == -1) {
                strLeadPrec = str.substring(leadPrecIndex);
                this.setHour(strvalue);
            } else {
                strLeadPrec = str.substring(leadPrecIndex, toIndex);
                if (str.indexOf("MINUTE", toIndex) != -1) {
                    this.setHourToMinute(strvalue);
                } else {
                    secPrecIndex = str.indexOf("SECOND", toIndex);
                    if (secPrecIndex != -1) {
                        strSecPrec = str.substring(secPrecIndex);
                        this.setHourToSecond(strvalue);
                    } else {
                        DBError.throwSQLException(6005);
                    }
                }
            }
            this.setPrecForSvr(strLeadPrec, strSecPrec);
            return;
        }
        leadPrecIndex = str.indexOf("MINUTE");
        if (leadPrecIndex != -1) {
            toIndex = str.indexOf("TO", leadPrecIndex);
            strvalue = str.substring(valueIndex, leadPrecIndex).trim();
            if (toIndex == -1) {
                strLeadPrec = str.substring(leadPrecIndex);
                this.setMinute(strvalue);
            } else {
                strLeadPrec = str.substring(leadPrecIndex, toIndex);
                secPrecIndex = str.indexOf("SECOND", toIndex);
                if (secPrecIndex != -1) {
                    strSecPrec = str.substring(secPrecIndex);
                    this.setMinuteToSecond(strvalue);
                } else {
                    DBError.throwSQLException(6005);
                }
            }
            this.setPrecForSvr(strLeadPrec, strSecPrec);
            return;
        }
        leadPrecIndex = str.indexOf("SECOND");
        if (leadPrecIndex != -1) {
            strvalue = str.substring(valueIndex, leadPrecIndex).trim();
            this.setSecond(strvalue);
            strvalue = str.substring(leadPrecIndex).trim();
            int colonIndex = strvalue.indexOf(",");
            if (colonIndex == -1) {
                strLeadPrec = strvalue;
            } else {
                strLeadPrec = strvalue.substring(0, colonIndex).trim() + ")";
                strSecPrec = "(" + strvalue.substring(colonIndex + 1).trim();
            }
            this.setPrecForSvr(strLeadPrec, strSecPrec);
            return;
        }
        DBError.throwSQLException(6005);
    }
}

