/*
 * Decompiled with CFR 0.152.
 */
package dm.sql;

import dm.jdbc.dataConvertion.accessor.BaseAccessor;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.CommDesc;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.util.DmJdbcUtil;
import dm.sql.ArrayDescriptor;
import dm.sql.DmdbArrayDataResultSet;
import dm.sql.STRUCT;
import dm.sql.TypeData;
import dm.sql.TypeDescriptor;
import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARRAY
extends TypeData
implements Array {
    ArrayDescriptor m_arrDesc;
    TypeData[] m_arrData;
    Object m_objArray;
    final int ARRAY_MAX_ITEM_COUNT = 60000;
    int m_totalCount = 0;
    int m_index = 0;
    int m_countHasGet = 0;
    int m_itemCount;
    int m_itemSize;
    int m_objCount = 0;
    int m_strCount = 0;
    int[] m_objStrOffs = null;

    private void initData() {
        this.m_itemCount = 0;
        this.m_itemSize = 0;
        this.m_objCount = 0;
        this.m_strCount = 0;
        this.m_objStrOffs = null;
        this.m_dumyData = null;
        this.m_offset = 0;
        this.m_objArray = null;
    }

    public ARRAY(TypeData[] atData, TypeDescriptor desc) {
        super(null, null);
        this.m_arrDesc = new ArrayDescriptor(desc);
        this.m_arrData = atData;
    }

    void checkSArrayLen(int lenToCheck) throws SQLException {
        if (lenToCheck != this.m_arrDesc.getLength()) {
            DBError.throwSQLException(6036);
        }
    }

    public ARRAY(ArrayDescriptor arrDesc, Connection connAgent, Object[] objArr) throws SQLException {
        super(null, null);
        DmdbConnection_bs conn;
        if (null == arrDesc) {
            DBError.throwSQLException(6036);
        }
        if ((conn = DmJdbcUtil.getBaseConnection(connAgent)) == null || conn.isClosed()) {
            throw new SQLException(DmSvcConf.res.getString("error.connectionClosedOrNotBuild"));
        }
        this.initData();
        this.m_arrDesc = arrDesc;
        if (null == objArr) {
            this.m_arrData = new TypeData[0];
        } else {
            if (arrDesc.getMDesc().getDType() == 122 && objArr.length > arrDesc.getMDesc().getStaticArrayLength()) {
                throw new SQLException(DmSvcConf.res.getString("error.invalidLenOfSARR"));
            }
            this.m_arrData = TypeData.toArray(objArr, this.m_arrDesc.getMDesc());
        }
        this.m_itemCount = this.m_arrData.length;
    }

    private void checkIndex(long index) throws SQLException {
        if (index < 1L || index > (long)this.m_arrData.length) {
            DBError.throwSQLException(6057);
        }
    }

    private void checkIndexAndCount(long index, int count) throws SQLException {
        this.checkIndex(index);
        if (count <= 0 || index - 1L + (long)count > (long)this.m_arrData.length) {
            DBError.throwSQLException(6057);
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.m_arrDesc.m_typeDesc.getFulName();
    }

    @Override
    public int getBaseType() throws SQLException {
        return DmdbType.dtypeToSqlType(this.m_arrDesc.getItemDesc().getDType(), this.getBaseTypeName());
    }

    @Override
    public Object getArray() throws SQLException {
        if (null == this.m_arrData || this.m_arrData.length <= 0) {
            return null;
        }
        return this.toJavaArray(this, this.m_arrData.length, this.m_arrDesc.getItemDesc().getDType());
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        this.checkIndexAndCount(index, count);
        return this.toJavaArray(this, index, count, this.m_arrDesc.getItemDesc().getDType());
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public int[] getIntArray() throws SQLException {
        return (int[])this.toNumericArray(this, 1L, this.m_itemCount, 2);
    }

    public int[] getIntArray(long index, int count) throws SQLException {
        this.checkIndexAndCount(index, count);
        return (int[])this.toNumericArray(this, index, count, 2);
    }

    public short[] getShortArray() throws SQLException {
        return (short[])this.toNumericArray(this, 1L, this.m_itemCount, 1);
    }

    public short[] getShortArray(long index, int count) throws SQLException {
        this.checkIndexAndCount(index, count);
        return (short[])this.toNumericArray(this, index, count, 1);
    }

    public long[] getLongArray() throws SQLException {
        return (long[])this.toNumericArray(this, 1L, this.m_itemCount, 3);
    }

    public long[] getLongArray(long index, int count) throws SQLException {
        this.checkIndexAndCount(index, count);
        return (long[])this.toNumericArray(this, index, count, 3);
    }

    public float[] getFloatArray() throws SQLException {
        return (float[])this.toNumericArray(this, 1L, this.m_itemCount, 4);
    }

    public float[] getFloatArray(long index, int count) throws SQLException {
        this.checkIndexAndCount(index, count);
        return (float[])this.toNumericArray(this, index, count, 4);
    }

    public double[] getDoubleArray() throws SQLException {
        return (double[])this.toNumericArray(this, 1L, this.m_itemCount, 5);
    }

    public double[] getDoubleArray(long index, int count) throws SQLException {
        this.checkIndexAndCount(index, count);
        return (double[])this.toNumericArray(this, index, count, 5);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return new DmdbArrayDataResultSet(this);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        this.checkIndexAndCount(index, count);
        return new DmdbArrayDataResultSet(this, index, count);
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public void free() throws SQLException {
        this.m_arrData = null;
        this.m_arrDesc = null;
        this.initData();
    }

    TypeData getData(long index, int col, Map<String, Class<?>> map) throws SQLException {
        this.checkIndex(index);
        TypeData oneRow = this.m_arrData[(int)(index - 1L)];
        if (oneRow.m_dumyData instanceof STRUCT) {
            return ((STRUCT)oneRow.m_dumyData).getAttrValue(col);
        }
        return oneRow;
    }

    CommDesc getDataDesc(long index, int col) throws SQLException {
        this.checkIndex(index);
        CommDesc commDesc = new CommDesc();
        TypeDescriptor dataDesc = this.m_arrDesc.getItemDesc();
        if (dataDesc.getDType() == 121 || dataDesc.getDType() == 119) {
            TypeDescriptor[] attis = dataDesc.m_fieldsObj;
            if (col < 1 || col > attis.length) {
                DBError.throwSQLException(6032);
            }
            dataDesc = attis[col - 1];
        }
        commDesc.setDtypeInfo(dataDesc.m_dTypeInfo);
        commDesc.setLobDesc(dataDesc.m_lobDesc);
        return commDesc;
    }

    public BaseAccessor getDataAccessor(int m_curRowNum, int columnIndex) throws SQLException {
        TypeDescriptor dataDesc = this.m_arrDesc.getItemDesc();
        if (dataDesc.getDType() == 121 || dataDesc.getDType() == 119) {
            TypeDescriptor[] attis = dataDesc.m_fieldsObj;
            if (columnIndex < 1 || columnIndex > attis.length) {
                DBError.throwSQLException(6032);
            }
            dataDesc = attis[columnIndex - 1];
        }
        return dataDesc.accessor;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        try {
            str.append(this.getBaseTypeName()).append("(");
            for (int i = 0; i < this.m_arrData.length; ++i) {
                if (i == 0) {
                    str.append(this.m_arrData[i].m_dumyData);
                    continue;
                }
                str.append(", ").append(this.m_arrData[i].m_dumyData);
            }
            str.append(")");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str.toString();
    }
}

