/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util.stat;

import dm.jdbc.util.stat.FilterUtil;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONWriter {
    private StringBuilder out = new StringBuilder();

    public void writeArrayStart() {
        this.write('[');
    }

    public void writeComma() {
        this.write(',');
    }

    public void writeArrayEnd() {
        this.write(']');
    }

    public void writeNull() {
        this.write("null");
    }

    public void writeObject(Object o) {
        if (o == null) {
            this.writeNull();
            return;
        }
        if (o instanceof String) {
            this.writeString((String)o);
            return;
        }
        if (o instanceof Number) {
            this.write(o.toString());
            return;
        }
        if (o instanceof Boolean) {
            this.write(o.toString());
            return;
        }
        if (o instanceof Date) {
            this.writeDate((Date)o);
            return;
        }
        if (o instanceof Collection) {
            this.writeArray((Collection)o);
            return;
        }
        if (o instanceof Throwable) {
            this.writeError((Throwable)o);
            return;
        }
        if (o instanceof int[]) {
            int[] array = (int[])o;
            this.write('[');
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    this.write(',');
                }
                this.write(array[i]);
            }
            this.write(']');
            return;
        }
        if (o instanceof long[]) {
            long[] array = (long[])o;
            this.write('[');
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    this.write(',');
                }
                this.write(array[i]);
            }
            this.write(']');
            return;
        }
        if (o instanceof TabularData) {
            this.writeTabularData((TabularData)o);
            return;
        }
        if (o instanceof CompositeData) {
            this.writeCompositeData((CompositeData)o);
            return;
        }
        if (o instanceof Map) {
            this.writeMap((Map)o);
            return;
        }
        throw new IllegalArgumentException("not support type : " + o.getClass());
    }

    public void writeDate(Date date) {
        if (date == null) {
            this.writeNull();
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.writeString(dateFormat.format(date));
    }

    public void writeError(Throwable error) {
        if (error == null) {
            this.writeNull();
            return;
        }
        this.write("{\"Class\":");
        this.writeString(error.getClass().getName());
        this.write(",\"Message\":");
        this.writeString(error.getMessage());
        this.write(",\"StackTrace\":");
        this.writeString(FilterUtil.getStackTrace(error));
        this.write('}');
    }

    public void writeArray(Object[] array) {
        if (array == null) {
            this.writeNull();
            return;
        }
        this.write('[');
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                this.write(',');
            }
            this.writeObject(array[i]);
        }
        this.write(']');
    }

    public void writeArray(Collection<Object> list) {
        if (list == null) {
            this.writeNull();
            return;
        }
        int entryIndex = 0;
        this.write('[');
        for (Object entry : list) {
            if (entryIndex != 0) {
                this.write(',');
            }
            this.writeObject(entry);
            ++entryIndex;
        }
        this.write(']');
    }

    public void writeString(String text) {
        if (text == null) {
            this.writeNull();
            return;
        }
        this.write('\"');
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\"') {
                this.write("\\\"");
                continue;
            }
            if (c == '\n') {
                this.write("\\n");
                continue;
            }
            if (c == '\r') {
                this.write("\\r");
                continue;
            }
            if (c == '\\') {
                this.write("\\\\");
                continue;
            }
            if (c == '\t') {
                this.write("\\t");
                continue;
            }
            if (c < '\u0010') {
                this.write("\\u000");
                this.write(Integer.toHexString(c));
                continue;
            }
            if (c < ' ') {
                this.write("\\u00");
                this.write(Integer.toHexString(c));
                continue;
            }
            if (c >= '\u007f' && c <= '\u00a0') {
                this.write("\\u00");
                this.write(Integer.toHexString(c));
                continue;
            }
            this.write(c);
        }
        this.write('\"');
    }

    public void writeTabularData(TabularData tabularData) {
        if (tabularData == null) {
            this.writeNull();
            return;
        }
        int entryIndex = 0;
        this.write('[');
        for (Object item : tabularData.values()) {
            if (entryIndex != 0) {
                this.write(',');
            }
            CompositeData row = (CompositeData)item;
            this.writeCompositeData(row);
            ++entryIndex;
        }
        this.write(']');
    }

    public void writeCompositeData(CompositeData compositeData) {
        if (compositeData == null) {
            this.writeNull();
            return;
        }
        int entryIndex = 0;
        this.write('{');
        for (String key : compositeData.getCompositeType().keySet()) {
            if (entryIndex != 0) {
                this.write(',');
            }
            this.writeString(key);
            this.write(':');
            Object value = compositeData.get(key);
            this.writeObject(value);
            ++entryIndex;
        }
        this.write('}');
    }

    public void writeMap(Map<String, Object> map) {
        if (map == null) {
            this.writeNull();
            return;
        }
        int entryIndex = 0;
        this.write('{');
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entryIndex != 0) {
                this.write(',');
            }
            this.writeString(entry.getKey());
            this.write(':');
            this.writeObject(entry.getValue());
            ++entryIndex;
        }
        this.write('}');
    }

    protected void write(String text) {
        this.out.append(text);
    }

    protected void write(char c) {
        this.out.append(c);
    }

    protected void write(int c) {
        this.out.append(c);
    }

    protected void write(long c) {
        this.out.append(c);
    }

    public String toString() {
        return this.out.toString();
    }
}

