/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.DmdbExecOpt;
import dm.jdbc.desc.DmdbLexWord;
import dm.jdbc.driver.DmdbNumeric;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecOptProcessor {
    private ArrayList<DmdbLexWord> m_wordList = null;
    private String m_serverEncoding = null;
    private boolean m_escProcessErr = false;

    public ExecOptProcessor(String serverEncoding, boolean escProcessErr, ArrayList<DmdbLexWord> arrList) {
        this.m_wordList = arrList;
        this.m_serverEncoding = serverEncoding;
        this.m_escProcessErr = escProcessErr;
    }

    public DmdbExecOpt getExecOpt(String sql) throws SQLException {
        boolean bExistErr = false;
        boolean order_flag = false;
        boolean order_by_flag = false;
        DmdbExecOpt retExecOpt = new DmdbExecOpt();
        retExecOpt.setOrgSql(sql);
        if (this.m_escProcessErr) {
            retExecOpt.setHasErrorOrProcessed(true);
            return retExecOpt;
        }
        for (int index = 0; index < this.m_wordList.size(); ++index) {
            DmdbLexWord lexWordTemp = this.m_wordList.get(index);
            if (0 == index) {
                if (!this.checkOptType(lexWordTemp.getM_value())) {
                    bExistErr = true;
                    break;
                }
                retExecOpt.addSqlWord(lexWordTemp.getM_value());
                continue;
            }
            if (this.checkOrderBy_order(lexWordTemp.getM_value())) {
                order_flag = true;
                retExecOpt.addSqlWord(lexWordTemp.getM_value());
                continue;
            }
            if (order_flag && !order_by_flag) {
                while (lexWordTemp.getM_value().equalsIgnoreCase(" ")) {
                    retExecOpt.addSqlWord(lexWordTemp.getM_value());
                    lexWordTemp = this.m_wordList.get(++index);
                }
                if (this.checkOrderBy_by(lexWordTemp.getM_value())) {
                    order_by_flag = true;
                    retExecOpt.addSqlWord(lexWordTemp.getM_value());
                    continue;
                }
            }
            if (order_by_flag) {
                lexWordTemp.setM_type(1);
            }
            if (1 == lexWordTemp.getM_type() || 3 == lexWordTemp.getM_type()) {
                String str = lexWordTemp.getM_value();
                if (str.equalsIgnoreCase("function")) {
                    DmdbLexWord prevWord = null;
                    for (int prevIndex = index - 1; prevIndex >= 0 && (prevWord = this.m_wordList.get(prevIndex)).getM_type() == 7; --prevIndex) {
                    }
                    if (prevWord != null && prevWord.getM_value().equalsIgnoreCase("with")) {
                        bExistErr = true;
                        break;
                    }
                }
                if (str.equalsIgnoreCase("?")) {
                    retExecOpt.setToPrepare(true);
                }
                retExecOpt.addSqlWord(str);
                continue;
            }
            try {
                if (lexWordTemp.getM_type() != 7) {
                    DmdbLexWord currentWord = null;
                    DmdbLexWord nextWord = null;
                    DmdbLexWord thirdWord = null;
                    int curIndex = index;
                    int nextIndex = 0;
                    int thirdIndex = 0;
                    if (lexWordTemp.getM_value().equals("'")) {
                        currentWord = this.m_wordList.get(++curIndex);
                        nextIndex = curIndex + 2;
                    } else {
                        currentWord = lexWordTemp;
                        nextIndex = curIndex + 1;
                    }
                    while (this.m_wordList.size() > nextIndex) {
                        nextWord = this.m_wordList.get(nextIndex);
                        if (nextWord.getM_type() != 7) {
                            if (!nextWord.getM_value().equals("'")) break;
                            nextWord = this.m_wordList.get(++nextIndex);
                            ++nextIndex;
                            break;
                        }
                        ++nextIndex;
                    }
                    for (thirdIndex = nextIndex + 1; this.m_wordList.size() > thirdIndex; ++thirdIndex) {
                        thirdWord = this.m_wordList.get(thirdIndex);
                        if (thirdWord.getM_type() == 7) continue;
                        if (!thirdWord.getM_value().equals("'")) break;
                        thirdWord = this.m_wordList.get(++thirdIndex);
                        ++thirdIndex;
                        break;
                    }
                    if (this.word_is_const(currentWord) && nextWord != null && thirdWord != null && this.word_is_op(nextWord) && this.word_is_const(thirdWord)) {
                        for (int i = index; i <= thirdIndex; ++i) {
                            retExecOpt.addSqlWord(this.m_wordList.get(i).getM_value());
                        }
                        index = thirdIndex;
                        continue;
                    }
                    index = this.replaceConstVal(lexWordTemp, retExecOpt, index);
                    continue;
                }
                index = this.replaceConstVal(lexWordTemp, retExecOpt, index);
                continue;
            }
            catch (UnsupportedEncodingException ex) {
                DBError.throwSQLException(ex.toString(), -1);
            }
        }
        if (bExistErr) {
            retExecOpt.setHasErrorOrProcessed(true);
            return retExecOpt;
        }
        return retExecOpt;
    }

    private int replaceConstVal(DmdbLexWord lexWordTemp, DmdbExecOpt retExecOpt, int index) throws UnsupportedEncodingException, SQLException {
        String strValue = lexWordTemp.getM_value();
        switch (lexWordTemp.getM_type()) {
            case 2: {
                long lint = Long.parseLong(strValue, 10);
                if (lint > Integer.MAX_VALUE || lint < Integer.MIN_VALUE) {
                    long lval = Long.parseLong(strValue, 10);
                    retExecOpt.addParam(Convertion.longToByteArray(lval), 8, 8);
                    break;
                }
                int vint = Integer.parseInt(strValue, 10);
                retExecOpt.addParam(Convertion.intToByteArray(vint), 7, 4);
                break;
            }
            case 3: {
                if (strValue.length() > 2 && (strValue.startsWith("0x") || strValue.startsWith("0X"))) {
                    strValue = strValue.substring(2);
                }
                long lval = Long.parseLong(strValue, 16);
                retExecOpt.addParam(Convertion.longToByteArray(lval), 8, 8);
                break;
            }
            case 4: {
                double vdbl = Double.parseDouble(strValue);
                retExecOpt.addParam(Convertion.doubleToByteArray(vdbl), 11, 8);
                break;
            }
            case 5: {
                DmdbNumeric num = new DmdbNumeric();
                retExecOpt.addParam(num.StrToDec(strValue, 0, 0), 9, 0);
                break;
            }
            case 6: {
                boolean isEmpty = false;
                String str1 = lexWordTemp.getM_value();
                lexWordTemp = this.m_wordList.get(++index);
                String str2 = lexWordTemp.getM_value();
                if (str1.equalsIgnoreCase("'") && str2.equalsIgnoreCase("'")) {
                    isEmpty = true;
                }
                int ind = -1;
                ind = str2.indexOf("''");
                if (ind != -1) {
                    StringBuffer str2Buf = new StringBuffer(str2);
                    while (ind != -1) {
                        str2Buf.replace(ind, ind + 2, "'");
                        ind = str2Buf.indexOf("''", ind + 1);
                    }
                    str2 = str2Buf.toString();
                }
                String str = "";
                if (!isEmpty) {
                    str = str2;
                    ++index;
                }
                byte[] bytes = null;
                bytes = null == this.m_serverEncoding ? str.getBytes() : str.getBytes(this.m_serverEncoding);
                if (bytes.length > Short.MAX_VALUE) {
                    retExecOpt.addSqlWord(strValue);
                    return index++;
                }
                retExecOpt.addParam(bytes, 2, bytes.length);
                break;
            }
            default: {
                retExecOpt.addSqlWord(strValue);
                return index++;
            }
        }
        retExecOpt.addSqlWord("?");
        return index++;
    }

    private boolean checkOrderBy_order(String strOrder) {
        return strOrder.equalsIgnoreCase("ORDER");
    }

    private boolean checkOrderBy_by(String strBy) {
        return strBy.equalsIgnoreCase("BY");
    }

    private boolean checkOptType(String strType) {
        if (null == strType || strType.length() == 0) {
            return false;
        }
        return strType.equalsIgnoreCase("INSERT") || strType.equalsIgnoreCase("SELECT") || strType.equalsIgnoreCase("UPDATE") || strType.equalsIgnoreCase("DELETE") || strType.equalsIgnoreCase("EXPLAIN");
    }

    private boolean word_is_op(DmdbLexWord word) {
        return word.getM_type() == 1 && (word.getM_value().equals("=") || word.getM_value().equals(">") || word.getM_value().equals("<") || word.getM_value().equals("<>") || word.getM_value().equals(">=") || word.getM_value().equals("<=") || word.getM_value().equals("!="));
    }

    private boolean word_is_const(DmdbLexWord word) {
        return word.getM_type() != 1 && word.getM_type() != 7 && !word.getM_value().equals("'");
    }
}

