/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.desc.DmdbLexWord;
import dm.jdbc.lex.Yylex;
import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EscapeProcessor {
    private ArrayList<DmdbLexWord> m_wordList = new ArrayList();
    private boolean m_lexErr = false;
    private boolean m_excptThrow = false;

    private String escapePro() {
        String word;
        int i;
        DmdbLexWord lexWord3 = null;
        DmdbLexWord lexWord5 = null;
        String addedArg = null;
        int leftQIndex = -1;
        int wordToEscape = -1;
        int rightQIndex = -1;
        int len = this.m_wordList.size();
        for (i = 0; i < len; ++i) {
            word = this.m_wordList.get(i).getM_value();
            if (!word.equals("}")) continue;
            rightQIndex = i;
            boolean isEscape = false;
            String word3 = null;
            for (int j = i - 1; j >= 0; --j) {
                String word4 = this.m_wordList.get(j).getM_value();
                if (!word4.equals("{")) continue;
                leftQIndex = j;
                lexWord3 = this.m_wordList.get(j + 1);
                while (lexWord3 != null && lexWord3.getM_type() == 7) {
                    lexWord3 = this.m_wordList.get(++j + 1);
                }
                word3 = lexWord3.getM_value();
                wordToEscape = j + 1;
                break;
            }
            if (word3 == null || lexWord3 == null) continue;
            if (!word3.equalsIgnoreCase("oj")) {
                if (word3.equalsIgnoreCase("d")) {
                    lexWord3.setM_value("date");
                    lexWord3.setM_valLen("date".length());
                    isEscape = true;
                } else if (word3.equalsIgnoreCase("t")) {
                    lexWord3.setM_value("time");
                    lexWord3.setM_valLen("time".length());
                    isEscape = true;
                } else if (word3.equalsIgnoreCase("ts")) {
                    lexWord3.setM_value("datetime");
                    lexWord3.setM_valLen("datetime".length());
                    isEscape = true;
                } else if (word3.equalsIgnoreCase("?")) {
                    int k = wordToEscape + 1;
                    lexWord5 = this.m_wordList.get(k);
                    while (lexWord5 != null && !lexWord5.getM_value().equals("=") && k < this.m_wordList.size() - 1) {
                        lexWord5 = this.m_wordList.get(++k);
                    }
                    if (lexWord5 != null && lexWord5.getM_value().equals("=")) {
                        lexWord5 = this.m_wordList.get(++k);
                        while (lexWord5 != null && !lexWord5.getM_value().equalsIgnoreCase("call") && k < this.m_wordList.size() - 1) {
                            lexWord5 = this.m_wordList.get(++k);
                        }
                        if (lexWord5 != null && "call".equalsIgnoreCase(lexWord5.getM_value())) {
                            this.m_wordList.remove(k);
                            --rightQIndex;
                        }
                    }
                    isEscape = true;
                } else if (word3.equalsIgnoreCase("?=")) {
                    int k = wordToEscape + 1;
                    lexWord5 = this.m_wordList.get(k);
                    while (lexWord5 != null && !lexWord5.getM_value().equalsIgnoreCase("call") && k < this.m_wordList.size() - 1) {
                        lexWord5 = this.m_wordList.get(++k);
                    }
                    if (lexWord5 != null && "call".equalsIgnoreCase(lexWord5.getM_value())) {
                        this.m_wordList.remove(k);
                        --rightQIndex;
                    }
                    isEscape = true;
                } else if (word3.equalsIgnoreCase("escape") || word3.equalsIgnoreCase("call")) {
                    isEscape = true;
                } else {
                    if (!word3.equalsIgnoreCase("fn")) continue;
                    String new_name = null;
                    int k = wordToEscape + 1;
                    lexWord5 = this.m_wordList.get(k);
                    while (lexWord5 != null && lexWord5.getM_type() == 7 && k < this.m_wordList.size() - 1) {
                        lexWord5 = this.m_wordList.get(++k);
                    }
                    String word5 = lexWord5.getM_value();
                    if (word5.equalsIgnoreCase("ascii") || word5.equalsIgnoreCase("bit_length") || word5.equalsIgnoreCase("concat") || word5.equalsIgnoreCase("length") || word5.equalsIgnoreCase("locate") || word5.equalsIgnoreCase("ltrim") || word5.equalsIgnoreCase("replace") || word5.equalsIgnoreCase("rtrim") || word5.equalsIgnoreCase("space") || word5.equalsIgnoreCase("abs") || word5.equalsIgnoreCase("acos") || word5.equalsIgnoreCase("asin") || word5.equalsIgnoreCase("atan") || word5.equalsIgnoreCase("atan2") || word5.equalsIgnoreCase("cos") || word5.equalsIgnoreCase("cot") || word5.equalsIgnoreCase("degrees") || word5.equalsIgnoreCase("floor") || word5.equalsIgnoreCase("log10") || word5.equalsIgnoreCase("mod") || word5.equalsIgnoreCase("pi") || word5.equalsIgnoreCase("power") || word5.equalsIgnoreCase("radians") || word5.equalsIgnoreCase("round") || word5.equalsIgnoreCase("sign") || word5.equalsIgnoreCase("sin") || word5.equalsIgnoreCase("sqrt") || word5.equalsIgnoreCase("tan") || word5.equalsIgnoreCase("truncate") || word5.equalsIgnoreCase("dayname") || word5.equalsIgnoreCase("dayofyear") || word5.equalsIgnoreCase("dayofmonth") || word5.equalsIgnoreCase("monthname") || word5.equalsIgnoreCase("quarter") || word5.equalsIgnoreCase("week") || word5.equalsIgnoreCase("year") || word5.equalsIgnoreCase("month") || word5.equalsIgnoreCase("hour") || word5.equalsIgnoreCase("minute") || word5.equalsIgnoreCase("second") || word5.equalsIgnoreCase("user")) {
                        new_name = word5;
                    } else if (word5.equalsIgnoreCase("char")) {
                        new_name = "chr";
                    } else if (word5.equalsIgnoreCase("char_length")) {
                        new_name = "length";
                    } else if (word5.equalsIgnoreCase("character_length")) {
                        new_name = "length";
                    } else if (word5.equalsIgnoreCase("insert")) {
                        new_name = "insstr";
                    } else if (word5.equalsIgnoreCase("lcase")) {
                        new_name = "lower";
                    } else if (word5.equalsIgnoreCase("left")) {
                        new_name = "leftstr";
                    } else if (word5.equalsIgnoreCase("octet_length")) {
                        new_name = "length";
                    } else if (word5.equalsIgnoreCase("repeat")) {
                        new_name = "repeatstr";
                    } else if (word5.equalsIgnoreCase("right")) {
                        new_name = "rightstr";
                    } else if (word5.equalsIgnoreCase("substring")) {
                        new_name = "substr";
                    } else if (word5.equalsIgnoreCase("ucase")) {
                        new_name = "upper";
                    } else if (word5.equalsIgnoreCase("ceiling")) {
                        new_name = "ceil";
                    } else if (word5.equalsIgnoreCase("log")) {
                        new_name = "ln";
                    } else if (word5.equalsIgnoreCase("current_timestamp")) {
                        new_name = "sysdate";
                    } else if (word5.equalsIgnoreCase("dayofmonth")) {
                        addedArg = ",'DD'";
                        new_name = "datepart";
                    } else if (word5.equalsIgnoreCase("dayofweek")) {
                        new_name = "weekday";
                    } else if (word5.equalsIgnoreCase("hour")) {
                        addedArg = ",'HH'";
                        new_name = "datepart";
                    } else if (word5.equalsIgnoreCase("minute")) {
                        addedArg = ",'MI'";
                        new_name = "datepart";
                    } else if (word5.equalsIgnoreCase("month")) {
                        addedArg = ",'MM'";
                        new_name = "datepart";
                    } else if (word5.equalsIgnoreCase("now")) {
                        new_name = "sysdate";
                    } else if (word5.equalsIgnoreCase("second")) {
                        addedArg = ",'SS'";
                        new_name = "datepart";
                    } else if (word5.equalsIgnoreCase("year")) {
                        addedArg = ",'YYYY'";
                        new_name = "datepart";
                    } else {
                        new_name = word5.equalsIgnoreCase("ifnull") ? "nvl" : (word5.equalsIgnoreCase("database") ? "cur_database" : (word5.equalsIgnoreCase("convert") ? word5 : word5));
                    }
                    if (!word5.equals(new_name)) {
                        lexWord5.setM_value(new_name);
                        lexWord5.setM_valLen(new_name.length());
                    }
                    if (addedArg != null) {
                        DmdbLexWord addLexWord = new DmdbLexWord(addedArg, 1, addedArg.length());
                        this.m_wordList.add(i - 1, addLexWord);
                        addedArg = null;
                    }
                }
            }
            if (leftQIndex == -1 || rightQIndex == -1 || wordToEscape == -1) continue;
            this.m_wordList.remove(rightQIndex);
            if (!isEscape) {
                this.m_wordList.remove(wordToEscape);
            }
            this.m_wordList.remove(leftQIndex);
            i = 0;
            len = this.m_wordList.size();
            leftQIndex = -1;
            rightQIndex = -1;
            wordToEscape = -1;
        }
        StringBuffer sqlStr = new StringBuffer();
        len = this.m_wordList.size();
        for (i = 0; i < len; ++i) {
            word = this.m_wordList.get(i).getM_value();
            sqlStr.append(word);
        }
        return sqlStr.toString();
    }

    public synchronized String escapeSQL(String sql, boolean escape, boolean execOpt, String[] keyWords) throws SQLException {
        boolean doEscape;
        block14: {
            doEscape = false;
            if (escape && sql.indexOf("{") != -1 && sql.indexOf("}") != -1) {
                doEscape = true;
            }
            if (!(doEscape || keyWords != null && keyWords.length != 0 || execOpt)) {
                return sql;
            }
            boolean hasOptimize = false;
            if (doEscape && (keyWords == null || keyWords.length == 0) && !execOpt) {
                int leftIndex = sql.indexOf("{");
                int rightIndex = sql.lastIndexOf("}");
                if (leftIndex != -1 && sql.substring(leftIndex).indexOf("'") == -1 && rightIndex != -1 && leftIndex < rightIndex && sql.substring(rightIndex, sql.length()).indexOf("'") == -1) {
                    block13: {
                        hasOptimize = true;
                        DmdbLexWord startWord = new DmdbLexWord(sql.substring(0, leftIndex), 1, leftIndex + 1);
                        this.m_wordList.add(startWord);
                        try {
                            this.parseSQL(sql.substring(leftIndex, rightIndex + 1), doEscape, this.m_wordList, keyWords);
                        }
                        catch (SQLException sqle) {
                            this.m_lexErr = true;
                            if (!this.m_excptThrow) break block13;
                            throw sqle;
                        }
                    }
                    DmdbLexWord endWord = new DmdbLexWord(sql.substring(rightIndex + 1), 1, sql.substring(rightIndex + 1).length());
                    this.m_wordList.add(endWord);
                }
            }
            if (!hasOptimize) {
                try {
                    this.parseSQL(sql, doEscape, this.m_wordList, keyWords);
                }
                catch (SQLException sqle) {
                    this.m_lexErr = true;
                    if (!this.m_excptThrow) break block14;
                    throw sqle;
                }
            }
        }
        if (this.m_lexErr || this.m_wordList.size() == 0) {
            return sql;
        }
        String sqlStr = "";
        if (doEscape) {
            sqlStr = this.escapePro();
        } else {
            StringBuffer strBuf = new StringBuffer();
            int len = this.m_wordList.size();
            for (int i = 0; i < len; ++i) {
                strBuf.append(this.m_wordList.get(i).getM_value());
            }
            sqlStr = strBuf.toString();
        }
        return sqlStr;
    }

    public boolean hasError() {
        return this.m_lexErr;
    }

    private void parseSQL(String sql, boolean escapePro, ArrayList<DmdbLexWord> wordList, String[] keyWords) throws SQLException {
        StringReader reader = new StringReader(sql);
        Yylex lexer = new Yylex(reader, "", this.m_wordList, escapePro);
        DmdbLexWord lexWordTemp = null;
        try {
            if (DmSvcConf.globalDmSvcConf.getKeywordOpen()) {
                while (lexer.yylex() > 0) {
                    lexWordTemp = wordList.get(wordList.size() - 1);
                    String str = lexWordTemp.getM_value();
                    String str2 = this.repaceReservedWord(str, keyWords);
                    lexWordTemp.setM_value(str2);
                    lexWordTemp.setM_valLen(str2.length());
                }
            } else {
                while (lexer.yylex() > 0) {
                }
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        if (lexer.getErrCode() < 0) {
            throw new SQLException(lexer.getErrMsg());
        }
    }

    public String repaceReservedWord(String reservedWord, String[] keyWords) {
        if (keyWords == null || keyWords.length == 0 || reservedWord == null) {
            return reservedWord;
        }
        String strDesWord2 = "";
        for (String strDesWord2 : keyWords) {
            if (!strDesWord2.equalsIgnoreCase(reservedWord)) continue;
            return "\"" + strDesWord2.toUpperCase() + "\"";
        }
        return reservedWord;
    }

    public void setExcpThrow(boolean toThrow) {
        this.m_excptThrow = toThrow;
    }

    public ArrayList<DmdbLexWord> getWordList() {
        return this.m_wordList;
    }
}

