/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.driver.DmDriver_bs;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.util.ReflectUtil;
import dm.jdbc.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;

public class DmJdbcUtil {
    public static final int DEFAULT_READ_BUFFER_SIZE = 4096;

    public static DmdbConnection_bs getBaseConnection(Connection connAgent) {
        DmdbConnection_bs retConn = null;
        if (connAgent != null) {
            retConn = !(connAgent instanceof DmdbConnection_bs) ? (DmdbConnection_bs)ReflectUtil.executeMethod(connAgent, "getBaseObject") : (DmdbConnection_bs)connAgent;
        }
        return retConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void executeUpdate(DmdbConnection_bs conn, String sql) throws SQLException {
        DmdbStatement_bs stmt = null;
        try {
            stmt = (DmdbStatement_bs)conn.createStatement();
            stmt.executeUpdate(sql);
            Object var4_3 = null;
            if (stmt == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (stmt == null) throw throwable;
            try {
                stmt.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            stmt.close();
            return;
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void executeForRw(DmdbConnection_bs conn, String sql, int rwDestType) throws SQLException {
        DmdbStatement_bs stmt = null;
        try {
            stmt = (DmdbStatement_bs)conn.createStatement();
            stmt.executeForRw(sql, rwDestType);
            Object var5_4 = null;
            if (stmt == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (stmt == null) throw throwable;
            try {
                stmt.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            stmt.close();
            return;
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet executeQuery(DmdbConnection_bs conn, String sql) throws SQLException {
        ResultSet resultSet;
        block5: {
            DmdbStatement_bs stmt = null;
            try {
                stmt = (DmdbStatement_bs)conn.createStatement(1004, 1007, 1);
                resultSet = stmt.executeQuery(sql, -1);
                Object var5_4 = null;
                if (stmt == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_5 = null;
                    if (stmt == null) break block6;
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeAndGetExplain(DmdbConnection_bs conn, String sql) throws SQLException {
        String string;
        block5: {
            DmdbStatement_bs stmt = null;
            try {
                stmt = (DmdbStatement_bs)conn.createStatement();
                stmt.execute(sql);
                string = stmt.getExplain();
                Object var5_4 = null;
                if (stmt == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_5 = null;
                    if (stmt == null) break block6;
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public static DmdbConnection_bs createConnection(String host, String port, String userName, String password, Properties props) throws SQLException {
        DmDriver_bs driver = new DmDriver_bs();
        return (DmdbConnection_bs)driver.connect("jdbc:dm://" + host + ":" + port + "?username=" + userName + "&password=" + password, props);
    }

    public static String formatTime() {
        return StringUtil.formatDateTimeString(new Timestamp(System.currentTimeMillis()), 2);
    }

    public static String formatTime(String prefix, String suffix) {
        return prefix + DmJdbcUtil.formatTime() + suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readByteArrayFromResource(String resource) throws IOException {
        InputStream in;
        block3: {
            byte[] byArray;
            in = null;
            try {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
                if (in != null) break block3;
                byArray = null;
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                DmJdbcUtil.close(in);
                throw throwable;
            }
            DmJdbcUtil.close(in);
            return byArray;
        }
        byte[] byArray = DmJdbcUtil.readByteArray(in);
        Object var4_5 = null;
        DmJdbcUtil.close(in);
        return byArray;
    }

    public static byte[] readByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DmJdbcUtil.copy(input, output);
        return output.toByteArray();
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        int EOF = -1;
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static String read(InputStream in) {
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(in, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return DmJdbcUtil.read(reader);
    }

    public static String read(Reader reader) {
        try {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[4096];
            int n = 0;
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
            }
            return writer.toString();
        }
        catch (IOException ex) {
            throw new IllegalStateException("read error", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromResource(String resource) throws IOException {
        String text;
        InputStream in;
        block4: {
            String string;
            in = null;
            try {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
                if (in == null) {
                    in = DmJdbcUtil.class.getResourceAsStream("/" + resource);
                }
                if (in != null) break block4;
                string = null;
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                DmJdbcUtil.close(in);
                throw throwable;
            }
            DmJdbcUtil.close(in);
            return string;
        }
        String string = text = DmJdbcUtil.read(in);
        Object var5_5 = null;
        DmJdbcUtil.close(in);
        return string;
    }

    public static void close(Closeable x) {
        if (x == null) {
            return;
        }
        try {
            x.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void printRs(ResultSet rs) throws SQLException {
        System.out.println("---------RS---------");
        ResultSetMetaData rsmd = rs.getMetaData();
        ArrayList<String> colNameList = new ArrayList<String>();
        String format = "";
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            format = format + "%-20s";
            colNameList.add(rsmd.getColumnName(i));
        }
        System.out.println(String.format(format, colNameList.toArray()));
        while (rs.next()) {
            ArrayList<String> valList = new ArrayList<String>();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                valList.add(rs.getString(i));
            }
            System.out.println(String.format(format, valList.toArray()));
        }
        rs.close();
    }
}

