/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.rsCache;

import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbInfo;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.rsCache.DmdbCachedResultSet;
import dm.jdbc.rsCache.DmdbResultSetKey;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DmdbCachedResultSetPool {
    static Map<DmdbResultSetKey, DmdbCachedResultSet> m_rsHashMap = null;
    static Map<String, Object> m_sqlMap = null;
    static List<DmdbResultSetKey> m_keyList = null;
    static long m_totalDataLen;

    private static long removeLast() {
        int size = m_keyList.size();
        if (size == 0) {
            return 0L;
        }
        DmdbResultSetKey rsKey = m_keyList.remove(size - 1);
        if (rsKey == null) {
            return 0L;
        }
        DmdbCachedResultSet crs = m_rsHashMap.remove(rsKey);
        if (crs == null) {
            return 0L;
        }
        return crs.getDataLen();
    }

    private static void refreshKeyList(DmdbResultSetKey rsKey) {
        m_keyList.remove(rsKey);
        m_keyList.add(0, rsKey);
    }

    private static void addSqlDbInfo(String guid, String curSch, String sql, DmdbInfo dbInfo) {
        String key = guid + "&" + curSch + "&" + sql;
        m_sqlMap.put(key, dbInfo.clone());
    }

    private static void removeSqlDbInfo(String guid, String curSch, String sql) {
        String key = guid + "&" + curSch + "&" + sql;
        m_sqlMap.remove(key);
    }

    public static void addResultSet(DmdbResultSet_bs rs, DmdbConnection_bs conn, String sql, long[] tbIds, long[] tbTss, DmdbInfo dbInfo) throws SQLException {
        long dataLen = rs == null ? 0L : (long)rs.getDataLen();
        long cacheSize = conn.getRsCacheSize() * 1024 * 1024;
        while (m_totalDataLen + dataLen > cacheSize) {
            if (m_totalDataLen == 0L) {
                return;
            }
            m_totalDataLen -= DmdbCachedResultSetPool.removeLast();
        }
        DmdbCachedResultSetPool.addSqlDbInfo(conn.getGUID(), conn.getSchema(), sql, dbInfo);
        DmdbResultSetKey rsKey = new DmdbResultSetKey(conn.getGUID(), conn.getSchema(), sql, (DmdbStatement_bs)rs.getStatement());
        DmdbCachedResultSetPool.refreshKeyList(rsKey);
        DmdbCachedResultSet crs = new DmdbCachedResultSet(rs, tbIds, tbTss);
        m_rsHashMap.put(rsKey, crs);
        m_totalDataLen += dataLen;
    }

    public static DmdbResultSet_bs getResultSet(String guid, String curSch, String sql, DmdbStatement_bs stmt) throws SQLException {
        DmdbResultSetKey rsKey = new DmdbResultSetKey(guid, curSch, sql, stmt);
        DmdbCachedResultSet crs = m_rsHashMap.get(rsKey);
        if (crs == null) {
            return null;
        }
        if (crs.refreshed((DmdbConnection_bs)stmt.getConnection())) {
            m_rsHashMap.remove(rsKey);
            m_keyList.remove(rsKey);
            DmdbCachedResultSetPool.removeSqlDbInfo(guid, curSch, sql);
            return null;
        }
        DmdbResultSet_bs rs = crs.getResultSet(stmt);
        DmdbCachedResultSetPool.refreshKeyList(rsKey);
        return rs;
    }

    public static DmdbInfo getDbInfo(String guid, String curSch, String sql) {
        String key = guid + "&" + curSch + "&" + sql;
        DmdbInfo dbInfo = (DmdbInfo)m_sqlMap.get(key);
        if (dbInfo == null) {
            return null;
        }
        return (DmdbInfo)dbInfo.clone();
    }

    static {
        m_rsHashMap = Collections.synchronizedMap(new HashMap(100));
        m_sqlMap = Collections.synchronizedMap(new HashMap(100));
        m_keyList = Collections.synchronizedList(new LinkedList());
        m_totalDataLen = 0L;
    }
}

