/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.rsCache;

import dm.jdbc.dbaccess.DmdbCSI;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import java.sql.SQLException;
import java.util.Calendar;

public class DmdbCachedResultSet {
    private long m_lastChkTime;
    private DmdbResultSet_bs m_rs = null;
    private long[] m_TbIds = null;
    private long[] m_TbTss = null;

    DmdbCachedResultSet(DmdbResultSet_bs rs, long[] tbIds, long[] tbTss) throws SQLException {
        if (rs != null) {
            this.m_rs = (DmdbResultSet_bs)rs.clone();
        }
        this.m_TbIds = (long[])tbIds.clone();
        this.m_TbTss = (long[])tbTss.clone();
        this.m_lastChkTime = Calendar.getInstance().getTimeInMillis();
    }

    boolean refreshed(DmdbConnection_bs conn) throws SQLException {
        int tbCount;
        if (conn.getRsRefreshFreq() == 0) {
            return false;
        }
        if (this.m_lastChkTime + (long)(conn.getRsRefreshFreq() * 1000) > Calendar.getInstance().getTimeInMillis()) {
            return false;
        }
        long[] tss = DmdbCSI.table_ts(conn, this.m_TbIds);
        this.m_lastChkTime = Calendar.getInstance().getTimeInMillis();
        int n = tbCount = tss == null ? 0 : tss.length;
        if (tbCount != this.m_TbTss.length) {
            return true;
        }
        for (int i = 0; i < tbCount; ++i) {
            if (this.m_TbTss[i] == tss[i]) continue;
            return true;
        }
        return false;
    }

    DmdbResultSet_bs getResultSet(DmdbStatement_bs stmt) throws SQLException {
        DmdbResultSet_bs rs = (DmdbResultSet_bs)this.m_rs.clone();
        rs.setStatement(stmt);
        rs.setFetchDirection(stmt.getFetchDirection());
        rs.setConcurrencyType(stmt.getResultSetConcurrency());
        rs.setHoldability(stmt.getResultSetHoldability());
        rs.maxRows = stmt.getMaxRows();
        return rs;
    }

    long getLastChkTime() {
        return this.m_lastChkTime;
    }

    long getDataLen() {
        if (this.m_rs == null) {
            return 0L;
        }
        return this.m_rs.getDataLen();
    }
}

