/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.rowset;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbResultSetMetaData;
import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.RowSetMetaData;

public class DmdbRowSetMetaData
implements RowSetMetaData,
Serializable {
    private boolean[] m_autoIncr;
    private boolean[] m_caseSens;
    private String[] m_catalogName;
    private int m_columnCount;
    private int[] m_colDisplaySize;
    private String[] m_colDisplayLable;
    private String[] m_columnName;
    private String[] m_columnClassName;
    private int[] m_colSQLType;
    private String[] m_colTypeName;
    private boolean[] m_currency;
    private int[] m_nullable;
    private int[] m_precision;
    private int[] m_scale;
    private String[] m_schemaName;
    private boolean[] m_searchable;
    private boolean[] m_signed;
    private String[] m_tableName;
    private boolean[] m_readOnly;
    private boolean[] m_writeable;
    private boolean[] m_defWriteable;

    public DmdbRowSetMetaData(DmdbResultSetMetaData metaData) throws SQLException {
        this.initializeProps(metaData.getColumnCount(), metaData);
    }

    private void initializeProps(int columnCount, DmdbResultSetMetaData rsmd) throws SQLException {
        this.m_columnCount = columnCount;
        this.m_autoIncr = new boolean[this.m_columnCount];
        this.m_caseSens = new boolean[this.m_columnCount];
        this.m_catalogName = new String[this.m_columnCount];
        this.m_colDisplaySize = new int[this.m_columnCount];
        this.m_colDisplayLable = new String[this.m_columnCount];
        this.m_columnClassName = new String[this.m_columnCount];
        this.m_columnName = new String[this.m_columnCount];
        this.m_colSQLType = new int[this.m_columnCount];
        this.m_colTypeName = new String[this.m_columnCount];
        this.m_currency = new boolean[this.m_columnCount];
        this.m_nullable = new int[this.m_columnCount];
        this.m_precision = new int[this.m_columnCount];
        this.m_scale = new int[this.m_columnCount];
        this.m_schemaName = new String[this.m_columnCount];
        this.m_searchable = new boolean[this.m_columnCount];
        this.m_signed = new boolean[this.m_columnCount];
        this.m_tableName = new String[this.m_columnCount];
        this.m_readOnly = new boolean[this.m_columnCount];
        this.m_writeable = new boolean[this.m_columnCount];
        this.m_defWriteable = new boolean[this.m_columnCount];
        for (int i = 0; i < this.m_columnCount; ++i) {
            this.m_autoIncr[i] = rsmd == null ? false : rsmd.isAutoIncrement(i + 1);
            this.m_caseSens[i] = rsmd == null ? false : rsmd.isCaseSensitive(i + 1);
            this.m_catalogName[i] = rsmd == null ? "" : rsmd.getCatalogName(i + 1);
            this.m_colDisplaySize[i] = rsmd == null ? 0 : rsmd.getColumnDisplaySize(i + 1);
            this.m_colDisplayLable[i] = rsmd == null ? "" : rsmd.getColumnLabel(i + 1);
            this.m_columnClassName[i] = rsmd == null ? "" : rsmd.getColumnClassName(i + 1);
            this.m_columnName[i] = rsmd == null ? "" : rsmd.getColumnName(i + 1);
            this.m_colSQLType[i] = rsmd == null ? 0 : rsmd.getColumnType(i + 1);
            this.m_colTypeName[i] = rsmd == null ? "" : rsmd.getColumnTypeName(i + 1);
            this.m_currency[i] = rsmd == null ? false : rsmd.isCurrency(i + 1);
            this.m_nullable[i] = rsmd == null ? 0 : rsmd.isNullable(i + 1);
            this.m_precision[i] = rsmd == null ? 0 : rsmd.getPrecision(i + 1);
            this.m_scale[i] = rsmd == null ? 0 : rsmd.getScale(i + 1);
            this.m_schemaName[i] = rsmd == null ? "" : rsmd.getSchemaName(i + 1);
            this.m_searchable[i] = rsmd == null ? false : rsmd.isSearchable(i + 1);
            this.m_signed[i] = rsmd == null ? false : rsmd.isSigned(i + 1);
            this.m_tableName[i] = rsmd == null ? "" : rsmd.getTableName(i + 1);
            this.m_readOnly[i] = rsmd == null ? false : rsmd.isReadOnly(i + 1);
            this.m_writeable[i] = rsmd == null ? false : rsmd.isWritable(i + 1);
            this.m_defWriteable[i] = rsmd == null ? false : rsmd.isDefinitelyWritable(i + 1);
        }
    }

    private void checkColumn(int column) throws SQLException {
        if (column < 1 || column > this.m_columnCount) {
            DBError.throwSQLException(6010);
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.m_columnCount;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.checkColumn(column);
        return this.m_autoIncr[column - 1];
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        this.checkColumn(column);
        return this.m_caseSens[column - 1];
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.checkColumn(column);
        return this.m_searchable[column - 1];
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        this.checkColumn(column);
        return this.m_currency[column - 1];
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.checkColumn(column);
        return this.m_nullable[column - 1];
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        this.checkColumn(column);
        return this.m_signed[column - 1];
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        this.checkColumn(column);
        return this.m_colDisplaySize[column - 1];
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        this.checkColumn(column);
        return this.m_colDisplayLable[column - 1];
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        this.checkColumn(column);
        return this.m_columnName[column - 1];
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.checkColumn(column);
        return this.m_schemaName[column - 1];
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        this.checkColumn(column);
        return this.m_precision[column - 1];
    }

    @Override
    public int getScale(int column) throws SQLException {
        this.checkColumn(column);
        return this.m_scale[column - 1];
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.checkColumn(column);
        return this.m_tableName[column - 1];
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.checkColumn(column);
        return this.m_catalogName[column - 1];
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        this.checkColumn(column);
        return this.m_colSQLType[column - 1];
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.checkColumn(column);
        return this.m_colTypeName[column - 1];
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.checkColumn(column);
        return this.m_readOnly[column - 1];
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.checkColumn(column);
        return this.m_writeable[column - 1];
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.checkColumn(column);
        return this.m_defWriteable[column - 1];
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        this.checkColumn(column);
        return this.m_columnClassName[column - 1];
    }

    @Override
    public void setColumnCount(int columnCount) throws SQLException {
        this.m_columnCount = columnCount;
    }

    @Override
    public void setAutoIncrement(int columnIndex, boolean property) throws SQLException {
        this.checkColumn(columnIndex);
        this.m_autoIncr[columnIndex - 1] = property;
    }

    @Override
    public void setCaseSensitive(int columnIndex, boolean property) throws SQLException {
        this.checkColumn(columnIndex);
        this.m_caseSens[columnIndex - 1] = property;
    }

    @Override
    public void setSearchable(int columnIndex, boolean property) throws SQLException {
        this.checkColumn(columnIndex);
        this.m_searchable[columnIndex - 1] = property;
    }

    @Override
    public void setCurrency(int columnIndex, boolean property) throws SQLException {
        this.checkColumn(columnIndex);
        this.m_currency[columnIndex - 1] = property;
    }

    @Override
    public void setNullable(int columnIndex, int property) throws SQLException {
        this.checkColumn(columnIndex);
        this.m_nullable[columnIndex - 1] = property;
    }

    @Override
    public void setSigned(int columnIndex, boolean property) throws SQLException {
        this.checkColumn(columnIndex);
        this.m_signed[columnIndex - 1] = property;
    }

    @Override
    public void setColumnDisplaySize(int columnIndex, int size) throws SQLException {
        this.checkColumn(columnIndex);
        this.m_colDisplaySize[columnIndex - 1] = size;
    }

    @Override
    public void setColumnLabel(int columnIndex, String label) throws SQLException {
        this.checkColumn(columnIndex);
        this.m_colDisplayLable[columnIndex - 1] = label;
    }

    @Override
    public void setColumnName(int columnIndex, String columnName) throws SQLException {
        this.checkColumn(columnIndex);
        this.m_columnName[columnIndex - 1] = columnName;
    }

    @Override
    public void setSchemaName(int columnIndex, String schemaName) throws SQLException {
        this.checkColumn(columnIndex);
        this.m_schemaName[columnIndex - 1] = schemaName;
    }

    @Override
    public void setPrecision(int columnIndex, int precision) throws SQLException {
        this.checkColumn(columnIndex);
        this.m_precision[columnIndex - 1] = precision;
    }

    @Override
    public void setScale(int columnIndex, int scale) throws SQLException {
        this.checkColumn(columnIndex);
        this.m_scale[columnIndex - 1] = scale;
    }

    @Override
    public void setTableName(int columnIndex, String tableName) throws SQLException {
        this.checkColumn(columnIndex);
        this.m_tableName[columnIndex - 1] = tableName;
    }

    @Override
    public void setCatalogName(int columnIndex, String catalogName) throws SQLException {
        this.checkColumn(columnIndex);
        this.m_catalogName[columnIndex - 1] = catalogName;
    }

    @Override
    public void setColumnType(int columnIndex, int SQLType2) throws SQLException {
        this.checkColumn(columnIndex);
        this.m_colSQLType[columnIndex - 1] = SQLType2;
    }

    @Override
    public void setColumnTypeName(int columnIndex, String typeName) throws SQLException {
        this.checkColumn(columnIndex);
        this.m_colTypeName[columnIndex - 1] = typeName;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

