/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.processor;

import dm.jdbc.processor.BaseThread;
import dm.jdbc.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Date;

public abstract class BaseFlusher
extends BaseThread {
    protected String date = new Date(System.currentTimeMillis()).toString();
    private File logFile = null;
    private FileOutputStream os;
    protected final byte[] datas = new byte[32768];
    public static final int MAX_LOG_FILE_SIZE = 0x6400000;

    public BaseFlusher(String name) {
        super(name);
    }

    protected FileOutputStream createNewFile() {
        try {
            this.date = new Date(System.currentTimeMillis()).toString();
            String dir = this.getFilePath();
            String fileName = this.getFileName();
            if (StringUtil.isNotEmpty(dir) && StringUtil.isNotEmpty(fileName)) {
                File logPath = new File(dir);
                if (!logPath.exists()) {
                    logPath.mkdirs();
                }
                this.logFile = new File(dir + fileName);
                if (!this.logFile.exists()) {
                    this.logFile.createNewFile();
                }
                return new FileOutputStream(this.logFile, true);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeCurrentFile() {
        if (this.os != null) {
            try {
                try {
                    this.os.close();
                }
                catch (IOException iOException) {
                    Object var3_2 = null;
                    this.os = null;
                }
                Object var3_1 = null;
                this.os = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.os = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block13: {
            try {
                while (this.getFlushFreq() > 0) {
                    if (this.os == null || this.needCreateNewFile()) {
                        this.closeCurrentFile();
                        this.os = this.createNewFile();
                    }
                    try {
                        if (this.os != null) {
                            this.doFlush();
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    if (this.getFlushFreq() <= 0) continue;
                    try {
                        Thread.sleep(this.getFlushFreq() * 1000);
                    }
                    catch (Exception exception) {}
                }
                Object var3_4 = null;
                if (this.os == null) break block13;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                if (this.os != null) {
                    try {
                        this.beforeExit();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    this.closeCurrentFile();
                }
                throw throwable;
            }
            try {
                this.beforeExit();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.closeCurrentFile();
            {
            }
        }
    }

    protected int getFlushFreq() {
        return 0;
    }

    private boolean needCreateNewFile() {
        String value = new Date(System.currentTimeMillis()).toString();
        return !value.equals(this.date) || this.logFile == null || this.logFile.length() > 0x6400000L;
    }

    protected String getFileName() {
        return this.date + "_" + System.currentTimeMillis() + ".log";
    }

    protected abstract String getFilePath();

    protected abstract void doFlush() throws Exception;

    protected void writeAndFlush(String[] logs, int startOff, int len) throws IOException {
        if (this.os != null) {
            int bufferOffset = 0;
            byte[] bytes = null;
            int bytesOffset = 0;
            for (int i = startOff; i < startOff + len; ++i) {
                int appendlen;
                bytes = (logs[i] + StringUtil.LINE_SEPARATOR).getBytes();
                for (bytesOffset = 0; bytesOffset < bytes.length; bytesOffset += appendlen) {
                    appendlen = bytes.length - bytesOffset <= this.datas.length - bufferOffset ? bytes.length - bytesOffset : this.datas.length - bufferOffset;
                    System.arraycopy(bytes, bytesOffset, this.datas, bufferOffset, appendlen);
                    if (this.datas.length != (bufferOffset += appendlen)) continue;
                    this.os.write(this.datas, 0, bufferOffset);
                    bufferOffset = 0;
                }
            }
            if (bufferOffset > 0) {
                this.os.write(this.datas, 0, bufferOffset);
            }
            this.os.flush();
        }
    }
}

