/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.log;

import dm.jdbc.log.LogBuffer;
import dm.jdbc.log.LogFlusher;
import java.util.concurrent.locks.ReentrantLock;

public class LogWriter {
    private LogBuffer buffer;
    private ReentrantLock lock = new ReentrantLock();
    private LogFlusher flusher;

    private LogWriter() {
        this.buffer = LogBuffer.borrowBuffer();
        this.flusher = LogFlusher.getInstance();
        this.flusher.start();
    }

    public static LogWriter getInstance() {
        return LoggerHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String log) {
        try {
            this.lock.lock();
            if (this.buffer.isFull()) {
                this.flusher.submit(this.buffer);
                this.buffer = LogBuffer.borrowBuffer();
            }
            this.buffer.log(log);
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSubmitBuffer() {
        try {
            this.lock.lock();
            if (this.buffer.getOffset() > 0) {
                this.flusher.submit(this.buffer);
                this.buffer = LogBuffer.borrowBuffer();
            }
            Object var2_1 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    public static void submitBuffer() {
        LogWriter.getInstance().doSubmitBuffer();
    }

    public static void main(String[] args) {
        LogWriter logger = LogWriter.getInstance();
        for (int i = 0; i < 500; ++i) {
            logger.write("select " + i + " from dual;");
        }
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LogWriter.submitBuffer();
    }

    private static class LoggerHolder {
        private static final LogWriter instance = new LogWriter();

        private LoggerHolder() {
        }
    }
}

