/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.jzlib;

import dm.jdbc.jzlib.ZInputStream;
import dm.jdbc.jzlib.ZOutputStream;
import dm.jdbc.jzlib.ZStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ZlibUtil {
    public static int compress(byte[] src, byte[] obj) {
        int err = 0;
        ZStream c_stream = new ZStream();
        err = c_stream.deflateInit(-1);
        ZlibUtil.CHECK_ERR(c_stream, err, "deflateInit");
        c_stream.next_in = src;
        c_stream.avail_in = src.length;
        c_stream.next_in_index = 0;
        c_stream.next_out = obj;
        c_stream.avail_out = obj.length;
        c_stream.next_out_index = 0;
        err = c_stream.deflate(0);
        ZlibUtil.CHECK_ERR(c_stream, err, "deflate");
        while (true) {
            c_stream.avail_out = 1;
            err = c_stream.deflate(4);
            if (err == 1) break;
            ZlibUtil.CHECK_ERR(c_stream, err, "deflate");
        }
        if (c_stream.avail_in != 0) {
            System.out.println("deflate not greedy");
            System.exit(1);
        }
        err = c_stream.deflateEnd();
        ZlibUtil.CHECK_ERR(c_stream, err, "deflateEnd");
        return (int)c_stream.total_out;
    }

    public static byte[] uncompress(byte[] src, int length) {
        byte[] uncomp = null;
        byte[] tmp = new byte[length];
        ZStream d_stream = new ZStream();
        d_stream.next_in = src;
        d_stream.next_in_index = 0;
        d_stream.avail_in = src.length;
        int err = d_stream.inflateInit();
        ZlibUtil.CHECK_ERR(d_stream, err, "inflateInit");
        while (true) {
            d_stream.next_out = tmp;
            d_stream.next_out_index = 0;
            d_stream.avail_out = length;
            err = d_stream.inflate(0);
            if (err == 1) break;
            ZlibUtil.CHECK_ERR(d_stream, err, "inflate large");
        }
        err = d_stream.inflateEnd();
        ZlibUtil.CHECK_ERR(d_stream, err, "inflateEnd");
        uncomp = new byte[(int)d_stream.total_out];
        int i = 0;
        while ((long)i < d_stream.total_out) {
            uncomp[i] = tmp[i];
            ++i;
        }
        return uncomp;
    }

    private static void CHECK_ERR(ZStream z, int err, String msg) {
        if (err != 0) {
            if (z.msg != null) {
                System.out.print(z.msg + " ");
            }
            System.out.println(msg + " error: " + err);
            System.exit(1);
        }
    }

    public static byte[] compress(byte[] object) {
        byte[] data = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ZOutputStream zOut = new ZOutputStream(out, -1);
            DataOutputStream objOut = new DataOutputStream(zOut);
            objOut.write(object);
            objOut.flush();
            zOut.close();
            data = out.toByteArray();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    public static byte[] uncompress(byte[] object) {
        byte[] data = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(object);
            ZInputStream zIn = new ZInputStream(in);
            byte[] buf = new byte[1024];
            int num = -1;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((num = zIn.read(buf, 0, buf.length)) != -1) {
                baos.write(buf, 0, num);
            }
            data = baos.toByteArray();
            baos.flush();
            baos.close();
            zIn.close();
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    public static void main(String[] args) {
        int i;
        String str = "\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd";
        byte[] original = str.getBytes();
        byte[] comp = new byte[100];
        byte[] compIn = null;
        byte[] uncomp = null;
        System.out.println("\u539f\u59cb\u6570\u636e\uff1a");
        for (i = 0; i < original.length; ++i) {
            System.out.print(original[i] + " ");
        }
        System.out.println();
        System.out.println("<\u65b9\u6cd51>");
        long length = ZlibUtil.compress(original, comp);
        System.out.println("\u538b\u7f29\u540e\u7684\u6570\u636e\uff1a");
        i = 0;
        while ((long)i < length) {
            System.out.print(comp[i] + " ");
            ++i;
        }
        compIn = new byte[(int)length];
        i = 0;
        while ((long)i < length) {
            compIn[i] = comp[i];
            ++i;
        }
        uncomp = ZlibUtil.uncompress(compIn, 100);
        System.out.println("\n\u89e3\u538b\u540e\u7684\u6570\u636e\uff1a");
        for (i = 0; i < uncomp.length; ++i) {
            System.out.print(uncomp[i] + " ");
        }
        System.out.println();
        System.out.println("<\u65b9\u6cd52>");
        byte[] jzlib = ZlibUtil.compress(original);
        System.out.println("\u538b\u7f29\u540e\u7684\u6570\u636e\uff1a");
        for (int i2 = 0; i2 < jzlib.length; ++i2) {
            System.out.print(jzlib[i2] + " ");
        }
        byte[] unjzlib = ZlibUtil.uncompress(jzlib);
        System.out.println("\n\u89e3\u538b\u540e\u7684\u6570\u636e\uff1a");
        for (int i3 = 0; i3 < unjzlib.length; ++i3) {
            System.out.print(unjzlib[i3] + " ");
        }
    }
}

