/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.jzlib;

import dm.jdbc.jzlib.ZStream;
import dm.jdbc.jzlib.ZStreamException;
import java.io.IOException;
import java.io.OutputStream;

public class ZOutputStream
extends OutputStream {
    protected ZStream z = new ZStream();
    protected int bufsize = 512;
    protected int flush = 0;
    protected byte[] buf = new byte[this.bufsize];
    protected byte[] buf1 = new byte[1];
    protected boolean compress;
    protected OutputStream out;

    public ZOutputStream(OutputStream out) {
        this.out = out;
        this.z.inflateInit();
        this.compress = false;
    }

    public ZOutputStream(OutputStream out, int level) {
        this(out, level, false);
    }

    public ZOutputStream(OutputStream out, int level, boolean nowrap) {
        this.out = out;
        this.z.deflateInit(level, nowrap);
        this.compress = true;
    }

    public void write(int b) throws IOException {
        this.buf1[0] = (byte)b;
        this.write(this.buf1, 0, 1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        this.z.next_in = b;
        this.z.next_in_index = off;
        this.z.avail_in = len;
        do {
            this.z.next_out = this.buf;
            this.z.next_out_index = 0;
            this.z.avail_out = this.bufsize;
            int err = this.compress ? this.z.deflate(this.flush) : this.z.inflate(this.flush);
            if (err != 0) {
                throw new ZStreamException((this.compress ? "de" : "in") + "flating: " + this.z.msg);
            }
            this.out.write(this.buf, 0, this.bufsize - this.z.avail_out);
        } while (this.z.avail_in > 0 || this.z.avail_out == 0);
    }

    public int getFlushMode() {
        return this.flush;
    }

    public void setFlushMode(int flush) {
        this.flush = flush;
    }

    public void finish() throws IOException {
        do {
            this.z.next_out = this.buf;
            this.z.next_out_index = 0;
            this.z.avail_out = this.bufsize;
            int err = this.compress ? this.z.deflate(4) : this.z.inflate(4);
            if (err != 1 && err != 0) {
                throw new ZStreamException((this.compress ? "de" : "in") + "flating: " + this.z.msg);
            }
            if (this.bufsize - this.z.avail_out <= 0) continue;
            this.out.write(this.buf, 0, this.bufsize - this.z.avail_out);
        } while (this.z.avail_in > 0 || this.z.avail_out == 0);
        this.flush();
    }

    public void end() {
        if (this.z == null) {
            return;
        }
        if (this.compress) {
            this.z.deflateEnd();
        } else {
            this.z.inflateEnd();
        }
        this.z.free();
        this.z = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            try {
                this.finish();
            }
            catch (IOException iOException) {
            }
            Object var3_2 = null;
            this.end();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.end();
            this.out.close();
            this.out = null;
            throw throwable;
        }
        this.out.close();
        this.out = null;
    }

    public long getTotalIn() {
        return this.z.total_in;
    }

    public long getTotalOut() {
        return this.z.total_out;
    }

    public void flush() throws IOException {
        this.out.flush();
    }
}

