/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.accessor.BaseAccessor;
import dm.jdbc.dataConvertion.accessor.BlobAccessor;
import dm.jdbc.dataConvertion.accessor.ClobAccessor;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmdbCSI;
import dm.jdbc.dbaccess.FetchDaemons;
import dm.jdbc.desc.ColumnDesc;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.desc.DmdbParamVal;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbColumn;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbInfo;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbResultSetCache_h;
import dm.jdbc.driver.DmdbResultSetMetaData_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.util.StringUtil;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DmdbResultSet_bs
implements ResultSet,
Cloneable {
    private DmdbResultSetCache rsCache;
    public LinkedList<DmdbResultSetCache> rsCacheList;
    public int cacheCount = 0;
    Thread fetchThread;
    public SQLException fetchThreadError = null;
    private boolean m_multiRsCaches = false;
    DmdbStatement_bs statement = null;
    DmdbConnection_bs conn = null;
    protected SQLWarning m_warnings = null;
    protected int maxFieldSize;
    protected boolean isClosed = false;
    int fetchDirection;
    int fetchSize;
    protected int resultSetType;
    protected int resultConcurrencyType;
    protected int resultSetHoldability;
    protected int lastColIndex;
    private boolean m_ignorCase = true;
    long startRow = 0L;
    DmdbInfo dbInfo = null;
    DmdbColumn[] colInfo = null;
    protected long currentRow = -1L;
    Hashtable<Integer, DmdbParamVal> m_updateParams = new Hashtable();
    protected boolean isUpdateStatus = false;
    protected boolean isInsertStatus = false;
    boolean metaRsFlag = false;
    public long rowCount = 0L;
    public long maxRows = 0L;
    public boolean fromRsCachePool = false;
    int columnCount = 0;
    String serverEncoding = null;
    DmdbBlob[][] m_blobArray = null;
    DmdbClob[][] m_clobArray = null;
    private boolean m_lobCached = false;
    short rsId = 0;
    boolean m_fromStandby = false;
    private BaseAccessor[] colAccessor;
    int FETCH_FORWARD = 1000;
    int FETCH_REVERSE = 1001;
    int FETCH_UNKNOWN = 1002;
    int TYPE_FORWARD_ONLY = 1003;
    int TYPE_SCROLL_INSENSITIVE = 1004;
    int TYPE_SCROLL_SENSITIVE = 1005;
    int CONCUR_READ_ONLY = 1007;
    int CONCUR_UPDATABLE = 1008;
    int HOLD_CURSORS_OVER_COMMIT = 1;
    int CLOSE_CURSORS_AT_COMMIT = 2;

    DmdbResultSet_bs() {
    }

    public int getDataLen() {
        return this.getRsCache().realLen;
    }

    public void setStatement(DmdbStatement_bs stmt) throws SQLException {
        this.statement = stmt;
        this.conn = (DmdbConnection_bs)stmt.getConnection();
    }

    private void cacheLob() throws SQLException {
        if (this.conn == null || this.statement == null || this.colInfo == null || this.getRsCache() == null || this.colInfo.length == 0 || this.colInfo[0].getDesc().getLobMode() != 2) {
            return;
        }
        int rowCountTemp = (int)this.rowCount;
        if (rowCountTemp <= 0 || rowCountTemp != this.getRsCache().getRownum()) {
            return;
        }
        this.m_blobArray = new DmdbBlob[rowCountTemp][this.columnCount];
        this.m_clobArray = new DmdbClob[rowCountTemp][this.columnCount];
        boolean isBlob = false;
        for (short col = 0; col < this.columnCount; col = (short)((short)(col + 1))) {
            ColumnDesc desc = this.colInfo[col].getDesc();
            if (!desc.getIsLob()) continue;
            isBlob = desc.getDType() == 12;
            int row = 0;
            while ((long)row < this.rowCount) {
                if (row == 0) {
                    this.getRsCache().absolute(0);
                } else {
                    this.getRsCache().next();
                }
                byte[] value = this.getRsCache().getBytes(col);
                if (value != null) {
                    if (isBlob) {
                        this.m_blobArray[row][col] = BlobAccessor.get_blob_value(value, desc.getLobDesc(), this.conn, !desc.isReadOnly());
                    } else {
                        this.m_clobArray[row][col] = ClobAccessor.get_clob_value(value, desc.getLobDesc(), this.conn, !desc.isReadOnly());
                    }
                }
                ++row;
            }
        }
        this.m_lobCached = true;
    }

    private void initialize(DmdbInfo info, DmdbResultSetCache cache, boolean fromStandby) throws SQLException {
        int i;
        if (null != info) {
            this.dbInfo = (DmdbInfo)info.clone();
            this.colInfo = info.getColumnsInfo();
            this.rowCount = info.getRowCount();
            this.columnCount = info.getColumnCount();
            this.statement = null;
            this.conn = null;
        }
        if (null != cache) {
            this.setRsCache(cache);
            this.statement = this.getRsCache().getStatement();
            this.conn = this.statement.connection;
            this.maxFieldSize = 0;
            this.resultSetType = 1003;
            this.resultConcurrencyType = 1007;
            this.resultSetHoldability = 1;
            this.serverEncoding = this.conn.getServerEncoding();
            this.fetchDirection = 1000;
            this.fetchSize = 5;
            if (this.statement != null) {
                this.maxFieldSize = this.statement.getMaxFieldSize();
                this.resultSetType = this.statement.getResultSetType();
                this.resultConcurrencyType = this.statement.getResultSetConcurrency();
                this.resultSetHoldability = this.statement.getResultSetHoldability();
                this.fetchDirection = this.statement.getFetchDirection();
                this.fetchSize = this.statement.getFetchSize();
            }
            this.m_ignorCase = this.conn.isIgnoreCase();
            boolean bl = this.m_multiRsCaches = this.conn.isMultiRsCaches() && this.resultSetType == 1003 && (!this.conn.isEnRsCache() || this.dbInfo.getRsCacheOffset() == 0);
            if (this.conn.getRsCacheCount() > 1) {
                this.cacheCount = this.conn.getRsCacheCount() - 1;
            }
            if (this.m_multiRsCaches && this.rowCount == Long.MAX_VALUE) {
                this.rsCacheList = new LinkedList();
                this.fetchThread = new Thread(new FetchDaemons(this));
                this.fetchThread.setDaemon(true);
                this.fetchThread.start();
            }
            if (this.colInfo != null && this.colInfo.length > 0) {
                this.colAccessor = new BaseAccessor[this.colInfo.length];
                for (i = 0; i < this.colInfo.length; ++i) {
                    this.colAccessor[i] = BaseAccessor.getInstance(this.rsCache, this.colInfo[i].getDesc(), this.conn, i, this.colInfo.length, this.maxFieldSize);
                }
            }
        }
        if (this.colInfo != null && this.conn != null && this.conn.isEnRsCache() && info.getRsCacheOffset() > 0) {
            for (i = 0; i < this.colInfo.length; ++i) {
                this.colInfo[i].getDesc().setLobMode(2);
            }
        }
        this.m_fromStandby = fromStandby;
        this.initializePara();
        this.cacheLob();
    }

    public void setConcurrencyType(int conType) {
        this.resultConcurrencyType = conType;
    }

    public void setHoldability(int hold) {
        this.resultSetHoldability = hold;
    }

    DmdbResultSet_bs(DmdbInfo info, boolean fromStandby) throws SQLException {
        this.initialize(info, null, fromStandby);
    }

    DmdbResultSet_bs(DmdbResultSetCache cache, DmdbInfo info, boolean fromStandby) throws SQLException {
        this.initialize(info, cache, fromStandby);
    }

    DmdbResultSet_bs(DmdbResultSetCache cache, DmdbInfo info, boolean fetchAll, boolean fromStandby) throws SQLException {
        this.initialize(info, cache, fromStandby);
        if (this.rowCount > (long)this.getRsCache().getRownum()) {
            this.fetchData(1, fetchAll);
        }
        this.metaRsFlag = true;
        this.initializePara();
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClose();
        if (this.rowCount == 0L) {
            this.m_warnings = DBError.addSQLWarning(this.m_warnings, 100);
            return false;
        }
        if (this.fromRsCachePool && this.maxRows != 0L && this.currentRow + 1L == this.maxRows) {
            return false;
        }
        if (this.currentRow == -1L) {
            ++this.currentRow;
            if (this.startRow == 0L && this.getRsCache().getRownum() > 0) {
                this.getRsCache().absolute(0);
            } else if (this.m_multiRsCaches && this.rsCacheList != null) {
                this.fetch_for_multiRsCaches();
            } else {
                this.fetchData(1, false);
            }
            return true;
        }
        if (this.currentRow < this.rowCount) {
            ++this.currentRow;
            if (this.currentRow == this.rowCount) {
                this.getRsCache().next();
                return false;
            }
            if (this.currentRow >= this.startRow + (long)this.getRsCache().getRownum()) {
                this.startRow = this.currentRow;
                if (this.m_multiRsCaches && this.rsCacheList != null) {
                    this.fetch_for_multiRsCaches();
                } else {
                    int code = this.fetchData(1, false);
                    if (code == -7036) {
                        if (this.resultSetType != 1003) {
                            this.startRow = this.currentRow = this.rowCount - 1L;
                            this.fetchData(1, false);
                            this.currentRow = this.rowCount;
                            this.getRsCache().next();
                        }
                        return false;
                    }
                }
            } else {
                this.getRsCache().next();
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fetch_for_multiRsCaches() throws SQLException {
        if (this.fetchThreadError != null) {
            if (this.rsCacheList.size() <= 0) throw this.fetchThreadError;
            this.setRsCache(this.rsCacheList.removeFirst());
            return;
        } else {
            while (this.rsCacheList.size() == 0) {
                if (this.fetchThread.isAlive() || this.rowCount != Long.MAX_VALUE) continue;
                this.fetchThread = new Thread(new FetchDaemons(this));
                this.fetchThread.setDaemon(true);
                this.fetchThread.start();
            }
            this.setRsCache(this.rsCacheList.removeFirst());
            if (this.fetchThread.isAlive() || this.rowCount != Long.MAX_VALUE) return;
            this.fetchThread = new Thread(new FetchDaemons(this));
            this.fetchThread.setDaemon(true);
            this.fetchThread.start();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.dbInfo = null;
        this.colInfo = null;
        this.currentRow = -1L;
        this.m_multiRsCaches = false;
        this.setRsCache(null);
        this.rsCacheList = null;
        this.fetchThread = null;
        this.fetchThreadError = null;
        this.cacheCount = 1;
        if (this.fetchThread != null) {
            this.fetchThread.stop();
            this.fetchThread = null;
        }
        this.m_blobArray = null;
        this.m_clobArray = null;
        this.clearWarnings();
        this.statement = null;
        this.conn = null;
        if (this.rsCacheList != null) {
            this.rsCacheList.clear();
            this.rsCacheList = null;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClose();
        this.checkIndex(this.lastColIndex);
        return this.colAccessor[this.lastColIndex - 1].isWasNull();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkBeforeGetDate(columnIndex);
        return this.colAccessor[columnIndex - 1].getString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkBeforeGetDate(columnIndex);
        return this.colAccessor[columnIndex - 1].getBoolean();
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkBeforeGetDate(columnIndex);
        return this.colAccessor[columnIndex - 1].getByte();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkBeforeGetDate(columnIndex);
        return this.colAccessor[columnIndex - 1].getShort();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkBeforeGetDate(columnIndex);
        return this.colAccessor[columnIndex - 1].getInt();
    }

    private void checkBeforeGetDate(int columnIndex) throws SQLException {
        if (this.isClosed) {
            DBError.throwSQLException(6034);
        }
        if (this.currentRow <= -1L && this.rowCount >= 0L) {
            throw new SQLException(DmSvcConf.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.currentRow >= this.rowCount && this.rowCount >= 0L) {
            throw new SQLException(DmSvcConf.res.getString("error.cursorNotInResultSet"));
        }
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            DBError.throwSQLException(6032);
        }
        this.lastColIndex = columnIndex;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkBeforeGetDate(columnIndex);
        return this.colAccessor[columnIndex - 1].getLong();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkBeforeGetDate(columnIndex);
        return this.colAccessor[columnIndex - 1].getFloat();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkBeforeGetDate(columnIndex);
        return this.colAccessor[columnIndex - 1].getDouble();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal dec = this.getBigDecimal(columnIndex);
        return dec == null ? null : dec.setScale(scale, 4);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkBeforeGetDate(columnIndex);
        return this.colAccessor[columnIndex - 1].getBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkBeforeGetDate(columnIndex);
        return this.colAccessor[columnIndex - 1].getDate();
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkBeforeGetDate(columnIndex);
        return this.colAccessor[columnIndex - 1].getTime();
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkBeforeGetDate(columnIndex);
        return this.colAccessor[columnIndex - 1].getTimestamp();
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkBeforeGetDate(columnIndex);
        return this.colAccessor[columnIndex - 1].getAsciiStream();
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkBeforeGetDate(columnIndex);
        return this.colAccessor[columnIndex - 1].getUnicodeStream();
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkBeforeGetDate(columnIndex);
        return this.colAccessor[columnIndex - 1].getBinaryStream();
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClose();
        return this.m_warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.m_warnings = null;
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkClose();
        if (this.statement.cursorName == null) {
            this.statement.setCursorName("BPXLYBHQ" + this.statement.handle);
        }
        this.statement.connection.remove_statement(this.statement.handle);
        this.statement.connection.add_statement(this.statement.handle, this.statement);
        return this.statement.cursorName;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClose();
        if (this.conn != null) {
            return new DmdbResultSetMetaData_bs(this.statement, this.colInfo, this.resultConcurrencyType, this.conn.isCompatibleOracle(), this.conn.isClobAsString());
        }
        return new DmdbResultSetMetaData_bs(this.statement, this.colInfo, this.resultConcurrencyType, false, false);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getObjectInner(columnIndex, this.conn.getTypeMap());
    }

    private Object getObjectInner(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.checkBeforeGetDate(columnIndex);
        ColumnDesc desc = this.colInfo[columnIndex - 1].getDesc();
        if (this.conn.isCompatibleOracle() && DmdbType.isNUMERICtype(DmdbType.dtypeToSqlType(desc.getDType(), desc.getTypeName()))) {
            return this.getBigDecimal(columnIndex);
        }
        if (this.m_lobCached && (desc.getDType() == 12 || desc.getDType() == 19) && !DmdbType.isComplexType(desc.getDType(), desc.getScale())) {
            int len = 0;
            if (desc.getDType() == 12) {
                DmdbBlob blob = this.m_blobArray[(int)this.currentRow][columnIndex - 1];
                this.colAccessor[columnIndex - 1].setWasNull(blob == null);
                if (blob == null) {
                    return null;
                }
                if ("LONGVARBINARY".equalsIgnoreCase(desc.getTypeName())) {
                    len = blob.getLobLen();
                    if (this.maxFieldSize > 0 && len > this.maxFieldSize) {
                        len = this.maxFieldSize;
                    }
                    return blob.getBytes(1L, len);
                }
                return blob;
            }
            DmdbClob clob = this.m_clobArray[(int)this.currentRow][columnIndex - 1];
            this.colAccessor[columnIndex - 1].setWasNull(clob == null);
            if (clob == null) {
                return null;
            }
            if ("LONGVARCHAR".equalsIgnoreCase(desc.getTypeName())) {
                len = clob.getLobLen();
                return clob.getSubString(1L, len);
            }
            return clob;
        }
        return this.colAccessor[columnIndex - 1].getObject(map == null ? this.conn.getTypeMap() : map);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        this.checkClose();
        String colTemp = null;
        int retIndex = -1;
        for (int i = 0; i < this.colInfo.length; ++i) {
            colTemp = this.colInfo[i].getDesc().getName();
            if (this.m_ignorCase) {
                if (!colTemp.equalsIgnoreCase(columnName)) continue;
                retIndex = i + 1;
                break;
            }
            if (!colTemp.equals(columnName)) continue;
            retIndex = i + 1;
            break;
        }
        if (retIndex == -1) {
            DBError.throwSQLException(6017);
        }
        return retIndex;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkBeforeGetDate(columnIndex);
        return this.colAccessor[columnIndex - 1].getCharacterStream();
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkBeforeGetDate(columnIndex);
        return this.colAccessor[columnIndex - 1].getBigDecimal();
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClose();
        return this.isBeforeFirst_inner();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClose();
        return this.isAfterLast_inner();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClose();
        return this.currentRow == 0L && this.currentRow < this.rowCount;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClose();
        if (this.resultSetType == 1003) {
            DBError.throwSQLException(6019);
        }
        if (this.rowCount == Long.MAX_VALUE) {
            this.rowCount = DmdbCSI.getRowCount(this.statement, this.m_fromStandby);
        }
        return this.currentRow == this.rowCount - 1L && this.currentRow > -1L;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.rowCount != 0L) {
            this.absolute(1);
            this.currentRow = -1L;
        }
    }

    @Override
    public void afterLast() throws SQLException {
        this.last();
        this.currentRow = this.rowCount;
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClose();
        if (this.resultSetType == 1003) {
            DBError.throwSQLException(6019);
        }
        if (this.rowCount == Long.MAX_VALUE) {
            this.rowCount = DmdbCSI.getRowCount(this.statement, this.m_fromStandby);
        }
        if (this.rowCount == 0L) {
            return false;
        }
        return this.absolute((int)this.rowCount);
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClose();
        if (this.rowCount == 0L || this.currentRow == -1L || this.currentRow >= this.rowCount) {
            return 0;
        }
        return (int)this.currentRow + 1;
    }

    @Override
    public boolean absolute(int rows) throws SQLException {
        this.checkClose();
        if (rows == 0) {
            DBError.throwSQLException(6020);
        }
        if (this.resultSetType == 1003) {
            DBError.throwSQLException(6019);
        }
        if (this.rowCount == 0L) {
            this.currentRow = -1L;
            return false;
        }
        if (rows > 0) {
            if ((long)rows > this.startRow && (long)rows <= this.startRow + (long)this.getRsCache().getRownum()) {
                this.currentRow = rows - 1;
                this.getRsCache().absolute((int)((long)rows - this.startRow - 1L));
                return true;
            }
            if ((long)rows <= this.rowCount) {
                this.startRow = this.currentRow = (long)(rows - 1);
                int code = this.fetchData(1, false);
                if (code == -7036) {
                    this.startRow = this.currentRow = this.rowCount - 1L;
                    code = this.fetchData(1, false);
                    this.getRsCache().absolute(this.getRsCache().getRownum());
                    this.currentRow = this.rowCount;
                    return false;
                }
                return true;
            }
            this.startRow = this.currentRow = this.rowCount - 1L;
            this.fetchData(1, false);
            this.getRsCache().absolute(this.getRsCache().getRownum());
            this.currentRow = this.rowCount;
            return false;
        }
        if (rows < 0) {
            if (this.rowCount == Long.MAX_VALUE) {
                this.rowCount = DmdbCSI.getRowCount(this.statement, this.m_fromStandby);
            }
            if ((long)rows + this.rowCount >= this.startRow && (long)rows + this.rowCount < this.startRow + (long)this.getRsCache().getRownum()) {
                this.currentRow = this.rowCount + (long)rows;
                this.getRsCache().absolute(this.getRsCache().getRownum() + rows);
            } else if (this.rowCount + (long)rows >= 0L) {
                this.startRow = this.currentRow = this.rowCount + (long)rows;
                this.fetchData(1, false);
            } else if (this.rowCount + (long)rows <= -1L) {
                this.currentRow = 0L;
                this.startRow = 0L;
                this.fetchData(1, false);
                this.getRsCache().absolute(0);
                this.currentRow = -1L;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        int rowNum;
        this.checkClose();
        if (this.resultSetType == 1003) {
            DBError.throwSQLException(6019);
        }
        if ((rowNum = (int)((long)rows + this.currentRow + 1L)) <= 0) {
            this.beforeFirst();
            return false;
        }
        if ((long)rowNum > this.rowCount) {
            this.afterLast();
            return false;
        }
        return this.absolute(rowNum);
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClose();
        if (this.resultSetType == 1003) {
            DBError.throwSQLException(6019);
        }
        if (this.currentRow > -1L) {
            if (this.currentRow <= this.startRow && this.currentRow > 0L) {
                this.startRow = this.currentRow - 1L;
                this.fetchData(2, false);
            } else {
                this.getRsCache().previous();
                --this.currentRow;
            }
        }
        return this.currentRow > -1L;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClose();
        if (direction != 1002 && direction != 1000 && direction != 1001) {
            DBError.throwSQLException(6022);
        }
        if (this.resultSetType == 1003 && direction != 1000) {
            DBError.throwSQLException(6023);
        }
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClose();
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClose();
        if (rows >= 0 && (this.statement.getMaxRows() > 0 && rows <= this.statement.getMaxRows() || this.statement.getMaxRows() == 0)) {
            this.fetchSize = rows;
        } else {
            DBError.throwSQLException(6020);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClose();
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        this.checkClose();
        return this.resultSetType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClose();
        return this.resultConcurrencyType;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.updateParam(columnIndex, null, 24);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.updateParam(columnIndex, new Boolean(x), 0);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.updateParam(columnIndex, new Byte(x), 1);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.updateParam(columnIndex, new Short(x), 2);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.updateParam(columnIndex, new Integer(x), 3);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.updateParam(columnIndex, new Long(x), 4);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.updateParam(columnIndex, new Float(x), 5);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.updateParam(columnIndex, new Double(x), 6);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.updateParam(columnIndex, x, 7);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.updateParam(columnIndex, x, 14);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.updateParam(columnIndex, x, 15);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.updateParam(columnIndex, x, 8);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.updateParam(columnIndex, x, 9);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.updateParam(columnIndex, x, 10);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.updateParam(columnIndex, x, 19, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.updateParam(columnIndex, x, 19, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.updateParam(columnIndex, x, 19);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.updateParam(columnIndex, x, 19, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.updateParam(columnIndex, x, 19, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.updateParam(columnIndex, x, 19);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.updateParam(columnIndex, x, 18, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.updateParam(columnIndex, x, 18, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.updateParam(columnIndex, x, 18);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.updateParam_withScale(columnIndex, x, 25, scale);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        if (x instanceof BigDecimal) {
            int scale = ((BigDecimal)x).scale();
            this.updateParam_withScale(columnIndex, x, 25, scale);
        } else {
            this.updateParam(columnIndex, x, 25);
        }
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        if (!this.isInsertStatus) {
            DBError.throwSQLException(6026);
        }
        if (this.m_updateParams.size() <= 0) {
            throw new SQLException("Can't insert Row for nothing update.");
        }
        this.checkBoundaryForUpdate();
        String paramNames = "";
        String paramEntity = "";
        String schemaName = "\"" + StringUtil.getEscObjName(this.colInfo[0].getDesc().getSchName()) + "\"";
        String tableName = "\"" + StringUtil.getEscObjName(this.colInfo[0].getDesc().getTabName()) + "\"";
        int pan = 0;
        DmdbParamVal param = null;
        for (int i = 0; i < this.columnCount; ++i) {
            param = this.m_updateParams.get(new Integer(i + 1));
            if (null == param) continue;
            if (pan++ > 0) {
                paramNames = paramNames + " , ";
                paramEntity = paramEntity + " , ";
            }
            paramNames = paramNames + "\"" + StringUtil.getEscObjName(this.colInfo[i].getDesc().getName()) + "\"";
            paramEntity = paramEntity + " ? ";
        }
        if (paramEntity.length() == 0 || paramNames.length() == 0) {
            return;
        }
        String insertSql = "insert into " + schemaName + "." + tableName + " (" + paramNames + ") values(" + paramEntity + ")";
        DmdbPreparedStatement_bs pstmt = this.conn.prepareStatement(insertSql);
        pan = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            param = this.m_updateParams.get(new Integer(i + 1));
            if (null == param) continue;
            pstmt.setParamValue(++pan, param);
        }
        pstmt.setPutLobData(2);
        pstmt.executeUpdate();
        pstmt.close();
        this.initializePara();
        this.isInsertStatus = false;
    }

    @Override
    public void updateRow() throws SQLException {
        int i;
        this.checkClose();
        this.checkUpdatable();
        if (this.isInsertStatus) {
            DBError.throwSQLException(6027);
        }
        if (this.m_updateParams.size() <= 0) {
            throw new SQLException("Can't update Row for nothing update.");
        }
        this.checkBoundaryForUpdate();
        String schemaName = "\"" + StringUtil.getEscObjName(this.colInfo[0].getDesc().getSchName()) + "\"";
        String tableName = "\"" + StringUtil.getEscObjName(this.colInfo[0].getDesc().getTabName()) + "\"";
        int pan = 0;
        DmdbParamVal param = null;
        String paramNames = "";
        for (i = 0; i < this.columnCount; ++i) {
            param = this.m_updateParams.get(new Integer(i + 1));
            if (null == param) continue;
            if (pan++ > 0) {
                paramNames = paramNames + ", ";
            }
            paramNames = paramNames + "\"" + StringUtil.getEscObjName(this.colInfo[i].getDesc().getName()) + "\"" + " = ? ";
        }
        if (paramNames.length() == 0) {
            return;
        }
        String insertSql = "update " + schemaName + "." + tableName + " set " + paramNames + " where current of \"" + StringUtil.getEscObjName(this.getCursorName()) + "\"";
        DmdbPreparedStatement_bs pstmt = this.conn.prepareStatement(insertSql);
        pan = 0;
        for (i = 0; i < this.columnCount; ++i) {
            param = this.m_updateParams.get(new Integer(i + 1));
            if (null == param) continue;
            pstmt.setParamValue(++pan, param);
        }
        pstmt.setPutLobData(2);
        pstmt.executeUpdate();
        pstmt.close();
        this.initializePara();
        this.isUpdateStatus = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteRow() throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkBoundary();
        if (this.isInsertStatus) {
            DBError.throwSQLException(6027);
        }
        this.checkBoundaryForUpdate();
        StringBuffer deleteStmtBuffer = new StringBuffer();
        deleteStmtBuffer.append("DELETE FROM ");
        String schema = "\"" + StringUtil.getEscObjName(this.colInfo[0].getDesc().getSchName()) + "\"";
        String table = "\"" + StringUtil.getEscObjName(this.colInfo[0].getDesc().getTabName()) + "\"";
        deleteStmtBuffer.append(schema).append(".");
        deleteStmtBuffer.append(table);
        deleteStmtBuffer.append(" WHERE CURRENT OF \"" + StringUtil.getEscObjName(this.getCursorName()) + "\"");
        String sql = deleteStmtBuffer.toString();
        DmdbStatement_bs stmtForDel = null;
        try {
            stmtForDel = new DmdbStatement_bs(this.conn, 1003, 1007, 1);
            stmtForDel.cursorUpdateRow = this.currentRow;
            stmtForDel.executeUpdate(sql);
            Object var7_6 = null;
            if (stmtForDel == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (stmtForDel == null) throw throwable;
            stmtForDel.close();
            stmtForDel = null;
            throw throwable;
        }
        stmtForDel.close();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkClose();
        if (this.resultSetType == 1003) {
            DBError.throwSQLException(6019);
        }
        if (this.isInsertStatus) {
            DBError.throwSQLException(6027);
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkClose();
        this.m_updateParams.clear();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkClose();
        if (this.resultConcurrencyType == 1007) {
            DBError.throwSQLException(6029);
        }
        this.isInsertStatus = true;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkClose();
        this.isInsertStatus = false;
        if (this.resultConcurrencyType == 1007) {
            DBError.throwSQLException(6029);
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClose();
        return this.statement;
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        if (null == map) {
            return this.getObject(i);
        }
        return this.getObjectInner(i, map);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkBeforeGetDate(columnIndex);
        if (this.m_lobCached) {
            if (this.colInfo[columnIndex - 1].getDesc().getDType() == 12) {
                return this.m_blobArray[(int)this.currentRow][columnIndex - 1];
            }
            DBError.throwSQLException(6016);
        }
        return this.colAccessor[columnIndex - 1].getBlob();
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        this.checkBeforeGetDate(i);
        if (this.m_lobCached) {
            if (this.colInfo[i - 1].getDesc().getDType() == 19) {
                return this.m_clobArray[(int)this.currentRow][i - 1];
            }
            DBError.throwSQLException(6016);
        }
        return this.colAccessor[i - 1].getClob();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(colName), map);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date d = this.getDate(columnIndex);
        if (cal == null) {
            return d;
        }
        if (d == null) {
            return null;
        }
        cal.clear();
        cal.setTime(d);
        return new Date(cal.getTimeInMillis());
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time time = this.getTime(columnIndex);
        if (cal == null) {
            return time;
        }
        if (time == null) {
            return null;
        }
        cal.clear();
        cal.setTimeInMillis(time.getTime());
        return new Time(cal.getTimeInMillis());
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp timestamp = this.getTimestamp(columnIndex);
        if (cal == null) {
            return timestamp;
        }
        if (timestamp == null) {
            return null;
        }
        cal.clear();
        cal.setTime(timestamp);
        Timestamp xn = new Timestamp(cal.getTimeInMillis());
        int nanos = timestamp.getNanos();
        if (nanos != 0) {
            xn.setNanos(nanos);
        }
        return xn;
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.updateParam(columnIndex, x, 16);
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.updateBlob(this.findColumn(columnName), x);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.updateParam(columnIndex, x, 17);
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        this.updateClob(this.findColumn(columnName), x);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void updateINTERVALYM(int i, DmdbIntervalYM ym) throws SQLException {
        this.updateParam(i, ym, 12);
    }

    public void updateINTERVALYM(String s, DmdbIntervalYM ym) throws SQLException {
        this.updateINTERVALYM(this.findColumn(s), ym);
    }

    public void updateINTERVALDT(int i, DmdbIntervalDT dt) throws SQLException {
        this.updateParam(i, dt, 13);
    }

    public void updateINTERVALDT(String s, DmdbIntervalDT dt) throws SQLException {
        this.updateINTERVALDT(this.findColumn(s), dt);
    }

    byte[] getByteArrayValue(int columnIndex, ColumnDesc desc, boolean loadLobAll) throws SQLException {
        byte[] val = this.getRsCache().getBytes((short)(--columnIndex));
        if (val != null && loadLobAll && (desc.getDType() == 12 || desc.getDType() == 19)) {
            if (!desc.getIsLob()) {
                DBError.throwSQLException(6007);
            }
            val = Convertion.getBytesFrmLob(val, desc.getDtypeInfo().getDType(), desc.getLobDesc(), this.conn, this.statement, this.m_fromStandby);
        }
        return val;
    }

    protected long getCurrentRowNum() {
        return this.currentRow;
    }

    private int fetchData(int fetchType, boolean fetchAll) throws SQLException {
        long curPos;
        int ret = 1;
        if (this.metaRsFlag) {
            return ret;
        }
        if (fetchAll) {
            curPos = this.getRsCache().getRownum();
        } else if (fetchType == 1) {
            curPos = this.startRow;
        } else {
            int tmp_tuple_len = DmdbColumn.getMaxTupleLen(this.colInfo, this.conn.getMaxRowSize());
            int max_row_num = 32640 / tmp_tuple_len;
            curPos = this.startRow - (long)(max_row_num / 2);
            if (curPos < 0L) {
                curPos = 0L;
            }
        }
        ret = DmdbCSI.fetch(this.statement, curPos, fetchAll, this, this.rsId, this.m_fromStandby);
        if (fetchType == 2) {
            if (this.getRsCache() instanceof DmdbResultSetCache_h) {
                this.setRsCache_after_fetch((DmdbResultSetCache_h)this.getRsCache(), curPos);
            }
            this.getRsCache().curpos = (int)(this.startRow - curPos);
            this.startRow = curPos;
        }
        return ret;
    }

    private void setRsCache_after_fetch(DmdbResultSetCache_h rsCache, long curPos) {
        int offset = 0;
        int i = 0;
        while ((long)i < this.startRow - curPos) {
            offset += rsCache.rec4_get_len(rsCache.rowbuf, offset);
            ++i;
        }
        rsCache.offset = offset;
    }

    public long getRowid() {
        return this.getRsCache().rec_get_rowid();
    }

    public long getRowCount() throws SQLException {
        this.checkClose();
        if (this.rowCount == Long.MAX_VALUE) {
            if (this.resultSetType == 1003) {
                return -1L;
            }
            return DmdbCSI.getRowCount(this.statement, this.m_fromStandby);
        }
        return this.rowCount;
    }

    void initializePara() {
        this.m_updateParams.clear();
    }

    public final Object clone() {
        DmdbResultSet_bs rs = null;
        try {
            rs = (DmdbResultSet_bs)super.clone();
            rs.statement = null;
            rs.conn = null;
            rs.m_multiRsCaches = false;
            rs.setRsCache(null);
            rs.rsCacheList = null;
            rs.fetchThread = null;
            rs.fetchThreadError = null;
            rs.cacheCount = 1;
            if (this.dbInfo != null) {
                rs.dbInfo = (DmdbInfo)this.dbInfo.clone();
            }
            if (this.colInfo != null) {
                rs.colInfo = (DmdbColumn[])this.colInfo.clone();
            }
            if (this.getRsCache() != null) {
                rs.setRsCache((DmdbResultSetCache)this.getRsCache().clone());
                rs.getRsCache().setCols(rs.colInfo);
            }
            rs.startRow = 0L;
            rs.currentRow = -1L;
            rs.initializePara();
            if (this.m_lobCached) {
                for (int col = 0; col < this.columnCount; col = (int)((short)(col + 1))) {
                    int dtype = this.colInfo[col].getDesc().getDType();
                    int row = 0;
                    while ((long)row < this.rowCount) {
                        if (dtype == 12 && this.m_blobArray[row][col] != null) {
                            rs.m_blobArray[row][col] = (DmdbBlob)this.m_blobArray[row][col].clone();
                        }
                        if (dtype == 19 && this.m_clobArray[row][col] != null) {
                            rs.m_clobArray[row][col] = (DmdbClob)this.m_clobArray[row][col].clone();
                        }
                        ++row;
                    }
                }
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public void setRsId(short resId) {
        this.rsId = resId;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    private boolean isBeforeFirst_inner() {
        return this.currentRow <= -1L && this.rowCount >= 0L;
    }

    private boolean isAfterLast_inner() throws SQLException {
        if (this.rowCount == Long.MAX_VALUE) {
            return false;
        }
        return this.currentRow >= this.rowCount && this.rowCount >= 0L;
    }

    protected void checkIndex(int i) throws SQLException {
        if (i < 1 || i > this.columnCount) {
            DBError.throwSQLException(6032);
        }
    }

    protected void checkClose() throws SQLException {
        if (this.isClosed) {
            DBError.throwSQLException(6034);
        }
    }

    void checkUpdatable() throws SQLException {
        if (this.resultConcurrencyType != 1008 || !this.dbInfo.getUpdatable()) {
            DBError.throwSQLException(6029);
        }
        if (this.m_fromStandby) {
            DBError.throwSQLException(DmSvcConf.res.getString("error.rsUpdateNotSupportWhenFromStandby"));
        }
    }

    protected void checkBoundary() throws SQLException {
        if (this.isBeforeFirst_inner()) {
            throw new SQLException(DmSvcConf.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast_inner()) {
            throw new SQLException(DmSvcConf.res.getString("error.cursorNotInResultSet"));
        }
    }

    private void checkBoundaryForUpdate() throws SQLException {
        if ((this.isBeforeFirst_inner() || this.isAfterLast_inner()) && !this.isInsertStatus) {
            throw new SQLException(DmSvcConf.res.getString("error.cursorNotInResultSet"));
        }
    }

    private void checkNullable(int columnIndex) throws SQLException {
        if (!this.colInfo[columnIndex - 1].getDesc().getNullable()) {
            DBError.throwSQLException(6024);
        }
    }

    private void setUpdateStatus(boolean update) {
        this.isUpdateStatus = update;
    }

    private void putUpdateParam(int columnIndex, Object x, int jType) {
        DmdbParamVal param = new DmdbParamVal();
        param.setInValue(x, jType);
        param.setTypeFlag((byte)1);
        this.m_updateParams.put(new Integer(columnIndex), param);
    }

    private void putUpdateParam(int columnIndex, Object x, int jType, long length) {
        DmdbParamVal param = new DmdbParamVal();
        param.setInValue(x, jType);
        param.setLength(length);
        param.setTypeFlag((byte)1);
        this.m_updateParams.put(new Integer(columnIndex), param);
    }

    private void putUpdateParam_withScale(int columnIndex, Object x, int jType, int scale) {
        DmdbParamVal param = new DmdbParamVal();
        param.setInValue(x, jType);
        param.setTargetScale(scale);
        param.setTypeFlag((byte)1);
        this.m_updateParams.put(new Integer(columnIndex), param);
    }

    private void updateParam(int columnIndex, Object x, int jType) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        this.checkBoundaryForUpdate();
        if (null == x) {
            this.checkNullable(columnIndex);
        }
        this.setUpdateStatus(true);
        this.putUpdateParam(columnIndex, x, jType);
    }

    private void updateParam(int columnIndex, Object x, int jType, long length) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        this.checkBoundaryForUpdate();
        if (null == x) {
            this.checkNullable(columnIndex);
        }
        this.setUpdateStatus(true);
        this.putUpdateParam(columnIndex, x, jType, length);
    }

    private void updateParam_withScale(int columnIndex, Object x, int jType, int scale) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        this.checkBoundaryForUpdate();
        if (null == x) {
            this.checkNullable(columnIndex);
        }
        this.setUpdateStatus(true);
        this.putUpdateParam_withScale(columnIndex, x, jType, scale);
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    public int fetchData_for_multiRscaches() throws SQLException {
        int ret = 1;
        if (this.metaRsFlag) {
            return ret;
        }
        ret = DmdbCSI.fetch(this.statement, this.startRow, false, this, this.rsId, this.m_fromStandby);
        return ret;
    }

    public boolean multiRsCaches() {
        return this.m_multiRsCaches;
    }

    public void addRsCache(DmdbResultSetCache tmp) {
        this.rsCacheList.addLast(tmp);
    }

    public void setRsCache(DmdbResultSetCache rsCache) {
        this.rsCache = rsCache;
    }

    public DmdbResultSetCache getRsCache() {
        return this.rsCache;
    }

    public long getFetchRowCount() {
        if (this.currentRow >= this.rowCount) {
            return this.rowCount;
        }
        return this.currentRow + 1L;
    }
}

