/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbParameterMetaData_bs;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbResultSetMetaData_bs;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.driver.DmdbRowId;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.pool.DmdbPooledConnection;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbTimestamp;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class DmdbPreparedStatement
extends DmdbStatement
implements PreparedStatement {
    private DmdbPreparedStatement_bs rpstmt = null;
    private DmdbPooledConnection curPoolConn = null;

    DmdbPreparedStatement(DmdbPreparedStatement_bs pstmt, DmdbConnection curConn) throws SQLException {
        super(pstmt, curConn);
        this.rpstmt = pstmt;
    }

    private void curPoolConnNotify() throws SQLException {
        if (this.rpstmt.getConnection_bs() != null && this.rpstmt.getConnection_bs().getMpc() != null) {
            if (null == this.curPoolConn) {
                this.curPoolConn = new DmdbPooledConnection(this.rpstmt.getConnection_bs().getMpc());
            }
            this.curPoolConn.notifyStatementChanged(this, 2);
        }
    }

    @Override
    public DmdbPreparedStatement_bs getBaseObject() {
        return this.rpstmt;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.createChain().PreparedStatement_executeQuery(this);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.createChain().PreparedStatement_executeUpdate(this);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.createChain().PreparedStatement_setNull(this, parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.createChain().PreparedStatement_setBoolean(this, parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.createChain().PreparedStatement_setByte(this, parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.createChain().PreparedStatement_setShort(this, parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.createChain().PreparedStatement_setInt(this, parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.createChain().PreparedStatement_setLong(this, parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.createChain().PreparedStatement_setFloat(this, parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.createChain().PreparedStatement_setDouble(this, parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.createChain().PreparedStatement_setBigDecimal(this, parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.createChain().PreparedStatement_setString(this, parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.createChain().PreparedStatement_setBytes(this, parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.createChain().PreparedStatement_setDate(this, parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.createChain().PreparedStatement_setTime(this, parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.createChain().PreparedStatement_setTimestamp(this, parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.createChain().PreparedStatement_setAsciiStream(this, parameterIndex, x, length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.createChain().PreparedStatement_setUnicodeStream(this, parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.createChain().PreparedStatement_setBinaryStream(this, parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.createChain().PreparedStatement_clearParameters(this);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.createChain().PreparedStatement_setObject(this, parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.createChain().PreparedStatement_setObject(this, parameterIndex, x);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.createChain().PreparedStatement_execute(this);
    }

    @Override
    public void addBatch() throws SQLException {
        this.createChain().PreparedStatement_addBatch(this);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.createChain().PreparedStatement_setCharacterStream(this, parameterIndex, reader, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.createChain().PreparedStatement_setRef(this, parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.createChain().PreparedStatement_setBlob(this, parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.createChain().PreparedStatement_setClob(this, parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.createChain().PreparedStatement_setArray(this, parameterIndex, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.createChain().PreparedStatement_getMetaData(this);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.createChain().PreparedStatement_setDate(this, parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.createChain().PreparedStatement_setTime(this, parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.createChain().PreparedStatement_setTimestamp(this, parameterIndex, x, cal);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.createChain().PreparedStatement_setNull(this, parameterIndex, sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.createChain().PreparedStatement_setURL(this, parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.createChain().PreparedStatement_getParameterMetaData(this);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.createChain().PreparedStatement_setRowId(this, parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.createChain().PreparedStatement_setNString(this, parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.createChain().PreparedStatement_setNCharacterStream(this, parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.createChain().PreparedStatement_setNClob(this, parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.createChain().PreparedStatement_setClob(this, parameterIndex, reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.createChain().PreparedStatement_setBlob(this, parameterIndex, inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.createChain().PreparedStatement_setNClob(this, parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.createChain().PreparedStatement_setSQLXML(this, parameterIndex, xmlObject);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.createChain().PreparedStatement_setObject(this, parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.createChain().PreparedStatement_setAsciiStream(this, parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.createChain().PreparedStatement_setBinaryStream(this, parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.createChain().PreparedStatement_setCharacterStream(this, parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.createChain().PreparedStatement_setAsciiStream(this, parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.createChain().PreparedStatement_setBinaryStream(this, parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.createChain().PreparedStatement_setCharacterStream(this, parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.createChain().PreparedStatement_setNCharacterStream(this, parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.createChain().PreparedStatement_setClob(this, parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.createChain().PreparedStatement_setBlob(this, parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.createChain().PreparedStatement_setNClob(this, parameterIndex, reader);
    }

    public synchronized ResultSet do_executeQuery() throws SQLException {
        DmdbResultSet rs = null;
        try {
            DmdbResultSet_bs rbs = (DmdbResultSet_bs)this.rpstmt.executeQuery();
            if (null != rbs) {
                rs = new DmdbResultSet(rbs, this);
            }
        }
        catch (SQLException e) {
            this.rpstmt.setRealClose(true);
            this.curPoolConnNotify();
            throw e;
        }
        this.setCurResultSet(rs);
        return rs;
    }

    public int do_executeUpdate() throws SQLException {
        return this.rpstmt.executeUpdate();
    }

    public void do_setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            this.rpstmt.setNull(parameterIndex, sqlType);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setBoolean(int parameterIndex, boolean x) throws SQLException {
        try {
            this.rpstmt.setBoolean(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setByte(int parameterIndex, byte x) throws SQLException {
        try {
            this.rpstmt.setByte(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setShort(int parameterIndex, short x) throws SQLException {
        try {
            this.rpstmt.setShort(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setInt(int parameterIndex, int x) throws SQLException {
        try {
            this.rpstmt.setInt(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setLong(int parameterIndex, long x) throws SQLException {
        try {
            this.rpstmt.setLong(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setFloat(int parameterIndex, float x) throws SQLException {
        try {
            this.rpstmt.setFloat(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setDouble(int parameterIndex, double x) throws SQLException {
        try {
            this.rpstmt.setDouble(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        try {
            this.rpstmt.setBigDecimal(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setString(int parameterIndex, String x) throws SQLException {
        try {
            this.rpstmt.setString(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setBytes(int parameterIndex, byte[] x) throws SQLException {
        try {
            this.rpstmt.setBytes(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setDate(int parameterIndex, Date x) throws SQLException {
        try {
            this.rpstmt.setDate(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setTime(int parameterIndex, Time x) throws SQLException {
        try {
            this.rpstmt.setTime(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        try {
            this.rpstmt.setTimestamp(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public synchronized void do_setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.rpstmt.setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public synchronized void do_setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.rpstmt.setUnicodeStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public synchronized void do_setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.rpstmt.setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public synchronized void do_clearParameters() throws SQLException {
        this.rpstmt.clearParameters();
    }

    @Override
    public synchronized void do_close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.curPoolConnNotify();
        this.rpstmt.close();
    }

    public synchronized void do_setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        try {
            if (x instanceof DmdbRowId) {
                this.rpstmt.setLong(parameterIndex, ((DmdbRowId)x).getValue());
            } else {
                this.rpstmt.setObject(parameterIndex, x, targetSqlType, scale);
            }
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        try {
            this.rpstmt.setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public synchronized void do_setObject(int parameterIndex, Object x) throws SQLException {
        try {
            if (x instanceof DmdbRowId) {
                this.rpstmt.setLong(parameterIndex, ((DmdbRowId)x).getValue());
            } else {
                this.rpstmt.setObject(parameterIndex, x);
            }
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public synchronized boolean do_execute() throws SQLException {
        boolean rs = false;
        try {
            rs = this.rpstmt.execute();
        }
        catch (SQLException e) {
            this.rpstmt.setRealClose(true);
            this.curPoolConnNotify();
            throw e;
        }
        return rs;
    }

    public void do_addBatch() throws SQLException {
        try {
            this.rpstmt.addBatch();
        }
        catch (SQLException ex) {
            this.curPoolConnNotify();
            throw ex;
        }
    }

    @Override
    public int[] do_executeBatch() throws SQLException {
        try {
            return this.rpstmt.executeBatch();
        }
        catch (SQLException e) {
            this.rpstmt.setRealClose(true);
            this.curPoolConnNotify();
            throw e;
        }
    }

    public synchronized void do_setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            this.rpstmt.setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setRef(int i, Ref x) throws SQLException {
        try {
            this.rpstmt.setRef(i, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setBlob(int i, Blob x) throws SQLException {
        try {
            if (x instanceof DmdbBlob) {
                this.rpstmt.setBlob(i, x);
            } else {
                this.rpstmt.setBlob(i, x);
            }
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setClob(int i, Clob x) throws SQLException {
        try {
            if (x instanceof DmdbClob) {
                this.rpstmt.setClob(i, x);
            } else {
                this.rpstmt.setClob(i, x);
            }
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setArray(int i, Array x) throws SQLException {
        try {
            this.rpstmt.setArray(i, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public synchronized ResultSetMetaData do_getMetaData() throws SQLException {
        try {
            DmdbResultSetMetaData_bs bs = (DmdbResultSetMetaData_bs)this.rpstmt.getMetaData();
            if (bs == null) {
                return null;
            }
            return new DmdbResultSetMetaData(bs, null);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        try {
            this.rpstmt.setDate(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        try {
            this.rpstmt.setTime(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        try {
            this.rpstmt.setTimestamp(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        try {
            this.rpstmt.setNull(paramIndex, sqlType, typeName);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setURL(int parameterIndex, URL x) throws SQLException {
        try {
            this.rpstmt.setURL(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public synchronized ParameterMetaData do_getParameterMetaData() throws SQLException {
        try {
            DmdbParameterMetaData_bs bs = (DmdbParameterMetaData_bs)this.rpstmt.getParameterMetaData();
            if (null == bs) {
                return null;
            }
            return new DmdbParameterMetaData(bs, this);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void setINTERVALYM(int i, DmdbIntervalYM ym) throws SQLException {
        try {
            this.rpstmt.setINTERVALYM(i, ym);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void setINTERVALDT(int i, DmdbIntervalDT dt) throws SQLException {
        try {
            this.rpstmt.setINTERVALDT(i, dt);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void setTIMESTAMP(int i, DmdbTimestamp t) throws SQLException {
        try {
            this.rpstmt.setTIMESTAMP(i, t);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public String getPrintMsg() throws SQLException {
        try {
            return this.rpstmt.getPrintMsg();
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public int getSqlType() throws SQLException {
        try {
            return this.rpstmt.getSqlType();
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    @Override
    public void do_clearBatch() throws SQLException {
        try {
            this.rpstmt.clearBatch();
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setRowId(int parameterIndex, RowId x) throws SQLException {
        if (x == null) {
            this.rpstmt.setObject(parameterIndex, null);
            return;
        }
        long val = ((DmdbRowId)x).getValue();
        this.do_setLong(parameterIndex, val);
    }

    public void do_setNString(int parameterIndex, String value) throws SQLException {
        this.curPoolConnNotify();
        DBError.throwUnsupportedSQLException();
    }

    public void do_setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.curPoolConnNotify();
        DBError.throwUnsupportedSQLException();
    }

    public void do_setNClob(int parameterIndex, NClob value) throws SQLException {
        this.curPoolConnNotify();
        DBError.throwUnsupportedSQLException();
    }

    public void do_setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            this.rpstmt.setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        try {
            this.rpstmt.setBinaryStream(parameterIndex, inputStream, length);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.curPoolConnNotify();
        DBError.throwUnsupportedSQLException();
    }

    public void do_setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.curPoolConnNotify();
        DBError.throwUnsupportedSQLException();
    }

    public void do_setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.rpstmt.setAsciiStream(parameterIndex, x, length);
    }

    public void do_setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        try {
            this.rpstmt.setAsciiStream(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.rpstmt.setBinaryStream(parameterIndex, x, length);
    }

    public void do_setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        try {
            this.rpstmt.setBinaryStream(parameterIndex, x);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.do_setBinaryStream(parameterIndex, inputStream);
    }

    public void do_setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.rpstmt.setCharacterStream(parameterIndex, reader, length);
    }

    public void do_setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        try {
            this.rpstmt.setCharacterStream(parameterIndex, reader);
        }
        catch (SQLException e) {
            this.curPoolConnNotify();
            throw e;
        }
    }

    public void do_setClob(int parameterIndex, Reader reader) throws SQLException {
        this.do_setCharacterStream(parameterIndex, reader);
    }

    public void do_setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.curPoolConnNotify();
        DBError.throwUnsupportedSQLException();
    }

    public void do_setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.curPoolConnNotify();
        DBError.throwUnsupportedSQLException();
    }

    public int getParametersSize() {
        return this.rpstmt.paramCount;
    }

    public Object[] getParameters() {
        return this.rpstmt.getParamObjects();
    }

    public Object getParameter(int i) {
        return this.rpstmt.getParamObject(1, i);
    }
}

