/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class DmdbInputStream
extends InputStream {
    public DmdbBlob blob = null;
    private DmdbClob clob = null;
    private int typeFlag;
    String serverEncoding = null;
    byte[] byteBuffer = null;
    int currentPos = 0;
    static final int blobLen = 32000;
    static final int clobLen = 8000;
    int curPos = 0;
    int byteLen = -1;
    long lob_length = -1L;

    public DmdbInputStream(Object o, String serverEncoding) throws NumberFormatException {
        this.serverEncoding = serverEncoding;
        if (o instanceof DmdbBlob) {
            this.typeFlag = 0;
            this.blob = (DmdbBlob)o;
        } else if (o instanceof DmdbClob) {
            this.typeFlag = 1;
            this.clob = (DmdbClob)o;
        } else if (o instanceof byte[]) {
            this.typeFlag = 3;
            this.byteBuffer = (byte[])o;
            this.curPos = 0;
            this.byteLen = this.byteBuffer == null ? 0 : this.byteBuffer.length;
        } else {
            throw new NumberFormatException("cast error.");
        }
    }

    protected DmdbInputStream(DmdbBlob blob, long pos, long length) {
        this.typeFlag = 0;
        this.blob = blob;
        this.currentPos = (int)(pos - 1L);
        this.lob_length = length;
    }

    public int read() throws IOException {
        byte[] buf = new byte[1];
        int retLen = this.read(buf);
        if (retLen == -1) {
            return -1;
        }
        return buf[0] & 0xFF;
    }

    public int read(byte[] bs) throws IOException {
        switch (this.typeFlag) {
            case 0: {
                return this.readFromBlob(bs);
            }
            case 1: {
                return this.readFromClob(bs);
            }
            case 3: {
                return this.readFromByteArray(bs);
            }
        }
        throw new IOException("io read error,invalid data type of this stream.");
    }

    public int available() throws IOException {
        int length = 0;
        switch (this.typeFlag) {
            case 0: {
                length = this.blob.getLobLen();
                break;
            }
            case 1: {
                length = this.clob.getLobLen();
                break;
            }
            case 3: {
                length = this.byteBuffer.length;
                break;
            }
            default: {
                throw new IOException("io read error.");
            }
        }
        return length - this.curPos;
    }

    private int readFromBlob(byte[] buf) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        int needLen = buf.length;
        int bufPos = 0;
        int readLen = 0;
        try {
            if (this.blob == null) {
                return -1;
            }
            if (this.lob_length < 0L) {
                this.lob_length = this.blob.length();
            }
            if (this.lob_length <= 0L || (this.byteBuffer == null || this.curPos >= this.byteLen) && this.lob_length <= (long)this.currentPos) {
                return -1;
            }
            long invalidLen = 0L;
            invalidLen = this.byteBuffer == null ? this.lob_length - (long)this.currentPos : this.lob_length - (long)this.currentPos + (long)this.byteLen - (long)this.curPos;
            int destLen = (int)(invalidLen < (long)needLen ? invalidLen : (long)needLen);
            while (destLen > readLen) {
                if (this.byteBuffer == null || this.curPos >= this.byteBuffer.length) {
                    int bufLen = (int)(32000L > this.lob_length - (long)this.currentPos ? this.lob_length - (long)this.currentPos : 32000L);
                    this.byteBuffer = this.blob.getBytes(this.currentPos + 1, bufLen);
                    if (this.byteBuffer.length <= 0) break;
                    this.currentPos += bufLen;
                    this.curPos = 0;
                    this.byteLen = this.byteBuffer.length;
                }
                int realLen = this.byteLen - this.curPos > destLen - readLen ? destLen - readLen : this.byteLen - this.curPos;
                System.arraycopy(this.byteBuffer, this.curPos, buf, bufPos, realLen);
                bufPos += realLen;
                this.curPos += realLen;
                readLen += realLen;
            }
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
        return readLen;
    }

    private int readFromClob(byte[] buf) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        int needLen = buf.length;
        int bufPos = 0;
        int readLen = 0;
        try {
            if (this.clob == null) {
                return -1;
            }
            if (this.lob_length < 0L) {
                this.lob_length = this.clob.length();
            }
            if (this.lob_length <= 0L || (this.byteBuffer == null || this.curPos >= this.byteLen) && this.lob_length <= (long)this.currentPos) {
                return -1;
            }
            long invalidLen = 0L;
            invalidLen = this.byteBuffer == null ? this.lob_length - (long)this.currentPos : this.lob_length - (long)this.currentPos + (long)this.byteLen - (long)this.curPos;
            int destLen = (int)(invalidLen < (long)needLen ? invalidLen : (long)needLen);
            while (destLen > readLen) {
                if (this.byteBuffer == null || this.curPos >= this.byteBuffer.length) {
                    if (this.serverEncoding == null) {
                        this.serverEncoding = this.clob.m_conn.getServerEncoding();
                    }
                    int bufLen = (int)(8000L > this.lob_length - (long)this.currentPos ? this.lob_length - (long)this.currentPos : 8000L);
                    String subString = this.clob.getSubString(this.currentPos + 1, bufLen);
                    this.currentPos += bufLen;
                    if (subString == null || subString.length() <= 0) {
                        this.byteBuffer = new byte[0];
                        break;
                    }
                    this.byteBuffer = Convertion.getBytes(subString, 0, subString.length(), this.serverEncoding);
                    this.curPos = 0;
                    this.byteLen = this.byteBuffer.length;
                }
                int realLen = this.byteLen - this.curPos > destLen - readLen ? destLen - readLen : this.byteLen - this.curPos;
                System.arraycopy(this.byteBuffer, this.curPos, buf, bufPos, realLen);
                bufPos += realLen;
                this.curPos += realLen;
                readLen += realLen;
            }
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
        return readLen;
    }

    private int readFromByteArray(byte[] buf) {
        if (buf == null) {
            throw new NullPointerException();
        }
        int needLen = buf.length;
        if (this.byteBuffer == null || (this.byteLen = this.byteBuffer.length) <= this.curPos) {
            return -1;
        }
        int invalidLen = this.byteLen - this.curPos > needLen ? needLen : this.byteLen - this.curPos;
        System.arraycopy(this.byteBuffer, this.curPos, buf, 0, invalidLen);
        this.curPos += invalidLen;
        return invalidLen;
    }
}

