/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmdbCSI;
import dm.jdbc.desc.LobDesc;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbLob;
import dm.jdbc.driver.DmdbOutputStream;
import dm.jdbc.driver.DmdbReader;
import dm.jdbc.log.ILogger;
import dm.jdbc.log.LogFactory;
import dm.jdbc.util.Comparison;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;

public class DmdbBlob
extends DmdbLob
implements Blob {
    ILogger LOG = LogFactory.getLog(DmdbBlob.class);

    public DmdbBlob(byte[] bs, DmdbConnection_bs conn) throws SQLException {
        super(bs, conn);
    }

    public DmdbBlob(byte[] value, LobDesc lobDesc, DmdbConnection_bs conn, boolean updAble) {
        super(value, (byte)0, lobDesc, conn, updAble);
    }

    public DmdbBlob(Connection conn) {
        super(null, conn);
    }

    public static DmdbBlob getEmptyBlob() {
        return new DmdbBlob(new DmdbConnection_bs());
    }

    public long length() throws SQLException {
        this.LOG.info((Object)this, "length", new Object[0]);
        this.checkFreed();
        if (this.m_lobMode == 2) {
            long len = this.m_value.length - this.m_hdr_size;
            if (len < 0L) {
                DBError.throwSQLException(6057);
            }
            return len;
        }
        if (this.fromRowSetFlag || !this.m_updatAble || this.isValueInRow()) {
            return this.getLobLen();
        }
        if (this.offRowLen == -1L) {
            this.checkConnClosed();
            long len = DmdbCSI.lob_get_len(this, this.m_fromStandby);
            if (len < 0L) {
                DBError.throwSQLException(6057);
            }
            this.offRowLen = len;
            return len;
        }
        return this.offRowLen;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        this.LOG.info((Object)this, "getBytes", pos, length);
        this.checkFreed();
        if (pos <= 0L || length < 0) {
            DBError.throwSQLException(6057);
        }
        byte[] buf = new byte[length];
        if (this.m_lobMode == 2) {
            if (pos > (long)(this.m_value.length - this.m_hdr_size)) {
                return null;
            }
            if ((long)(this.m_value.length - this.m_hdr_size) - pos + 1L < (long)length) {
                buf = new byte[(int)((long)(this.m_value.length - this.m_hdr_size) - pos + 1L)];
            }
            System.arraycopy(this.m_value, (int)pos - 1 + this.m_hdr_size, buf, 0, buf.length);
            return buf;
        }
        if (this.isValueInRow()) {
            byte[] val = this.getValueInRow();
            if (pos > (long)val.length) {
                if (this.m_conn != null && this.m_conn.isCompatibleOracle()) {
                    return new byte[0];
                }
                return null;
            }
            if ((long)val.length - pos + 1L < (long)length) {
                buf = new byte[(int)((long)val.length - pos + 1L)];
            }
            System.arraycopy(val, (int)pos - 1, buf, 0, buf.length);
            return buf;
        }
        if (this.fromRowSetFlag) {
            DBError.throwUnsupportedSQLException();
            return null;
        }
        return this.getBytesOffRow(pos, length);
    }

    public byte[] getBytesOffRow(long pos, int length) throws SQLException {
        this.checkFreed();
        if (pos <= 0L || length < 0) {
            DBError.throwSQLException(6057);
        }
        byte[] tmpBuf = null;
        byte[] buf = new byte[length];
        int len = length > 32000 ? 32000 : length;
        int position = (int)pos - 1;
        int bytesGet = 0;
        do {
            this.checkConnClosed();
            tmpBuf = DmdbCSI.lob_get_bytes(this, (byte)0, position, len, this.m_fromStandby);
            if (tmpBuf == null) break;
            System.arraycopy(tmpBuf, 0, buf, bytesGet, tmpBuf.length);
            position += tmpBuf.length;
            len = length - (bytesGet += tmpBuf.length);
            if (len <= 0) break;
            if (len <= 32000) continue;
            len = 32000;
        } while (!this.getLobLocator().isReadOver());
        if (bytesGet == length) {
            return buf;
        }
        byte[] tmpVal = new byte[bytesGet];
        System.arraycopy(buf, 0, tmpVal, 0, bytesGet);
        return tmpVal;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.LOG.info((Object)this, "getBinaryStream", new Object[0]);
        this.checkFreed();
        return new DmdbInputStream(this, this.m_conn.getServerEncoding());
    }

    public long position(byte[] pattern, long start) throws SQLException {
        int length;
        this.LOG.info((Object)this, "position", pattern, start);
        this.checkFreed();
        if (this.fromRowSetFlag || start < 1L) {
            DBError.throwSQLException(6057);
        }
        if ((long)pattern.length > (long)(length = (int)this.length()) - start + 1L) {
            return -1L;
        }
        byte[] bs = this.getBytes(start, length);
        long ret = Comparison.getIndexOfByteArray(pattern, bs);
        if (ret >= 0L) {
            ++ret;
        }
        return ret;
    }

    public long position(Blob pattern, long start) throws SQLException {
        this.LOG.info((Object)this, "position", pattern, start);
        this.checkFreed();
        if (this.fromRowSetFlag || pattern == null) {
            return -1L;
        }
        if (start < 1L) {
            DBError.throwSQLException(6057);
        }
        int length = (int)this.length();
        if (pattern.length() > (long)length - start + 1L) {
            return -1L;
        }
        byte[] bytes = pattern.getBytes(1L, (int)pattern.length());
        return this.position(bytes, start);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        this.checkFreed();
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.LOG.info((Object)this, "setBytes", pos, bytes, offset, len);
        this.checkFreed();
        if (pos <= 0L || len < 0 || offset < 0) {
            DBError.throwSQLException(6057);
        }
        if (!this.fromRowSetFlag && !this.m_updatAble) {
            DBError.throwSQLException(6029);
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException(new Integer(offset).toString());
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException(new Integer(len).toString());
        }
        if (offset + len > bytes.length) {
            throw new IndexOutOfBoundsException(new Integer(offset + len).toString());
        }
        if (this.m_lobMode == 2) {
            this.setBlobInRow(pos, bytes, offset, len);
            return len;
        }
        if (this.fromRowSetFlag) {
            this.setBlobInRow(pos, bytes, offset, len);
            return len;
        }
        int position = (int)pos - 1;
        int off = offset;
        int length = len > 16000 ? 16000 : len;
        int count = len / 16000 + 1;
        int ret = 0;
        byte firstOrLast = 0;
        for (int i = 0; i < count; ++i) {
            firstOrLast = i == 0 && i == count - 1 ? (byte)3 : (i == 0 ? (byte)1 : (i == count - 1 ? (byte)2 : 0));
            this.checkConnClosed();
            int tmp = DmdbCSI.lob_set_bytes(this, (byte)0, position, bytes, off, length, firstOrLast, this.m_fromStandby);
            if (tmp <= 0) {
                return ret;
            }
            ret += tmp;
            position += length;
            off += length;
            length = i == count - 2 ? len - (i + 1) * 16000 : 16000;
        }
        short groupid = Convertion.getShort(this.getLobLocator().m_data_groupId, 0);
        if (groupid == -1) {
            this.setBlobInRow(pos, bytes, offset, len);
        } else {
            this.m_value[0] = 2;
            this.offRowLen = -1L;
        }
        this.isUpdated = true;
        return ret;
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkFreed();
        if (this.m_conn != null && this.m_conn.isCompatibleOracle() && pos == 0L) {
            pos = 1L;
        }
        if (pos <= 0L) {
            DBError.throwSQLException(6057);
        }
        return new DmdbOutputStream(this, pos);
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        return this.setBinaryStream(1L);
    }

    public OutputStream getBinaryOutputStream(long pos) throws SQLException {
        return this.setBinaryStream(pos);
    }

    public void truncate(long len) throws SQLException {
        this.LOG.info((Object)this, "truncate", len);
        this.checkFreed();
        if (len < 0L) {
            DBError.throwSQLException(6057);
        }
        if (this.m_lobMode == 2) {
            byte[] tmp = new byte[(int)len + this.m_hdr_size];
            System.arraycopy(this.m_value, 0, tmp, 0, (int)len + this.m_hdr_size);
            this.m_value = tmp;
            this.isUpdated = true;
            return;
        }
        if (this.fromRowSetFlag || !this.m_updatAble) {
            DBError.throwSQLException(6029);
        }
        this.checkConnClosed();
        DmdbCSI.blob_text_truncate(this, (byte)0, (int)len, this.m_fromStandby);
        short groupid = Convertion.getShort(this.getLobLocator().m_data_groupId, 0);
        if (groupid == -1) {
            byte[] tmp = new byte[(int)((long)this.m_hdr_size + len)];
            System.arraycopy(this.m_value, 0, tmp, 0, tmp.length);
            Convertion.setInt(tmp, 9, (int)len);
            this.m_value = tmp;
        } else {
            this.offRowLen = len;
        }
        this.isUpdated = true;
    }

    public Reader getCharacterStream() throws SQLException {
        this.LOG.info((Object)this, "getCharacterStream", new Object[0]);
        this.checkFreed();
        return new DmdbReader(this);
    }

    private void setBlobInRow(long pos, byte[] bytes, int offset, int len) {
        int length = this.getLobLen();
        this.m_value[0] = 1;
        if (pos > (long)(length + 1)) {
            throw new IndexOutOfBoundsException(new Long(pos).toString());
        }
        if (pos + (long)len <= (long)length) {
            System.arraycopy(bytes, offset, this.m_value, (int)((long)this.m_hdr_size + pos - 1L), len);
        } else {
            length = (int)(pos + (long)len - 1L);
            Convertion.setInt(this.m_value, 9, length);
            byte[] tmp = new byte[this.m_hdr_size + length];
            System.arraycopy(this.m_value, 0, tmp, 0, this.m_value.length);
            this.m_value = tmp;
            System.arraycopy(bytes, offset, this.m_value, (int)((long)this.m_hdr_size + pos - 1L), len);
        }
    }

    public void free() throws SQLException {
        this.LOG.info((Object)this, "free", new Object[0]);
        super.free();
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.LOG.info((Object)this, "getBinaryStream", pos, length);
        this.checkFreed();
        return new DmdbInputStream(this, pos, length);
    }
}

