/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.driver.DmDriver_bs;
import dm.jdbc.driver.DmdbConnection_bs;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;

public class DmdbConnGroup {
    private static HashMap<String, DmdbConnGroup> connGroupMap = new HashMap();
    private DmdbConnection_bs conn;
    private Object connMutex = new Object();
    private boolean connUsing = false;
    private int size = 1;
    private int referenceCount = 0;
    private Object referenceMutex = new Object();

    private DmdbConnGroup(DmdbConnection_bs conn, int size) {
        this.conn = conn;
        this.size = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DmdbConnGroup getInstance(String url, Properties props, int size) throws SQLException {
        DmdbConnGroup connGroup = null;
        String key = props.getProperty("host", "localhost") + "_" + props.getProperty("port", String.valueOf(5236)) + "_" + size;
        HashMap<String, DmdbConnGroup> hashMap = connGroupMap;
        synchronized (hashMap) {
            connGroup = connGroupMap.get(key);
            if (connGroup == null || !connGroup.canUse()) {
                DmdbConnection_bs conn = DmDriver_bs.createConnection(url, props);
                connGroup = new DmdbConnGroup(conn, size);
                connGroupMap.put(key, connGroup);
            }
            connGroup.addReference();
        }
        return connGroup;
    }

    public synchronized boolean canUse() {
        return this.conn != null && this.referenceCount < this.size;
    }

    public void close(DmdbConnection_bs rConn) throws SQLException {
        this.removeReference();
        if (rConn != null) {
            this.connUsing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReference() {
        Object object = this.referenceMutex;
        synchronized (object) {
            ++this.referenceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReference() throws SQLException {
        Object object = this.referenceMutex;
        synchronized (object) {
            if (this.referenceCount > 0) {
                --this.referenceCount;
                if (this.referenceCount == 0) {
                    this.conn.close();
                    this.conn = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmdbConnection_bs getConnection() {
        Object object = this.connMutex;
        synchronized (object) {
            while (this.connUsing) {
                try {
                    Thread.sleep(3L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.connUsing = true;
            return this.conn;
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.conn.setAutoCommit(autoCommit);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.conn.nativeSQL(sql);
    }

    public void setCatalog(String catalog) throws SQLException {
        this.conn.setCatalog(catalog);
    }

    public String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    public void setHoldability(int holdability) throws SQLException {
        this.conn.setHoldability(holdability);
    }

    public int getHoldability() throws SQLException {
        return this.conn.getHoldability();
    }
}

