/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;
import java.util.Properties;

public class ConnClientAttr {
    String url;
    String user;
    String password;
    String host = "localhost";
    int port = 5236;
    String appName = "";
    String osName = System.getProperty("os.name", "");
    boolean mppLocal = false;
    int socketTimeout = 0;
    int sessionTimeout = 0;
    boolean wellDistributed = false;
    int osAuthType = 0;
    int rwStandbyRecoverTime = 300;
    boolean rwHA = false;
    boolean continueBatchOnError = false;
    boolean escapeProcess = true;
    boolean autoCommit = true;
    int maxRows = 0;
    int rowPrefetch = 10;
    int LobMode = 1;
    int stmtPoolMaxSize = 15;
    boolean ignoreCase = true;
    boolean alwayseAllowCommit = true;
    int batchType = 1;
    int maxCachedPstmtSize;
    int resultSetType = 1003;
    boolean dbmdChkPrv = false;
    boolean isBdtaRS = true;
    boolean clobAsString = false;
    boolean callBatchNot = false;
    String sslFilesPath = "";
    String sslKeystorePass = "";
    String kerberosLoginConfPath = "";
    String uKeyName = "";
    String uKeyPin = "";
    boolean columnNameUpperCase = false;
    String databaseProductName = "";
    public boolean fullToHalfWidth = false;
    int rsCacheCount = 2;
    boolean multiRsCaches = false;
    DmSvcConf dmSvcConf = (DmSvcConf)DmSvcConf.globalDmSvcConf.clone();

    public String printProperties() {
        StringBuilder str = new StringBuilder();
        str.append("url = " + this.url).append(StringUtil.LINE_SEPARATOR);
        str.append("user = " + this.user).append(StringUtil.LINE_SEPARATOR);
        str.append("password = " + (StringUtil.isNotEmpty(this.password) ? "******" : "null")).append(StringUtil.LINE_SEPARATOR);
        str.append("host = " + this.host).append(StringUtil.LINE_SEPARATOR);
        str.append("port = " + this.port).append(StringUtil.LINE_SEPARATOR);
        str.append("appName = " + this.appName).append(StringUtil.LINE_SEPARATOR);
        str.append("osName = " + this.osName).append(StringUtil.LINE_SEPARATOR);
        str.append("mppLocal = " + this.mppLocal).append(StringUtil.LINE_SEPARATOR);
        str.append("socketTimeout = " + this.socketTimeout).append(StringUtil.LINE_SEPARATOR);
        str.append("sessionTimeout = " + this.sessionTimeout).append(StringUtil.LINE_SEPARATOR);
        str.append("wellDistributed = " + this.wellDistributed).append(StringUtil.LINE_SEPARATOR);
        str.append("osAuthType = " + this.osAuthType).append(StringUtil.LINE_SEPARATOR);
        str.append("rwStandbyRecoverTime = " + this.rwStandbyRecoverTime).append(StringUtil.LINE_SEPARATOR);
        str.append("rwHA = " + this.rwHA).append(StringUtil.LINE_SEPARATOR);
        str.append("continueBatchOnError = " + this.continueBatchOnError).append(StringUtil.LINE_SEPARATOR);
        str.append("escapeProcess = " + this.escapeProcess).append(StringUtil.LINE_SEPARATOR);
        str.append("autoCommit = " + this.autoCommit).append(StringUtil.LINE_SEPARATOR);
        str.append("maxRows = " + this.maxRows).append(StringUtil.LINE_SEPARATOR);
        str.append("rowPrefetch = " + this.rowPrefetch).append(StringUtil.LINE_SEPARATOR);
        str.append("LobMode = " + this.LobMode).append(StringUtil.LINE_SEPARATOR);
        str.append("stmtPoolMaxSize = " + this.stmtPoolMaxSize).append(StringUtil.LINE_SEPARATOR);
        str.append("ignoreCase = " + this.ignoreCase).append(StringUtil.LINE_SEPARATOR);
        str.append("alwayseAllowCommit = " + this.alwayseAllowCommit).append(StringUtil.LINE_SEPARATOR);
        str.append("batchType = " + this.batchType).append(StringUtil.LINE_SEPARATOR);
        str.append("maxCachedPstmtSize = " + this.maxCachedPstmtSize).append(StringUtil.LINE_SEPARATOR);
        str.append("resultSetType = " + this.resultSetType).append(StringUtil.LINE_SEPARATOR);
        str.append("dbmdChkPrv = " + this.dbmdChkPrv).append(StringUtil.LINE_SEPARATOR);
        str.append("isBdtaRS = " + this.isBdtaRS).append(StringUtil.LINE_SEPARATOR);
        str.append("clobAsString = " + this.clobAsString).append(StringUtil.LINE_SEPARATOR);
        str.append("sslFilesPath = " + this.sslFilesPath).append(StringUtil.LINE_SEPARATOR);
        str.append("sslKeystorePass = " + (StringUtil.isNotEmpty(this.sslKeystorePass) ? "******" : "")).append(StringUtil.LINE_SEPARATOR);
        str.append("kerberosLoginConfPath = " + this.kerberosLoginConfPath).append(StringUtil.LINE_SEPARATOR);
        str.append("uKeyName = " + (StringUtil.isNotEmpty(this.uKeyName) ? "******" : "")).append(StringUtil.LINE_SEPARATOR);
        str.append("uKeyPin = " + (StringUtil.isNotEmpty(this.uKeyPin) ? "******" : "")).append(StringUtil.LINE_SEPARATOR);
        str.append("columnNameUpperCase = " + this.columnNameUpperCase).append(StringUtil.LINE_SEPARATOR);
        str.append("databaseProductName = " + this.databaseProductName).append(StringUtil.LINE_SEPARATOR);
        str.append("fullToHalfWidth = " + this.fullToHalfWidth).append(StringUtil.LINE_SEPARATOR);
        str.append("rsCacheCount = " + this.rsCacheCount).append(StringUtil.LINE_SEPARATOR);
        str.append("multiRsCaches = " + this.multiRsCaches).append(StringUtil.LINE_SEPARATOR);
        if (this.dmSvcConf != null) {
            str.append(this.dmSvcConf.printProperties());
        }
        return str.toString();
    }

    public void init(String url, String host, String port, Properties props, DmSvcConf conf) throws SQLException {
        if (conf != null) {
            this.dmSvcConf = (DmSvcConf)conf.clone();
        }
        this.url = url;
        this.host = host;
        this.port = Integer.parseInt(port);
        if (null != props) {
            this.user = props.getProperty("user");
            this.password = props.getProperty("password", "");
            this.parseOsAuthType(props);
            this.socketTimeout = DmSvcConf.parseInt(props.getProperty("socketTimeout"), this.socketTimeout, 0, null);
            this.continueBatchOnError = DmSvcConf.parseBoolean(props.getProperty("continueBatchOnError"), this.continueBatchOnError);
            this.escapeProcess = DmSvcConf.parseBoolean(props.getProperty("escapeProcess"), this.escapeProcess);
            this.maxRows = DmSvcConf.parseInt(props.getProperty("maxRows"), this.maxRows, 0, null);
            this.rowPrefetch = DmSvcConf.parseInt(props.getProperty("rowPrefetch"), this.rowPrefetch, 0, null);
            this.autoCommit = DmSvcConf.parseBoolean(props.getProperty("autoCommit"), this.autoCommit);
            this.maxCachedPstmtSize = DmSvcConf.parseInt(props.getProperty("maxCachedPstmtSize"), this.maxCachedPstmtSize, 0, null);
            this.LobMode = DmSvcConf.parseInt(props.getProperty("LobMode"), this.LobMode, 1, 2);
            this.stmtPoolMaxSize = DmSvcConf.parseInt(props.getProperty("StmtPoolSize"), this.stmtPoolMaxSize, 0, null);
            this.ignoreCase = DmSvcConf.parseBoolean(props.getProperty("ignoreCase"), this.ignoreCase);
            this.alwayseAllowCommit = DmSvcConf.parseBoolean(props.getProperty("alwayseAllowCommit"), this.alwayseAllowCommit);
            this.batchType = DmSvcConf.parseInt(props.getProperty("batchType"), this.batchType, 1, 2);
            this.appName = DmSvcConf.parseString(props.getProperty("appName"), this.appName);
            this.dmSvcConf.setCompressMsg(DmSvcConf.parseBoolean(props.getProperty("isCompress"), this.dmSvcConf.isCompressMsg()));
            this.sessionTimeout = DmSvcConf.parseInt(props.getProperty("sessionTimeout"), this.sessionTimeout, 0, null);
            this.dmSvcConf.setConnectTimeout(DmSvcConf.parseInt(props.getProperty("connectTimeout"), this.dmSvcConf.getConnectTimeout(), 0, null));
            this.sslFilesPath = DmSvcConf.parseString(props.getProperty("sslFilesPath"), this.sslFilesPath);
            this.sslKeystorePass = DmSvcConf.parseString(props.getProperty("sslKeystorePass"), this.sslKeystorePass);
            this.resultSetType = DmSvcConf.parseInt(props.getProperty("resultSetType"), this.resultSetType, null, null);
            this.kerberosLoginConfPath = DmSvcConf.parseString(props.getProperty("kerberosLoginConfPath"), this.kerberosLoginConfPath);
            this.mppLocal = DmSvcConf.parseBoolean(props.getProperty("mppLocal"), this.mppLocal);
            this.dmSvcConf.setRwSeparate(DmSvcConf.parseBoolean(props.getProperty("rwSeparate"), this.dmSvcConf.isRwSeparate()));
            this.dmSvcConf.setRwAutoDistribute(DmSvcConf.parseBoolean(props.getProperty("rwAutoDistribute"), this.dmSvcConf.isRwAutoDistribute()));
            this.dmSvcConf.setRwPercent(DmSvcConf.parseInt(props.getProperty("rwPercent"), this.dmSvcConf.getRwPercent(), 0, 100));
            this.rwStandbyRecoverTime = DmSvcConf.parseInt(props.getProperty("rwStandbyRecoverTime"), this.rwStandbyRecoverTime, 0, null);
            this.rwHA = DmSvcConf.parseBoolean(props.getProperty("rwHA"), this.rwHA);
            this.dbmdChkPrv = DmSvcConf.parseBoolean(props.getProperty("dbmdChkPrv"), this.dbmdChkPrv);
            this.uKeyName = DmSvcConf.parseString(props.getProperty("uKeyName"), this.uKeyName);
            this.uKeyPin = DmSvcConf.parseString(props.getProperty("uKeyPin"), this.uKeyPin);
            this.wellDistributed = DmSvcConf.parseBoolean(props.getProperty("wellDistributed"), this.wellDistributed);
            this.isBdtaRS = DmSvcConf.parseBoolean(props.getProperty("isBdtaRS"), this.isBdtaRS);
            this.columnNameUpperCase = DmSvcConf.parseBoolean(props.getProperty("columnNameUpperCase"), this.columnNameUpperCase);
            this.dmSvcConf.setDoSwitch(DmSvcConf.parseBoolean(props.getProperty("doSwitch"), this.dmSvcConf.isDoSwitch()));
            this.clobAsString = DmSvcConf.parseBoolean(props.getProperty("clobAsString"), this.clobAsString);
            this.databaseProductName = DmSvcConf.parseString(props.getProperty("databaseProductName"), this.databaseProductName);
            this.fullToHalfWidth = DmSvcConf.parseBoolean(props.getProperty("fullToHalfWidth"), this.fullToHalfWidth);
            this.dmSvcConf.setLoadBalance(DmSvcConf.parseBoolean(props.getProperty("loadBalance"), this.dmSvcConf.isLoadBalance()));
            DmSvcConf.loadBalanceFreq = DmSvcConf.parseInt(props.getProperty("loadBalanceFreq"), DmSvcConf.loadBalanceFreq, 0, null);
            this.dmSvcConf.setLoadBalancePercent(DmSvcConf.parseInt(props.getProperty("loadBalancePercent"), this.dmSvcConf.getLoadBalancePercent(), 0, 100));
            this.multiRsCaches = DmSvcConf.parseBoolean(props.getProperty("multiRsCaches"), this.multiRsCaches);
            this.rsCacheCount = DmSvcConf.parseInt(props.getProperty("rsCacheCount"), this.rsCacheCount, 0, 5);
            DmSvcConf.dbAliveCheckFreq = DmSvcConf.parseInt(props.getProperty("dbAliveCheckFreq"), DmSvcConf.dbAliveCheckFreq, 0, null);
            if (DmSvcConf.parseBoolean(props.getProperty("comOra"), false)) {
                this.dmSvcConf.setCompatibleMode(1);
            }
            this.parseCompatibleMode(props.getProperty("compatibleMode"));
            ConnClientAttr.initLogProps(props);
            ConnClientAttr.initStatProps(props);
            DmSvcConf.nullWithType = DmSvcConf.parseBoolean(props.getProperty("nullWithType"), DmSvcConf.nullWithType);
            this.callBatchNot = DmSvcConf.parseBoolean(props.getProperty("callBatchNot"), this.callBatchNot);
        }
    }

    public static void initLogProps(Properties props) {
        ConnClientAttr.parseTraceLevel(props.getProperty("traceLevel"));
        ConnClientAttr.parseLogLevel(props.getProperty("logLevel"));
        DmSvcConf.logDir = StringUtil.formatDir(DmSvcConf.parseString(props.getProperty("logDir"), DmSvcConf.logDir));
        DmSvcConf.logBufferPoolSize = DmSvcConf.parseInt(props.getProperty("logBufferPoolSize"), DmSvcConf.logBufferPoolSize, 1, null);
        DmSvcConf.logBufferSize = DmSvcConf.parseInt(props.getProperty("logBufferSize"), DmSvcConf.logBufferSize, 1, null);
        DmSvcConf.logFlusherQueueSize = DmSvcConf.parseInt(props.getProperty("logFlusherQueueSize"), DmSvcConf.logFlusherQueueSize, 1, null);
        DmSvcConf.logFlushFreq = DmSvcConf.parseInt(props.getProperty("logFlushFreq"), DmSvcConf.logFlushFreq, 0, null);
    }

    public static void initStatProps(Properties props) {
        DmSvcConf.statEnable = DmSvcConf.parseBoolean(props.getProperty("statEnable"), DmSvcConf.statEnable);
        DmSvcConf.statDir = StringUtil.formatDir(DmSvcConf.parseString(props.getProperty("statDir"), DmSvcConf.statDir));
        DmSvcConf.statFlushFreq = DmSvcConf.parseInt(props.getProperty("statFlushFreq"), DmSvcConf.statFlushFreq, 0, null);
        DmSvcConf.statHighFreqSqlCount = DmSvcConf.parseInt(props.getProperty("statHighFreqSqlCount"), DmSvcConf.statHighFreqSqlCount, 0, 1000);
        DmSvcConf.statSlowSqlCount = DmSvcConf.parseInt(props.getProperty("statSlowSqlCount"), DmSvcConf.statSlowSqlCount, 0, 1000);
        DmSvcConf.statSqlMaxCount = DmSvcConf.parseInt(props.getProperty("statSqlMaxCount"), DmSvcConf.statSqlMaxCount, 0, 100000);
        ConnClientAttr.parseStatSqlRemoveMode(props.getProperty("statSqlRemoveMode"));
    }

    private void parseCompatibleMode(String value) {
        if (StringUtil.isNotEmpty(value = DmSvcConf.parseString(value, ""))) {
            if (value.equalsIgnoreCase("oracle")) {
                this.dmSvcConf.setCompatibleMode(1);
            } else if (value.equalsIgnoreCase("mysql")) {
                this.dmSvcConf.setCompatibleMode(2);
            }
        }
    }

    private static void parseStatSqlRemoveMode(String value) {
        if (StringUtil.isNotEmpty(value = DmSvcConf.parseString(value, "")) && !StringUtil.isDigit(value)) {
            if ("oldest".equalsIgnoreCase(value) || "eldest".equalsIgnoreCase(value)) {
                DmSvcConf.statSqlRemoveMode = DmSvcConf.STAT_SQL_REMOVE_OLDEST;
            } else if ("latest".equalsIgnoreCase(value)) {
                DmSvcConf.statSqlRemoveMode = DmSvcConf.STAT_SQL_REMOVE_LATEST;
            }
        } else {
            DmSvcConf.statSqlRemoveMode = DmSvcConf.parseInt(value, DmSvcConf.statSqlRemoveMode, 1, 2);
        }
    }

    private static void parseLogLevel(String value) {
        if (StringUtil.isNotEmpty(value = DmSvcConf.parseString(value, ""))) {
            if ("DEBUG".equalsIgnoreCase(value)) {
                DmSvcConf.logLevel = 5;
            } else if ("INFO".equalsIgnoreCase(value)) {
                DmSvcConf.logLevel = 4;
            } else if ("warn".equalsIgnoreCase(value)) {
                DmSvcConf.logLevel = 2;
            } else if ("error".equalsIgnoreCase(value)) {
                DmSvcConf.logLevel = 1;
            } else if ("off".equalsIgnoreCase(value)) {
                DmSvcConf.logLevel = 0;
            } else if ("all".equalsIgnoreCase(value)) {
                DmSvcConf.logLevel = 9;
            }
        }
    }

    private static void parseTraceLevel(String value) {
        switch (DmSvcConf.parseInt(value, 0, 0, null)) {
            case 1: {
                DmSvcConf.logLevel = 2;
                break;
            }
            case 2: {
                DmSvcConf.logLevel = 3;
                break;
            }
            case 3: {
                DmSvcConf.logLevel = 4;
                break;
            }
            case 4: {
                DmSvcConf.logLevel = 9;
                break;
            }
        }
    }

    private void parseOsAuthType(Properties props) throws SQLException {
        String value = props.getProperty("osAuthType", "");
        if (StringUtil.isNotEmpty(value) && !StringUtil.isDigit(value)) {
            if ("ON".equalsIgnoreCase(value)) {
                this.osAuthType = 0;
            } else if ("SYSDBA".equalsIgnoreCase(value)) {
                this.osAuthType = 1;
            } else if ("SYSAUDITOR".equalsIgnoreCase(value)) {
                this.osAuthType = 3;
            } else if ("SYSSSO".equalsIgnoreCase(value)) {
                this.osAuthType = 2;
            } else if ("AUTO".equalsIgnoreCase(value)) {
                this.osAuthType = 4;
            } else if ("OFF".equalsIgnoreCase(value)) {
                this.osAuthType = 0;
            }
        } else {
            this.osAuthType = DmSvcConf.parseInt(value, this.osAuthType, 0, 4);
        }
        if (this.user == null && this.osAuthType == 0) {
            this.user = "SYSDBA";
        } else if (this.osAuthType != 0 && StringUtil.isNotEmpty(this.user)) {
            DBError.throwSQLException(6073);
        } else if (this.osAuthType != 0) {
            this.user = System.getProperty("user.name", "");
            this.password = "";
        }
        props.setProperty("user", this.user);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public boolean isCompress() {
        return this.dmSvcConf.isCompressMsg();
    }

    public void setCompress(boolean isCompress) {
        this.dmSvcConf.setCompressMsg(isCompress);
    }

    public boolean isMppLocal() {
        return this.mppLocal;
    }

    public void setMppLocal(boolean mppLocal) {
        this.mppLocal = mppLocal;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectTimeout() {
        return this.dmSvcConf.getConnectTimeout();
    }

    public void setConnectTimeout(int connectTimeout) {
        this.dmSvcConf.setConnectTimeout(connectTimeout);
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public boolean isWellDistributed() {
        return this.wellDistributed;
    }

    public void setWellDistributed(boolean wellDistributed) {
        this.wellDistributed = wellDistributed;
    }

    public boolean isDoSwitch() {
        return this.dmSvcConf.isDoSwitch();
    }

    public void setDoSwitch(boolean doSwitch) {
        this.dmSvcConf.setDoSwitch(doSwitch);
    }

    public boolean getRwSeparate() {
        return this.dmSvcConf.isRwSeparate();
    }

    public void setRwSeparate(boolean rwSeparate) {
        this.dmSvcConf.setRwSeparate(rwSeparate);
    }

    public int getRwPercent() {
        return this.dmSvcConf.getRwPercent();
    }

    public void setRwPercent(int rwPercent) {
        this.dmSvcConf.setRwPercent(rwPercent);
    }

    public int getRwStandbyRecoverTime() {
        return this.rwStandbyRecoverTime;
    }

    public void setRwStandbyRecoverTime(int rwStandbyRecoverTime) {
        this.rwStandbyRecoverTime = rwStandbyRecoverTime;
    }

    public boolean isContinueBatchOnError() {
        return this.continueBatchOnError;
    }

    public void setContinueBatchOnError(boolean continueBatchOnError) {
        this.continueBatchOnError = continueBatchOnError;
    }

    public boolean isEscapeProcess() {
        return this.escapeProcess;
    }

    public void setEscapeProcess(boolean escapeProcess) {
        this.escapeProcess = escapeProcess;
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public int getRowPrefetch() {
        return this.rowPrefetch;
    }

    public void setRowPrefetch(int rowPrefetch) {
        this.rowPrefetch = rowPrefetch;
    }

    public int getLobMode() {
        return this.LobMode;
    }

    public void setLobMode(int lobMode) {
        this.LobMode = lobMode;
    }

    public int getStmtPoolMaxSize() {
        return this.stmtPoolMaxSize;
    }

    public void setStmtPoolMaxSize(int stmtPoolSize) {
        this.stmtPoolMaxSize = stmtPoolSize;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public boolean isAlwayseAllowCommit() {
        return this.alwayseAllowCommit;
    }

    public void setAlwayseAllowCommit(boolean alwayseAllowCommit) {
        this.alwayseAllowCommit = alwayseAllowCommit;
    }

    public int getBatchType() {
        return this.batchType;
    }

    public void setBatchType(int batchType) {
        this.batchType = batchType;
    }

    public int getMaxCachedPstmtSize() {
        return this.maxCachedPstmtSize;
    }

    public void setMaxCachedPstmtSize(int maxCachedPstmtSize) {
        this.maxCachedPstmtSize = maxCachedPstmtSize;
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public boolean isDbmdChkPrv() {
        return this.dbmdChkPrv;
    }

    public void setDbmdChkPrv(boolean dbmdChkPrv) {
        this.dbmdChkPrv = dbmdChkPrv;
    }

    public boolean isBdtaRS() {
        return this.isBdtaRS;
    }

    public void setBdtaRS(boolean isBdtaRS) {
        this.isBdtaRS = isBdtaRS;
    }

    public boolean isClobAsString() {
        return this.clobAsString;
    }

    public void setClobAsString(boolean clobAsString) {
        this.clobAsString = clobAsString;
    }

    public String getSslFilesPath() {
        return this.sslFilesPath;
    }

    public void setSslFilesPath(String sslFilesPath) {
        this.sslFilesPath = sslFilesPath;
    }

    public String getSslKeystorePass() {
        return this.sslKeystorePass;
    }

    public void setSslKeystorePass(String sslKeystorePass) {
        this.sslKeystorePass = sslKeystorePass;
    }

    public String getKerberosLoginConfPath() {
        return this.kerberosLoginConfPath;
    }

    public void setKerberosLoginConfPath(String kerberosLoginConfPath) {
        this.kerberosLoginConfPath = kerberosLoginConfPath;
    }

    public String getUKeyName() {
        return this.uKeyName;
    }

    public void setUKeyName(String uKeyName) {
        this.uKeyName = uKeyName;
    }

    public String getUKeyPin() {
        return this.uKeyPin;
    }

    public void setUKeyPin(String uKeyPin) {
        this.uKeyPin = uKeyPin;
    }

    public boolean isColumnNameUpperCase() {
        return this.columnNameUpperCase;
    }

    public void setColumnNameUpperCase(boolean columnNameUpperCase) {
        this.columnNameUpperCase = columnNameUpperCase;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public void setDatabaseProductName(String databaseProductName) {
        this.databaseProductName = databaseProductName;
    }

    public int getRsCacheCount() {
        return this.rsCacheCount;
    }

    public void setRsCacheCount(int rsCacheCount) {
        this.rsCacheCount = rsCacheCount;
    }

    public boolean isMultiRsCaches() {
        return this.multiRsCaches;
    }

    public void setMultiRsCaches(boolean multiRsCaches) {
        this.multiRsCaches = multiRsCaches;
    }

    public boolean isLoginEncrypt() {
        return this.dmSvcConf.isLoginEncrypt();
    }

    public void setLoginEncrypt(boolean loginEncrypt) {
        this.dmSvcConf.setLoginEncrypt(loginEncrypt);
    }

    public int getLoginMode() {
        return this.dmSvcConf.getLoginMode();
    }

    public void setLoginMode(int loginMode) {
        this.dmSvcConf.setLoginMode(loginMode);
    }

    public String getCipherPath() {
        return this.dmSvcConf.getCipherPath();
    }

    public void setCipherPath(String cipherPath) {
        this.dmSvcConf.setCipherPath(cipherPath);
    }

    public long getSwitchTimes() {
        return this.dmSvcConf.getSwitchTimes();
    }

    public void setSwitchTimes(long switchTimes) {
        this.dmSvcConf.setSwitchTimes(switchTimes);
    }

    public long getSwitchInterval() {
        return this.dmSvcConf.getSwitchInterval();
    }

    public void setSwitchInterval(long switchInterval) {
        this.dmSvcConf.setSwitchInterval(switchInterval);
    }

    public boolean isEnRsCache() {
        return this.dmSvcConf.isEnRsCache();
    }

    public void setEnRsCache(boolean enRsCache) {
        this.dmSvcConf.setEnRsCache(enRsCache);
    }

    public int getRsRefreshFreq() {
        return this.dmSvcConf.getRsRefreshFreq();
    }

    public void setRsRefreshFreq(int rsRefreshFreq) {
        this.dmSvcConf.setRsRefreshFreq(rsRefreshFreq);
    }

    public int getRsCacheSize() {
        return this.dmSvcConf.getRsCacheSize();
    }

    public void setRsCacheSize(int rsCacheSize) {
        this.dmSvcConf.setRsCacheSize(rsCacheSize);
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public int getLanguage() {
        return this.dmSvcConf.getLanguage();
    }

    public short getClientTz() {
        return this.dmSvcConf.getTimeZone();
    }

    public void setClientTz(short timeZone) {
        this.dmSvcConf.setTimeZone(timeZone);
    }

    public String[] getKeyWords() {
        return this.dmSvcConf.getKeyWords();
    }

    public void setRwAutoDistribute(boolean rwAutoDistribute) {
        this.dmSvcConf.setRwAutoDistribute(rwAutoDistribute);
    }

    public boolean isRwAutoDistribute() {
        return this.dmSvcConf.isRwAutoDistribute();
    }

    public boolean isLoadBalance() {
        return this.dmSvcConf.isLoadBalance() && !this.dmSvcConf.isRwSeparate();
    }

    public int getLoadBalancePercent() {
        return this.dmSvcConf.getLoadBalancePercent();
    }

    public boolean isRwHA() {
        return this.rwHA;
    }

    public void setRwHA(boolean rwHA) {
        this.rwHA = rwHA;
    }

    public boolean isCompatibleOracle() {
        return this.dmSvcConf.isCompatibleOracle();
    }

    public boolean isCompatibleMysql() {
        return this.dmSvcConf.isCompatibleMysql();
    }

    public int getOsAuthType() {
        return this.osAuthType;
    }

    public void setOsAuthType(int osAuthType) {
        this.osAuthType = osAuthType;
    }

    public boolean isCallBatchNot() {
        return this.callBatchNot;
    }

    public void setCallBatchNot(boolean callBatchNot) {
        this.callBatchNot = callBatchNot;
    }
}

