/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.util.SQLStateMapping;
import dm.jdbc.util.SQLStateRange;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class DBError {
    public static boolean useSQLState = false;
    static final SQLStateMapping[] mappings = new SQLStateMapping[]{new SQLStateMapping(100, "02000", ""), new SQLStateMapping(0, "00000", ""), new SQLStateMapping(117, "01000", DmSvcConf.res.getString("warning.rangeWarn")), new SQLStateMapping(119, "01000", DmSvcConf.res.getString("warning.listWarn")), new SQLStateMapping(121, "01000", DmSvcConf.res.getString("warning.bp_with_err")), new SQLStateMapping(125, "01000", DmSvcConf.res.getString("warning.objCreateWithWarn")), new SQLStateMapping(-2007, "42000", ""), new SQLStateMapping(-2001, "30000", ""), new SQLStateMapping(-2003, "42000", ""), new SQLStateMapping(-2004, "30000", ""), new SQLStateMapping(-2005, "42000", ""), new SQLStateMapping(-6007, "08000", ""), new SQLStateMapping(-1000, "3D000", ""), new SQLStateMapping(-1001, "3D000", ""), new SQLStateMapping(-1006, "0P000", ""), new SQLStateMapping(-1007, "3F000", ""), new SQLStateMapping(-1029, "3B000", ""), new SQLStateMapping(-1031, "34000", ""), new SQLStateMapping(-1035, "3D000", ""), new SQLStateMapping(-1061, "0P000", ""), new SQLStateMapping(-1100, "25006", ""), new SQLStateMapping(-1101, "25000", ""), new SQLStateMapping(-1200, "28000", ""), new SQLStateMapping(-1402, "27000", ""), new SQLStateMapping(-1403, "27000", ""), new SQLStateMapping(-1404, "09000", ""), new SQLStateMapping(-1701, "2201B", ""), new SQLStateMapping(-2500, "22000", ""), new SQLStateMapping(-2501, "22000", ""), new SQLStateMapping(-2502, "22003", DmSvcConf.res.getString("error.dataOverflow")), new SQLStateMapping(-2503, "22012", ""), new SQLStateMapping(-2504, "22021", ""), new SQLStateMapping(-2505, "22000", ""), new SQLStateMapping(-2506, "22000", ""), new SQLStateMapping(-2507, "22019", ""), new SQLStateMapping(-2508, "22001", ""), new SQLStateMapping(-2511, "22000", ""), new SQLStateMapping(-2512, "22008", DmSvcConf.res.getString("DM_SQLSTATE_22008")), new SQLStateMapping(-2513, "22000", ""), new SQLStateMapping(-2514, "22000", ""), new SQLStateMapping(-2515, "22007", ""), new SQLStateMapping(-2518, "22015", ""), new SQLStateMapping(-2519, "22007", ""), new SQLStateMapping(-2520, "22000", ""), new SQLStateMapping(-2522, "22000", ""), new SQLStateMapping(-2523, "22000", ""), new SQLStateMapping(-2524, "22007", ""), new SQLStateMapping(-2525, "22000", ""), new SQLStateMapping(-3050, "25000", ""), new SQLStateMapping(-3051, "3B001", ""), new SQLStateMapping(-3201, "22000", ""), new SQLStateMapping(-3306, "24000", ""), new SQLStateMapping(-3315, "3D000", ""), new SQLStateMapping(-3318, "3F000", ""), new SQLStateMapping(-3415, "42000", ""), new SQLStateMapping(-6010, "08000", ""), new SQLStateMapping(-3801, "08000", ""), new SQLStateMapping(-3802, "08000", ""), new SQLStateMapping(-3803, "08004", ""), new SQLStateMapping(6001, "08S01", DmSvcConf.res.getString("error.cumunationError")), new SQLStateMapping(6002, "HY021", DmSvcConf.res.getString("error.msgCheckError")), new SQLStateMapping(6003, "40003", DmSvcConf.res.getString("error.sqlIsNullOrEmpty")), new SQLStateMapping(6004, "22003", DmSvcConf.res.getString("error.overflow")), new SQLStateMapping(6005, "22007", DmSvcConf.res.getString("error.invalidTimeIntervalValue")), new SQLStateMapping(6066, "22015", DmSvcConf.res.getString("error.intervalValueOverflow")), new SQLStateMapping(6006, "HY004", DmSvcConf.res.getString("error.unsupportedType")), new SQLStateMapping(6007, "HY096", DmSvcConf.res.getString("error.dataConvertionError")), new SQLStateMapping(6008, "01001", DmSvcConf.res.getString("error.readOnlyConnection")), new SQLStateMapping(6009, "HY004", DmSvcConf.res.getString("error.invalidSqlType")), new SQLStateMapping(6010, "HY093", DmSvcConf.res.getString("error.invalidSequence")), new SQLStateMapping(6011, "3D000", DmSvcConf.res.getString("error.invalidDbName")), new SQLStateMapping(6012, "22003", DmSvcConf.res.getString("error.invalidDigitalTypeFormat")), new SQLStateMapping(6013, "22007", DmSvcConf.res.getString("error.invalidDateTypeFormat")), new SQLStateMapping(6014, "22007", DmSvcConf.res.getString("error.invalidTimeTypeFormat")), new SQLStateMapping(6015, "22007", DmSvcConf.res.getString("error.invalidDateTimeTypeFormat")), new SQLStateMapping(6016, "HY004", DmSvcConf.res.getString("error.invalidColumnType")), new SQLStateMapping(6017, "HY111", DmSvcConf.res.getString("error.invalidColumnName")), new SQLStateMapping(6018, "22003", DmSvcConf.res.getString("error.invalidBigDecimalTypeFormat")), new SQLStateMapping(6019, "01001", DmSvcConf.res.getString("error.invalidResultsetType")), new SQLStateMapping(6020, "HY107", DmSvcConf.res.getString("error.invalidRowNo")), new SQLStateMapping(6021, "HY020", DmSvcConf.res.getString("error.emptyResultset")), new SQLStateMapping(6022, "HYC00", DmSvcConf.res.getString("error.invalidCursorMoveDirection")), new SQLStateMapping(6023, "HY024", DmSvcConf.res.getString("error.forwardOnlyResultset")), new SQLStateMapping(6024, "HY024", DmSvcConf.res.getString("error.notAllowNull")), new SQLStateMapping(6025, "3D000", DmSvcConf.res.getString("error.invalidDbName")), new SQLStateMapping(6026, "01001", DmSvcConf.res.getString("error.resultsetNotInInsertStatus")), new SQLStateMapping(6027, "01001", DmSvcConf.res.getString("error.resultsetInInsertStatus")), new SQLStateMapping(6029, "42000", DmSvcConf.res.getString("error.resultsetInReadOnlyStatus")), new SQLStateMapping(6030, "HYC00", DmSvcConf.res.getString("error.unsupportedInterfase")), new SQLStateMapping(6032, "42S22", DmSvcConf.res.getString("error.invalidSequenceNo")), new SQLStateMapping(6033, "HY024", DmSvcConf.res.getString("error.invalidReturnValue")), new SQLStateMapping(6034, "08007", DmSvcConf.res.getString("error.resultsetClosed")), new SQLStateMapping(6035, "08007", DmSvcConf.res.getString("error.statementHandleClosed")), new SQLStateMapping(6036, "HY024", DmSvcConf.res.getString("error.invalidParameterValue")), new SQLStateMapping(6037, "HY024", DmSvcConf.res.getString("error.invalidTypeDesc")), new SQLStateMapping(6038, "HYC00", DmSvcConf.res.getString("error.invalidTranIsolation")), new SQLStateMapping(6039, "HY012", DmSvcConf.res.getString("error.savepointInAutoCommitMode")), new SQLStateMapping(6040, "HY012", DmSvcConf.res.getString("error.rollbackToSavepointInAutoCommitMode")), new SQLStateMapping(6041, "HY012", DmSvcConf.res.getString("error.releaseSavepointInAutoCommitMode")), new SQLStateMapping(6042, "HY012", DmSvcConf.res.getString("error.commitInAutoCommitMode")), new SQLStateMapping(6043, "HY012", DmSvcConf.res.getString("error.rollbackInAutoCommitMode")), new SQLStateMapping(6044, "21S01", DmSvcConf.res.getString("error.invalidInputParameterValue")), new SQLStateMapping(6045, "21S01", DmSvcConf.res.getString("error.invalidOutParameterValue")), new SQLStateMapping(6046, "42000", DmSvcConf.res.getString("error.canNotGetSavepointID")), new SQLStateMapping(6047, "42000", DmSvcConf.res.getString("error.canNotGetSavepointName")), new SQLStateMapping(6048, "22002", DmSvcConf.res.getString("error.unknownParameterType")), new SQLStateMapping(6049, "HY104", DmSvcConf.res.getString("error.invalidScale")), new SQLStateMapping(6050, "HY093", DmSvcConf.res.getString("error.invalidParameterName")), new SQLStateMapping(6051, "HY092", DmSvcConf.res.getString("error.invalidSavepointName")), new SQLStateMapping(6064, "", DmSvcConf.res.getString("error.invalidSavepoint")), new SQLStateMapping(6052, "HY104", DmSvcConf.res.getString("error.tooBigParameterPrecsicion")), new SQLStateMapping(6053, "HY009", DmSvcConf.res.getString("error.savepointReleased")), new SQLStateMapping(6054, "21S01", DmSvcConf.res.getString("error.unbindedParameter")), new SQLStateMapping(6055, "HY024", DmSvcConf.res.getString("error.invalidCursorValue")), new SQLStateMapping(6065, "", DmSvcConf.res.getString("error.invalidResultSetField")), new SQLStateMapping(6057, "22025", DmSvcConf.res.getString("error.invalidLenOrOffset")), new SQLStateMapping(6060, "08003", DmSvcConf.res.getString("error.connectionClosedOrNotBuild")), new SQLStateMapping(6061, "08003", DmSvcConf.res.getString("error.encrypt.negotiate.fail")), new SQLStateMapping(6062, "08003", DmSvcConf.res.getString("error.init.kerberos.fail")), new SQLStateMapping(6063, "08003", DmSvcConf.res.getString("error.getFQDN.fail")), new SQLStateMapping(20000, "", DmSvcConf.res.getString("error.SwitchedSused")), new SQLStateMapping(20001, "", DmSvcConf.res.getString("error.SwitchedFailed")), new SQLStateMapping(20002, "", DmSvcConf.res.getString("error.SSLInitFailed")), new SQLStateMapping(20003, "", DmSvcConf.res.getString("error.LobDataHasFreed")), new SQLStateMapping(20004, "", DmSvcConf.res.getString("error.fatalError")), new SQLStateMapping(20005, "", DmSvcConf.res.getString("error.invalidStmtCall")), new SQLStateMapping(20006, "", DmSvcConf.res.getString("error.registedNotCursorType")), new SQLStateMapping(20007, "", DmSvcConf.res.getString("error.colIndexLowerOne")), new SQLStateMapping(20008, "", DmSvcConf.res.getString("error.colIndexesNull")), new SQLStateMapping(20009, "", DmSvcConf.res.getString("error.colName")), new SQLStateMapping(20010, "", DmSvcConf.res.getString("error.colNames")), new SQLStateMapping(20011, "", DmSvcConf.res.getString("error.nocolumnset")), new SQLStateMapping(20012, "", DmSvcConf.res.getString("error.nocolnameset")), new SQLStateMapping(20013, "", DmSvcConf.res.getString("error.nocolindexset")), new SQLStateMapping(20014, "", DmSvcConf.res.getString("error.colindexunset")), new SQLStateMapping(20015, "", DmSvcConf.res.getString("error.colnameunset")), new SQLStateMapping(20016, "", DmSvcConf.res.getString("error.jrstnshowdeleted")), new SQLStateMapping(20017, "", DmSvcConf.res.getString("error.serilobioex")), new SQLStateMapping(20018, "", DmSvcConf.res.getString("error.connurlerror")), new SQLStateMapping(20019, "", DmSvcConf.res.getString("error.commadNull")), new SQLStateMapping(20020, "", DmSvcConf.res.getString("error.cachedRowSetCursorMoved")), new SQLStateMapping(20021, "", DmSvcConf.res.getString("error.cachedRowSetRsNotSupt")), new SQLStateMapping(20023, "", DmSvcConf.res.getString("error.cachedRowSetRowNpopu")), new SQLStateMapping(20024, "", DmSvcConf.res.getString("error.cachedRowSetStartRowNNeg")), new SQLStateMapping(20025, "", DmSvcConf.res.getString("error.cachedRowSetRsNull")), new SQLStateMapping(20026, "", DmSvcConf.res.getString("error.cachedRowSetRsTooFew")), new SQLStateMapping(6067, "22001", DmSvcConf.res.getString("error.StringCut")), new SQLStateMapping(6068, "22000", DmSvcConf.res.getString("error.invalidHex")), new SQLStateMapping(6069, "", DmSvcConf.res.getString("error.invalidCipher")), new SQLStateMapping(6070, "", DmSvcConf.res.getString("error.invalidBfileStr")), new SQLStateMapping(6071, "", DmSvcConf.res.getString("error.cipher.encrypt.fail")), new SQLStateMapping(6072, "", DmSvcConf.res.getString("error.cipher.decrypt.fail")), new SQLStateMapping(6601, "", DmSvcConf.res.getString("error.standbyConnectFailed")), new SQLStateMapping(6602, "", DmSvcConf.res.getString("error.invalidRsFromStandby")), new SQLStateMapping(6073, "", DmSvcConf.res.getString("error.osAuthUserConflict")), new SQLStateMapping(125, "", DmSvcConf.res.getString("warning.objCreateWithWarn"))};
    static final SQLStateRange[] ranges = new SQLStateRange[]{new SQLStateRange(101, 203, "01000"), new SQLStateRange(-1997, -1900, "42000"), new SQLStateRange(-3109, -3100, "23000")};

    public static void throwSQLException(String reason, int errCode) throws SQLException {
        if (errCode == 0 || errCode == 13) {
            return;
        }
        String SQLState = DBError.getSQLStateByErrorCode(errCode);
        throw new SQLException(reason, SQLState, errCode);
    }

    public static void throwSQLException(String reason) throws SQLException {
        throw new SQLException(reason);
    }

    public static void throwSQLException(int errCode) throws SQLException {
        String state = DBError.getSQLStateByErrorCode(errCode);
        String info = DBError.getErrorInfoByErrorCode(errCode);
        throw new SQLException(info, state, errCode);
    }

    public static String getSQLStateByErrorCode(int errCode) {
        for (int j = 0; j < mappings.length; ++j) {
            if (errCode != DBError.mappings[j].err) continue;
            return DBError.mappings[j].SQLState;
        }
        for (int k = 0; k < ranges.length; ++k) {
            if (errCode < DBError.ranges[k].low || errCode > DBError.ranges[k].high) continue;
            return DBError.ranges[k].SQLState;
        }
        return "22000";
    }

    public static String getErrorInfoByErrorCode(int errCode) {
        for (int j = 0; j < mappings.length; ++j) {
            if (errCode != DBError.mappings[j].err) continue;
            return DBError.mappings[j].errInfo;
        }
        return "";
    }

    public static void throwUnsupportedSQLException() throws SQLException {
        DBError.throwSQLException(6030);
    }

    public static SQLWarning addSQLWarning(SQLWarning oldWarning, int warnCode) {
        String state = DBError.getSQLStateByErrorCode(warnCode);
        String info = DBError.getErrorInfoByErrorCode(warnCode);
        SQLWarning warn = new SQLWarning(info, state, warnCode);
        if (oldWarning == null) {
            return warn;
        }
        oldWarning.setNextWarning(warn);
        return oldWarning;
    }

    public static void SQLToIOException(SQLException sqlexception) throws IOException {
        throw new IOException(sqlexception.getMessage());
    }

    public static String ErrorToSQLState(int i) {
        for (int j = 0; j < mappings.length; ++j) {
            if (i != DBError.mappings[j].err) continue;
            return DBError.mappings[j].SQLState;
        }
        for (int k = 0; k < ranges.length; ++k) {
            if (i < DBError.ranges[k].low || i > DBError.ranges[k].high) continue;
            return DBError.ranges[k].SQLState;
        }
        return "22000";
    }
}

