/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.dbaccess.AuthInfo;
import dm.jdbc.dbaccess.DBError;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class Auth {
    private static String serviceName = "dmserver";
    private String servicePrincipleName = null;
    private AuthInfo authInfo = null;
    private Oid authTypeOid = null;

    private static String getServerFQDN(String serverName) throws UnknownHostException {
        InetAddress addr = InetAddress.getByName(serverName);
        addr = InetAddress.getByAddress(addr.getAddress());
        String name = addr.getCanonicalHostName();
        return name;
    }

    private static String getServicePrincipleName(String serverName) throws UnknownHostException {
        String serverFQDN = Auth.getServerFQDN(serverName);
        return serviceName + "@" + serverFQDN;
    }

    public Auth(String serverName, int authType) throws UnknownHostException {
        switch (authType) {
            case 2: {
                try {
                    this.authTypeOid = new Oid("1.2.840.113554.1.2.2");
                }
                catch (GSSException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        this.servicePrincipleName = Auth.getServicePrincipleName(serverName);
    }

    private void doAuth() throws GSSException {
        GSSManager manager = GSSManager.getInstance();
        GSSName serverName = manager.createName(this.servicePrincipleName, GSSName.NT_HOSTBASED_SERVICE);
        GSSContext context = manager.createContext(serverName, this.authTypeOid, null, 0);
        context.requestMutualAuth(false);
        byte[] token = new byte[]{};
        token = context.initSecContext(token, 0, token.length);
        if (context.isEstablished()) {
            if (token != null) {
                this.authInfo = new AuthInfo(token);
                this.authInfo.setUserName(this.getContextUserName(context));
            }
            context.dispose();
        } else {
            this.authInfo = null;
        }
    }

    public AuthInfo getAuthInfo() throws SQLException {
        try {
            System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
            this.doAuth();
        }
        catch (GSSException e) {
            DBError.throwSQLException(e.getMessage());
        }
        return this.authInfo;
    }

    public String getContextUserName(GSSContext context) throws GSSException {
        String userPrincipleName = context.getSrcName().toString();
        String userName = null;
        int index = userPrincipleName.indexOf(64);
        userName = userPrincipleName.substring(0, index);
        return userName;
    }
}

