/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.binder;

import dm.jdbc.dataConvertion.BFileInner;
import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.binder.DmBinder;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmReaderParam;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.sql.TypeDescriptor;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class DmReaderBinder
extends DmBinder {
    boolean toBindLobCyc = false;
    boolean new_lob_flag = false;
    byte[] ret = null;

    public DmReaderBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
        this.new_lob_flag = pstmt.getConnection_bs().getNewLobFlag();
    }

    void init() {
        this.recDType = 19;
        this.recPrec = Integer.MAX_VALUE;
        this.recScale = 0;
    }

    void checkType(int irow, int icol, boolean forBatch) throws SQLException {
        byte ioType;
        if (this.m_checkType) {
            return;
        }
        this.m_checkType = true;
        if (this.paramsDesc == null) {
            this.paramsDesc = this.pstmt.getParamsDesc();
        }
        byte typeFlag = this.paramsDesc[icol].getTypeFlag();
        int dType = this.paramsDesc[icol].getDType();
        int prec = this.paramsDesc[icol].getPrec();
        int scale = this.paramsDesc[icol].getScale();
        this.destIoType = ioType = this.paramsDesc[icol].getIOType();
        this.srcScale = scale;
        if (typeFlag == 1 || ioType == 1) {
            this.destDType = dType;
            this.destPrec = prec;
            this.destScale = scale;
            return;
        }
        switch (dType) {
            case 0: 
            case 1: 
            case 2: 
            case 17: 
            case 18: {
                dType = 2;
                prec = 8188;
                scale = 0;
                break;
            }
            case 12: 
            case 19: {
                dType = 19;
                prec = Integer.MAX_VALUE;
                scale = 0;
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        this.destDType = dType;
        this.destPrec = prec;
        this.destScale = scale;
    }

    private String readLeftCompletelyWithTry(DmReaderParam readerParam, String strTry) throws IOException {
        int readLen;
        Reader reader = readerParam.getReader();
        long targetLen = readerParam.getTargetLen();
        if (this.streamReadOver) {
            return strTry;
        }
        StringBuffer strBuf = new StringBuffer(strTry);
        int maxLen = 8000;
        char[] totalBuf = new char[maxLen];
        int count = this.readerTryLen;
        while ((readLen = reader.read(totalBuf, 0, maxLen)) > 0) {
            String tmp;
            if (targetLen != -1L && (long)(count + readLen) >= targetLen) {
                tmp = new String(totalBuf, 0, (int)(targetLen - (long)count));
                strBuf.append(tmp);
                break;
            }
            count += readLen;
            tmp = new String(totalBuf, 0, readLen);
            strBuf.append(tmp);
        }
        this.streamReadOver = true;
        return strBuf.toString();
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        Object obj = this.pstmt.getParamObject(irow, icol);
        String serverEncoding = this.pstmt.getConnection_bs().getServerEncoding();
        short dbTz = this.pstmt.getConnection_bs().getDbTz();
        short ltz = this.pstmt.getConnection_bs().getClientTz();
        TypeDescriptor typeDesc = this.paramsDesc[icol].getTypeDescriptor();
        if (this.isDiffParamObjectType() && !(obj instanceof DmReaderParam)) {
            this.ret = this.castToDestType(obj, this.destDType, this.destPrec, this.destScale, serverEncoding, ltz, dbTz, typeDesc);
        } else {
            DmReaderParam readerParam = (DmReaderParam)obj;
            Reader reader = readerParam.getReader();
            long targetLen = readerParam.getTargetLen();
            int retLen = 0;
            String str = null;
            if (this.toBindLobCyc) {
                return -1;
            }
            if (this.ret != null) {
                int realLen = msg.appendBytesWithLen2(this.ret, 0, this.ret.length);
                this.ret = null;
                return realLen;
            }
            try {
                int maxLen = 8000;
                this.readerTry = new char[maxLen];
                this.readerTryLen = reader.read(this.readerTry, 0, maxLen);
                if (this.readerTryLen < maxLen) {
                    if (this.readerTryLen == -1) {
                        this.readerTryLen = 0;
                    }
                    this.streamReadOver = true;
                }
                int charsLen = this.readerTryLen;
                if (targetLen != -1L && (long)charsLen > targetLen) {
                    charsLen = (int)targetLen;
                    this.streamReadOver = true;
                }
                str = new String(this.readerTry, 0, charsLen);
                if (this.destDType == 12 || this.destDType == 19) {
                    this.ret = Convertion.getBytes(str, serverEncoding);
                    retLen = this.ret.length;
                    if (retLen > 2048) {
                        this.toBindLobCyc = true;
                        return -1;
                    }
                }
                switch (this.destDType) {
                    case 0: 
                    case 1: {
                        if (!this.streamReadOver) {
                            str = this.readLeftCompletelyWithTry(readerParam, str);
                        }
                        this.ret = Convertion.String_char_2CType(str, this.destPrec, this.destDType, serverEncoding);
                        break;
                    }
                    case 2: 
                    case 19: {
                        if (!this.streamReadOver) {
                            str = this.readLeftCompletelyWithTry(readerParam, str);
                        }
                        if (DmdbType.isBFileType(this.destDType, this.destPrec, this.destScale)) {
                            this.ret = Convertion.String_varchar_2CType(new BFileInner(str).toString(), this.destPrec, 2, serverEncoding);
                            break;
                        }
                        this.ret = Convertion.String_varchar_2CType(str, this.destPrec, this.destDType, serverEncoding);
                        break;
                    }
                    case 12: 
                    case 17: 
                    case 18: {
                        if (!this.streamReadOver) {
                            str = this.readLeftCompletelyWithTry(readerParam, str);
                        }
                        this.ret = Convertion.getBytes(str, serverEncoding);
                        break;
                    }
                    default: {
                        DBError.throwSQLException(6007);
                        break;
                    }
                }
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
            this.clearVars();
        }
        return msg.appendBytesWithLen2(this.ret, 0, this.ret.length);
    }

    public int bindLobCyc(DmMsgSend lobMsg, int irow, int icol) throws SQLException {
        DmReaderParam readerParam = (DmReaderParam)this.pstmt.getParamObject(irow, icol);
        Reader reader = readerParam.getReader();
        long targetLen = readerParam.getTargetLen();
        int realLen = 0;
        int retLen = 0;
        String serverEncoding = this.pstmt.getConnection_bs().getServerEncoding();
        this.toBindLobCyc = false;
        if (this.readerTry != null) {
            realLen = this.readerTryLen;
            if (targetLen != -1L && (long)this.readerTryLen > targetLen) {
                realLen = (int)targetLen;
            }
            String str = new String(this.readerTry, 0, realLen);
            byte[] ret = Convertion.getBytes(str, serverEncoding);
            retLen = lobMsg.appendOffRowBytes(ret, 0, ret.length, this.new_lob_flag, -1);
            this.readerTry = null;
            return retLen;
        }
        if (this.streamReadOver) {
            this.clearVars();
            return 0;
        }
        int maxLen = 8000;
        char[] charsBuf = new char[maxLen];
        try {
            retLen = reader.read(charsBuf, 0, maxLen);
            if (retLen == -1) {
                this.clearVars();
                return 0;
            }
            if (retLen < maxLen) {
                this.streamReadOver = true;
            }
            this.readerTryLen += retLen;
            if (targetLen != -1L && (long)this.readerTryLen >= targetLen) {
                this.streamReadOver = true;
                retLen = (int)((long)retLen - ((long)this.readerTryLen - targetLen));
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        String subStr = new String(charsBuf, 0, retLen);
        byte[] strbs = this.destDType == 12 || this.destDType == 17 || this.destDType == 18 ? Convertion.stringToBinary(subStr, this.destPrec) : Convertion.getBytes(subStr, serverEncoding);
        return lobMsg.appendOffRowBytes(strbs, 0, strbs.length, this.new_lob_flag, -1);
    }

    public void clearRetValue() {
        this.ret = null;
    }
}

