/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.binder;

import dm.jdbc.dataConvertion.BFileInner;
import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.binder.DmBinder;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.sql.TypeDescriptor;
import java.sql.Clob;
import java.sql.SQLException;

public class DmClobBinder
extends DmBinder {
    boolean new_lob_flag = false;

    public DmClobBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
        this.new_lob_flag = pstmt.getConnection_bs().getNewLobFlag();
    }

    void init() {
        this.recDType = 19;
        this.recPrec = Integer.MAX_VALUE;
        this.recScale = 0;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        Object obj = this.pstmt.getParamObject(irow, icol);
        String serverEncoding = this.pstmt.getConnection_bs().getServerEncoding();
        short dbTz = this.pstmt.getConnection_bs().getDbTz();
        short ltz = this.pstmt.getConnection_bs().getClientTz();
        TypeDescriptor typeDesc = this.paramsDesc[icol].getTypeDescriptor();
        byte[] ret = null;
        if (this.isDiffParamObjectType() && !(obj instanceof Clob)) {
            ret = this.castToDestType(obj, this.destDType, this.destPrec, this.destScale, serverEncoding, ltz, dbTz, typeDesc);
        } else {
            Clob clob = (Clob)obj;
            String str = "";
            long length = clob.length();
            if (this.destDType == 19) {
                if (length > 2048L) {
                    return -1;
                }
                str = clob.getSubString(1L, (int)length);
                ret = Convertion.getBytes(str, serverEncoding);
                if (ret.length > 2048) {
                    return -1;
                }
            }
            switch (this.destDType) {
                case 2: 
                case 19: {
                    str = clob.getSubString(1L, (int)length);
                    if (DmdbType.isBFileType(this.destDType, this.destPrec, this.destScale)) {
                        ret = Convertion.String_varchar_2CType(new BFileInner(str).toString(), this.destPrec, 2, serverEncoding);
                        break;
                    }
                    ret = Convertion.getBytes(str, serverEncoding);
                    break;
                }
                default: {
                    DBError.throwSQLException(6007);
                }
            }
        }
        if (ret.length == 0 && this.pstmt.getConnection_bs().isLobEmptyCompOrcl()) {
            return msg.appendLen2(-6);
        }
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public int bindLobCyc(DmMsgSend lobMsg, int irow, int icol) throws SQLException {
        Clob lob = (Clob)this.pstmt.getParamObject(irow, icol);
        int maxLen = 8000;
        long lobLen = lob.length();
        if ((long)this.offset_var > lobLen) {
            this.clearVars();
            return 0;
        }
        if (this.offset_var == -1) {
            this.offset_var = 1;
        }
        int readLen = (int)(lobLen - (long)this.offset_var + 1L > (long)maxLen ? (long)maxLen : lobLen - (long)this.offset_var + 1L);
        String serverEncoding = this.pstmt.getConnection_bs().getServerEncoding();
        String str = lob.getSubString(this.offset_var, readLen);
        this.offset_var += str.length();
        byte[] ret = Convertion.getBytes(str, serverEncoding);
        return lobMsg.appendOffRowBytes(ret, 0, ret.length, this.new_lob_flag, -1);
    }
}

