/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.accessor;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.accessor.BaseAccessor;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.util.StringUtil;
import dm.jdbc.util.UtilBinaryToUnicodeInputStream;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbTimestamp;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringAccessor
extends BaseAccessor {
    private Calendar calendar = Calendar.getInstance();

    @Override
    public boolean getBoolean() throws SQLException {
        String str = this.getString();
        if (this.wasNull) {
            return false;
        }
        return str.length() != 0 && str.charAt(0) != '0';
    }

    @Override
    public byte getByte() throws SQLException {
        String str = this.getString();
        if (this.wasNull) {
            return 0;
        }
        Double tmp = null;
        try {
            tmp = Double.valueOf(str.trim());
        }
        catch (Exception e) {
            DBError.throwSQLException(6007);
        }
        if (tmp < -128.0 || tmp > 127.0) {
            DBError.throwSQLException(6004);
        }
        return tmp.byteValue();
    }

    @Override
    public short getShort() throws SQLException {
        String str = this.getString();
        if (this.wasNull) {
            return 0;
        }
        Double tmp = null;
        try {
            tmp = Double.valueOf(str.trim());
        }
        catch (Exception e) {
            DBError.throwSQLException(6007);
        }
        if (tmp < -32768.0 || tmp > 32767.0) {
            DBError.throwSQLException(6004);
        }
        return tmp.shortValue();
    }

    @Override
    public int getInt() throws SQLException {
        String str = this.getString();
        if (this.wasNull) {
            return 0;
        }
        Double tmp = null;
        try {
            tmp = Double.valueOf(str.trim());
        }
        catch (Exception e) {
            DBError.throwSQLException(6007);
        }
        if (tmp < -2.147483648E9 || tmp > 2.147483647E9) {
            DBError.throwSQLException(6004);
        }
        return tmp.intValue();
    }

    @Override
    public long getLong() throws SQLException {
        String str = this.getString();
        if (this.wasNull) {
            return 0L;
        }
        Double tmp = null;
        try {
            tmp = Double.valueOf(str.trim());
        }
        catch (Exception e) {
            DBError.throwSQLException(6007);
        }
        if (tmp < -9.223372036854776E18 || tmp > 9.223372036854776E18) {
            DBError.throwSQLException(6004);
        }
        return tmp.longValue();
    }

    @Override
    public float getFloat() throws SQLException {
        String str = this.getString();
        if (this.wasNull) {
            return 0.0f;
        }
        BigDecimal tmp1 = null;
        try {
            tmp1 = new BigDecimal(str.trim());
        }
        catch (Exception e) {
            DBError.throwSQLException(6007);
        }
        float flt = tmp1.floatValue();
        if (flt == Float.NEGATIVE_INFINITY || flt == Float.POSITIVE_INFINITY) {
            DBError.throwSQLException(6004);
        }
        return flt;
    }

    @Override
    public double getDouble() throws SQLException {
        String str = this.getString();
        if (this.wasNull) {
            return 0.0;
        }
        Double db1 = null;
        try {
            db1 = Double.valueOf(str.trim());
        }
        catch (Exception e) {
            DBError.throwSQLException(6007);
        }
        return db1;
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        String str = this.getString();
        if (this.wasNull) {
            return null;
        }
        BigDecimal dec = null;
        try {
            dec = new BigDecimal(str.trim());
        }
        catch (Exception e) {
            DBError.throwSQLException(6007);
        }
        return dec;
    }

    @Override
    public Date getDate() throws SQLException {
        String str = this.getString();
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        return DmdbTimestamp.toDate(str, this.calendar);
    }

    @Override
    public Time getTime() throws SQLException {
        String str = this.getString();
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        return DmdbTimestamp.toTime(str, this.calendar);
    }

    @Override
    public Timestamp getTimestamp() throws SQLException {
        String str = this.getString();
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        return DmdbTimestamp.toTimestamp(str, this.calendar);
    }

    @Override
    public DmdbTimestamp getDmdbTimestamp() throws SQLException {
        String str = this.getString();
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        return DmdbTimestamp.valueOf(str);
    }

    @Override
    public DmdbIntervalDT getIntervalDT() throws SQLException {
        String str = this.getString();
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        return new DmdbIntervalDT(str);
    }

    @Override
    public DmdbIntervalYM getIntervalYM() throws SQLException {
        String str = this.getString();
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        return new DmdbIntervalYM(str);
    }

    @Override
    public Object getObjectInner(Map<String, Class<?>> typeMap) throws SQLException {
        return this.getString();
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return null;
        }
        this.dataBuffer = StringAccessor.checkVarchar2(this.dataBuffer, this.dtype, this.prec);
        return new DmdbInputStream(this.dataBuffer, this.serverEncoding);
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return null;
        }
        this.dataBuffer = StringAccessor.checkVarchar2(this.dataBuffer, this.dtype, this.prec);
        return new UtilBinaryToUnicodeInputStream(new ByteArrayInputStream(this.dataBuffer));
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return null;
        }
        this.dataBuffer = StringAccessor.checkVarchar2(this.dataBuffer, this.dtype, this.prec);
        return new DmdbInputStream(this.dataBuffer, this.serverEncoding);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        String str = this.getString();
        if (this.wasNull) {
            return null;
        }
        return new StringReader(str);
    }

    @Override
    public String getString() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return null;
        }
        this.dataBuffer = StringAccessor.checkVarchar2(this.dataBuffer, this.dtype, this.prec);
        String str = Convertion.getString(this.dataBuffer, 0, this.dataBuffer.length, this.serverEncoding);
        if (DmdbType.isBFileType(this.dtype, this.prec, this.scale)) {
            str = Convertion.stringToBFile(str).toString();
        }
        return str;
    }

    public static byte[] checkVarchar2(byte[] val, int dType, int prec) {
        if (dType == 1 && val.length < prec) {
            byte[] retBs = new byte[prec];
            System.arraycopy(val, 0, retBs, 0, val.length);
            for (int i = val.length; i < retBs.length; ++i) {
                retBs[i] = 32;
            }
            return retBs;
        }
        return val;
    }
}

