/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.accessor;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.accessor.BaseAccessor;
import dm.jdbc.dbaccess.DBError;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortAccessor
extends BaseAccessor {
    @Override
    public boolean getBoolean() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return false;
        }
        return Convertion.twoByteToShort(this.dataBuffer) != 0;
    }

    @Override
    public byte getByte() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return 0;
        }
        short result = Convertion.twoByteToShort(this.dataBuffer);
        if (result < -128 || result > 127) {
            DBError.throwSQLException(6004);
        }
        return (byte)result;
    }

    @Override
    public short getShort() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? (short)0 : Convertion.twoByteToShort(this.dataBuffer);
    }

    @Override
    public int getInt() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? 0 : (int)Convertion.twoByteToShort(this.dataBuffer);
    }

    @Override
    public long getLong() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? 0L : (long)Convertion.twoByteToShort(this.dataBuffer);
    }

    @Override
    public float getFloat() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? 0.0f : (float)Convertion.twoByteToShort(this.dataBuffer);
    }

    @Override
    public double getDouble() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? 0.0 : (double)Convertion.twoByteToShort(this.dataBuffer);
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? null : new BigDecimal(Convertion.twoByteToShort(this.dataBuffer));
    }

    @Override
    public String getString() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? null : String.valueOf(Convertion.twoByteToShort(this.dataBuffer));
    }

    @Override
    Object getObjectInner(Map<String, Class<?>> typeMap) throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? null : Short.valueOf(Convertion.twoByteToShort(this.dataBuffer));
    }
}

