/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.accessor;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.accessor.BaseAccessor;
import dm.jdbc.dbaccess.DBError;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecimalAccessor
extends BaseAccessor {
    @Override
    public boolean getBoolean() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return false;
        }
        BigDecimal result = Convertion.bytesToBigDecimal(this.dataBuffer, this.scale, this.prec, this.compatibleOracle);
        return result.byteValue() != 0;
    }

    @Override
    public byte getByte() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return 0;
        }
        BigDecimal result = Convertion.bytesToBigDecimal(this.dataBuffer, this.scale, this.prec, this.compatibleOracle);
        if (result.doubleValue() < -128.0 || result.doubleValue() > 127.0) {
            DBError.throwSQLException(6004);
        }
        return result.byteValue();
    }

    @Override
    public short getShort() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return 0;
        }
        BigDecimal result = Convertion.bytesToBigDecimal(this.dataBuffer, this.scale, this.prec, this.compatibleOracle);
        if (result.doubleValue() < -32768.0 || result.doubleValue() > 32767.0) {
            DBError.throwSQLException(6004);
        }
        return result.shortValue();
    }

    @Override
    public int getInt() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return 0;
        }
        BigDecimal result = Convertion.bytesToBigDecimal(this.dataBuffer, this.scale, this.prec, this.compatibleOracle);
        if (result.doubleValue() < -2.147483648E9 || result.doubleValue() > 2.147483647E9) {
            DBError.throwSQLException(6004);
        }
        return result.intValue();
    }

    @Override
    public long getLong() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return 0L;
        }
        BigDecimal result = Convertion.bytesToBigDecimal(this.dataBuffer, this.scale, this.prec, this.compatibleOracle);
        if (result.doubleValue() < -9.223372036854776E18 || result.doubleValue() > 9.223372036854776E18) {
            DBError.throwSQLException(6004);
        }
        return result.longValue();
    }

    @Override
    public float getFloat() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return 0.0f;
        }
        float flt = Convertion.bytesToBigDecimal(this.dataBuffer, this.scale, this.prec, this.compatibleOracle).floatValue();
        if (flt == Float.NEGATIVE_INFINITY || flt == Float.POSITIVE_INFINITY) {
            DBError.throwSQLException(6004);
        }
        return flt;
    }

    @Override
    public double getDouble() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return 0.0;
        }
        return Convertion.bytesToBigDecimal(this.dataBuffer, this.scale, this.prec, this.compatibleOracle).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? null : Convertion.bytesToBigDecimal(this.dataBuffer, this.scale, this.prec, this.compatibleOracle);
    }

    @Override
    public String getString() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return null;
        }
        return String.valueOf(Convertion.bytesToBigDecimal(this.dataBuffer, this.scale, this.prec, this.compatibleOracle));
    }

    @Override
    public Object getObjectInner(Map<String, Class<?>> typeMap) throws SQLException {
        return this.getBigDecimal();
    }
}

