/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.accessor;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.accessor.BinaryAccessor;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.LobDesc;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.util.StringUtil;
import dm.sql.DmdbSQLInput;
import dm.sql.STRUCT;
import dm.sql.TypeData;
import dm.sql.TypeDescriptor;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Array;
import java.sql.Blob;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlobAccessor
extends BinaryAccessor {
    DmdbConnection_bs conn;
    LobDesc lobDesc;
    boolean lobReadOnly;
    TypeDescriptor typeDesc;

    protected BlobAccessor(DmdbConnection_bs conn, LobDesc lobDesc, boolean lobReadOnly, TypeDescriptor typeDesc, int maxFieldSize) {
        super(maxFieldSize);
        this.conn = conn;
        this.lobDesc = lobDesc;
        this.lobReadOnly = lobReadOnly;
        this.typeDesc = typeDesc;
    }

    @Override
    public boolean getBoolean() throws SQLException {
        Blob blob = this.getBlob();
        byte[] bytes = blob.getBytes(1L, 1);
        return this.wasNull ? false : (bytes == null || bytes.length == 0 ? false : bytes[0] != 0);
    }

    @Override
    public byte getByte() throws SQLException {
        Blob blob = this.getBlob();
        byte[] bytes = blob.getBytes(1L, 1);
        return this.wasNull ? (byte)0 : (bytes == null || bytes.length == 0 ? (byte)0 : bytes[0]);
    }

    @Override
    public short getShort() throws SQLException {
        Blob blob = this.getBlob();
        byte[] bytes = blob.getBytes(1L, 2);
        return this.wasNull ? (short)0 : Convertion.bytesToShort(bytes);
    }

    @Override
    public int getInt() throws SQLException {
        Blob blob = this.getBlob();
        byte[] bytes = blob.getBytes(1L, 4);
        return this.wasNull ? 0 : Convertion.bytesToInt(bytes);
    }

    @Override
    public long getLong() throws SQLException {
        Blob blob = this.getBlob();
        byte[] bytes = blob.getBytes(1L, 8);
        return this.wasNull ? 0L : Convertion.bytesToLong(bytes);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        Blob blob = this.getBlob();
        return this.wasNull ? null : new DmdbInputStream(blob, this.serverEncoding);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        Blob blob = this.getBlob();
        return this.wasNull ? null : new DmdbInputStream(blob, this.serverEncoding);
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        Blob blob = this.getBlob();
        return this.wasNull ? null : new DmdbInputStream(blob, this.serverEncoding);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        Blob blob = this.getBlob();
        return this.wasNull ? null : ((DmdbBlob)blob).getCharacterStream();
    }

    @Override
    public Blob getBlob() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? null : BlobAccessor.get_blob_value(this.dataBuffer, this.lobDesc, this.conn, !this.lobReadOnly);
    }

    @Override
    public byte[] getBytes() throws SQLException {
        Blob blob = this.getBlob();
        if (this.wasNull) {
            return null;
        }
        long length = blob.length();
        if ("LONGVARBINARY".equalsIgnoreCase(this.dTypeName) && this.maxFieldSize > 0 && length > (long)this.maxFieldSize) {
            length = this.maxFieldSize;
        }
        return blob.getBytes(1L, (int)length);
    }

    @Override
    public String getString() throws SQLException {
        Object obj = this.getObjectInner(null);
        if (this.wasNull) {
            return null;
        }
        if (obj instanceof Blob) {
            long length = ((Blob)obj).length();
            byte[] val = ((Blob)obj).getBytes(1L, (int)length);
            return Convertion.bytesToHexString(val);
        }
        if (obj instanceof byte[]) {
            return Convertion.bytesToHexString((byte[])obj);
        }
        return obj.toString();
    }

    @Override
    public Array getArray() throws SQLException {
        Object obj = this.getObjectInner(null);
        if (this.wasNull) {
            return null;
        }
        if (obj instanceof Array) {
            return (Array)obj;
        }
        DBError.throwSQLException(6007);
        return null;
    }

    @Override
    public Struct getStruct() throws SQLException {
        Object obj = this.getObjectInner(null);
        if (this.wasNull) {
            return null;
        }
        if (obj instanceof Struct) {
            return (Struct)obj;
        }
        DBError.throwSQLException(6007);
        return null;
    }

    @Override
    public Object getObjectInner(Map<String, Class<?>> typeMap) throws SQLException {
        if ("LONGVARBINARY".equalsIgnoreCase(this.dTypeName)) {
            return this.getBytes();
        }
        Blob blob = this.getBlob();
        if (this.wasNull) {
            return null;
        }
        if (DmdbType.isComplexType(this.dtype, this.scale)) {
            if (this.typeDesc != null) {
                return BlobAccessor.getComplexObj_from_blob(blob, this.typeDesc, this.conn.getTypeMap(), this.dTypeName);
            }
            DBError.throwSQLException(6007);
            return null;
        }
        return blob;
    }

    public static Object getComplexObj_from_blob(Blob blob, TypeDescriptor desc, Map<String, Class<?>> map, String typeName) throws SQLException {
        Object ret = TypeData.objBlobToObj(blob, desc);
        if (ret instanceof STRUCT && StringUtil.isNotEmpty(typeName)) {
            return BlobAccessor.getStruct_SQLData(map, (STRUCT)ret, typeName);
        }
        return ret;
    }

    public static Object getStruct_SQLData(Map<String, Class<?>> typeMap, STRUCT struct, String typeName) throws SQLException {
        if (typeMap == null || typeMap.size() == 0) {
            return struct;
        }
        Class<?> cls = typeMap.get(typeName);
        if (cls != null) {
            try {
                Object obj = cls.newInstance();
                DmdbSQLInput stream = new DmdbSQLInput(typeMap, struct.getAttributes(typeMap));
                ((SQLData)obj).readSQL(stream, typeName);
                return obj;
            }
            catch (Exception e) {
                DBError.throwSQLException(6007);
            }
        }
        return struct;
    }

    public static DmdbBlob get_blob_value(byte[] bs, LobDesc lobInfo, DmdbConnection_bs conn, boolean updable) throws SQLException {
        DmdbBlob ret = null;
        if (lobInfo != null) {
            ret = new DmdbBlob(bs, lobInfo, conn, updable);
            if (lobInfo.getLobMode() == 2 && ret != null && !ret.isValueInRow()) {
                int nblob_inrow_hdr_size = ret.nblob_inrow_hdr_size(conn.getNewLobFlag());
                byte[] tmp = ret.getBytesOffRow(1L, ret.getLobLen());
                byte[] value = new byte[nblob_inrow_hdr_size + tmp.length];
                System.arraycopy(ret.m_value, 0, value, 0, nblob_inrow_hdr_size);
                System.arraycopy(tmp, 0, value, nblob_inrow_hdr_size, tmp.length);
                ret.m_value = value;
            }
        } else {
            ret = new DmdbBlob(bs, conn);
        }
        return ret;
    }
}

