/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;

public class BFileInner {
    protected String dir;
    protected String fileName;
    private String fileId;

    public BFileInner() {
    }

    public BFileInner(String fullName) throws SQLException {
        String[] strs;
        if (!BFileInner.isValidBFileStr(fullName)) {
            DBError.throwSQLException(6070);
        }
        if ((strs = fullName.split(":")).length > 2) {
            this.init(strs[0], strs[1], strs[2]);
        } else {
            this.init(strs[0], strs[1], null);
        }
    }

    protected void init(String dir, String fileName, String fileId) throws SQLException {
        this.dir = dir;
        this.fileName = fileName;
        this.fileId = fileId;
    }

    public static boolean isValidBFileStr(String str) {
        if (StringUtil.isEmpty(str = str.trim())) {
            return false;
        }
        String[] strs = str.split(":");
        if (strs == null || strs.length < 2 || strs.length > 3) {
            return false;
        }
        if (strs[0].length() > 128) {
            return false;
        }
        return strs[1].length() <= 256;
    }

    protected String getFileId() {
        return this.fileId;
    }

    protected void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getDir() {
        return this.dir;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isNull() {
        return !StringUtil.isNotEmpty(this.dir) || !StringUtil.isNotEmpty(this.fileName);
    }

    public String toString() {
        if (this.isNull()) {
            return "";
        }
        if (StringUtil.isNotEmpty(this.fileId)) {
            return this.getDir() + ":" + this.getFileName() + ":" + this.fileId;
        }
        return this.getDir() + ":" + this.getFileName();
    }
}

