/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.core.internals;

import com.ctrip.framework.apollo.core.enums.Env;
import com.ctrip.framework.apollo.core.spi.MetaServerProvider;
import com.ctrip.framework.apollo.core.utils.ResourceUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class LegacyMetaServerProvider
implements MetaServerProvider {
    public static final int ORDER = 0x7FFFFFFE;
    private static final Map<Env, String> domains = new HashMap<Env, String>();

    public LegacyMetaServerProvider() {
        this.initialize();
    }

    private void initialize() {
        Properties prop = new Properties();
        prop = ResourceUtils.readConfigFile("apollo-env.properties", prop);
        Properties env = System.getProperties();
        domains.put(Env.LOCAL, env.getProperty("local_meta", prop.getProperty("local.meta")));
        domains.put(Env.DEV, env.getProperty("dev_meta", prop.getProperty("dev.meta")));
        domains.put(Env.FAT, env.getProperty("fat_meta", prop.getProperty("fat.meta")));
        domains.put(Env.UAT, env.getProperty("uat_meta", prop.getProperty("uat.meta")));
        domains.put(Env.LPT, env.getProperty("lpt_meta", prop.getProperty("lpt.meta")));
        domains.put(Env.PRO, env.getProperty("pro_meta", prop.getProperty("pro.meta")));
    }

    @Override
    public String getMetaServerAddress(Env targetEnv) {
        String metaServerAddress = domains.get((Object)targetEnv);
        return metaServerAddress == null ? null : metaServerAddress.trim();
    }

    @Override
    public int getOrder() {
        return 0x7FFFFFFE;
    }
}

