/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.config.data.system;

import com.ctrip.framework.apollo.config.data.util.Slf4jLogMessageFormatter;
import com.ctrip.framework.apollo.spring.boot.ApolloApplicationContextInitializer;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.util.StringUtils;

public class ApolloClientSystemPropertyInitializer {
    private final Log log;

    public ApolloClientSystemPropertyInitializer(Log log) {
        this.log = log;
    }

    public void initializeSystemProperty(Binder binder, BindHandler bindHandler) {
        for (String propertyName : ApolloApplicationContextInitializer.APOLLO_SYSTEM_PROPERTIES) {
            this.fillSystemPropertyFromBinder(propertyName, propertyName, binder, bindHandler);
        }
    }

    private void fillSystemPropertyFromBinder(String propertyName, String bindName, Binder binder, BindHandler bindHandler) {
        if (System.getProperty(propertyName) != null) {
            return;
        }
        String propertyValue = (String)binder.bind(bindName, Bindable.of(String.class), bindHandler).orElse(null);
        if (!StringUtils.hasText((String)propertyValue)) {
            return;
        }
        this.log.debug((Object)Slf4jLogMessageFormatter.format("apollo client set system property key=[{}] value=[{}]", propertyName, propertyValue));
        System.setProperty(propertyName, propertyValue);
    }
}

