/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.config.data.importer;

import com.ctrip.framework.apollo.config.data.extension.initialize.ApolloClientExtensionInitializeFactory;
import com.ctrip.framework.apollo.config.data.importer.ApolloConfigEmptyPropertySource;
import com.ctrip.framework.apollo.config.data.injector.ApolloConfigDataInjectorCustomizer;
import com.ctrip.framework.apollo.config.data.internals.PureApolloConfigFactory;
import com.ctrip.framework.apollo.config.data.system.ApolloClientSystemPropertyInitializer;
import com.ctrip.framework.apollo.config.data.util.Slf4jLogMessageFormatter;
import com.ctrip.framework.apollo.core.utils.DeferredLogger;
import com.ctrip.framework.apollo.spi.ConfigFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

class ApolloConfigDataLoaderInitializer {
    private static volatile boolean INITIALIZED = false;
    private final Log log;
    private final Binder binder;
    private final BindHandler bindHandler;
    private final ConfigurableBootstrapContext bootstrapContext;

    public ApolloConfigDataLoaderInitializer(Log log, Binder binder, BindHandler bindHandler, ConfigurableBootstrapContext bootstrapContext) {
        this.log = log;
        this.binder = binder;
        this.bindHandler = bindHandler;
        this.bootstrapContext = bootstrapContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PropertySource<?>> initApolloClient() {
        if (INITIALIZED) {
            return Collections.emptyList();
        }
        Class<ApolloConfigDataLoaderInitializer> clazz = ApolloConfigDataLoaderInitializer.class;
        synchronized (ApolloConfigDataLoaderInitializer.class) {
            if (INITIALIZED) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return Collections.emptyList();
            }
            this.initApolloClientInternal();
            INITIALIZED = true;
            if (this.forceDisableApolloBootstrap()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("apollo.bootstrap.enabled", "false");
                map.put("apollo.bootstrap.eagerLoad.enabled", "false");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return Arrays.asList(new PropertySource[]{new ApolloConfigEmptyPropertySource("ApolloPropertySources"), new MapPropertySource("ApolloBootstrapPropertySources", Collections.unmodifiableMap(map))});
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Arrays.asList(new PropertySource[]{new ApolloConfigEmptyPropertySource("ApolloPropertySources"), new ApolloConfigEmptyPropertySource("ApolloBootstrapPropertySources")});
        }
    }

    private void initApolloClientInternal() {
        new ApolloClientSystemPropertyInitializer(this.log).initializeSystemProperty(this.binder, this.bindHandler);
        new ApolloClientExtensionInitializeFactory(this.log, this.bootstrapContext).initializeExtension(this.binder, this.bindHandler);
        DeferredLogger.enable();
        ApolloConfigDataInjectorCustomizer.register(ConfigFactory.class, PureApolloConfigFactory::new);
    }

    private boolean forceDisableApolloBootstrap() {
        boolean bootstrapEnabled = (Boolean)this.binder.bind(this.camelCasedToKebabCase("apollo.bootstrap.enabled"), Bindable.of(Boolean.class), this.bindHandler).orElse((Object)false);
        if (bootstrapEnabled) {
            this.log.warn((Object)Slf4jLogMessageFormatter.format("apollo bootstrap is force disabled. please don't configure the property [{}=true] and [spring.config.import=apollo://...] at the same time", "apollo.bootstrap.enabled"));
            return true;
        }
        boolean bootstrapEagerLoadEnabled = (Boolean)this.binder.bind(this.camelCasedToKebabCase("apollo.bootstrap.eagerLoad.enabled"), Bindable.of(Boolean.class), this.bindHandler).orElse((Object)false);
        if (bootstrapEagerLoadEnabled) {
            this.log.warn((Object)Slf4jLogMessageFormatter.format("apollo bootstrap eager load is force disabled. please don't configure the property [{}=true] and [spring.config.import=apollo://...] at the same time", "apollo.bootstrap.eagerLoad.enabled"));
            return true;
        }
        return false;
    }

    private String camelCasedToKebabCase(String source) {
        if (ConfigurationPropertyName.isValid((CharSequence)source)) {
            return source;
        }
        StringBuilder stringBuilder = new StringBuilder(source.length() * 2);
        for (char ch : source.toCharArray()) {
            if (Character.isUpperCase(ch)) {
                stringBuilder.append("-").append(Character.toLowerCase(ch));
                continue;
            }
            stringBuilder.append(ch);
        }
        return stringBuilder.toString();
    }
}

