/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.config.data.extension.webclient;

import com.ctrip.framework.apollo.exceptions.ApolloConfigException;
import com.ctrip.framework.apollo.exceptions.ApolloConfigStatusCodeException;
import com.ctrip.framework.apollo.util.http.HttpClient;
import com.ctrip.framework.apollo.util.http.HttpRequest;
import com.ctrip.framework.apollo.util.http.HttpResponse;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class ApolloWebClientHttpClient
implements HttpClient {
    private final WebClient webClient;
    private final Gson gson;

    public ApolloWebClientHttpClient(WebClient webClient) {
        this(webClient, new Gson());
    }

    public ApolloWebClientHttpClient(WebClient webClient, Gson gson) {
        this.webClient = webClient;
        this.gson = gson;
    }

    public <T> HttpResponse<T> doGet(HttpRequest httpRequest, Class<T> responseType) throws ApolloConfigException {
        return this.doGetInternal(httpRequest, responseType);
    }

    private <T> HttpResponse<T> doGetInternal(HttpRequest httpRequest, Type responseType) throws ApolloConfigException {
        WebClient.RequestHeadersSpec requestHeadersSpec = this.webClient.get().uri(URI.create(httpRequest.getUrl()));
        if (!CollectionUtils.isEmpty((Map)httpRequest.getHeaders())) {
            for (Map.Entry entry : httpRequest.getHeaders().entrySet()) {
                requestHeadersSpec.header((String)entry.getKey(), new String[]{(String)entry.getValue()});
            }
        }
        return (HttpResponse)requestHeadersSpec.exchangeToMono(clientResponse -> {
            if (HttpStatus.OK.equals((Object)clientResponse.statusCode())) {
                return clientResponse.bodyToMono(String.class).map(body -> new HttpResponse(HttpStatus.OK.value(), this.gson.fromJson(body, responseType)));
            }
            if (HttpStatus.NOT_MODIFIED.equals((Object)clientResponse.statusCode())) {
                return Mono.just((Object)new HttpResponse(HttpStatus.NOT_MODIFIED.value(), null));
            }
            return Mono.error((Throwable)new ApolloConfigStatusCodeException(clientResponse.rawStatusCode(), String.format("Get operation failed for %s", httpRequest.getUrl())));
        }).block();
    }

    public <T> HttpResponse<T> doGet(HttpRequest httpRequest, Type responseType) throws ApolloConfigException {
        return this.doGetInternal(httpRequest, responseType);
    }
}

