/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.config.data.extension.initialize;

import com.ctrip.framework.apollo.config.data.extension.enums.ApolloClientMessagingType;
import com.ctrip.framework.apollo.config.data.extension.initialize.ApolloClientPropertiesFactory;
import com.ctrip.framework.apollo.config.data.extension.properties.ApolloClientExtensionProperties;
import com.ctrip.framework.apollo.config.data.extension.properties.ApolloClientProperties;
import com.ctrip.framework.apollo.config.data.extension.webclient.ApolloClientLongPollingExtensionInitializer;
import com.ctrip.framework.apollo.config.data.extension.websocket.ApolloClientWebsocketExtensionInitializer;
import com.ctrip.framework.apollo.config.data.util.Slf4jLogMessageFormatter;
import org.apache.commons.logging.Log;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Binder;

public class ApolloClientExtensionInitializeFactory {
    private final Log log;
    private final ApolloClientPropertiesFactory apolloClientPropertiesFactory;
    private final ApolloClientLongPollingExtensionInitializer apolloClientLongPollingExtensionInitializer;
    private final ApolloClientWebsocketExtensionInitializer apolloClientWebsocketExtensionInitializer;

    public ApolloClientExtensionInitializeFactory(Log log, ConfigurableBootstrapContext bootstrapContext) {
        this.log = log;
        this.apolloClientPropertiesFactory = new ApolloClientPropertiesFactory();
        this.apolloClientLongPollingExtensionInitializer = new ApolloClientLongPollingExtensionInitializer(log, bootstrapContext);
        this.apolloClientWebsocketExtensionInitializer = new ApolloClientWebsocketExtensionInitializer(log, bootstrapContext);
    }

    public void initializeExtension(Binder binder, BindHandler bindHandler) {
        ApolloClientProperties apolloClientProperties = this.apolloClientPropertiesFactory.createApolloClientProperties(binder, bindHandler);
        if (apolloClientProperties == null || apolloClientProperties.getExtension() == null) {
            this.log.info((Object)"apollo client extension is not configured, default to disabled");
            return;
        }
        ApolloClientExtensionProperties extension = apolloClientProperties.getExtension();
        if (!extension.getEnabled().booleanValue()) {
            this.log.info((Object)"apollo client extension disabled");
            return;
        }
        ApolloClientMessagingType messagingType = extension.getMessagingType();
        this.log.debug((Object)Slf4jLogMessageFormatter.format("apollo client extension messaging type: {}", new Object[]{messagingType}));
        switch (messagingType) {
            case LONG_POLLING: {
                this.apolloClientLongPollingExtensionInitializer.initialize(apolloClientProperties, binder, bindHandler);
                return;
            }
            case WEBSOCKET: {
                this.apolloClientWebsocketExtensionInitializer.initialize(apolloClientProperties, binder, bindHandler);
                return;
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)messagingType));
    }
}

