/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.provider.report.file;

import com.bstek.ureport.exception.ReportException;
import com.bstek.ureport.provider.report.ReportFile;
import com.bstek.ureport.provider.report.ReportProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;

public class FileReportProvider
implements ReportProvider,
ApplicationContextAware {
    private String prefix = "file:";
    private String fileStoreDir;
    private boolean disabled;

    @Override
    public InputStream loadReport(String file) {
        if (file.startsWith(this.prefix)) {
            file = file.substring(this.prefix.length(), file.length());
        }
        String fullPath = this.fileStoreDir + "/" + file;
        try {
            return new FileInputStream(fullPath);
        }
        catch (FileNotFoundException e) {
            throw new ReportException(e);
        }
    }

    @Override
    public void deleteReport(String file) {
        String fullPath;
        File f;
        if (file.startsWith(this.prefix)) {
            file = file.substring(this.prefix.length(), file.length());
        }
        if ((f = new File(fullPath = this.fileStoreDir + "/" + file)).exists()) {
            f.delete();
        }
    }

    @Override
    public List<ReportFile> getReportFiles() {
        File file = new File(this.fileStoreDir);
        ArrayList<ReportFile> list = new ArrayList<ReportFile>();
        for (File f : file.listFiles()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(f.lastModified());
            list.add(new ReportFile(f.getName(), calendar.getTime()));
        }
        Collections.sort(list, new Comparator<ReportFile>(){

            @Override
            public int compare(ReportFile f1, ReportFile f2) {
                return f2.getUpdateDate().compareTo(f1.getUpdateDate());
            }
        });
        return list;
    }

    @Override
    public String getName() {
        return "\u670d\u52a1\u5668\u6587\u4ef6\u7cfb\u7edf";
    }

    @Override
    public void saveReport(String file, String content) {
        if (file.startsWith(this.prefix)) {
            file = file.substring(this.prefix.length(), file.length());
        }
        String fullPath = this.fileStoreDir + "/" + file;
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(new File(fullPath));
            IOUtils.write((String)content, (OutputStream)outStream, (String)"utf-8");
        }
        catch (Exception ex) {
            throw new ReportException(ex);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public boolean disabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setFileStoreDir(String fileStoreDir) {
        this.fileStoreDir = fileStoreDir;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        File file = new File(this.fileStoreDir);
        if (file.exists()) {
            return;
        }
        if (applicationContext instanceof WebApplicationContext) {
            WebApplicationContext context = (WebApplicationContext)applicationContext;
            ServletContext servletContext = context.getServletContext();
            String basePath = servletContext.getRealPath("/");
            this.fileStoreDir = basePath + this.fileStoreDir;
            file = new File(this.fileStoreDir);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }
}

