/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.parse.builder;

import com.bstek.ureport.dsl.ReportParserParser;
import com.bstek.ureport.expression.ExpressionUtils;
import com.bstek.ureport.expression.model.expr.BaseExpression;
import com.bstek.ureport.expression.model.expr.FunctionExpression;
import com.bstek.ureport.expression.parse.builder.BaseExpressionBuilder;
import java.util.ArrayList;
import java.util.List;

public class FunctionExpressionBuilder
extends BaseExpressionBuilder {
    @Override
    public BaseExpression build(ReportParserParser.UnitContext unitContext) {
        ReportParserParser.FunctionContext ctx = unitContext.function();
        FunctionExpression expr = new FunctionExpression();
        expr.setExpr(ctx.getText());
        expr.setName(ctx.Identifier().getText());
        ReportParserParser.FunctionParameterContext functionParameterContext = ctx.functionParameter();
        if (functionParameterContext != null) {
            ArrayList<BaseExpression> exprList = new ArrayList<BaseExpression>();
            List<ReportParserParser.ItemContext> itemContexts = functionParameterContext.item();
            if (itemContexts != null) {
                for (int i = 0; i < itemContexts.size(); ++i) {
                    ReportParserParser.ItemContext itemContext = itemContexts.get(i);
                    BaseExpression baseExpr = ExpressionUtils.getExprVisitor().parseItemContext(itemContext);
                    exprList.add(baseExpr);
                }
            }
            expr.setExpressions(exprList);
        }
        return expr;
    }

    @Override
    public boolean support(ReportParserParser.UnitContext unitContext) {
        return unitContext.function() != null;
    }
}

