/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model.expr.set;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.expression.model.Condition;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.NoneExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.expression.model.expr.set.CellExpression;
import com.bstek.ureport.model.Cell;
import java.util.ArrayList;
import java.util.List;

public class CellConditionExpression
extends CellExpression {
    private static final long serialVersionUID = 536887481808944331L;
    protected Condition condition;

    public CellConditionExpression(String cellName, Condition condition) {
        super(cellName);
        this.condition = condition;
    }

    @Override
    protected ExpressionData<?> compute(Cell cell, Cell currentCell, Context context) {
        List<Cell> targetCells = Utils.fetchTargetCells(cell, context, this.cellName);
        if ((targetCells = this.filterCells(cell, context, this.condition, targetCells)).size() > 1) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Cell targetCell : targetCells) {
                list.add(targetCell.getData());
            }
            return new ObjectListExpressionData(list);
        }
        if (targetCells.size() == 1) {
            return new ObjectExpressionData(targetCells.get(0).getData());
        }
        return new NoneExpressionData();
    }

    @Override
    public ExpressionData<?> computePageCells(Cell cell, Cell currentCell, Context context) {
        List<Cell> targetCells = this.fetchPageCells(cell, currentCell, context);
        if ((targetCells = this.filterCells(cell, context, this.condition, targetCells)).size() > 1) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Cell targetCell : targetCells) {
                list.add(targetCell.getData());
            }
            return new ObjectListExpressionData(list);
        }
        if (targetCells.size() == 1) {
            return new ObjectExpressionData(targetCells.get(0).getData());
        }
        return new NoneExpressionData();
    }
}

