/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model.condition;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.condition.BaseCondition;
import com.bstek.ureport.expression.model.condition.ConditionType;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.model.Cell;
import java.util.List;

public class CellExpressionCondition
extends BaseCondition {
    private ConditionType type = ConditionType.cell;
    private String cellName;
    private Expression rightExpression;

    @Override
    Object computeLeft(Cell cell, Cell currentCell, Object obj, Context context) {
        if (this.cellName.equals(currentCell.getName())) {
            return currentCell.getData();
        }
        List<Cell> cells = Utils.fetchTargetCells(cell, context, this.cellName);
        int size = cells.size();
        if (cells == null || size == 0) {
            return new ReportComputeException("Unknow cell : " + this.cellName);
        }
        for (Cell c : cells) {
            if (c.getRow() != cell.getRow() && c.getColumn() != cell.getColumn()) continue;
            return c.getData();
        }
        if (size > 1) {
            StringBuilder sb = new StringBuilder();
            for (Cell c : cells) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(c.getData());
            }
            return sb.toString();
        }
        return cells.get(0).getData();
    }

    @Override
    Object computeRight(Cell cell, Cell currentCell, Object obj, Context context) {
        ExpressionData<?> exprData = this.rightExpression.execute(cell, currentCell, context);
        return this.extractExpressionData(exprData);
    }

    @Override
    public ConditionType getType() {
        return this.type;
    }

    public void setCellName(String cellName) {
        this.cellName = cellName;
    }

    public void setRightExpression(Expression rightExpression) {
        this.rightExpression = rightExpression;
    }
}

